/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.util;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;

public class EntityMethodGenerator {
    private final WorkingCopy copy;
    private final GenerationUtils genUtils;
    private final TypeElement scope;

    public EntityMethodGenerator(WorkingCopy copy, GenerationUtils genUtils, TypeElement scope) {
        this.copy = copy;
        this.genUtils = genUtils;
        this.scope = scope;
    }

    public MethodTree createHashCodeMethod(List<VariableTree> fields) {
        StringBuilder body = new StringBuilder(20 + fields.size() * 30);
        body.append("{");
        body.append("int hash = 0;");
        for (VariableTree field : fields) {
            body.append(this.createHashCodeLineForField(field));
        }
        body.append("return hash;");
        body.append("}");
        TreeMaker make = this.copy.getTreeMaker();
        return make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(this.genUtils.createAnnotation("java.lang.Override"))), (CharSequence)"hashCode", (Tree)make.PrimitiveType(TypeKind.INT), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body.toString(), null);
    }

    private String createHashCodeLineForField(VariableTree field) {
        Name fieldName = field.getName();
        Tree fieldType = field.getType();
        if (fieldType.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
            if (((PrimitiveTypeTree)fieldType).getPrimitiveTypeKind() == TypeKind.BOOLEAN) {
                return "hash += (" + fieldName + " ? 1 : 0";
            }
            return "hash += (int)" + fieldName + ";";
        }
        return "hash += (" + fieldName + " != null ? " + fieldName + ".hashCode() : 0);";
    }

    public MethodTree createEqualsMethod(String simpleClassName, List<VariableTree> fields) {
        StringBuilder body = new StringBuilder(50 + fields.size() * 30);
        body.append("{");
        body.append("// TODO: Warning - this method won't work in the case the id fields are not set\n");
        body.append("if (!(object instanceof ");
        body.append(simpleClassName + ")) {return false;}");
        body.append(simpleClassName + " other = (" + simpleClassName + ")object;");
        for (VariableTree field : fields) {
            body.append(this.createEqualsLineForField(field));
        }
        body.append("return true;");
        body.append("}");
        TreeMaker make = this.copy.getTreeMaker();
        return make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(this.genUtils.createAnnotation("java.lang.Override"))), (CharSequence)"equals", (Tree)make.PrimitiveType(TypeKind.BOOLEAN), Collections.emptyList(), Collections.singletonList(this.genUtils.createVariable(this.scope, "object", "java.lang.Object")), Collections.emptyList(), body.toString(), null);
    }

    private String createEqualsLineForField(VariableTree field) {
        Name fieldName = field.getName();
        Tree fieldType = field.getType();
        if (fieldType.getKind() == Tree.Kind.PRIMITIVE_TYPE) {
            return "if (this." + fieldName + " != other." + fieldName + ") return false;";
        }
        return "if ((this." + fieldName + " == null && other." + fieldName + " != null) || (this." + fieldName + " != null && !this." + fieldName + ".equals(other." + fieldName + "))) return false;";
    }

    public MethodTree createToStringMethod(String fqn, List<VariableTree> fields) {
        StringBuilder body = new StringBuilder(30 + fields.size() * 30);
        body.append("{");
        body.append("return \"" + fqn + "[ ");
        Iterator<VariableTree> i = fields.iterator();
        while (i.hasNext()) {
            String fieldName = i.next().getName().toString();
            body.append(fieldName + "=\" + " + fieldName + " + \"");
            body.append(i.hasNext() ? ", " : " ]\";");
        }
        body.append("}");
        TreeMaker make = this.copy.getTreeMaker();
        return make.Method(make.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(this.genUtils.createAnnotation("java.lang.Override"))), (CharSequence)"toString", this.genUtils.createType("java.lang.String", this.scope), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), body.toString(), null);
    }
}

