/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.rules.attribute.ValidColumnName;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class ValidModifiers
extends JPAEntityAttributeCheck {
    @Override
    public Collection<ErrorDescription> check(JPAProblemContext ctx, HintContext hc, AttributeWrapper attrib) {
        Set<Modifier> fieldModifiers = attrib.getInstanceVariable() == null ? null : attrib.getInstanceVariable().getModifiers();
        Set<Modifier> accesorModifiers = attrib.getAccesor() == null ? null : attrib.getAccesor().getModifiers();
        Set<Modifier> mutatorModifiers = attrib.getMutator() == null ? null : attrib.getMutator().getModifiers();
        ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        if (fieldModifiers != null && fieldModifiers.contains((Object)Modifier.PUBLIC)) {
            errors.addAll(ValidModifiers.getErr(ctx, hc, attrib, "MSG_PublicVariable"));
        }
        if (accesorModifiers != null) {
            if (ctx.getAccessType() == AccessType.PROPERTY && !accesorModifiers.contains((Object)Modifier.PUBLIC) && !accesorModifiers.contains((Object)Modifier.PROTECTED)) {
                errors.addAll(ValidModifiers.getErr(ctx, hc, attrib, "MSG_NonPublicAccesor"));
            }
            if (accesorModifiers.contains((Object)Modifier.FINAL)) {
                errors.addAll(ValidModifiers.getErr(ctx, hc, attrib, "MSG_FinalAccesor"));
            }
        }
        if (mutatorModifiers != null) {
            if (mutatorModifiers.contains((Object)Modifier.PRIVATE)) {
                errors.addAll(ValidModifiers.getErr(ctx, hc, attrib, "MSG_NonPublicMutator"));
            }
            if (mutatorModifiers.contains((Object)Modifier.FINAL)) {
                errors.addAll(ValidModifiers.getErr(ctx, hc, attrib, "MSG_FinalMutator"));
            }
        }
        return errors;
    }

    private static Collection<ErrorDescription> getErr(JPAProblemContext ctx, HintContext hc, AttributeWrapper attrib, String msgKey) {
        Tree elementTree = ctx.getCompilationInfo().getTrees().getTree(attrib.getJavaElement());
        Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), elementTree);
        ErrorDescription error = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(ValidColumnName.class, (String)msgKey), (Fix[])new Fix[0]);
        return Collections.singleton(error);
    }
}

