/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject.jaxws;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.spi.ProjectJAXWSSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class EjbProjectJAXWSSupport
extends ProjectJAXWSSupport {
    private EjbJarProject project;

    public EjbProjectJAXWSSupport(EjbJarProject project, AntProjectHelper antProjectHelper) {
        super((Project)project, antProjectHelper);
        this.project = project;
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        FileObject metaInfFo;
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbModule != null && (metaInfFo = ejbModule.getMetaInf()) != null) {
            FileObject wsdlFo = metaInfFo.getFileObject("wsdl");
            if (wsdlFo != null) {
                return wsdlFo;
            }
            if (create) {
                return metaInfFo.createFolder("wsdl");
            }
        }
        return null;
    }

    public String getWsdlLocation(String serviceName) {
        String localWsdlFile;
        Service service;
        String localWsdl = serviceName + ".wsdl";
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (service = jaxWsModel.findServiceByName(serviceName)) != null && (localWsdlFile = service.getLocalWsdlFile()) != null) {
            localWsdl = localWsdlFile;
        }
        String prefix = "META-INF/wsdl/";
        return prefix + serviceName + "/" + localWsdl;
    }

    public FileObject getDeploymentDescriptorFolder() {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbModule != null) {
            return ejbModule.getMetaInf();
        }
        return null;
    }

    protected void addJaxwsArtifacts(Project project, String wsName, String serviceImpl) throws Exception {
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getAPIEjbJar().getMetaInf();
    }

    public void removeNonJsr109Entries(String serviceName) throws IOException {
    }

    public String addService(String name, String serviceImpl, String wsdlUrl, String serviceName, String portName, String packageName, boolean isJsr109, boolean useProvider) {
        FileObject fo = WSUtils.findJaxWsFileObject((Project)this.project);
        if (fo == null) {
            try {
                WSUtils.createJaxWsFileObject((Project)this.project);
                this.logWsDetected();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return super.addService(name, serviceImpl, wsdlUrl, serviceName, portName, packageName, isJsr109, useProvider);
    }

    public void addService(String serviceName, String serviceImpl, boolean isJsr109) {
        FileObject fo = WSUtils.findJaxWsFileObject((Project)this.project);
        if (fo == null) {
            try {
                WSUtils.createJaxWsFileObject((Project)this.project);
                this.logWsDetected();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        super.addService(serviceName, serviceImpl, isJsr109);
    }

    public MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        return this.project.getEjbModule().getWebservicesMetadataModel();
    }

    private void logWsDetected() {
        Object[] params = new Object[]{"JAX-WS", this.project.getClass().getName(), "SERVICE"};
        LogUtils.logWsDetect((Object[])params);
    }

    protected String getProjectJavaEEVersion() {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        if (ejbModule != null) {
            switch (ejbModule.getJ2eeProfile()) {
                case JAVA_EE_6_WEB: 
                case JAVA_EE_6_FULL: {
                    return "java-ee-version-16";
                }
                case JAVA_EE_7_WEB: 
                case JAVA_EE_7_FULL: {
                    return "java-ee-version-17";
                }
                case JAVA_EE_8_WEB: 
                case JAVA_EE_8_FULL: {
                    return "java-ee-version-18";
                }
                case JAKARTA_EE_8_WEB: 
                case JAKARTA_EE_8_FULL: {
                    return "jakarta-ee-version-8";
                }
                case JAKARTA_EE_9_WEB: 
                case JAKARTA_EE_9_FULL: {
                    return "jakarta-ee-version-9";
                }
                case JAKARTA_EE_9_1_WEB: 
                case JAKARTA_EE_9_1_FULL: {
                    return "jakarta-ee-version-91";
                }
                case JAKARTA_EE_10_WEB: 
                case JAKARTA_EE_10_FULL: {
                    return "jakarta-ee-version-10";
                }
                case JAKARTA_EE_11_WEB: 
                case JAKARTA_EE_11_FULL: {
                    return "jakarta-ee-version-11";
                }
                case JAVA_EE_5: {
                    return "java-ee-version-15";
                }
            }
        }
        return "java-ee-version-none";
    }
}

