/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.ModuleNode;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class LogicalViewChildren
extends Children.Keys<ClassPathSupport.Item>
implements AntProjectListener {
    private final AntProjectHelper model;
    private ClassPathSupport cs;
    private final UpdateHelper updateHelper;
    private EarProject project;

    public LogicalViewChildren(AntProjectHelper model, EarProject project, UpdateHelper updateHelper, ClassPathSupport cs) {
        if (null == model) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
        this.project = project;
        this.updateHelper = updateHelper;
        this.cs = cs;
    }

    protected void addNotify() {
        super.addNotify();
        this.model.addAntProjectListener((AntProjectListener)this);
        this.updateKeys();
    }

    private void updateKeys() {
        List<ClassPathSupport.Item> vcpis = EarProjectProperties.getJarContentAdditional(this.project);
        ArrayList<ClassPathSupport.Item> keys = new ArrayList<ClassPathSupport.Item>();
        for (ClassPathSupport.Item item : vcpis) {
            Project vcpiProject;
            J2eeModuleProvider jmp;
            if (item.getType() != 2 || item.getArtifact() == null || null == (jmp = (J2eeModuleProvider)(vcpiProject = item.getArtifact().getProject()).getLookup().lookup(J2eeModuleProvider.class))) continue;
            keys.add(item);
        }
        this.setKeys(keys);
    }

    protected void removeNotify() {
        this.model.removeAntProjectListener((AntProjectListener)this);
        this.setKeys(Collections.emptySet());
        super.removeNotify();
    }

    protected Node[] createNodes(ClassPathSupport.Item item) {
        return new Node[]{new ModuleNode(item, this.model.getProjectDirectory(), this.project, this.updateHelper, this.cs)};
    }

    public void modelChanged(Object ev) {
        this.updateKeys();
    }

    public void configurationXmlChanged(AntProjectEvent ape) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogicalViewChildren.this.updateKeys();
            }
        });
    }

    public void propertiesChanged(AntProjectEvent ape) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogicalViewChildren.this.updateKeys();
            }
        });
    }
}

