/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.ui.OpenableInBrowser;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.api.UI;
import org.netbeans.modules.hudson.ui.nodes.HudsonArtifactsNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

class HudsonMavenModuleBuildNode
extends AbstractNode {
    private final HudsonMavenModuleBuild module;
    private String htmlDisplayName;

    public HudsonMavenModuleBuildNode(HudsonMavenModuleBuild module) {
        super(HudsonMavenModuleBuildNode.makeChildren(module), Lookups.singleton((Object)module));
        this.module = module;
        this.setName(module.getName());
        this.setDisplayName(module.getDisplayName());
        try {
            this.htmlDisplayName = module.getColor().colorizeDisplayName(XMLUtil.toElementContent((String)this.getDisplayName()));
        }
        catch (CharConversionException x) {
            this.htmlDisplayName = null;
        }
        this.setIconBaseWithExtension(module.getColor().iconBase());
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(UI.showConsoleAction(this.module));
        actions.add((Action)UI.showFailuresAction());
        actions.add(null);
        if (this.module instanceof OpenableInBrowser) {
            actions.add(OpenUrlAction.forOpenable((OpenableInBrowser)this.module));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private static Children makeChildren(final HudsonMavenModuleBuild module) {
        return Children.create((ChildFactory)new ChildFactory<Object>(){
            final Object ARTIFACTS = new Object();

            protected boolean createKeys(List<Object> toPopulate) {
                if (module.getArtifacts() != null) {
                    toPopulate.add(this.ARTIFACTS);
                }
                return true;
            }

            protected Node createNodeForKey(Object key) {
                assert (key == this.ARTIFACTS) : key;
                return new HudsonArtifactsNode(module);
            }
        }, (boolean)false);
    }
}

