/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.ojet.javascript;

import java.util.Collections;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.ojet.OJETUtils;
import org.netbeans.modules.html.ojet.data.DataItem;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class OJETCodeCompletionItem
implements CompletionProposal {
    private final int anchorOffset;
    private final ElementHandle element;

    public OJETCodeCompletionItem(ElementHandle element, int anchorOffset) {
        this.anchorOffset = anchorOffset;
        this.element = element;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        OJETUtils.logUsage(null);
        return this.element.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return 20;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        return this.element.getName();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return "";
    }

    public static class OJETComponentEventItem
    extends OJETComponentOptionItem {
        private static ImageIcon eventIcon = null;

        public OJETComponentEventItem(DataItem option, CodeCompletionContext ccContext) {
            super(option, ccContext);
        }

        @Override
        public ImageIcon getIcon() {
            if (eventIcon == null) {
                eventIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/html/ojet/ui/resources/ojetEvent-icon.png"));
            }
            return eventIcon;
        }
    }

    public static class OJETComponentOptionItem
    extends OJETComponentItem {
        private final DataItem option;

        public OJETComponentOptionItem(DataItem option, CodeCompletionContext ccContext) {
            super(option, ccContext);
            this.option = option;
        }

        @Override
        public String getCustomInsertTemplate() {
            return this.option.getName() + ": ";
        }
    }

    public static class OJETComponentItem
    extends OJETCodeCompletionItem {
        private final DataItem component;
        private final CodeCompletionContext context;

        public OJETComponentItem(DataItem component, CodeCompletionContext ccContext) {
            super(new DocSimpleElement(component.getName(), component.getDocumentation(), ElementKind.CLASS), ccContext.getCaretOffset());
            this.component = component;
            this.context = ccContext;
        }

        @Override
        public ImageIcon getIcon() {
            return OJETUtils.OJET_ICON;
        }

        @Override
        public int getAnchorOffset() {
            return this.context.getCaretOffset() - this.context.getPrefix().length();
        }

        @Override
        public String getCustomInsertTemplate() {
            int diff;
            TokenSequence ts;
            String result = this.component.getName();
            TokenHierarchy th = TokenHierarchy.get((Document)this.context.getParserResult().getSnapshot().getSource().getDocument(true));
            if (th != null && (ts = LexerUtils.getTokenSequence((TokenHierarchy)th, (int)this.context.getCaretOffset(), (Language)JsTokenId.javascriptLanguage(), (boolean)false)) != null && ((diff = ts.move(this.context.getCaretOffset())) == 0 && ts.movePrevious() || ts.moveNext())) {
                boolean isInString;
                Token token = ts.token();
                JsTokenId id = (JsTokenId)token.id();
                if (id == JsTokenId.UNKNOWN && ts.movePrevious()) {
                    token = ts.token();
                    id = (JsTokenId)token.id();
                }
                boolean bl = isInString = id == JsTokenId.STRING_BEGIN || id == JsTokenId.STRING;
                if (!isInString) {
                    result = '\'' + result + '\'';
                }
            }
            return result;
        }
    }

    public static class DocSimpleElement
    extends SimpleElement {
        private final String documentation;

        public DocSimpleElement(String name, String documentation, ElementKind kind) {
            super(name, kind);
            this.documentation = documentation;
        }

        public String getDocumentation() {
            return this.documentation;
        }
    }

    public static class SimpleElement
    implements ElementHandle {
        private final String name;
        private final ElementKind kind;

        public SimpleElement(String name, ElementKind kind) {
            this.name = name;
            this.kind = kind;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getName() {
            return this.name;
        }

        public String getIn() {
            return "";
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }
    }
}

