/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.netbeans.modules.html.custom.conf.Tag;

public abstract class Element {
    private final String name;
    private final String description;
    private final String documentation;
    private final String documentationURL;
    private final Collection<String> contextNames = new ArrayList<String>();
    private final Tag parent;
    private final boolean required;

    public Element(String name, String description, String documentation, String documentationURL, Tag parent, boolean required, String ... contexts) {
        this.name = name;
        this.description = description;
        this.documentation = documentation;
        this.documentationURL = documentationURL;
        this.parent = parent;
        this.contextNames.addAll(Arrays.asList(contexts));
        this.required = required;
        if (parent != null) {
            this.contextNames.add(parent.getName());
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public void addContext(String tagName) {
        this.contextNames.add(tagName);
    }

    public String getName() {
        return this.name;
    }

    public Collection<String> getContexts() {
        return this.contextNames;
    }

    public Tag getParent() {
        return this.parent;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getDocumentationURL() {
        return this.documentationURL;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name=");
        sb.append(this.name);
        if (this.parent != null) {
            sb.append(',');
            sb.append("parent=");
            sb.append(this.parent != null ? this.parent.getName() : null);
        }
        if (this.getContexts() != null) {
            sb.append(',');
            sb.append("contexts={");
            for (String ctx : this.getContexts()) {
                sb.append(ctx);
                sb.append(',');
            }
            sb.append("}");
        }
        if (this.description != null) {
            sb.append(',');
            sb.append("description=");
            sb.append(this.description);
        }
        if (this.documentation != null) {
            sb.append(',');
            sb.append("doc=");
            sb.append(this.documentation);
        }
        if (this.documentationURL != null) {
            sb.append(',');
            sb.append("doc_url=");
            sb.append(this.documentationURL);
        }
        return sb.toString();
    }
}

