/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.htmlui;

import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.netbeans.modules.gradle.spi.newproject.TemplateOperation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.MapFormat;

public final class GradleArchetype {
    private final FileObject templates;
    private final File rootDir;
    private final Map<String, Object> params;

    public GradleArchetype(FileObject templates, File rootDir, Map<String, Object> params) {
        this.templates = templates;
        this.rootDir = rootDir;
        this.params = params;
    }

    public final void copyTemplates(TemplateOperation ops) {
        MapFormat mf = new MapFormat(this.params);
        mf.setLeftBrace("${");
        mf.setRightBrace("}");
        LinkedList<File> projectDirs = new LinkedList<File>();
        projectDirs.add(this.rootDir);
        Enumeration en = this.templates.getChildren(true);
        while (en.hasMoreElements()) {
            FileObject template = (FileObject)en.nextElement();
            String relativePath = FileUtil.getRelativePath((FileObject)this.templates, (FileObject)template);
            if (template.isFolder()) {
                File dir = new File(this.rootDir, relativePath);
                ops.createFolder(dir);
                Object projectAttr = template.getAttribute("project");
                if (Boolean.TRUE != projectAttr) continue;
                projectDirs.add(dir);
                continue;
            }
            if (!template.isData()) continue;
            Object packageAttr = template.getAttribute("package");
            if (packageAttr instanceof String) {
                String relativeParent = FileUtil.getRelativePath((FileObject)this.templates, (FileObject)template.getParent());
                String packageName = mf.format(packageAttr);
                File sourceRoot = new File(this.rootDir, relativeParent);
                ops.createPackage(sourceRoot, packageName);
                File packageDir = new File(sourceRoot, packageName.replace('.', '/'));
                HashMap<String, Object> pparams = new HashMap<String, Object>(this.params);
                pparams.put("package", packageName);
                GradleArchetype.copyDataTemplate(ops, template, new File(packageDir, template.getNameExt()), pparams);
                continue;
            }
            GradleArchetype.copyDataTemplate(ops, template, new File(this.rootDir, relativePath), this.params);
        }
        for (File projectDir : projectDirs) {
            ops.addProjectPreload(projectDir);
        }
    }

    private static void copyDataTemplate(TemplateOperation ops, FileObject template, File target, Map<String, Object> params) {
        Object importantAttr = template.getAttribute("important");
        if (importantAttr == Boolean.TRUE) {
            ops.openFromTemplate(template.getPath(), target, params);
        } else {
            ops.copyFromTemplate(template.getPath(), target, params);
        }
    }
}

