/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.modules.glassfish.tooling.utils.NetUtils;

public class IpComboBox
extends JComboBox<InetAddr> {
    public static final String IP_4_127_0_0_1_NAME = "localhost";
    private static final byte[] IP_4_127_0_0_1 = IpComboBox.initIp127_0_0_1();
    private static final InetAddrComparator ipComparator = new InetAddrComparator();
    private static final String CONSTRUCTOR_EXCEPTION_MSG = "Data model for a combo box shall not be supplied in constructor.";

    private static byte[] initIp127_0_0_1() {
        try {
            return InetAddress.getByName("127.0.0.1").getAddress();
        }
        catch (UnknownHostException uhe) {
            throw new IllegalStateException("Could not initialize raw byte sequence for 127.0.0.1");
        }
    }

    public static boolean isLocalhost(InetAddress ip) {
        byte[] ipBytes = ip.getAddress();
        boolean result = IP_4_127_0_0_1.length == ipBytes.length;
        for (int i = 0; result && i < ip.getAddress().length; i = (int)((byte)(i + 1))) {
            result = IP_4_127_0_0_1[i] == ipBytes[i];
        }
        return result;
    }

    private static int loopBackCount(Set<? extends InetAddress> ips) {
        int count = 0;
        for (InetAddress inetAddress : ips) {
            if (!inetAddress.isLoopbackAddress()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddr[] toInetAddr(Set<? extends InetAddress> ipsIn, boolean lopbackOnly) {
        void var6_9;
        int size = ipsIn == null ? 0 : (lopbackOnly ? IpComboBox.loopBackCount(ipsIn) : ipsIn.size());
        InetAddr[] ipsOut = new InetAddr[size];
        int i = 0;
        for (InetAddress inetAddress : ipsIn) {
            if (lopbackOnly && !inetAddress.isLoopbackAddress()) continue;
            ipsOut[i++] = new InetAddr(inetAddress, false);
        }
        Arrays.sort(ipsOut, ipComparator);
        boolean gotDefault = false;
        boolean bl = false;
        while (var6_9 < ipsOut.length) {
            if (ipsOut[var6_9].getIp().isLoopbackAddress()) {
                ipsOut[var6_9].def = true;
                gotDefault = true;
                break;
            }
            ++var6_9;
        }
        if (!gotDefault && ipsOut.length > 0) {
            ipsOut[0].def = true;
        }
        return ipsOut;
    }

    @Deprecated
    public IpComboBox(ComboBoxModel comboBoxModel) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(CONSTRUCTOR_EXCEPTION_MSG);
    }

    @Deprecated
    public IpComboBox(Object[] items) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(CONSTRUCTOR_EXCEPTION_MSG);
    }

    @Deprecated
    public IpComboBox(Vector<?> items) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(CONSTRUCTOR_EXCEPTION_MSG);
    }

    public IpComboBox(boolean lopbackOnly) {
        super(new DefaultComboBoxModel<InetAddr>(IpComboBox.toInetAddr(NetUtils.getHostIP4s(), lopbackOnly)));
    }

    public IpComboBox(Set<? extends InetAddress> ips, boolean lopbackOnly) {
        super(new DefaultComboBoxModel<InetAddr>(IpComboBox.toInetAddr(ips, lopbackOnly)));
    }

    public void updateModel(boolean lopbackOnly) {
        this.setModel(new DefaultComboBoxModel<InetAddr>(IpComboBox.toInetAddr(NetUtils.getHostIP4s(), lopbackOnly)));
    }

    public void updateModel(Set<? extends InetAddress> ips, boolean lopbackOnly) {
        this.setModel(new DefaultComboBoxModel<InetAddr>(IpComboBox.toInetAddr(ips, lopbackOnly)));
    }

    public InetAddress getSelectedIp() {
        Object item = this.getSelectedItem();
        if (item instanceof InetAddr) {
            return ((InetAddr)item).getIp();
        }
        if (item instanceof String) {
            InetAddress ip;
            try {
                ip = InetAddress.getByName(((String)item).trim());
            }
            catch (SecurityException | UnknownHostException ex) {
                ip = null;
            }
            return ip;
        }
        return null;
    }

    @Override
    public Object getSelectedItem() {
        Object item = super.getSelectedItem();
        if (item instanceof InetAddr || item instanceof String || item == null) {
            return item;
        }
        throw new IllegalStateException("Selected item is not IP adress");
    }

    public void setSelectedIp(InetAddress ip) {
        int count = this.dataModel.getSize();
        int defaultIndex = -1;
        boolean isSelectedSet = false;
        for (int i = 0; i < count; ++i) {
            InetAddr element = (InetAddr)this.dataModel.getElementAt(i);
            if (ip.equals(element.getIp())) {
                super.setSelectedItem(element);
                isSelectedSet = true;
                break;
            }
            if (!element.isDefault()) continue;
            defaultIndex = i;
        }
        if (!isSelectedSet && count > 0) {
            super.setSelectedItem(this.dataModel.getElementAt(defaultIndex >= 0 ? defaultIndex : 0));
        }
    }

    @Override
    public void setSelectedItem(Object ip) {
        if (ip instanceof String) {
            return;
        }
        if (ip == null) {
            int count = this.dataModel.getSize();
            for (int i = 0; i < count; ++i) {
                if (!((InetAddr)this.dataModel.getElementAt(i)).isDefault()) continue;
                super.setSelectedItem(this.dataModel.getElementAt(i));
                break;
            }
        }
        if (ip instanceof InetAddr) {
            this.setSelectedIp(((InetAddr)ip).getIp());
        }
        if (ip instanceof InetAddress) {
            this.setSelectedIp((InetAddress)ip);
        } else {
            super.setSelectedItem(ip);
        }
    }

    public static class InetAddrComparator
    implements Comparator<InetAddr> {
        private static final NetUtils.InetAddressComparator INET_ADDRESS_COMPARATOR = new NetUtils.InetAddressComparator();

        @Override
        public int compare(InetAddr ip1, InetAddr ip2) {
            return INET_ADDRESS_COMPARATOR.compare(ip1.getIp(), ip2.getIp());
        }
    }

    public static class InetAddr {
        private final InetAddress ip;
        private boolean def;

        InetAddr(InetAddress ip, boolean def) {
            this.ip = ip;
            this.def = def;
        }

        public InetAddress getIp() {
            return this.ip;
        }

        public String toString() {
            return IpComboBox.isLocalhost(this.ip) ? IpComboBox.IP_4_127_0_0_1_NAME : this.ip.getHostAddress();
        }

        public boolean isDefault() {
            return this.def;
        }
    }
}

