/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.conflicts;

import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class ResolveAllConflictsAction
extends MultipleRepositoryAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/git/resources/icons/conflict-resolve.png";

    public ResolveAllConflictsAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected boolean enableFull(Node[] activatedNodes) {
        VCSContext context = this.getCurrentContext(activatedNodes);
        Set<File> roots = GitUtils.getRepositoryRoots(context);
        return Git.getInstance().getFileStatusCache().containsFiles(roots, EnumSet.of(FileInformation.Status.IN_CONFLICT), false);
    }

    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        return ((ResolveConflictsAction)SystemAction.get(ResolveConflictsAction.class)).performAction(repository, new File[]{repository}, GitUtils.getContextForFile(repository));
    }
}

