/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitFileNode;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.AddAction;
import org.netbeans.modules.git.ui.checkout.CheckoutPathsAction;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.git.ui.commit.IncludeInCommitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.diff.Bundle;
import org.netbeans.modules.git.ui.diff.DiffFileTable;
import org.netbeans.modules.git.ui.diff.DiffFileTreeImpl;
import org.netbeans.modules.git.ui.diff.DiffFileViewComponent;
import org.netbeans.modules.git.ui.diff.DiffNode;
import org.netbeans.modules.git.ui.diff.ExportUncommittedChangesAction;
import org.netbeans.modules.git.ui.diff.MultiDiffPanel;
import org.netbeans.modules.git.ui.diff.Setup;
import org.netbeans.modules.git.ui.ignore.IgnoreAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.ui.repository.RevisionPicker;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.diff.DiffViewModeSwitcher;
import org.netbeans.modules.versioning.diff.EditorSaveCookie;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.OpenInEditorAction;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class MultiDiffPanelController
implements ActionListener,
PropertyChangeListener,
PreferenceChangeListener {
    private final VCSContext context;
    private EnumSet<FileInformation.Status> displayStatuses;
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private FileInformation.Mode mode;
    private final MultiDiffPanel panel;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private PlaceholderPanel diffViewPanel;
    private JComponent infoPanelLoadingFromRepo;
    static final Logger LOG = Logger.getLogger(MultiDiffPanelController.class.getName());
    private DiffFileViewComponent<DiffNode> activeComponent;
    private DiffFileTable fileListComponent;
    private DiffFileTreeImpl fileTreeComponent;
    private static final RequestProcessor RP = new RequestProcessor("GitDiffWindow", 1);
    private final RefreshNodesTask refreshNodesTask = new RefreshNodesTask();
    private final ApplyChangesTask changeTask = new ApplyChangesTask();
    private final RequestProcessor.Task refreshNodesRPTask = RP.create((Runnable)this.refreshNodesTask);
    private final RequestProcessor.Task changeRPTask = RP.create((Runnable)this.changeTask);
    private static final String TEXT_DIFF = "text/x-diff";
    private GitProgressSupport multiTextDiffSupport;
    private static final String PROP_SEARCH_CONTAINER = "diff.search.container";
    private boolean dividerSet;
    private final Map<File, Setup> setups = new HashMap<File, Setup>();
    private final Map<File, EditorCookie> editorCookies = new HashMap<File, EditorCookie>();
    private JComponent diffView;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private Setup currentSetup;
    private GitProgressSupport statusRefreshSupport;
    private PreferenceChangeListener prefList;
    private final Revision revisionOriginalLeft;
    private final Revision revisionOriginalRight;
    private Revision revisionLeft;
    private Revision revisionRight;
    private final boolean fixedRevisions;
    private static final String REVISION_SELECT = Bundle.MSG_Revision_Select();
    private static final String REVISION_SELECT_SEP = Bundle.MSG_Revision_Select_Separator();
    private RequestProcessor.Task refreshComboTask;
    private boolean activated = true;
    private int popupViewIndex;
    private int requestedRightLine = -1;
    private int requestedLeftLine = -1;
    private static final int VIEW_MODE_TABLE = 1;
    private static final int VIEW_MODE_TREE = 2;
    private int currentSetupDiffLengthChanged;
    private boolean fileComponentSetSelectedIndexContext;
    private boolean popupAllowed;
    private DiffViewModeSwitcher diffViewModeSwitcher;
    PropertyChangeListener list;
    private int lastDividerLoc;
    private final Map<File, FileStatusCache.ChangedEvent> changes = new HashMap<File, FileStatusCache.ChangedEvent>();

    public MultiDiffPanelController(VCSContext context, Revision rev1, Revision rev2) {
        this(context, rev1, rev2, false);
        this.popupAllowed = true;
        this.initFileComponent();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.initPanelMode();
        this.attachListeners();
        this.refreshComponents();
        this.refreshComboTask = Git.getInstance().getRequestProcessor().create((Runnable)new RefreshComboTask());
        this.refreshSelectionCombos();
    }

    public MultiDiffPanelController(GitFileNode[] files, FileInformation.Mode mode) {
        this(null, Revision.HEAD, Revision.LOCAL, true);
        for (JComponent c : new JComponent[]{this.panel.tgbHeadVsIndex, this.panel.tgbHeadVsWorking, this.panel.tgbIndexVsWorking}) {
            c.setVisible(false);
        }
        this.popupAllowed = false;
        this.panel.treeSelectionPanel.setVisible(false);
        this.initFileComponent();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.changeFiles(files, mode);
        this.refreshComponents();
    }

    public MultiDiffPanelController(File file, Revision rev1, Revision rev2, int requestedRightLine) {
        this(null, rev1, rev2, true);
        this.diffViewPanel = new PlaceholderPanel();
        this.diffViewPanel.setComponent((Component)this.getInfoPanelLoading());
        this.requestedRightLine = requestedRightLine;
        this.popupAllowed = false;
        this.replaceVerticalSplitPane((JComponent)this.diffViewPanel);
        this.initToolbarButtons();
        this.initNextPrevActions();
        for (JComponent c : new JComponent[]{this.panel.tgbHeadVsIndex, this.panel.tgbHeadVsWorking, this.panel.tgbIndexVsWorking}) {
            c.setVisible(false);
        }
        Setup s = new Setup(file, rev1, rev2, null);
        GitFileNode.GitLocalFileNode fNode = new GitFileNode.GitLocalFileNode(Git.getInstance().getRepositoryRoot(file), file);
        EditorCookie cookie = DiffUtils.getEditorCookie((AbstractDiffSetup)s);
        s.setNode(new DiffNode.DiffLocalNode(fNode, s, cookie, FileInformation.Mode.HEAD_VS_WORKING_TREE));
        Map<File, Setup> localSetups = Collections.singletonMap(file, s);
        this.setSetups(localSetups, MultiDiffPanelController.getCookiesFromSetups(localSetups));
        this.setDiffIndex(s, 0, false);
        this.dpt = new DiffPrepareTask(this.setups.values().toArray(new Setup[this.setups.size()]));
        this.prepareTask = RP.create((Runnable)this.dpt);
        this.prepareTask.schedule(0);
    }

    private MultiDiffPanelController(VCSContext context, Revision revisionLeft, Revision revisionRight, boolean fixedRevisions) {
        this.context = context;
        this.revisionLeft = this.revisionOriginalLeft = revisionLeft;
        this.revisionRight = this.revisionOriginalRight = revisionRight;
        this.fixedRevisions = fixedRevisions;
        this.panel = new MultiDiffPanel();
        this.diffViewPanel = null;
        if (fixedRevisions) {
            this.panel.treeSelectionPanel.setVisible(false);
        }
        this.initSelectionCombos();
    }

    private void initSelectionCombos() {
        if (this.fixedRevisions) {
            this.panel.treeSelectionPanel.setVisible(false);
        } else {
            this.panel.cmbDiffTreeFirst.setMinimumSize(this.panel.cmbDiffTreeFirst.getMinimumSize());
            this.panel.cmbDiffTreeSecond.setMinimumSize(this.panel.cmbDiffTreeSecond.getMinimumSize());
            this.panel.treeSelectionPanel.setMinimumSize(this.panel.treeSelectionPanel.getMinimumSize());
            this.panel.cmbDiffTreeFirst.setRenderer(new RevisionCellRenderer());
            this.panel.cmbDiffTreeFirst.setModel(new DefaultComboBoxModel<Revision>(new Revision[]{this.revisionRight}));
            this.panel.cmbDiffTreeFirst.addActionListener(this);
            this.panel.cmbDiffTreeSecond.setRenderer(new RevisionCellRenderer());
            this.panel.cmbDiffTreeSecond.setModel(new DefaultComboBoxModel<Revision>(new Revision[]{this.revisionLeft}));
            this.panel.cmbDiffTreeSecond.addActionListener(this);
        }
    }

    private DiffFileViewComponent<DiffNode> getActiveFileComponent() {
        return this.activeComponent;
    }

    private void setActiveComponent(DiffFileViewComponent<DiffNode> fileComponent) {
        if (this.activeComponent == fileComponent) {
            return;
        }
        this.activeComponent = fileComponent;
        GitModuleConfig.getDefault().setDiffViewMode(this.activeComponent == this.fileListComponent ? 1 : 2);
        int gg = this.panel.splitPane.getDividerLocation();
        this.panel.splitPane.setTopComponent(this.getActiveFileComponent().getComponent());
        this.panel.splitPane.setDividerLocation(gg);
    }

    private void refreshSelectionCombos() {
        if (!this.fixedRevisions && GitUtils.getRepositoryRoots(this.context).size() == 1) {
            this.panel.cmbDiffTreeFirst.setEnabled(false);
            this.panel.cmbDiffTreeSecond.setEnabled(false);
            this.refreshComboTask.schedule(100);
        }
    }

    private void replaceVerticalSplitPane(JComponent replacement) {
        this.panel.removeAll();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.panel.controlToolbar, "North");
        this.panel.add((Component)replacement, "Center");
    }

    void setActions(JComponent comp) {
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        this.panel.getActionMap().put("prevInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanelController.this.onNextInnerView();
            }
        });
        this.panel.getActionMap().put("nextInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanelController.this.onPrevInnerView();
            }
        });
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void attachListeners() {
        this.panel.tgbHeadVsWorking.addActionListener(this);
        this.panel.tgbHeadVsIndex.addActionListener(this);
        this.panel.tgbIndexVsWorking.addActionListener(this);
        this.panel.btnCommit.addActionListener(this);
        this.panel.btnRevert.addActionListener(this);
        this.panel.btnRefresh.addActionListener(this);
        this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)Git.getInstance().getFileStatusCache());
        Git.getInstance().getFileStatusCache().addPropertyChangeListener(this.list);
        this.prefList = (PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)GitModuleConfig.getDefault().getPreferences());
        GitModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this.prefList);
    }

    boolean canClose() {
        if (this.setups.isEmpty()) {
            return true;
        }
        Map<File, SaveCookie> saveCookies = this.getSaveCookies(true);
        return saveCookies.isEmpty() || SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies.values().toArray(new SaveCookie[0]));
    }

    public Map<File, SaveCookie> getSaveCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        return this.getSaveCookies(editorCookiesCopy);
    }

    public EditorCookie[] getEditorCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        int count = 0;
        int length = editorCookiesCopy.length;
        Object[] editorCookiesShorten = new EditorCookie[length];
        for (int i = 0; i < length; ++i) {
            EditorCookie editorCookie = editorCookiesCopy[i];
            if (editorCookie == null) continue;
            editorCookiesShorten[count++] = editorCookie;
        }
        return (EditorCookie[])CollectionUtils.shortenArray((Object[])editorCookiesShorten, (int)count);
    }

    private EditorCookie[] getEditorCookiesIntern(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.editorCookies.values().toArray(new EditorCookie[this.editorCookies.values().size()]);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        if (ommitOpened) {
            DiffUtils.cleanThoseWithEditorPaneOpen((EditorCookie[])editorCookiesCopy);
        }
        return editorCookiesCopy;
    }

    private Map<File, SaveCookie> getSaveCookies(EditorCookie[] editorCookies) {
        HashMap<File, SaveCookie> proResult = new HashMap<File, SaveCookie>();
        HashSet<EditorCookie> editorCookieSet = new HashSet<EditorCookie>(Arrays.asList(editorCookies));
        for (Map.Entry<File, EditorCookie> e : this.editorCookies.entrySet()) {
            File baseFile;
            FileObject fileObj;
            if (!editorCookieSet.contains(e.getValue()) || (fileObj = FileUtil.toFileObject((File)(baseFile = e.getKey()))) == null) continue;
            proResult.put(baseFile, (SaveCookie)new EditorSaveCookie(e.getValue(), fileObj.getNameExt()));
        }
        return proResult;
    }

    UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    public void componentClosed() {
        this.setSetups(Collections.emptyMap(), Collections.emptyMap());
        this.prevAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.cancelBackgroundTasks();
        this.setups.clear();
        this.editorCookies.clear();
        if (this.list != null) {
            Git.getInstance().getFileStatusCache().removePropertyChangeListener(this.list);
        }
        if (this.prefList != null) {
            GitModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this.prefList);
        }
        this.dpt = null;
        DiffViewModeSwitcher.release((Object)this);
        this.diffViewModeSwitcher = null;
    }

    private void cancelBackgroundTasks() {
        GitProgressSupport supp;
        if (this.multiTextDiffSupport != null) {
            this.multiTextDiffSupport.cancel();
        }
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        if ((supp = this.statusRefreshSupport) != null) {
            supp.cancel();
        }
        this.refreshNodesTask.cancel();
        this.refreshNodesRPTask.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFocused(boolean focused) {
        if (focused) {
            DiffFileViewComponent<DiffNode> comp = this.getActiveFileComponent();
            if (comp != null) {
                comp.getComponent().requestFocusInWindow();
            }
            Map<File, FileStatusCache.ChangedEvent> map = this.changes;
            synchronized (map) {
                this.activated = true;
            }
            this.changeRPTask.schedule(100);
        } else {
            Map<File, FileStatusCache.ChangedEvent> map = this.changes;
            synchronized (map) {
                this.activated = false;
            }
        }
    }

    private void displayDiffView() {
        if (this.diffViewPanel == null) {
            int gg = this.panel.splitPane.getDividerLocation();
            this.panel.splitPane.setBottomComponent(this.diffView);
            this.panel.splitPane.setDividerLocation(gg);
        } else {
            this.diffViewPanel.setComponent((Component)this.diffView);
        }
    }

    private void initNextPrevActions() {
        this.nextAction = new AbstractAction(null, ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/git/resources/icons/diff-next.png", (boolean)false)){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.nextButton.toolTipText"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanelController.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/git/resources/icons/diff-prev.png", (boolean)false)){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.prevButton.toolTipText"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanelController.this.onPrevButton();
            }
        };
        this.panel.nextButton.setAction(this.nextAction);
        this.panel.prevButton.setAction(this.prevAction);
    }

    private void initFileComponent() {
        this.fileListComponent = new DiffFileTable((VCSStatusTableModel<DiffNode>)new VCSStatusTableModel((VCSStatusNode[])new DiffNode[0]), this);
        this.fileListComponent.addPropertyChangeListener(this);
        this.fileTreeComponent = new DiffFileTreeImpl(this);
        int viewMode = GitModuleConfig.getDefault().getDiffViewMode(1);
        if (viewMode == 2) {
            this.panel.treeButton.setSelected(true);
            this.setActiveComponent(this.fileTreeComponent);
        } else {
            this.panel.listButton.setSelected(true);
            this.setActiveComponent(this.fileListComponent);
        }
        this.panel.splitPane.setBottomComponent(this.getInfoPanelLoading());
        this.panel.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                JComponent parent = (JComponent)MultiDiffPanelController.this.panel.getParent();
                parent.getActionMap().put("jumpNext", MultiDiffPanelController.this.nextAction);
                parent.getActionMap().put("jumpPrev", MultiDiffPanelController.this.prevAction);
                if (MultiDiffPanelController.this.lastDividerLoc != 0) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((MultiDiffPanelController)MultiDiffPanelController.this).panel.splitPane.setDividerLocation(MultiDiffPanelController.this.lastDividerLoc);
                        }
                    });
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (MultiDiffPanelController.this.dividerSet) {
                    MultiDiffPanelController.this.lastDividerLoc = ((MultiDiffPanelController)MultiDiffPanelController.this).panel.splitPane.getDividerLocation();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private void initToolbarButtons() {
        if (this.context != null) {
            this.panel.btnCommit.setEnabled(false);
            this.panel.btnRevert.setEnabled(false);
        } else {
            this.panel.btnCommit.setVisible(false);
            this.panel.btnRevert.setVisible(false);
            this.panel.btnRefresh.setVisible(false);
        }
        if (this.showingFileComponent()) {
            this.panel.listButton.addActionListener(this);
            this.panel.treeButton.addActionListener(this);
        } else {
            this.panel.listButton.setVisible(false);
            this.panel.treeButton.setVisible(false);
        }
    }

    private JComponent getInfoPanelLoading() {
        if (this.infoPanelLoadingFromRepo == null) {
            this.infoPanelLoadingFromRepo = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        return this.infoPanelLoadingFromRepo;
    }

    private void refreshComponents() {
        int currentDifferenceIndex;
        if (this.currentSetup == null) {
            this.nextAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            return;
        }
        DiffController view = this.currentSetup.getView();
        int n = currentDifferenceIndex = view != null ? view.getDifferenceIndex() : -1;
        if (view != null) {
            this.nextAction.setEnabled(this.showingFileComponent() && this.getActiveFileComponent().hasNextNode((Node)this.currentSetup.getNode()) || currentDifferenceIndex < view.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.showingFileComponent() && this.getActiveFileComponent().hasPreviousNode((Node)this.currentSetup.getNode()) || currentDifferenceIndex > 0);
    }

    private void onPrevInnerView() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.panel.tgbHeadVsIndex.setSelected(true);
        } else if (this.panel.tgbHeadVsIndex.isSelected()) {
            this.panel.tgbIndexVsWorking.setSelected(true);
        } else {
            this.panel.tgbHeadVsWorking.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onNextInnerView() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.panel.tgbIndexVsWorking.setSelected(true);
        } else if (this.panel.tgbIndexVsWorking.isSelected()) {
            this.panel.tgbHeadVsIndex.setSelected(true);
        } else {
            this.panel.tgbHeadVsWorking.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onDisplayedStatusChanged() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.mode = FileInformation.Mode.HEAD_VS_WORKING_TREE;
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING);
            if (this.context != null) {
                GitModuleConfig.getDefault().setLastUsedModificationContext(this.mode);
            }
        } else if (this.panel.tgbHeadVsIndex.isSelected()) {
            this.mode = FileInformation.Mode.HEAD_VS_INDEX;
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX);
            if (this.context != null) {
                GitModuleConfig.getDefault().setLastUsedModificationContext(this.mode);
            }
        } else {
            this.mode = FileInformation.Mode.INDEX_VS_WORKING_TREE;
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_INDEX_VS_WORKING);
            if (this.context != null) {
                GitModuleConfig.getDefault().setLastUsedModificationContext(this.mode);
            }
        }
    }

    private void setDisplayStatuses(EnumSet<FileInformation.Status> displayStatuses) {
        this.displayStatuses = displayStatuses;
        if (this.context != null) {
            this.refreshNodes();
        }
    }

    private void setSetups(Map<File, Setup> setups, Map<File, EditorCookie> editorCookies) {
        for (Map.Entry<File, Setup> e : this.setups.entrySet()) {
            Setup setup = e.getValue();
            if (setup == null) continue;
            setup.getFirstSource().close();
            setup.getSecondSource().close();
        }
        this.setups.clear();
        this.setups.putAll(setups);
        this.editorCookies.clear();
        this.editorCookies.putAll(editorCookies);
    }

    private void onNextButton() {
        DiffNode next;
        DiffController view = this.currentSetup.getView();
        DiffNode diffNode = next = this.showingFileComponent() ? (DiffNode)this.getActiveFileComponent().getNextNode((Node)this.currentSetup.getNode()) : null;
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (this.currentSetupDiffLengthChanged >= 0) {
                ++currentDifferenceIndex;
            }
            this.currentSetupDiffLengthChanged = view.getDifferenceCount();
            if (currentDifferenceIndex >= view.getDifferenceCount()) {
                if (next != null) {
                    this.setDiffIndex(next.getSetup(), 0, true);
                }
            } else {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else if (next != null) {
            this.setDiffIndex(next.getSetup(), 0, true);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffNode prev;
        DiffController view = this.currentSetup.getView();
        DiffNode diffNode = prev = this.showingFileComponent() ? (DiffNode)this.getActiveFileComponent().getPreviousNode((Node)this.currentSetup.getNode()) : null;
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (this.currentSetupDiffLengthChanged >= 0) {
                --currentDifferenceIndex;
            }
            this.currentSetupDiffLengthChanged = view.getDifferenceCount();
            if (currentDifferenceIndex < 0) {
                if (prev != null) {
                    this.setDiffIndex(prev.getSetup(), -1, true);
                }
            } else if (currentDifferenceIndex < view.getDifferenceCount()) {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else if (prev != null) {
            this.setDiffIndex(prev.getSetup(), -1, true);
        }
        this.refreshComponents();
    }

    private void setDiffIndex(Setup selectedSetup, int location, boolean restartPrepareTask) {
        this.currentSetup = selectedSetup;
        this.currentSetupDiffLengthChanged = -1;
        if (this.currentSetup != null) {
            if (this.multiTextDiffSupport != null) {
                this.multiTextDiffSupport.cancel();
            }
            if (restartPrepareTask) {
                if (this.dpt != null) {
                    this.dpt.cancel();
                }
                this.startPrepareTask(selectedSetup);
            }
            DiffController view = this.currentSetup.getView();
            TopComponent tc = (TopComponent)this.panel.getClientProperty(TopComponent.class);
            if (tc != null) {
                DiffNode node = this.currentSetup.getNode();
                tc.setActivatedNodes(new Node[]{node == null ? Node.EMPTY : node});
            }
            this.diffView = null;
            if (view != null) {
                this.currentSetupDiffLengthChanged = view.getDifferenceCount();
                if (this.showingFileComponent()) {
                    this.fileComponentSetSelectedIndexContext = true;
                    this.getActiveFileComponent().setSelectedNode((Node)this.currentSetup.getNode());
                    this.fileComponentSetSelectedIndexContext = false;
                }
                this.getDiffViewModeSwitcher().setupMode(view);
                this.diffView = view.getJComponent();
                this.diffView.getActionMap().put("jumpNext", this.nextAction);
                this.diffView.getActionMap().put("jumpPrev", this.prevAction);
                this.displayDiffView();
                if (location == -1) {
                    location = view.getDifferenceCount() - 1;
                }
                if (location >= 0 && location < view.getDifferenceCount()) {
                    view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, location);
                }
            } else {
                this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
                this.displayDiffView();
            }
        } else {
            DiffFileViewComponent<DiffNode> comp = this.getActiveFileComponent();
            NoContentPanel p = new NoContentPanel(comp == null || comp.getSelectedFiles().length == 0 ? NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoFileSelected") : NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_MoreFilesSelected"));
            this.diffView = p;
            p.addMouseListener(new MouseAdapter((JPanel)p){
                final /* synthetic */ JPanel val$p;
                {
                    this.val$p = jPanel;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    final Map.Entry actionRoots = MultiDiffPanelController.this.getSelectedActionRoots();
                    if (this.val$p == MultiDiffPanelController.this.diffView) {
                        if (actionRoots == null) {
                            MultiDiffPanelController.this.diffView = (JComponent)new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoDiff"));
                            MultiDiffPanelController.this.displayDiffView();
                            return;
                        }
                        GitProgressSupport supp = new GitProgressSupport(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            protected void perform() {
                                block4: {
                                    try {
                                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                        this.exportDiff(bos);
                                        if (val$p != MultiDiffPanelController.this.diffView || this.isCanceled()) break block4;
                                        final JEditorPane editorPane = new JEditorPane();
                                        final EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)MultiDiffPanelController.TEXT_DIFF);
                                        final Document doc = this.prepareDoc(bos.toString(this.findEncoding()), editorKit);
                                        bos.reset();
                                        EventQueue.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (val$p == MultiDiffPanelController.this.diffView) {
                                                    editorPane.setEditorKit(editorKit);
                                                    editorPane.setDocument(doc);
                                                    editorPane.setEditable(false);
                                                    JPanel searchContainer = new JPanel();
                                                    searchContainer.setLayout(new BoxLayout(searchContainer, 1));
                                                    JPanel view = new JPanel(new BorderLayout());
                                                    view.add((Component)searchContainer, "Last");
                                                    view.add((Component)new JScrollPane(editorPane), "Center");
                                                    editorPane.putClientProperty(MultiDiffPanelController.PROP_SEARCH_CONTAINER, searchContainer);
                                                    MultiDiffPanelController.this.diffView = view;
                                                    MultiDiffPanelController.this.displayDiffView();
                                                }
                                            }
                                        });
                                    }
                                    catch (UnsupportedEncodingException | BadLocationException | GitException ex) {
                                        try {
                                            GitClientExceptionHandler.notifyException((Exception)ex, true);
                                        }
                                        catch (Throwable throwable) {
                                            EventQueue.invokeLater(new Runnable(){

                                                @Override
                                                public void run() {
                                                    MultiDiffPanelController.this.multiTextDiffSupport = null;
                                                }
                                            });
                                            throw throwable;
                                        }
                                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    }
                                }
                                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }

                            private String findEncoding() {
                                for (File f : (File[])actionRoots.getValue()) {
                                    FileObject fo = FileUtil.toFileObject((File)f);
                                    if (fo == null || !fo.isValid() || !fo.isData()) continue;
                                    return FileEncodingQuery.getEncoding((FileObject)fo).name();
                                }
                                return "UTF-8";
                            }

                            private Document prepareDoc(String content, EditorKit editorKit) throws BadLocationException {
                                Document doc = editorKit.createDefaultDocument();
                                doc.putProperty("mimeType", MultiDiffPanelController.TEXT_DIFF);
                                doc.remove(0, doc.getLength());
                                doc.insertString(0, content, null);
                                return doc;
                            }

                            private void exportDiff(ByteArrayOutputStream bos) throws GitException {
                                String revOther;
                                String revBase;
                                GitClient client = this.getClient();
                                if (MultiDiffPanelController.this.isLocal()) {
                                    if (MultiDiffPanelController.this.mode == FileInformation.Mode.INDEX_VS_WORKING_TREE) {
                                        revBase = "INDEX";
                                        revOther = "WORKING_TREE";
                                    } else if (MultiDiffPanelController.this.mode == FileInformation.Mode.HEAD_VS_INDEX) {
                                        revBase = MultiDiffPanelController.this.revisionLeft.getCommitId();
                                        revOther = "INDEX";
                                    } else {
                                        revBase = MultiDiffPanelController.this.revisionLeft.getCommitId();
                                        revOther = "WORKING_TREE";
                                    }
                                } else {
                                    revBase = MultiDiffPanelController.this.revisionLeft.getCommitId();
                                    revOther = MultiDiffPanelController.this.revisionRight.getCommitId();
                                }
                                client.exportDiff((File[])actionRoots.getValue(), revBase, revOther, bos, this.getProgressMonitor());
                            }
                        };
                        MultiDiffPanelController.this.multiTextDiffSupport = supp;
                        supp.start(Git.getInstance().getRequestProcessor((File)actionRoots.getKey()), (File)actionRoots.getKey(), Bundle.MSG_DiffPanel_multiTextualDiff_preparing());
                    }
                }
            });
            this.displayDiffView();
        }
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.refreshComponents();
    }

    private DiffViewModeSwitcher getDiffViewModeSwitcher() {
        if (this.diffViewModeSwitcher == null) {
            this.diffViewModeSwitcher = DiffViewModeSwitcher.get((Object)this);
        }
        return this.diffViewModeSwitcher;
    }

    private Map.Entry<File, File[]> getSelectedActionRoots() {
        VCSContext ctx = this.context;
        DiffFileViewComponent<DiffNode> comp = this.getActiveFileComponent();
        File[] selectedFiles = new File[]{};
        if (comp != null) {
            selectedFiles = comp.getSelectedFiles();
        }
        if (selectedFiles.length == 0) {
            selectedFiles = this.setups.keySet().toArray(new File[this.setups.keySet().size()]);
        }
        ctx = GitUtils.getContextForFiles(this.filterExcluded(selectedFiles));
        return GitUtils.getActionRoots(ctx);
    }

    private File[] filterExcluded(File[] files) {
        ArrayList<File> filtered = new ArrayList<File>(files.length);
        for (File f : files) {
            Setup s = this.setups.get(f);
            if (s == null || this.isLocal() && s.getNode().getFileNode().getCommitOptions() == VCSCommitOptions.EXCLUDE) continue;
            filtered.add(f);
        }
        return filtered.toArray(new File[filtered.size()]);
    }

    private boolean showingFileComponent() {
        return this.getActiveFileComponent() != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final Object source = e.getSource();
        if (source == this.panel.tgbHeadVsIndex || e.getSource() == this.panel.tgbHeadVsWorking || source == this.panel.tgbIndexVsWorking) {
            this.onDisplayedStatusChanged();
        } else if (source == this.panel.cmbDiffTreeSecond) {
            boolean refresh;
            Revision oldSelection = this.revisionLeft;
            Revision newSelection = this.getSelectedRevision(this.panel.cmbDiffTreeSecond);
            if (newSelection != null) {
                this.revisionLeft = newSelection;
            }
            boolean bl = refresh = !oldSelection.getCommitId().equals(this.revisionLeft.getCommitId());
            if (refresh) {
                this.refreshNodes();
            }
        } else if (source == this.panel.cmbDiffTreeFirst) {
            boolean refresh;
            Revision oldSelection = this.revisionRight;
            Revision newSelection = this.getSelectedRevision(this.panel.cmbDiffTreeFirst);
            if (newSelection != null) {
                this.revisionRight = newSelection;
            }
            boolean bl = refresh = !oldSelection.getCommitId().equals(this.revisionRight.getCommitId());
            if (refresh) {
                this.refreshNodes();
            }
        } else if (source == this.panel.listButton) {
            this.setActiveComponent(this.fileListComponent);
            this.setActiveDiff();
        } else if (source == this.panel.treeButton) {
            this.setActiveComponent(this.fileTreeComponent);
            this.setActiveDiff();
        } else {
            Utils.postParallel((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (source == ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnRevert) {
                        ((RevertChangesAction)SystemAction.get(RevertChangesAction.class)).performAction(MultiDiffPanelController.this.context);
                    } else if (source == ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnCommit) {
                        ((CommitAction.GitViewCommitAction)SystemAction.get(CommitAction.GitViewCommitAction.class)).performAction(MultiDiffPanelController.this.context);
                    } else if (source == ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnRefresh) {
                        if (MultiDiffPanelController.this.isLocal()) {
                            MultiDiffPanelController.this.statusRefreshSupport = ((StatusAction)SystemAction.get(StatusAction.class)).scanStatus(MultiDiffPanelController.this.context);
                            if (MultiDiffPanelController.this.statusRefreshSupport != null) {
                                MultiDiffPanelController.this.statusRefreshSupport.getTask().waitFinished();
                                if (!MultiDiffPanelController.this.statusRefreshSupport.isCanceled()) {
                                    MultiDiffPanelController.this.refreshNodes();
                                }
                            }
                        } else {
                            MultiDiffPanelController.this.refreshNodes();
                        }
                    }
                }
            }, (int)0);
        }
    }

    private void setActiveDiff() {
        DiffNode selectedNode = (DiffNode)this.activeComponent.getSelectedNode();
        this.setDiffIndex(selectedNode == null ? null : selectedNode.getSetup(), 0, false);
    }

    JPopupMenu getPopupFor(final Node[] selectedNodes, File[] selectedFiles) {
        if (!this.popupAllowed) {
            return null;
        }
        final JPopupMenu menu = new JPopupMenu();
        final int popupIndex = ++this.popupViewIndex;
        JMenuItem item = menu.add((Action)new OpenInEditorAction(selectedFiles));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        if (this.isLocal() && this.revisionLeft == Revision.HEAD) {
            menu.addSeparator();
            final JMenuItem dummyItem = menu.add(Bundle.CTL_MultiDiffPanelController_popup_initializing());
            dummyItem.setEnabled(false);
            Git.getInstance().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    SystemActionBridge ia;
                    if (popupIndex != MultiDiffPanelController.this.popupViewIndex) {
                        return;
                    }
                    Lookup lkp = Lookups.fixed((Object[])selectedNodes);
                    final ArrayList<Object> actions = new ArrayList<Object>();
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(AddAction.class), (String)NbBundle.getMessage(AddAction.class, (String)"LBL_AddAction.popupName"), (Lookup)lkp));
                    if (popupIndex != MultiDiffPanelController.this.popupViewIndex) {
                        return;
                    }
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction.popupName"), (Lookup)lkp));
                    SystemActionBridge efca = SystemActionBridge.createAction((Action)SystemAction.get(ExcludeFromCommitAction.class), (String)NbBundle.getMessage(ExcludeFromCommitAction.class, (String)"LBL_ExcludeFromCommitAction_PopupName"), (Lookup)lkp);
                    SystemActionBridge iica = SystemActionBridge.createAction((Action)SystemAction.get(IncludeInCommitAction.class), (String)NbBundle.getMessage(IncludeInCommitAction.class, (String)"LBL_IncludeInCommitAction_PopupName"), (Lookup)lkp);
                    if (efca.isEnabled() || iica.isEnabled()) {
                        if (efca.isEnabled()) {
                            actions.add(efca);
                        } else if (iica.isEnabled()) {
                            actions.add(iica);
                        }
                    }
                    if ((ia = SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)NbBundle.getMessage(IgnoreAction.class, (String)"LBL_IgnoreAction_PopupName"), (Lookup)lkp)).isEnabled()) {
                        actions.add(ia);
                    }
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(RevertChangesAction.class), (String)NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_RevertChangesAction_PopupName"), (Lookup)lkp));
                    actions.add(new AbstractAction(NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"LBL_ExportUncommittedChangesAction_PopupName")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ((ExportUncommittedChangesAction)SystemAction.get(ExportUncommittedChangesAction.class)).exportDiff(selectedNodes, MultiDiffPanelController.this.getDiffMode());
                        }
                    });
                    actions.add(SystemActionBridge.createAction((Action)SystemAction.get(CheckoutPathsAction.class), (String)NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_CheckoutPathsAction_PopupName"), (Lookup)lkp));
                    ResolveConflictsAction a = (ResolveConflictsAction)SystemAction.get(ResolveConflictsAction.class);
                    if (a.isEnabled()) {
                        actions.add(null);
                        actions.add(SystemActionBridge.createAction((Action)((Object)a), (String)NbBundle.getMessage(ResolveConflictsAction.class, (String)"LBL_ResolveConflictsAction_PopupName"), (Lookup)lkp));
                    }
                    if (popupIndex == MultiDiffPanelController.this.popupViewIndex) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (popupIndex == MultiDiffPanelController.this.popupViewIndex && menu.isShowing()) {
                                    menu.remove(dummyItem);
                                    for (Action a : actions) {
                                        if (a == null) {
                                            menu.addSeparator();
                                            continue;
                                        }
                                        JMenuItem item = menu.add(a);
                                        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
                                    }
                                    menu.pack();
                                    menu.repaint();
                                }
                            }
                        });
                    }
                }
            });
        }
        return menu;
    }

    private GitClient.DiffMode getDiffMode() {
        GitClient.DiffMode diffMode = GitClient.DiffMode.HEAD_VS_WORKINGTREE;
        if (this.mode == FileInformation.Mode.HEAD_VS_INDEX) {
            diffMode = GitClient.DiffMode.HEAD_VS_INDEX;
        } else if (this.mode == FileInformation.Mode.INDEX_VS_WORKING_TREE) {
            diffMode = GitClient.DiffMode.INDEX_VS_WORKINGTREE;
        }
        return diffMode;
    }

    private Revision getSelectedRevision(JComboBox cmbDiffTree) {
        RevisionPicker picker;
        Object selectedItem = cmbDiffTree.getSelectedItem();
        Revision selection = null;
        if (selectedItem instanceof Revision) {
            selection = (Revision)selectedItem;
        } else if (selectedItem == REVISION_SELECT && (picker = new RevisionPicker(GitUtils.getRootFile(this.context), new File[0])).open()) {
            Revision selectedRevision = picker.getRevision();
            this.addToModel(selectedRevision, cmbDiffTree);
        }
        return selection;
    }

    private void addToModel(final Revision newItem, final JComboBox cmbDiffTree) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)cmbDiffTree.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            final Object item = model.getElementAt(i);
            if (!(item instanceof Revision) || !((Revision)item).getCommitId().equals(newItem.getCommitId()) || !((Revision)item).getRevision().equals(newItem.getRevision())) continue;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cmbDiffTree.setSelectedItem(item);
                }
            });
            return;
        }
        model.addElement(newItem);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                cmbDiffTree.setSelectedItem(newItem);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChange(FileStatusCache.ChangedEvent event) {
        if (this.context != null) {
            LOG.log(Level.FINE, "Planning refresh for {0}", event.getFile());
            boolean start = true;
            Map<File, FileStatusCache.ChangedEvent> map = this.changes;
            synchronized (map) {
                this.changes.put(event.getFile(), event);
                start = this.activated;
            }
            if (start) {
                this.changeRPTask.schedule(1000);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("status.changed".equals(evt.getPropertyName())) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)evt.getNewValue();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "File status for file {0} changed from {1} to {2}", new Object[]{changedEvent.getFile(), changedEvent.getOldInfo(), changedEvent.getNewInfo()});
            }
            if (this.revisionLeft == Revision.HEAD && this.revisionRight == Revision.LOCAL && this.affectsView(changedEvent)) {
                this.applyChange(changedEvent);
            }
        } else if ("(void) differencesChanged".equals(evt.getPropertyName())) {
            Setup setup = this.currentSetup;
            if (setup != null && setup.getView() != null) {
                final DiffController view = setup.getView();
                if (setup.getView().getDifferenceCount() < this.currentSetupDiffLengthChanged) {
                    this.currentSetupDiffLengthChanged = -1;
                } else if (this.currentSetupDiffLengthChanged != -1) {
                    this.currentSetupDiffLengthChanged = setup.getView().getDifferenceCount();
                }
                if (view.getDifferenceCount() > 0 && this.requestedRightLine != -1) {
                    final int leftLine = this.requestedLeftLine;
                    final int rightLine = this.requestedRightLine;
                    this.requestedLeftLine = -1;
                    this.requestedRightLine = -1;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.LineNumber, rightLine);
                            if (leftLine != -1) {
                                view.getJComponent().putClientProperty("diff.smartScrollDisabled", Boolean.TRUE);
                                view.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.LineNumber, leftLine);
                            }
                        }
                    });
                }
            }
            this.refreshComponents();
        } else if ("selectedFiles".equals(evt.getPropertyName()) && evt.getSource() == this.getActiveFileComponent()) {
            this.filesSelected((File[])evt.getNewValue());
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.panel.repaint();
        }
    }

    public final void selectFile(File file) {
        Setup setup = this.setups.get(file);
        DiffFileViewComponent<DiffNode> comp = this.getActiveFileComponent();
        if (setup != null && comp != null) {
            comp.setSelectedNode((Node)setup.getNode());
        }
    }

    public final void changeFiles(GitFileNode[] files, FileInformation.Mode mode) {
        this.lastDividerLoc = 0;
        this.dividerSet = false;
        this.mode = mode;
        ArrayList<DiffNode> nodes = new ArrayList<DiffNode>(files.length);
        HashMap<File, Setup> localSetups = new HashMap<File, Setup>(files.length);
        Git git = Git.getInstance();
        for (GitFileNode fNode : files) {
            File root = git.getRepositoryRoot(fNode.getFile());
            if (root == null) continue;
            Setup setup = new Setup(fNode, mode, Revision.HEAD);
            DiffNode.DiffImmutableNode diffNode = new DiffNode.DiffImmutableNode(fNode, setup, DiffUtils.getEditorCookie((AbstractDiffSetup)setup));
            nodes.add(diffNode);
            setup.setNode(diffNode);
            localSetups.put(fNode.getFile(), setup);
        }
        this.setupsChanged(localSetups, nodes);
    }

    private boolean affectsView(FileStatusCache.ChangedEvent changedEvent) {
        File file = changedEvent.getFile();
        FileInformation oldInfo = changedEvent.getOldInfo();
        FileInformation newInfo = changedEvent.getNewInfo();
        if (oldInfo == null ? !newInfo.containsStatus(this.displayStatuses) : !oldInfo.containsStatus(this.displayStatuses) && !newInfo.containsStatus(this.displayStatuses)) {
            return false;
        }
        return this.context == null ? false : GitUtils.contains(this.context.getRootFiles(), file);
    }

    private void initPanelMode() {
        this.mode = GitModuleConfig.getDefault().getLastUsedModificationContext();
        this.panel.tgbHeadVsWorking.setSelected(true);
        switch (this.mode) {
            case HEAD_VS_WORKING_TREE: {
                this.panel.tgbHeadVsWorking.setSelected(true);
                break;
            }
            case HEAD_VS_INDEX: {
                this.panel.tgbHeadVsIndex.setSelected(true);
                break;
            }
            case INDEX_VS_WORKING_TREE: {
                this.panel.tgbIndexVsWorking.setSelected(true);
            }
        }
        this.onDisplayedStatusChanged();
    }

    private void updateSplitLocation() {
        Dimension dim;
        JComponent parent = (JComponent)this.panel.getParent();
        Dimension dimension = dim = parent == null ? new Dimension() : parent.getSize();
        if (dim.width <= 0 || dim.height <= 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanelController.this.updateSplitLocation();
                }
            });
            return;
        }
        DiffFileViewComponent<DiffNode> fileComp = this.getActiveFileComponent();
        int preferredHeaderHeight = fileComp.getPreferredHeaderHeight();
        int preferredHeight = fileComp.getPreferredHeight();
        int optimalLocation = preferredHeight + preferredHeaderHeight + 5;
        if (optimalLocation > dim.height / 3) {
            optimalLocation = dim.height / 3;
        }
        if (optimalLocation <= preferredHeaderHeight) {
            optimalLocation = preferredHeaderHeight * 3;
        }
        if (this.dividerSet && this.panel.splitPane.getDividerLocation() <= optimalLocation) {
            return;
        }
        this.panel.splitPane.setDividerLocation(optimalLocation);
        this.dividerSet = true;
    }

    void filesSelected(File ... files) {
        if (this.fileComponentSetSelectedIndexContext) {
            return;
        }
        Setup s = files.length == 1 ? this.setups.get(files[0]) : null;
        this.setDiffIndex(s, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshNodes() {
        if (this.context != null) {
            Map<File, FileStatusCache.ChangedEvent> map = this.changes;
            synchronized (map) {
                this.changes.clear();
            }
            this.changeTask.cancel();
            this.changeRPTask.cancel();
            this.refreshNodesTask.cancel();
            this.refreshNodesRPTask.cancel();
            this.panel.btnCommit.setEnabled(false);
            this.panel.btnRevert.setEnabled(false);
            this.panel.btnRefresh.setEnabled(false);
            boolean enabledToggles = this.revisionRight == Revision.LOCAL;
            this.panel.tgbHeadVsIndex.setEnabled(enabledToggles);
            this.panel.tgbHeadVsWorking.setEnabled(enabledToggles);
            this.panel.tgbIndexVsWorking.setEnabled(enabledToggles);
            this.refreshNodesRPTask.schedule(0);
        }
    }

    private void startPrepareTask(Setup activeSetup) {
        if (this.setups.size() > 0) {
            this.dpt = new DiffPrepareTask(this.setups.values().toArray(new Setup[this.setups.size()]));
            this.dpt.setSelectedSetup(activeSetup);
            this.prepareTask = RP.create((Runnable)this.dpt);
            this.prepareTask.schedule(0);
        }
    }

    private static Map<File, EditorCookie> getCookiesFromSetups(Map<File, Setup> localSetups) {
        AbstractDiffSetup[] retSetups = localSetups.values().toArray(new Setup[localSetups.values().size()]);
        EditorCookie[] cookies = DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])retSetups);
        HashMap<File, EditorCookie> map = new HashMap<File, EditorCookie>();
        for (int i = 0; i < cookies.length; ++i) {
            if (cookies[i] == null) continue;
            map.put(retSetups[i].getBaseFile(), cookies[i]);
        }
        return map;
    }

    private void updateView() {
        DiffFileViewComponent<DiffNode> activeFileComponent = this.getActiveFileComponent();
        if (this.setups.isEmpty()) {
            String noContentLabel = "";
            if (this.isLocal()) {
                switch (this.mode) {
                    case HEAD_VS_WORKING_TREE: {
                        noContentLabel = this.revisionLeft == Revision.HEAD ? Bundle.MSG_No_Changes_HeadWorking() : Bundle.MSG_No_Changes_RevisionWorking(this.revisionLeft.getRevision());
                        break;
                    }
                    case HEAD_VS_INDEX: {
                        noContentLabel = this.revisionLeft == Revision.HEAD ? Bundle.MSG_No_Changes_HeadIndex() : Bundle.MSG_No_Changes_RevisionIndex(this.revisionLeft.getRevision());
                        break;
                    }
                    case INDEX_VS_WORKING_TREE: {
                        noContentLabel = Bundle.MSG_No_Changes_IndexWorking();
                    }
                }
            } else {
                noContentLabel = Bundle.MSG_No_Changes_Revisions();
            }
            this.fileListComponent.getComponent().setEnabled(false);
            this.fileListComponent.getComponent().setPreferredSize(null);
            this.fileTreeComponent.getComponent().setEnabled(false);
            this.fileTreeComponent.getComponent().setPreferredSize(null);
            Dimension dim = activeFileComponent.getComponent().getPreferredSize();
            activeFileComponent.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
            this.diffView = new NoContentPanel(noContentLabel);
            this.displayDiffView();
            this.nextAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.panel.btnCommit.setEnabled(false);
            this.panel.btnRevert.setEnabled(false);
        } else {
            this.fileListComponent.getComponent().setEnabled(true);
            this.fileListComponent.getComponent().setPreferredSize(null);
            this.fileTreeComponent.getComponent().setEnabled(true);
            this.fileTreeComponent.getComponent().setPreferredSize(null);
            Dimension dim = activeFileComponent.getComponent().getPreferredSize();
            activeFileComponent.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
            DiffNode node = (DiffNode)activeFileComponent.getNodeAtPosition(0);
            Setup toSelect = node == null ? null : node.getSetup();
            this.setDiffIndex(toSelect, 0, true);
            boolean buttonsEnabled = this.revisionRight == Revision.LOCAL && this.revisionLeft == Revision.HEAD;
            this.panel.btnCommit.setEnabled(buttonsEnabled);
            this.panel.btnRevert.setEnabled(buttonsEnabled);
        }
        this.panel.btnRefresh.setEnabled(true);
        if (this.panel.splitPane != null) {
            this.updateSplitLocation();
        }
        this.panel.revalidate();
        this.panel.repaint();
    }

    private EditorCookie[] sort(Map<File, EditorCookie> cookies, DiffNode[] nodes) {
        ArrayList<EditorCookie> sorted = new ArrayList<EditorCookie>(cookies.size());
        for (DiffNode n : nodes) {
            sorted.add(cookies.get(n.getFile()));
        }
        return sorted.toArray(new EditorCookie[sorted.size()]);
    }

    private void setupsChanged(final Map<File, Setup> newSetups, List<DiffNode> nodes) {
        final Map<File, EditorCookie> cookies = MultiDiffPanelController.getCookiesFromSetups(newSetups);
        VCSStatusNode[] nodeArray = nodes.toArray(new DiffNode[nodes.size()]);
        Object modelDataList = this.fileListComponent.prepareModel((DiffNode[])nodeArray);
        Object modelDataTree = this.fileTreeComponent.prepareModel(nodeArray);
        Mutex.EVENT.readAccess(new Runnable((DiffNode[])nodeArray, modelDataList, modelDataTree){
            final /* synthetic */ DiffNode[] val$nodeArray;
            final /* synthetic */ Object val$modelDataList;
            final /* synthetic */ Object val$modelDataTree;
            {
                this.val$nodeArray = diffNodeArray;
                this.val$modelDataList = object;
                this.val$modelDataTree = object2;
            }

            @Override
            public void run() {
                MultiDiffPanelController.this.dividerSet = false;
                MultiDiffPanelController.this.setSetups(newSetups, cookies);
                MultiDiffPanelController.this.fileListComponent.setModel(this.val$nodeArray, new HashMap<File, EditorCookie>(cookies), this.val$modelDataList);
                MultiDiffPanelController.this.fileTreeComponent.setModel(this.val$nodeArray, MultiDiffPanelController.this.sort(cookies, this.val$nodeArray), this.val$modelDataTree);
                MultiDiffPanelController.this.updateView();
            }
        });
    }

    private boolean isLocal() {
        return this.revisionRight == Revision.LOCAL;
    }

    private static class RevisionCellRenderer
    extends DefaultListCellRenderer {
        private RevisionCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String tooltip = null;
            if (value instanceof Revision) {
                Revision rev = (Revision)value;
                value = rev.toString(true);
                tooltip = rev.getFullMessage();
                if (tooltip != null) {
                    tooltip = tooltip.replace("\r\n", "\n").replace("\n", "<br>");
                    StringBuilder sb = new StringBuilder("<html><p>");
                    sb.append(tooltip).append("</p></html>");
                    tooltip = sb.toString();
                }
            } else if (value instanceof String) {
                value = "<html><i>" + value + "</i></html>";
                tooltip = Bundle.MSG_Revision_Select_Tooltip();
            }
            Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (comp instanceof JComponent) {
                ((JComponent)comp).setToolTipText(tooltip);
            }
            return comp;
        }
    }

    private class DiffPrepareTask
    implements Runnable,
    Cancellable {
        private final Setup[] prepareSetups;
        private Setup selectedSetup;
        private volatile boolean canceled;

        public DiffPrepareTask(Setup[] prepareSetups) {
            assert (EventQueue.isDispatchThread());
            assert (!Arrays.asList(prepareSetups).contains(null));
            this.prepareSetups = prepareSetups;
            this.selectedSetup = prepareSetups[0];
        }

        @Override
        public void run() {
            DiffNode[] neighbourNodes;
            this.canceled = false;
            IOException exception = null;
            for (DiffNode n : neighbourNodes = this.prepareSetupsToRefresh()) {
                final Setup s = n.getSetup();
                if (this.canceled) {
                    return;
                }
                if (s.getView() != null) continue;
                try {
                    s.initSources();
                    if (this.canceled) {
                        return;
                    }
                    StreamSource ss1 = s.getFirstSource();
                    StreamSource ss2 = s.getSecondSource();
                    if (MultiDiffPanelController.this.requestedRightLine != -1) {
                        MultiDiffPanelController.this.requestedLeftLine = this.getMatchingLine(ss2, ss1, MultiDiffPanelController.this.requestedRightLine);
                    }
                    DiffController view = DiffController.createEnhanced((StreamSource)ss1, (StreamSource)ss2);
                    view.addPropertyChangeListener((PropertyChangeListener)MultiDiffPanelController.this);
                    if (this.canceled) {
                        return;
                    }
                    s.setView(view);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (((Object)((Object)s)).equals((Object)MultiDiffPanelController.this.currentSetup)) {
                                MultiDiffPanelController.this.setDiffIndex(s, 0, false);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    if (GitClientExceptionHandler.isCancelledAction(e)) continue;
                    LOG.log(Level.INFO, null, e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                GitClientExceptionHandler.notifyException(exception, true);
            }
        }

        private DiffNode[] prepareSetupsToRefresh() {
            return (DiffNode[])Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<DiffNode[]>(){

                public DiffNode[] run() {
                    DiffNode[] diffNodeArray;
                    if (MultiDiffPanelController.this.showingFileComponent()) {
                        diffNodeArray = (DiffNode[])MultiDiffPanelController.this.getActiveFileComponent().getNeighbouringNodes((Node)DiffPrepareTask.this.selectedSetup.getNode(), 2);
                    } else {
                        DiffNode[] diffNodeArray2 = new DiffNode[1];
                        diffNodeArray = diffNodeArray2;
                        diffNodeArray2[0] = DiffPrepareTask.this.selectedSetup.getNode();
                    }
                    return diffNodeArray;
                }
            });
        }

        private void setSelectedSetup(Setup setup) {
            this.selectedSetup = setup;
        }

        public boolean cancel() {
            this.canceled = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getMatchingLine(StreamSource ss2, StreamSource ss1, int requestedRightLine) {
            Reader currentReader = null;
            Reader previousReader = null;
            try {
                currentReader = ss2.createReader();
                previousReader = ss1.createReader();
                int n = DiffUtils.getMatchingLine((Reader)currentReader, (Reader)previousReader, (int)requestedRightLine);
                return n;
            }
            catch (IOException ex) {
                int n = -1;
                return n;
            }
            finally {
                if (currentReader != null) {
                    try {
                        currentReader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (previousReader != null) {
                    try {
                        previousReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class RefreshComboTask
    implements Runnable {
        private RefreshComboTask() {
        }

        @Override
        public void run() {
            File repository = GitUtils.getRootFile(MultiDiffPanelController.this.context);
            final ArrayList<Object> modelRight = new ArrayList<Object>(10);
            final ArrayList<Object> modelLeft = new ArrayList<Object>(10);
            modelLeft.add(MultiDiffPanelController.this.revisionOriginalLeft);
            if (MultiDiffPanelController.this.revisionOriginalLeft != Revision.HEAD) {
                modelLeft.add(Revision.HEAD);
            }
            modelRight.add(MultiDiffPanelController.this.revisionOriginalRight);
            if (MultiDiffPanelController.this.revisionOriginalRight != Revision.LOCAL) {
                modelRight.add(Revision.LOCAL);
            }
            if (MultiDiffPanelController.this.revisionOriginalRight != Revision.HEAD) {
                modelRight.add(Revision.HEAD);
            }
            modelLeft.add(REVISION_SELECT_SEP);
            modelRight.add(REVISION_SELECT_SEP);
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            info.refresh();
            boolean added = false;
            for (Map.Entry<String, GitBranch> e : info.getBranches().entrySet()) {
                String branchName = e.getValue().getName();
                if (branchName == "(no branch)") continue;
                Revision.BranchReference revision = new Revision.BranchReference(e.getValue());
                modelLeft.add(revision);
                modelRight.add(revision);
                added = true;
            }
            if (added) {
                modelLeft.add(REVISION_SELECT_SEP);
                modelRight.add(REVISION_SELECT_SEP);
            }
            modelLeft.add(REVISION_SELECT);
            modelLeft.add(REVISION_SELECT_SEP);
            modelRight.add(REVISION_SELECT);
            modelRight.add(REVISION_SELECT_SEP);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((MultiDiffPanelController)MultiDiffPanelController.this).panel.cmbDiffTreeFirst.setModel(new DefaultComboBoxModel<Object>(modelRight.toArray(new Object[modelRight.size()])));
                    ((MultiDiffPanelController)MultiDiffPanelController.this).panel.cmbDiffTreeSecond.setModel(new DefaultComboBoxModel<Object>(modelLeft.toArray(new Object[modelLeft.size()])));
                    ((MultiDiffPanelController)MultiDiffPanelController.this).panel.cmbDiffTreeFirst.setEnabled(true);
                    ((MultiDiffPanelController)MultiDiffPanelController.this).panel.cmbDiffTreeSecond.setEnabled(true);
                }
            });
        }
    }

    private final class ApplyChangesTask
    implements Runnable,
    Cancellable {
        private volatile boolean canceled;

        private ApplyChangesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet events;
            this.canceled = false;
            Map map = MultiDiffPanelController.this.changes;
            synchronized (map) {
                events = new HashSet(MultiDiffPanelController.this.changes.values());
                MultiDiffPanelController.this.changes.clear();
            }
            Iterator it = events.iterator();
            while (it.hasNext()) {
                FileStatusCache.ChangedEvent evt = (FileStatusCache.ChangedEvent)it.next();
                if (MultiDiffPanelController.this.affectsView(evt)) continue;
                LOG.log(Level.FINE, "ApplyChanges: file {0} does not affect view", evt.getFile());
                it.remove();
            }
            if (this.canceled || events.isEmpty()) {
                return;
            }
            Git git = Git.getInstance();
            Map nodes = (Map)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Map<File, DiffNode>>(){

                public Map<File, DiffNode> run() {
                    return MultiDiffPanelController.this.fileListComponent.getNodes();
                }
            });
            final LinkedList<DiffNode> toRemove = new LinkedList<DiffNode>();
            final LinkedList<DiffNode> toRefresh = new LinkedList<DiffNode>();
            final LinkedList<DiffNode.DiffLocalNode> toAdd = new LinkedList<DiffNode.DiffLocalNode>();
            final HashMap<File, Setup> localSetups = new HashMap<File, Setup>(nodes.size());
            for (FileStatusCache.ChangedEvent changedEvent : events) {
                if (this.canceled) break;
                FileInformation newInfo = changedEvent.getNewInfo();
                DiffNode node = (DiffNode)nodes.get(changedEvent.getFile());
                if (newInfo.containsStatus(MultiDiffPanelController.this.displayStatuses)) {
                    if (node != null) {
                        if (node instanceof DiffNode.DiffLocalNode) {
                            toRefresh.add(node);
                            Setup setup = new Setup((GitFileNode)((DiffNode.DiffLocalNode)node).getFileNode(), MultiDiffPanelController.this.mode, Revision.HEAD);
                            setup.setNode(node);
                            localSetups.put(changedEvent.getFile(), setup);
                            LOG.log(Level.FINE, "ApplyChanges: refreshing node {0}", node);
                            continue;
                        }
                        toRemove.add(node);
                        continue;
                    }
                    File root = git.getRepositoryRoot(changedEvent.getFile());
                    if (root == null) continue;
                    GitFileNode.GitLocalFileNode fNode = new GitFileNode.GitLocalFileNode(root, changedEvent.getFile());
                    Setup setup = new Setup(fNode, MultiDiffPanelController.this.mode, Revision.HEAD);
                    DiffNode.DiffLocalNode toAddNode = new DiffNode.DiffLocalNode(fNode, setup, DiffUtils.getEditorCookie((AbstractDiffSetup)setup), MultiDiffPanelController.this.mode);
                    setup.setNode(toAddNode);
                    localSetups.put(changedEvent.getFile(), setup);
                    toAdd.add(toAddNode);
                    LOG.log(Level.FINE, "ApplyChanges: adding node {0}", toAddNode);
                    continue;
                }
                if (node == null) continue;
                toRemove.add(node);
                LOG.log(Level.FINE, "ApplyChanges: removing node {0}", node);
            }
            if (this.canceled) {
                return;
            }
            for (DiffNode diffNode : toRemove) {
                nodes.remove(diffNode.getFile());
            }
            for (DiffNode diffNode : toAdd) {
                nodes.put(diffNode.getFile(), diffNode);
            }
            for (DiffNode diffNode : toRefresh) {
                nodes.put(diffNode.getFile(), diffNode);
            }
            VCSStatusNode[] diffNodes = nodes.values().toArray(new DiffNode[nodes.size()]);
            Object object = MultiDiffPanelController.this.fileTreeComponent.prepareModel(diffNodes);
            final Map cookies = MultiDiffPanelController.getCookiesFromSetups(localSetups);
            if (this.canceled) {
                return;
            }
            Mutex.EVENT.readAccess(new Runnable((DiffNode[])diffNodes, object){
                final /* synthetic */ DiffNode[] val$diffNodes;
                final /* synthetic */ Object val$modelDataTree;
                {
                    this.val$diffNodes = diffNodeArray;
                    this.val$modelDataTree = object;
                }

                @Override
                public void run() {
                    for (DiffNode node : toAdd) {
                        MultiDiffPanelController.this.setups.put(node.getFile(), localSetups.get(node.getFile()));
                        EditorCookie cookie = (EditorCookie)cookies.get(node.getFile());
                        if (cookie == null) continue;
                        MultiDiffPanelController.this.editorCookies.put(node.getFile(), cookie);
                    }
                    for (DiffNode node : toRemove) {
                        MultiDiffPanelController.this.setups.remove(node.getFile());
                        MultiDiffPanelController.this.editorCookies.remove(node.getFile());
                    }
                    MultiDiffPanelController.this.fileListComponent.updateNodes(new HashMap<File, EditorCookie>(MultiDiffPanelController.this.editorCookies), toRemove, toRefresh, toAdd);
                    MultiDiffPanelController.this.fileTreeComponent.setModel(this.val$diffNodes, MultiDiffPanelController.this.sort(MultiDiffPanelController.this.editorCookies, this.val$diffNodes), this.val$modelDataTree);
                    MultiDiffPanelController.this.updateView();
                }
            });
        }

        public boolean cancel() {
            this.canceled = true;
            return true;
        }
    }

    private final class RefreshNodesTask
    implements Runnable,
    Cancellable {
        private volatile boolean canceled;

        private RefreshNodesTask() {
        }

        @Override
        public void run() {
            this.canceled = false;
            LinkedList<DiffNode> nodes = new LinkedList<DiffNode>();
            Map<File, Setup> localSetups = MultiDiffPanelController.this.isLocal() ? (MultiDiffPanelController.this.revisionLeft == Revision.HEAD || MultiDiffPanelController.this.mode == FileInformation.Mode.INDEX_VS_WORKING_TREE ? this.getLocalToBaseSetups(nodes) : this.getLocalToRevisionSetups(nodes)) : this.getRevisionToRevisionSetups(nodes);
            if (this.canceled) {
                return;
            }
            MultiDiffPanelController.this.setupsChanged(localSetups, nodes);
        }

        public boolean cancel() {
            this.canceled = true;
            return true;
        }

        private Map<File, Setup> getLocalToBaseSetups(List<DiffNode> nodes) {
            Git git = Git.getInstance();
            File[] interestingFiles = git.getFileStatusCache().listFiles(MultiDiffPanelController.this.context.getRootFiles(), (EnumSet<FileInformation.Status>)MultiDiffPanelController.this.displayStatuses);
            HashMap<File, Setup> localSetups = new HashMap<File, Setup>(interestingFiles.length);
            for (File f : interestingFiles) {
                if (this.canceled) break;
                File root = git.getRepositoryRoot(f);
                if (root == null) continue;
                GitUtils.logRemoteRepositoryAccess(root);
                GitFileNode.GitLocalFileNode fNode = new GitFileNode.GitLocalFileNode(root, f);
                Setup setup = new Setup(fNode, MultiDiffPanelController.this.mode, Revision.HEAD);
                DiffNode.DiffLocalNode diffNode = new DiffNode.DiffLocalNode(fNode, setup, DiffUtils.getEditorCookie((AbstractDiffSetup)setup), MultiDiffPanelController.this.mode);
                nodes.add(diffNode);
                setup.setNode(diffNode);
                localSetups.put(f, setup);
            }
            return localSetups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<File, Setup> getLocalToRevisionSetups(List<DiffNode> nodes) {
            Git git = Git.getInstance();
            File repository = GitUtils.getRootFile(MultiDiffPanelController.this.context);
            GitClient client = null;
            try {
                GitUtils.logRemoteRepositoryAccess(repository);
                client = git.getClient(repository);
                Map<File, GitStatus> statuses = client.getStatus(MultiDiffPanelController.this.context.getRootFiles().toArray(new File[MultiDiffPanelController.this.context.getRootFiles().size()]), MultiDiffPanelController.this.revisionLeft.getCommitId(), GitUtils.NULL_PROGRESS_MONITOR);
                statuses.keySet().retainAll(Utils.flattenFiles((File[])MultiDiffPanelController.this.context.getRootFiles().toArray(new File[MultiDiffPanelController.this.context.getRootFiles().size()]), statuses.keySet()));
                HashMap<File, Setup> localSetups = new HashMap<File, Setup>(statuses.size());
                for (Map.Entry<File, GitStatus> e : statuses.entrySet()) {
                    FileInformation fi;
                    if (this.canceled) break;
                    File f = e.getKey();
                    GitStatus status = e.getValue();
                    if (status.isFolder() || !(fi = new FileInformation(status)).containsStatus(MultiDiffPanelController.this.displayStatuses)) continue;
                    GitFileNode.GitLocalFileNode fNode = new GitFileNode.GitLocalFileNode(repository, f){

                        @Override
                        public FileInformation getInformation() {
                            return fi;
                        }
                    };
                    Setup setup = new Setup(fNode, MultiDiffPanelController.this.mode, MultiDiffPanelController.this.revisionLeft);
                    DiffNode.DiffLocalNode diffNode = new DiffNode.DiffLocalNode(fNode, setup, DiffUtils.getEditorCookie((AbstractDiffSetup)setup), MultiDiffPanelController.this.mode);
                    nodes.add(diffNode);
                    setup.setNode(diffNode);
                    localSetups.put(f, setup);
                }
                HashMap<File, Setup> hashMap = localSetups;
                return hashMap;
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, null, ex);
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
            return Collections.emptyMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<File, Setup> getRevisionToRevisionSetups(List<DiffNode> nodes) {
            Git git = Git.getInstance();
            File repository = GitUtils.getRootFile(MultiDiffPanelController.this.context);
            GitClient client = null;
            try {
                GitUtils.logRemoteRepositoryAccess(repository);
                client = git.getClient(repository);
                Map<File, GitRevisionInfo.GitFileInfo> statuses = client.getStatus(MultiDiffPanelController.this.context.getRootFiles().toArray(new File[MultiDiffPanelController.this.context.getRootFiles().size()]), MultiDiffPanelController.this.revisionLeft.getCommitId(), MultiDiffPanelController.this.revisionRight.getCommitId(), GitUtils.NULL_PROGRESS_MONITOR);
                HashMap<File, Setup> historySetups = new HashMap<File, Setup>();
                for (Map.Entry<File, GitRevisionInfo.GitFileInfo> e : statuses.entrySet()) {
                    if (this.canceled) break;
                    File f = e.getKey();
                    GitRevisionInfo.GitFileInfo info = e.getValue();
                    GitFileNode.HistoryFileInformation fi = new GitFileNode.HistoryFileInformation(info);
                    Setup setup = new Setup(f, MultiDiffPanelController.this.revisionLeft, MultiDiffPanelController.this.revisionRight, fi);
                    DiffNode.DiffHistoryNode historyNode = new DiffNode.DiffHistoryNode(new GitFileNode.GitHistoryFileNode(repository, f, fi), setup);
                    setup.setNode(historyNode);
                    nodes.add(historyNode);
                    historySetups.put(f, setup);
                }
                HashMap<File, Setup> hashMap = historySetups;
                return hashMap;
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, null, ex);
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
            return Collections.emptyMap();
        }
    }
}

