/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.extbrowser.chrome.ChromeBrowserImpl;
import org.netbeans.modules.extbrowser.plugins.ExternalBrowserPlugin;
import org.netbeans.modules.web.browser.spi.MessageDispatcher;
import org.netbeans.modules.web.browser.spi.ScriptExecutor;
import org.openide.util.Lookup;

public class RemoteScriptExecutor
implements ScriptExecutor {
    private static final Logger LOG = Logger.getLogger(RemoteScriptExecutor.class.getName());
    private static final String MESSAGE_TYPE = "message";
    private static final String MESSAGE_EVAL = "eval";
    private static final String MESSAGE_ID = "id";
    private static final String MESSAGE_SCRIPT = "script";
    private static final String MESSAGE_STATUS = "status";
    private static final String MESSAGE_STATUS_OK = "ok";
    private static final String MESSAGE_RESULT = "result";
    private int lastIDSent = 0;
    private int lastIDReceived = 0;
    private final Object LOCK = new Object();
    private Map<Integer, Object> results = new HashMap<Integer, Object>();
    private ChromeBrowserImpl browserImpl;
    private boolean initialized;
    private boolean active;

    public RemoteScriptExecutor(ChromeBrowserImpl browserImpl) {
        this.browserImpl = browserImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(String script) {
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.active) {
                return ERROR_RESULT;
            }
            if (!this.initialized) {
                this.initialize();
            }
            int id = ++this.lastIDSent;
            JSONObject message = new JSONObject();
            message.put((Object)MESSAGE_TYPE, (Object)MESSAGE_EVAL);
            message.put((Object)MESSAGE_ID, (Object)id);
            message.put((Object)MESSAGE_SCRIPT, (Object)script);
            ExternalBrowserPlugin.getInstance().sendMessage(message.toJSONString(), this.browserImpl, "inspect");
            try {
                do {
                    this.LOCK.wait();
                } while (!this.results.containsKey(id));
            }
            catch (InterruptedException iex) {
                LOG.log(Level.INFO, null, iex);
            }
            return this.results.remove(id);
        }
    }

    private void initialize() {
        Lookup lookup = this.browserImpl.getLookup();
        MessageDispatcher dispatcher = (MessageDispatcher)lookup.lookup(MessageDispatcher.class);
        if (dispatcher != null) {
            dispatcher.addMessageListener(new MessageDispatcher.MessageListener(){

                public void messageReceived(String featureId, String message) {
                    if ("inspect".equals(featureId)) {
                        if (message == null) {
                            RemoteScriptExecutor.this.deactivate();
                        } else {
                            RemoteScriptExecutor.this.messageReceived(message);
                        }
                    }
                }
            });
        } else {
            LOG.log(Level.INFO, "No MessageDispatcher found in ExtBrowserImpl.getLookup()!");
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deactivate() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.lastIDReceived < this.lastIDSent) {
                int fromID = this.lastIDReceived + 1;
                LOG.log(Level.INFO, "Executor disposed before responses with IDs {0} to {1} were received!", new Object[]{fromID, this.lastIDSent});
                for (int i = fromID; i <= this.lastIDSent; ++i) {
                    this.results.put(i, ERROR_RESULT);
                }
                this.lastIDReceived = this.lastIDSent;
            }
            this.active = false;
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void messageReceived(String messageTxt) {
        block8: {
            try {
                JSONObject message = (JSONObject)JSONValue.parseWithException((String)messageTxt);
                Object type = message.get((Object)MESSAGE_TYPE);
                if (!MESSAGE_EVAL.equals(type)) break block8;
                int id = ((Number)message.get((Object)MESSAGE_ID)).intValue();
                Object object = this.LOCK;
                synchronized (object) {
                    for (int i = this.lastIDReceived + 1; i < id; ++i) {
                        LOG.log(Level.INFO, "Haven''t received result of execution of script with ID {0}.", i);
                        this.results.put(i, ERROR_RESULT);
                    }
                    Object status = message.get((Object)MESSAGE_STATUS);
                    Object result = message.get((Object)MESSAGE_RESULT);
                    if (MESSAGE_STATUS_OK.equals(status)) {
                        this.results.put(id, result);
                    } else {
                        LOG.log(Level.INFO, "Message with id {0} wasn''t executed successfuly: {1}", new Object[]{id, result});
                        this.results.put(id, ERROR_RESULT);
                    }
                    this.lastIDReceived = id;
                    this.LOCK.notifyAll();
                }
            }
            catch (ParseException ex) {
                LOG.log(Level.INFO, "Ignoring message that is not in JSON format: {0}", messageTxt);
            }
        }
    }
}

