/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.derby.DerbyOptions;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.ui.DerbyPropertiesPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CreateDatabasePanel
extends JPanel {
    private File derbySystemHome;
    private DialogDescriptor descriptor;
    private DocumentListener docListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            CreateDatabasePanel.this.validateInput();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CreateDatabasePanel.this.validateInput();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CreateDatabasePanel.this.validateInput();
        }
    };
    public JLabel databaseLocationLabel;
    public JLabel databaseLocationValueLabel;
    public JLabel databaseNameLabel;
    public JTextField databaseNameTextField;
    public JPasswordField password;
    public JLabel passwordLabel;
    public JButton propertiesButton;
    public JPasswordField retypePassword;
    public JLabel retypePasswordLabel;
    public JLabel userLabel;
    public JTextField userTextField;

    public CreateDatabasePanel(String derbySystemHome) {
        this.derbySystemHome = new File(derbySystemHome);
        this.initComponents();
        this.databaseNameTextField.getDocument().addDocumentListener(this.docListener);
        this.userTextField.getDocument().addDocumentListener(this.docListener);
        this.password.getDocument().addDocumentListener(this.docListener);
        this.retypePassword.getDocument().addDocumentListener(this.docListener);
        this.updateLocation();
    }

    public void setDialogDescriptor(DialogDescriptor descriptor) {
        this.descriptor = descriptor;
        this.validateInput();
    }

    public String getDatabaseName() {
        return this.databaseNameTextField.getText().trim();
    }

    public String getUser() {
        String user = this.userTextField.getText().trim();
        return user.length() > 0 ? user : null;
    }

    public String getPassword() {
        String pw = new String(this.password.getPassword());
        return pw.length() > 0 ? pw : null;
    }

    public String getRetypePassword() {
        String pw2 = new String(this.retypePassword.getPassword());
        return pw2.length() > 0 ? pw2 : null;
    }

    public boolean matchPasswords() {
        return Arrays.equals(this.retypePassword.getPassword(), this.password.getPassword());
    }

    public void setIntroduction() {
        String info = NbBundle.getMessage(CreateDatabasePanel.class, (String)"INFO_DatabaseNameEmpty");
        this.descriptor.getNotificationLineSupport().setInformationMessage(info);
        this.descriptor.setValid(false);
    }

    private void validateInput() {
        if (this.descriptor == null) {
            return;
        }
        String error = null;
        String warning = null;
        String info = null;
        String databaseName = this.getDatabaseName();
        String user = this.getUser();
        int illegalChar = DerbyDatabases.getFirstIllegalCharacter(databaseName);
        int unsupportedChar = this.getFirstUnsupportedCharacter(databaseName);
        this.retypePassword.setEnabled(this.getPassword() != null);
        this.retypePasswordLabel.setEnabled(this.getPassword() != null);
        if (databaseName.length() <= 0) {
            warning = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DatabaseNameEmpty");
        } else if (illegalChar >= 0) {
            error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DatabaseNameIllegalChar", (Object)Character.toString((char)illegalChar));
        } else if (databaseName.length() > 0 && new File(this.derbySystemHome, databaseName).exists()) {
            error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DatabaseDirectoryExists", (Object)databaseName);
        } else if (unsupportedChar >= 0) {
            error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_DatabaseNameUnsupportedChar", (Object)Character.toString((char)unsupportedChar));
        } else if (user != null && !CreateDatabasePanel.isSql92Identifier(user)) {
            error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_UserNameNotSqlIdentifier", (Object)user);
        } else if (user != null && SQLKeywords.isSQL99ReservedKeyword((String)user)) {
            error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_UserNameIsSqlKeyword", (Object)user);
        } else if (this.getUser() == null || this.getPassword() == null) {
            info = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_UserNamePasswordRecommended");
        } else if (this.getUser() != null && this.getPassword() != null && this.getRetypePassword() == null) {
            warning = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_NeedRetypePassword");
        } else if (!this.matchPasswords()) {
            error = NbBundle.getMessage(CreateDatabasePanel.class, (String)"ERR_PasswordsDontMatch");
        }
        if (error != null) {
            this.descriptor.getNotificationLineSupport().setErrorMessage(error);
            this.descriptor.setValid(false);
        } else if (warning != null) {
            this.descriptor.getNotificationLineSupport().setWarningMessage(warning);
            this.descriptor.setValid(false);
        } else if (info != null) {
            this.descriptor.getNotificationLineSupport().setInformationMessage(info);
            this.descriptor.setValid(true);
        } else {
            this.descriptor.getNotificationLineSupport().clearMessages();
            this.descriptor.setValid(true);
        }
    }

    static boolean isSql92Identifier(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (s.matches("[\\w&&[^\\d_]](_|\\d|\\w)*")) {
            return true;
        }
        if (s.matches("\\\".+\\\"")) {
            boolean unpairedQuite = false;
            for (int i = 1; i < s.length() - 1; ++i) {
                if (s.charAt(i) == '\"') {
                    unpairedQuite = !unpairedQuite;
                    continue;
                }
                if (!unpairedQuite) continue;
                return false;
            }
            return !unpairedQuite;
        }
        return false;
    }

    private void updateLocation() {
        this.databaseLocationValueLabel.setText(this.derbySystemHome.getAbsolutePath());
    }

    private int getFirstUnsupportedCharacter(String databaseName) {
        for (int i = 0; i < databaseName.length(); ++i) {
            char ch = databaseName.charAt(i);
            if (ch >= ' ' && ch <= '\u00ff') continue;
            return ch;
        }
        return -1;
    }

    private void initComponents() {
        this.databaseNameLabel = new JLabel();
        this.databaseNameTextField = new JTextField();
        this.databaseLocationLabel = new JLabel();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.password = new JPasswordField();
        this.propertiesButton = new JButton();
        this.databaseLocationValueLabel = new JLabel();
        this.retypePasswordLabel = new JLabel();
        this.retypePassword = new JPasswordField();
        this.databaseNameLabel.setLabelFor(this.databaseNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.databaseNameLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_DatabaseName"));
        this.databaseLocationLabel.setLabelFor(this.databaseLocationValueLabel);
        Mnemonics.setLocalizedText((JLabel)this.databaseLocationLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_DatabaseLocation"));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_UserName"));
        this.userTextField.setColumns(15);
        this.passwordLabel.setLabelFor(this.password);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_Password"));
        this.password.setColumns(15);
        Mnemonics.setLocalizedText((AbstractButton)this.propertiesButton, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_Properties"));
        this.propertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateDatabasePanel.this.propertiesButtonActionPerformed(evt);
            }
        });
        this.databaseLocationValueLabel.setToolTipText(this.derbySystemHome.getAbsolutePath());
        this.retypePasswordLabel.setLabelFor(this.retypePassword);
        Mnemonics.setLocalizedText((JLabel)this.retypePasswordLabel, (String)NbBundle.getMessage(CreateDatabasePanel.class, (String)"LBL_RetypePassword"));
        this.retypePassword.setColumns(15);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.databaseNameLabel).addComponent(this.passwordLabel).addComponent(this.userLabel).addComponent(this.databaseLocationLabel).addComponent(this.retypePasswordLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.retypePassword, -1, 296, Short.MAX_VALUE).addComponent(this.databaseNameTextField, -1, 296, Short.MAX_VALUE).addComponent(this.password, -1, 296, Short.MAX_VALUE).addComponent(this.userTextField, -1, 296, Short.MAX_VALUE).addComponent(this.databaseLocationValueLabel, -1, 296, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.propertiesButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.databaseNameLabel).addComponent(this.databaseNameTextField, -2, -1, -2)).addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.userLabel).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.passwordLabel).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.retypePasswordLabel).addComponent(this.retypePassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.databaseLocationLabel).addComponent(this.databaseLocationValueLabel).addComponent(this.propertiesButton)).addContainerGap()));
        layout.linkSize(1, this.databaseNameTextField, this.password, this.userTextField);
        this.databaseNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_databaseNameTextField"));
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_userTextField"));
        this.password.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_passwordTextField"));
        this.propertiesButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSN_CreateDatabasePanel_propertiesButton"));
        this.propertiesButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_propertiesButton"));
        this.databaseLocationValueLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSN_CreateDatabasePanel_databaseLocationValueLabel"));
        this.databaseLocationValueLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateDatabasePanel.class, (String)"ACSD_CreateDatabasePanel_databaseLocationValueLabel"));
    }

    private void propertiesButtonActionPerformed(ActionEvent evt) {
        DerbyPropertiesPanel.showDerbyProperties();
        String newLocation = DerbyOptions.getDefault().getSystemHome();
        this.databaseLocationValueLabel.setText(newLocation);
        this.databaseLocationValueLabel.setToolTipText(newLocation);
    }
}

