/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.io.IOException;
import java.io.Reader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StringReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class ShortenedStrings {
    private static final Map<String, StringInfo> infoStrings = new WeakHashMap<String, StringInfo>();
    private static final Map<StringReference, StringValueInfo> stringsCache = new WeakHashMap<StringReference, StringValueInfo>();
    private static final Set<StringReference> retrievingStrings = new HashSet<StringReference>();
    private static final Map<VirtualMachine, Boolean> isLittleEndianCache = new WeakHashMap<VirtualMachine, Boolean>();

    private ShortenedStrings() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringInfo getShortenedInfo(String s) {
        Map<String, StringInfo> map = infoStrings;
        synchronized (map) {
            return infoStrings.get(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLittleEndian(VirtualMachine virtualMachine) throws InvalidTypeException, IncompatibleThreadStateException, ClassNotLoadedException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        Map<VirtualMachine, Boolean> map = isLittleEndianCache;
        synchronized (map) {
            Boolean cached = isLittleEndianCache.get(virtualMachine);
            if (cached != null) {
                return cached;
            }
            List<ReferenceType> possibleClasses = virtualMachine.classesByName("java.lang.StringUTF16");
            boolean defaultValue = true;
            if (possibleClasses.isEmpty()) {
                ClassType ct = (ClassType)virtualMachine.classesByName("java.lang.Class").iterator().next();
                Method m = ct.concreteMethodByName("forName", "(Ljava/lang/String;)Ljava/lang/Class;");
                StringReference referenceString = virtualMachine.mirrorOf("java.lang.StringUTF16");
                ThreadReference threadReference = virtualMachine.allThreads().get(0);
                ct.invokeMethod(threadReference, m, Collections.singletonList(referenceString), 0);
                possibleClasses = virtualMachine.classesByName("java.lang.StringUTF16");
            }
            if (possibleClasses.size() != 1) {
                isLittleEndianCache.put(virtualMachine, true);
                return true;
            }
            ReferenceType utf16 = possibleClasses.get(0);
            Field hiByteShiftField = ReferenceTypeWrapper.fieldByName(utf16, "HI_BYTE_SHIFT");
            if (hiByteShiftField == null) {
                isLittleEndianCache.put(virtualMachine, true);
                return true;
            }
            Value hiByteShiftValue = utf16.getValue(hiByteShiftField);
            if (!(hiByteShiftValue instanceof PrimitiveValue)) {
                isLittleEndianCache.put(virtualMachine, true);
                return true;
            }
            boolean result = ((PrimitiveValue)hiByteShiftValue).intValue() == 0;
            isLittleEndianCache.put(virtualMachine, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(String shortedString, StringReference sr, int length, ArrayReference chars, InternalStringEncoding backingEncoding, boolean isLittleEndian) {
        StringInfo si = new StringInfo(sr, shortedString.length() - 3, length, chars, backingEncoding, isLittleEndian);
        Map<String, StringInfo> map = infoStrings;
        synchronized (map) {
            infoStrings.put(shortedString, si);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getStringWithLengthControl(StringReference sr) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, ClassNotLoadedException, ClassNotPreparedExceptionWrapper, IncompatibleThreadStateException, InvalidTypeException, InvocationException {
        Object st;
        boolean isShort;
        String string;
        block48: {
            Object type;
            boolean retrieved = false;
            Map<StringReference, StringValueInfo> map = stringsCache;
            synchronized (map) {
                StringValueInfo svi = stringsCache.get(sr);
                if (svi != null) {
                    if (svi.isShort) {
                        return StringReferenceWrapper.value(sr);
                    }
                    String str = svi.shortValueRef.get();
                    if (str != null) {
                        return str;
                    }
                }
                if (retrievingStrings.contains(sr)) {
                    try {
                        stringsCache.wait();
                    }
                    catch (InterruptedException str) {
                        // empty catch block
                    }
                    retrieved = true;
                } else {
                    retrievingStrings.add(sr);
                }
            }
            if (retrieved) {
                return ShortenedStrings.getStringWithLengthControl(sr);
            }
            string = null;
            isShort = true;
            InternalStringEncoding backingEncoding = InternalStringEncoding.CHAR_ARRAY;
            st = ObjectReferenceWrapper.referenceType(sr);
            ArrayReference sa = null;
            boolean isUTF16 = false;
            boolean isCompactImpl = false;
            int saLength = 0;
            String ERROR_RESULT = "<Unreadable>";
            try {
                Field valuesField = ReferenceTypeWrapper.fieldByName((ReferenceType)st, "value");
                if (valuesField == null) {
                    List<Field> allFields = ReferenceTypeWrapper.allFields((ReferenceType)st);
                    for (Field f : allFields) {
                        if (f.isStatic() || !((type = f.type()) instanceof ArrayType)) continue;
                        String componentType = ((ArrayType)type).componentTypeName();
                        if ("byte".equals(componentType)) {
                            isCompactImpl = true;
                            valuesField = f;
                        } else {
                            if (!"char".equals(componentType)) continue;
                            valuesField = f;
                        }
                        break;
                    }
                } else if (valuesField.type() instanceof ArrayType && "byte".equals(((ArrayType)valuesField.type()).componentTypeName())) {
                    isCompactImpl = true;
                }
                if (valuesField == null) {
                    isShort = true;
                } else {
                    Value values;
                    if (isCompactImpl) {
                        Value coderValue;
                        boolean LATIN1 = false;
                        Field coderField = ReferenceTypeWrapper.fieldByName((ReferenceType)st, "coder");
                        if (coderField != null && (coderValue = ObjectReferenceWrapper.getValue(sr, coderField)) instanceof PrimitiveValue && ((PrimitiveValue)coderValue).intValue() != 0) {
                            isUTF16 = true;
                        }
                        backingEncoding = isUTF16 ? InternalStringEncoding.BYTE_ARRAY_UTF16 : InternalStringEncoding.BYTE_ARRAY_LATIN1;
                    }
                    int limit = 100000;
                    if (isUTF16) {
                        limit *= 2;
                    }
                    isShort = (values = ObjectReferenceWrapper.getValue(sr, valuesField)) instanceof ArrayReference ? (saLength = ArrayReferenceWrapper.length(sa = (ArrayReference)values)) <= limit : true;
                }
            }
            catch (ClassNotPreparedExceptionWrapper cnpex) {
                isShort = true;
            }
            catch (ClassNotLoadedException cnlex) {
                isShort = true;
            }
            if (isShort) {
                string = StringReferenceWrapper.value(sr);
                break block48;
            }
            assert (sa != null);
            int l = 100000;
            char[] characters = new char[l + 3];
            Boolean isLittleEndian = backingEncoding == InternalStringEncoding.BYTE_ARRAY_UTF16 && ShortenedStrings.isLittleEndian(sr.virtualMachine());
            try {
                ShortenedStrings.copyToCharArray(sa, 0, characters, 0, l, backingEncoding, (boolean)isLittleEndian);
            }
            catch (IOException ioe) {
                type = "<Unreadable>";
                Map<StringReference, StringValueInfo> map2 = stringsCache;
                synchronized (map2) {
                    if (string != null) {
                        StringValueInfo svi = isShort ? new StringValueInfo(isShort) : new StringValueInfo(string);
                        stringsCache.put(sr, svi);
                    }
                    retrievingStrings.remove(sr);
                    stringsCache.notifyAll();
                }
                return type;
            }
            try {
                for (int i = l; i < l + 3; ++i) {
                    characters[i] = 46;
                }
                String shortedString = new String(characters);
                int stringLength = isUTF16 ? saLength / 2 : saLength;
                ShortenedStrings.register(shortedString, sr, stringLength, sa, backingEncoding, isLittleEndian);
                string = shortedString;
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException | ClassNotPreparedExceptionWrapper | InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper e) {
                try {
                    Logger.getLogger(ShortenedStrings.class.getSimpleName()).log(Level.INFO, "Error in getStringWithLengthControl", e);
                    throw e;
                }
                catch (Throwable throwable) {
                    Map<StringReference, StringValueInfo> map3 = stringsCache;
                    synchronized (map3) {
                        if (string != null) {
                            StringValueInfo svi = isShort ? new StringValueInfo(isShort) : new StringValueInfo(string);
                            stringsCache.put(sr, svi);
                        }
                        retrievingStrings.remove(sr);
                        stringsCache.notifyAll();
                    }
                    throw throwable;
                }
            }
        }
        st = stringsCache;
        synchronized (st) {
            if (string != null) {
                StringValueInfo svi = isShort ? new StringValueInfo(isShort) : new StringValueInfo(string);
                stringsCache.put(sr, svi);
            }
            retrievingStrings.remove(sr);
            stringsCache.notifyAll();
        }
        return string;
    }

    private static int charAt(ArrayReference sourceArray, int index, InternalStringEncoding encoding, boolean isLittleEndian) throws InternalExceptionWrapper, ObjectCollectedExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (encoding == InternalStringEncoding.CHAR_ARRAY) {
            Value v = ArrayReferenceWrapper.getValue(sourceArray, index);
            if (!(v instanceof CharValue)) {
                return -1;
            }
            return ((CharValue)v).charValue();
        }
        if (encoding == InternalStringEncoding.BYTE_ARRAY_LATIN1) {
            Value v = ArrayReferenceWrapper.getValue(sourceArray, index);
            if (!(v instanceof ByteValue)) {
                return -1;
            }
            char c = (char)((ByteValue)v).byteValue();
            c = (char)(c & 0xFF);
            return c;
        }
        List<Value> vals = ArrayReferenceWrapper.getValues(sourceArray, index * 2, 2);
        Value left = vals.get(0);
        Value right = vals.get(1);
        if (!(left instanceof ByteValue) || !(right instanceof ByteValue)) {
            return -1;
        }
        return ShortenedStrings.utf16Combine(((ByteValue)left).byteValue(), ((ByteValue)right).value(), isLittleEndian);
    }

    private static int charAt(List<Value> sourceArray, int index, InternalStringEncoding encoding, boolean isLittleEndian) {
        if (encoding == InternalStringEncoding.CHAR_ARRAY) {
            Value v = sourceArray.get(index);
            if (!(v instanceof CharValue)) {
                return -1;
            }
            return ((CharValue)v).charValue();
        }
        if (encoding == InternalStringEncoding.BYTE_ARRAY_LATIN1) {
            Value v = sourceArray.get(index);
            if (!(v instanceof ByteValue)) {
                return -1;
            }
            char c = (char)((ByteValue)v).byteValue();
            c = (char)(c & 0xFF);
            return c;
        }
        Value left = sourceArray.get(index * 2);
        Value right = sourceArray.get(index * 2 + 1);
        if (!(left instanceof ByteValue) || !(right instanceof ByteValue)) {
            return -1;
        }
        return ShortenedStrings.utf16Combine(((ByteValue)left).byteValue(), ((ByteValue)right).value(), isLittleEndian);
    }

    private static void copyToCharArray(ArrayReference sourceArray, int srcPos, char[] dest, int destPos, int length, InternalStringEncoding encoding, boolean isLittleEndian) throws ObjectCollectedExceptionWrapper, VMDisconnectedExceptionWrapper, InternalExceptionWrapper, IOException {
        int realStart = srcPos;
        int realLength = length;
        if (encoding == InternalStringEncoding.BYTE_ARRAY_UTF16) {
            realStart *= 2;
            realLength *= 2;
        }
        List<Value> values = ArrayReferenceWrapper.getValues(sourceArray, realStart, realLength);
        ShortenedStrings.copyToCharArray(values, 0, dest, destPos, length, encoding, isLittleEndian);
    }

    private static void copyToCharArray(List<Value> sourceArray, int srcPos, char[] dest, int destPos, int length, InternalStringEncoding backing, boolean isLittleEndian) throws IOException {
        if (backing == InternalStringEncoding.CHAR_ARRAY) {
            for (int i = 0; i < length; ++i) {
                Value v = sourceArray.get(i + srcPos);
                if (!(v instanceof CharValue)) {
                    throw new IOException(MessageFormat.format("Char at {0} is not a character: {1}", srcPos + i, v));
                }
                dest[destPos + i] = ((CharValue)v).charValue();
            }
            return;
        }
        if (backing == InternalStringEncoding.BYTE_ARRAY_LATIN1) {
            for (int i = 0; i < length; ++i) {
                Value v = sourceArray.get(i + srcPos);
                if (!(v instanceof ByteValue)) {
                    throw new IOException(MessageFormat.format("Char at {0} is not a byte: {1}", srcPos + i, v));
                }
                char c = (char)((ByteValue)v).byteValue();
                dest[destPos + i] = c = (char)(c & 0xFF);
            }
            return;
        }
        assert (backing == InternalStringEncoding.BYTE_ARRAY_UTF16);
        for (int i = 0; i < length; ++i) {
            Value left = sourceArray.get(i * 2);
            Value right = sourceArray.get(i * 2 + 1);
            if (!(left instanceof ByteValue) || !(right instanceof ByteValue)) {
                throw new IOException(MessageFormat.format("Char at {0} is not a byte pair: {1},{2}", srcPos + i, left, right));
            }
            dest[destPos + i] = ShortenedStrings.utf16Combine(((ByteValue)left).byteValue(), ((ByteValue)right).byteValue(), isLittleEndian);
        }
    }

    private static char utf16Combine(byte left, byte right, boolean isLittleEndian) {
        int lowByteShift;
        int hiByteShift;
        if (isLittleEndian) {
            hiByteShift = 0;
            lowByteShift = 8;
        } else {
            hiByteShift = 8;
            lowByteShift = 0;
        }
        char c1 = (char)left;
        char c2 = (char)right;
        c1 = (char)(0xFF & c1);
        c2 = (char)(0xFF & c2);
        char c = (char)(c1 << hiByteShift | c2 << lowByteShift);
        return c;
    }

    private static int length(int arrayLength, InternalStringEncoding backingEncoding) {
        switch (backingEncoding) {
            case CHAR_ARRAY: 
            case BYTE_ARRAY_LATIN1: {
                return arrayLength;
            }
            case BYTE_ARRAY_UTF16: {
                return arrayLength / 2;
            }
        }
        throw new AssertionError();
    }

    static {
        DebuggerManager.getDebuggerManager().addDebuggerListener("sessions", (DebuggerManagerListener)new DebuggerManagerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sessionRemoved(Session session) {
                int n = DebuggerManager.getDebuggerManager().getSessions().length;
                if (n == 0) {
                    Map<Object, Object> map = infoStrings;
                    synchronized (map) {
                        infoStrings.clear();
                    }
                    map = stringsCache;
                    synchronized (map) {
                        stringsCache.clear();
                        retrievingStrings.clear();
                    }
                    map = isLittleEndianCache;
                    synchronized (map) {
                        isLittleEndianCache.clear();
                    }
                }
            }
        });
    }

    public static class StringInfo {
        private final InternalStringEncoding backingEncoding;
        private final boolean isLittleEndian;
        private final StringReference sr;
        private final int shortLength;
        private final int length;
        private final ArrayReference chars;

        private StringInfo(StringReference sr, int shortLength, int length, ArrayReference chars, InternalStringEncoding backingEncoding, boolean isLittleEndian) {
            this.sr = sr;
            this.shortLength = shortLength;
            this.length = length;
            this.chars = chars;
            this.backingEncoding = backingEncoding;
            this.isLittleEndian = isLittleEndian;
        }

        public int getShortLength() {
            return this.shortLength;
        }

        public int getLength() {
            return this.length;
        }

        public String getFullString() {
            try {
                return StringReferenceWrapper.value(this.sr);
            }
            catch (InternalExceptionWrapper ex) {
                return null;
            }
            catch (VMDisconnectedExceptionWrapper ex) {
                return null;
            }
            catch (ObjectCollectedExceptionWrapper ex) {
                return null;
            }
        }

        public Reader getContent() {
            return new Reader(){
                int pos = 0;

                @Override
                public int read(char[] cbuf, int off, int len) throws IOException {
                    if (this.pos + len > length) {
                        len = length - this.pos;
                    }
                    if (len == 0) {
                        return -1;
                    }
                    try {
                        ShortenedStrings.copyToCharArray(chars, this.pos, cbuf, 0, len, backingEncoding, isLittleEndian);
                    }
                    catch (IOException ioe) {
                        throw ioe;
                    }
                    catch (InternalExceptionWrapper | ObjectCollectedExceptionWrapper | VMDisconnectedExceptionWrapper ex) {
                        throw new IOException(ex);
                    }
                    this.pos += len;
                    return len;
                }

                @Override
                public void close() throws IOException {
                }
            };
        }
    }

    private static enum InternalStringEncoding {
        CHAR_ARRAY,
        BYTE_ARRAY_LATIN1,
        BYTE_ARRAY_UTF16;

    }

    private static class StringValueInfo {
        boolean isShort;
        Reference<String> shortValueRef;

        StringValueInfo(boolean isShort) {
            this.isShort = isShort;
        }

        StringValueInfo(String shortenedValue) {
            this.isShort = false;
            this.shortValueRef = new WeakReference<String>(shortenedValue);
        }
    }
}

