/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ValueWrapper;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;

class ArrayFieldVariable
extends AbstractVariable
implements Field {
    private final ArrayReference array;
    private final ObjectVariable parent;
    private int index;
    private int maxIndexLog;
    private String declaredType;
    private static final String ZEROS = "            ";

    ArrayFieldVariable(JPDADebuggerImpl debugger, PrimitiveValue value, String declaredType, ObjectVariable array, int index, int maxIndex, String parentID) {
        super(debugger, value, parentID + "." + index + (value instanceof ObjectReference ? "^" : ""));
        this.index = index;
        this.maxIndexLog = ArrayFieldVariable.log10(maxIndex);
        this.declaredType = declaredType;
        this.parent = array;
        this.array = (ArrayReference)((JDIVariable)array).getJDIValue();
    }

    public String getName() {
        return ArrayFieldVariable.getName(this.maxIndexLog, this.index);
    }

    static String getName(int maxIndexLog, int index) {
        int num0 = maxIndexLog - ArrayFieldVariable.log10(index);
        if (num0 > 0) {
            return "[" + ArrayFieldVariable.zeros(num0) + index + "]";
        }
        return "[" + index + "]";
    }

    static int log10(int n) {
        int l = 1;
        while ((n /= 10) > 0) {
            ++l;
        }
        return l;
    }

    static String zeros(int n) {
        if (n < ZEROS.length()) {
            return ZEROS.substring(0, n);
        }
        Object z = ZEROS;
        while (((String)z).length() < n) {
            z = (String)z + " ";
        }
        return z;
    }

    public String getClassName() {
        return this.getType();
    }

    public JPDAClassType getDeclaringClass() {
        try {
            return this.getDebugger().getClassType((ReferenceType)ValueWrapper.type(this.array));
        }
        catch (InternalExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (ObjectCollectedExceptionWrapper ex) {
            throw ex.getCause();
        }
        catch (VMDisconnectedExceptionWrapper ex) {
            throw ex.getCause();
        }
    }

    public ObjectVariable getParentVariable() {
        return this.parent;
    }

    public boolean isStatic() {
        return false;
    }

    public String getDeclaredType() {
        return this.declaredType;
    }

    @Override
    protected void setValue(Value value) throws InvalidExpressionException {
        try {
            ArrayReferenceWrapper.setValue(this.array, this.index, value);
        }
        catch (InvalidTypeException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (ClassNotLoadedException ex) {
            throw new InvalidExpressionException((Throwable)ex);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            // empty catch block
        }
    }

    @Override
    public ArrayFieldVariable clone() {
        ArrayFieldVariable clon = new ArrayFieldVariable(this.getDebugger(), (PrimitiveValue)this.getJDIValue(), this.declaredType, this.parent, this.index, 0, this.getID().substring(0, this.getID().length() - (46 + this.index + (this.getJDIValue() instanceof ObjectReference ? "^" : "")).length()));
        clon.maxIndexLog = this.maxIndexLog;
        return clon;
    }

    @Override
    public String toString() {
        return "FieldVariable " + this.getName();
    }
}

