/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr.formatters;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.modules.debugger.jpda.expr.formatters.VariablesFormatter;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.util.WeakHashMapActive;
import org.openide.util.WeakListeners;

public final class Formatters {
    public static final String PROP_FORMATTERS = "formatters";
    private static final Formatters INSTANCE = new Formatters();
    private VariablesFormatter[] formatters;
    private final Object formattersLock = new Object();
    private Properties jpdaProperties;
    private PropertyChangeListener formattersChangeListener;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private Formatters() {
    }

    public static final Formatters getDefault() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariablesFormatter[] getFormatters() {
        Object object = this.formattersLock;
        synchronized (object) {
            if (this.formatters == null) {
                if (this.formattersChangeListener == null) {
                    this.formattersChangeListener = new PropertyChangeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if ("VariableFormatters".equals(evt.getPropertyName())) {
                                Object object = Formatters.this.formattersLock;
                                synchronized (object) {
                                    Formatters.this.formatters = null;
                                }
                                Formatters.this.pcs.firePropertyChange(Formatters.PROP_FORMATTERS, null, null);
                            }
                        }
                    };
                    this.jpdaProperties = Properties.getDefault().getProperties("debugger.options.JPDA");
                    this.jpdaProperties.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.formattersChangeListener, (Object)this.jpdaProperties));
                }
                this.formatters = VariablesFormatter.loadFormatters();
            }
            return this.formatters;
        }
    }

    public static VariablesFormatter getFormatterForType(JPDAClassType ct, VariablesFormatter[] formatters) {
        FormatterCache cache = FormatterCache.get(formatters);
        VariablesFormatter typeFormatter = cache.getFormatter(ct);
        if (typeFormatter == FormatterCache.NO_FORMATTER) {
            return null;
        }
        if (typeFormatter != null) {
            return typeFormatter;
        }
        String cname = ct.getName();
        for (VariablesFormatter f : formatters) {
            if (!f.isEnabled()) continue;
            String[] types = f.getClassTypes();
            boolean applies = false;
            for (String type : types) {
                if (!type.equals(cname) && (!f.isIncludeSubTypes() || !Formatters.isInstanceOf(ct, type))) continue;
                applies = true;
                break;
            }
            if (!applies) continue;
            typeFormatter = f;
            break;
        }
        cache.setFormatter(ct, typeFormatter);
        return typeFormatter;
    }

    private static boolean isInstanceOf(JPDAClassType ct, String className) {
        return ((JPDAClassTypeImpl)ct).isInstanceOf(className);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private static class FormatterCache {
        private static final VariablesFormatter NO_FORMATTER = new VariablesFormatter("");
        private static final Map<VariablesFormatter[], FormatterCache> cache = new WeakHashMapActive<VariablesFormatter[], FormatterCache>();
        private final Map<JPDAClassType, VariablesFormatter> formatters = new WeakHashMapActive<JPDAClassType, VariablesFormatter>();

        private FormatterCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FormatterCache get(VariablesFormatter[] formatters) {
            FormatterCache fc;
            Map<VariablesFormatter[], FormatterCache> map = cache;
            synchronized (map) {
                fc = cache.get(formatters);
                if (fc == null) {
                    fc = new FormatterCache();
                    cache.put(formatters, fc);
                }
            }
            return fc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        VariablesFormatter getFormatter(JPDAClassType ct) {
            Map<JPDAClassType, VariablesFormatter> map = this.formatters;
            synchronized (map) {
                return this.formatters.get(ct);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFormatter(JPDAClassType ct, VariablesFormatter vf) {
            if (vf == null) {
                vf = NO_FORMATTER;
            }
            Map<JPDAClassType, VariablesFormatter> map = this.formatters;
            synchronized (map) {
                this.formatters.put(ct, vf);
            }
        }
    }
}

