/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars.models;

import java.net.URL;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.debugger.jpda.truffle.vars.models.Bundle;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class TruffleVariablesActionsProviderFilter
implements NodeActionsProviderFilter {
    private final RequestProcessor rp;
    private final Action GO_TO_VALUE_SOURCE_ACTION = Models.createAction((String)Bundle.CTL_GoToSource(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            TruffleVariable var = (TruffleVariable)nodes[0];
            TruffleVariablesActionsProviderFilter.this.rp.post(() -> TruffleVariablesActionsProviderFilter.this.showSource(var.getValueSource()));
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final Action GO_TO_TYPE_SOURCE_ACTION = Models.createAction((String)Bundle.CTL_GoToTypeSource(), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            TruffleVariable var = (TruffleVariable)nodes[0];
            TruffleVariablesActionsProviderFilter.this.rp.post(() -> TruffleVariablesActionsProviderFilter.this.showSource(var.getTypeSource()));
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public TruffleVariablesActionsProviderFilter(ContextProvider contextProvider) {
        this.rp = ((JPDADebuggerImpl)contextProvider.lookupFirst(null, JPDADebugger.class)).getRequestProcessor();
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleVariable) {
            TruffleVariable var = (TruffleVariable)node;
            this.rp.post(() -> {
                SourcePosition source = var.getValueSource();
                if (source == null) {
                    source = var.getTypeSource();
                }
                if (source != null) {
                    this.showSource(source);
                }
            });
        } else {
            original.performDefaultAction(node);
        }
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        Action[] actions;
        UnknownTypeException originalUTEx = null;
        try {
            actions = original.getActions(node);
        }
        catch (UnknownTypeException utex) {
            originalUTEx = utex;
            actions = new Action[]{};
        }
        if (node instanceof TruffleVariable) {
            TruffleVariable var = (TruffleVariable)node;
            boolean hasValueSource = var.hasValueSource();
            boolean hasTypeSource = var.hasTypeSource();
            if (hasValueSource || hasTypeSource) {
                int l = actions.length;
                if (hasValueSource) {
                    ++l;
                }
                if (hasTypeSource) {
                    ++l;
                }
                Action[] newActions = new Action[l];
                System.arraycopy(actions, 0, newActions, 0, actions.length);
                l = actions.length;
                if (hasValueSource) {
                    newActions[l++] = this.GO_TO_VALUE_SOURCE_ACTION;
                }
                if (hasTypeSource) {
                    newActions[l++] = this.GO_TO_TYPE_SOURCE_ACTION;
                }
                actions = newActions;
            }
        } else if (originalUTEx != null) {
            throw originalUTEx;
        }
        return actions;
    }

    private void showSource(SourcePosition source) {
        URL url = source.getSource().getUrl();
        int lineNumber = source.getStartLine();
        SwingUtilities.invokeLater(() -> {
            boolean success = EditorContextBridge.getContext().showSource(url.toExternalForm(), lineNumber, null);
            if (!success) {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)Bundle.MSG_NoSourceFile(url.toExternalForm()), 2);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)d);
            }
        });
    }
}

