/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.options.TruffleOptions;
import org.netbeans.modules.debugger.jpda.util.WeakCacheMap;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class DebuggingTruffleTreeModel
implements TreeModelFilter {
    private static final Predicate<String> PREDICATE1 = Pattern.compile("^((com|org)\\.\\p{Alpha}*\\.truffle|(com|org)(\\.graalvm|\\.truffleruby))\\..*$").asPredicate();
    private static final String FILTER1 = "com.[A-z]*.truffle.";
    private static final String FILTER2 = "com.oracle.graal.";
    private static final String FILTER3 = "org.netbeans.modules.debugger.jpda.backend.";
    private final JPDADebugger debugger;
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private final PropertyChangeListener propListenerHolder;

    public DebuggingTruffleTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.propListenerHolder = propEvent -> {
            ModelListener[] mls;
            List<ModelListener> list = this.listeners;
            synchronized (list) {
                mls = this.listeners.toArray(new ModelListener[this.listeners.size()]);
            }
            ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)"Root");
            for (ModelListener ml : mls) {
                ml.modelChanged((ModelEvent)event);
            }
        };
        TruffleOptions.onLanguageDeveloperModeChange(this.propListenerHolder);
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        CurrentPCInfo currentPCInfo;
        Object[] children = original.getChildren(parent, from, to);
        if (parent instanceof DebuggingView.DVThread && children.length > 0 && (currentPCInfo = TruffleAccess.getCurrentPCInfo((JPDAThread)((WeakCacheMap.KeyedValue)parent).getKey())) != null) {
            boolean showInternalFrames = TruffleOptions.isLanguageDeveloperMode();
            TruffleStackFrame[] stackFrames = currentPCInfo.getStack().getStackFrames(showInternalFrames);
            children = this.filterAndAppend(children, stackFrames, currentPCInfo.getTopFrame());
        }
        return children;
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            return true;
        }
        return original.isLeaf(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private Object[] filterAndAppend(Object[] children, TruffleStackFrame[] stackFrames, TruffleStackFrame topFrame) {
        ArrayList<Object> newChildren = new ArrayList<Object>(children.length);
        for (Object ch : children) {
            String className;
            if (ch instanceof CallStackFrame && (PREDICATE1.test(className = ((CallStackFrame)ch).getClassName()) || className.startsWith(FILTER2) || className.startsWith(FILTER3))) continue;
            newChildren.add(ch);
        }
        int i = 0;
        newChildren.add(i++, topFrame);
        for (TruffleStackFrame tsf : stackFrames) {
            newChildren.add(i++, tsf);
        }
        return newChildren.toArray();
    }
}

