/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.netbeans.api.debugger.Properties;
import org.openide.util.BaseUtilities;

public final class TruffleProperties {
    private static final Properties truffleProperties = Properties.getDefault().getProperties("debugger.options.Truffle");
    private static final String PROP_SHOW_INTERNAL = "showInternal";
    private static TruffleProperties INSTANCE = new TruffleProperties();
    private TrufflePropertiesListener trufflePropertiesListener;

    private TruffleProperties() {
    }

    public boolean isShowInternal() {
        return truffleProperties.getBoolean(PROP_SHOW_INTERNAL, false);
    }

    public void setShowInternal(boolean showInternal) {
        truffleProperties.setBoolean(PROP_SHOW_INTERNAL, showInternal);
    }

    public synchronized Disposable onShowInternalChange(Consumer<Boolean> onChange) {
        if (this.trufflePropertiesListener == null) {
            this.trufflePropertiesListener = new TrufflePropertiesListener();
            truffleProperties.addPropertyChangeListener((PropertyChangeListener)this.trufflePropertiesListener);
        }
        return this.trufflePropertiesListener.addOnShowInternalChange(onChange);
    }

    private class TrufflePropertiesListener
    implements PropertyChangeListener {
        private LinkedList<Consumer<Boolean>> onChangeListeners = new LinkedList();

        private TrufflePropertiesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName;
            switch (propertyName = evt.getPropertyName()) {
                case "showInternal": {
                    ArrayList<Consumer<Boolean>> listeners;
                    Boolean isInternal = (Boolean)evt.getNewValue();
                    LinkedList<Consumer<Boolean>> linkedList = this.onChangeListeners;
                    synchronized (linkedList) {
                        listeners = new ArrayList<Consumer<Boolean>>(this.onChangeListeners);
                    }
                    for (Consumer consumer : listeners) {
                        consumer.accept(isInternal);
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Disposable addOnShowInternalChange(Consumer<Boolean> onChange) {
            LinkedList<Consumer<Boolean>> linkedList = this.onChangeListeners;
            synchronized (linkedList) {
                this.onChangeListeners.add(onChange);
            }
            return new Disposable(this.onChangeListeners, onChange);
        }
    }

    private static class DisposableReference
    extends WeakReference<Disposable>
    implements Runnable {
        private final LinkedList<?> list;
        private final Consumer f;

        DisposableReference(Disposable disposable, ReferenceQueue<? super Disposable> queue) {
            super(disposable, queue);
            this.list = disposable.list;
            this.f = disposable.f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            LinkedList<?> linkedList = this.list;
            synchronized (linkedList) {
                this.list.remove(this.f);
            }
        }

        @Override
        public void run() {
            this.dispose();
        }
    }

    public final class Disposable {
        private final LinkedList<?> list;
        private final Consumer f;
        private final DisposableReference ref;

        Disposable(LinkedList<?> list, Consumer f) {
            this.list = list;
            this.f = f;
            this.ref = new DisposableReference(this, BaseUtilities.activeReferenceQueue());
        }

        public void dispose() {
            this.ref.dispose();
            this.ref.clear();
        }
    }
}

