/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.frames.models.Bundle;
import org.netbeans.modules.debugger.jpda.truffle.options.TruffleOptions;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class DebuggingTruffleActionsProvider
implements NodeActionsProviderFilter {
    private final Action MAKE_CURRENT_ACTION;
    private final Action GO_TO_SOURCE_ACTION;
    private final Action POP_TO_HERE_ACTION;
    private final Action SHOW_INTERNAL_ACTION;
    private final Action HIDE_INTERNAL_ACTION;

    public DebuggingTruffleActionsProvider(ContextProvider lookupProvider) {
        RequestProcessor requestProcessor = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        this.MAKE_CURRENT_ACTION = this.createMAKE_CURRENT_ACTION(requestProcessor);
        this.GO_TO_SOURCE_ACTION = DebuggingTruffleActionsProvider.createGO_TO_SOURCE_ACTION(requestProcessor);
        this.POP_TO_HERE_ACTION = this.createPOP_TO_HERE_ACTION(requestProcessor);
        this.SHOW_INTERNAL_ACTION = DebuggingTruffleActionsProvider.createSHOW_INTERNAL_ACTION();
        this.HIDE_INTERNAL_ACTION = DebuggingTruffleActionsProvider.createHIDE_INTERNAL_ACTION();
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            TruffleStackFrame f = (TruffleStackFrame)node;
            CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(f.getThread());
            if (currentPCInfo != null) {
                currentPCInfo.setSelectedStackFrame(f);
                DebuggingTruffleActionsProvider.goToSource(f);
            }
        } else {
            original.performDefaultAction(node);
        }
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            return new Action[]{this.MAKE_CURRENT_ACTION, this.POP_TO_HERE_ACTION, this.GO_TO_SOURCE_ACTION};
        }
        return original.getActions(node);
    }

    private static void goToSource(final TruffleStackFrame f) {
        final SourcePosition sourcePosition = f.getSourcePosition();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorContextBridge.getContext().showSource(sourcePosition.getSource().getUrl().toExternalForm(), sourcePosition.getLine(), (Object)f.getDebugger());
            }
        });
    }

    private Action createMAKE_CURRENT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_MakeCurrent_Label(), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                TruffleStackFrame f;
                CurrentPCInfo currentPCInfo;
                if (node instanceof TruffleStackFrame && (currentPCInfo = TruffleAccess.getCurrentPCInfo((f = (TruffleStackFrame)node).getThread())) != null) {
                    TruffleStackFrame topFrame = currentPCInfo.getTopFrame();
                    if (topFrame == null) {
                        return f.getDepth() > 0;
                    }
                    return f != topFrame;
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                if (nodes.length == 0) {
                    return;
                }
                if (nodes[0] instanceof TruffleStackFrame) {
                    TruffleStackFrame f = (TruffleStackFrame)nodes[0];
                    CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(f.getThread());
                    if (currentPCInfo != null) {
                        currentPCInfo.setSelectedStackFrame(f);
                    }
                    DebuggingTruffleActionsProvider.goToSource(f);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createGO_TO_SOURCE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_GoToSource_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof TruffleStackFrame;
            }

            public void perform(final Object[] nodes) {
                requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingTruffleActionsProvider.goToSource((TruffleStackFrame)nodes[0]);
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createSHOW_INTERNAL_ACTION() {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_ShowInternal_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof DebuggingView.DVThread;
            }

            public void perform(Object[] nodes) {
                TruffleOptions.setLanguageDeveloperMode(true);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createHIDE_INTERNAL_ACTION() {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_HideInternal_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof DebuggingView.DVThread;
            }

            public void perform(Object[] nodes) {
                TruffleOptions.setLanguageDeveloperMode(false);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private Action createPOP_TO_HERE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_PopToHere_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof TruffleStackFrame;
            }

            public void perform(final Object[] nodes) {
                requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        ((TruffleStackFrame)nodes[0]).popToHere();
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static abstract class LazyActionPerformer
    implements Models.ActionPerformer {
        private final RequestProcessor rp;

        public LazyActionPerformer(RequestProcessor rp) {
            this.rp = rp;
        }

        public abstract boolean isEnabled(Object var1);

        public final void perform(final Object[] nodes) {
            this.rp.post(new Runnable(){

                @Override
                public void run() {
                    this.run(nodes);
                }
            });
        }

        public abstract void run(Object[] var1);
    }
}

