/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.ast.model;

import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.truffle.ast.TruffleNode;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class ASTNodeModel
implements NodeModel {
    private final JPDADebugger debugger;

    public ASTNodeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof TruffleNode) {
            int l1;
            TruffleNode ast = (TruffleNode)node;
            String label = ast.getClassSimpleName();
            String tags = ast.getTags();
            if (!tags.isEmpty()) {
                label = '[' + tags + "] " + label;
            }
            if ((l1 = ast.getStartLine()) >= 0) {
                int c1 = ast.getStartColumn();
                int l2 = ast.getEndLine();
                int c2 = ast.getEndColumn();
                label = label + " <" + l1 + ":" + c1 + "-" + l2 + ":" + c2 + ">";
            }
            if (ast.getChildren().length == 0 && ast.isCurrent()) {
                label = "<html><b>" + label + "</b></html>";
            }
            return label;
        }
        throw new UnknownTypeException(node);
    }

    public String getIconBase(Object node) throws UnknownTypeException {
        return "org/netbeans/modules/debugger/resources/threadsView/RunningThread";
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof TruffleNode) {
            TruffleNode ast = (TruffleNode)node;
            return ast.getClassName() + " (" + ast.getDescription() + ")";
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }
}

