/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.debugger.jpda.projects.SourcePathProviderImpl;
import org.netbeans.modules.debugger.jpda.projectsui.MainProjectManager;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.netbeans.spi.viewmodel.CheckNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public class SourcesCurrentModel
implements TreeModel,
CheckNodeModelFilter,
NodeActionsProvider {
    private static final Logger logger = Logger.getLogger(SourcesCurrentModel.class.getName());
    private Vector<ModelListener> listeners = new Vector();
    private Set<String> disabledSourceRoots = new HashSet<String>();
    private List<String> additionalSourceRoots = Collections.emptyList();
    private String[] unorderedOriginalSourceRoots;
    private String[] sortedOriginalSourceRoots;
    private int[] sourcePathPermutation;
    private Properties sourcesProperties = Properties.getDefault().getProperties("debugger").getProperties("sources");
    private String projectRoot;
    private PropertyChangeListener mainProjectListener;
    private DebuggerManagerListener debuggerListener;
    private SourcePathProviderImpl currentSourcePathProvider;
    private JFileChooser newSourceFileChooser;
    private final Action NEW_SOURCE_ROOT_ACTION = new AbstractAction(NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_Action_AddSrc")){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            int state;
            File currentSourceRoot;
            if (SourcesCurrentModel.this.newSourceFileChooser == null) {
                SourcesCurrentModel.this.newSourceFileChooser = new JFileChooser();
                SourcesCurrentModel.this.newSourceFileChooser.setFileSelectionMode(2);
                SourcesCurrentModel.this.newSourceFileChooser.setFileFilter(new FileFilter(){

                    @Override
                    public String getDescription() {
                        return NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_AddSrc_Chooser_Filter_Description");
                    }

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        try {
                            return FileUtil.isArchiveFile((URL)file.toURI().toURL());
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            return false;
                        }
                    }
                });
            }
            if ((currentSourceRoot = SourcesCurrentModel.getCurrentSourceRoot()) != null) {
                SourcesCurrentModel.this.newSourceFileChooser.setSelectedFile(currentSourceRoot);
            }
            if ((state = SourcesCurrentModel.this.newSourceFileChooser.showDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_AddSrc_Btn"))) == 0) {
                File zipOrDir = SourcesCurrentModel.this.newSourceFileChooser.getSelectedFile();
                try {
                    if (!zipOrDir.isDirectory() && !FileUtil.isArchiveFile((URL)zipOrDir.toURI().toURL())) {
                        return;
                    }
                    String d = FileUtil.normalizePath((String)zipOrDir.getAbsolutePath());
                    SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
                    synchronized (sourcesCurrentModel) {
                        SourcesCurrentModel.this.additionalSourceRoots.add(d);
                        SourcesCurrentModel.this.unorderedOriginalSourceRoots = SourcesCurrentModel.resize(SourcesCurrentModel.this.unorderedOriginalSourceRoots, 1);
                        SourcesCurrentModel.this.sortedOriginalSourceRoots = SourcesCurrentModel.resize(SourcesCurrentModel.this.sortedOriginalSourceRoots, 1);
                        SourcesCurrentModel.this.sourcePathPermutation = SourcesCurrentModel.resize(SourcesCurrentModel.this.sourcePathPermutation, 1);
                        SourcesCurrentModel.this.unorderedOriginalSourceRoots[SourcesCurrentModel.this.unorderedOriginalSourceRoots.length - 1] = d;
                        SourcesCurrentModel.this.sortedOriginalSourceRoots[SourcesCurrentModel.this.sortedOriginalSourceRoots.length - 1] = d;
                        SourcesCurrentModel.this.sourcePathPermutation[SourcesCurrentModel.this.sourcePathPermutation.length - 1] = SourcesCurrentModel.this.sourcePathPermutation.length - 1;
                        SourcePathProviderImpl.storeSourceRootsOrder((String)SourcesCurrentModel.this.projectRoot, (String[])SourcesCurrentModel.this.unorderedOriginalSourceRoots, (int[])SourcesCurrentModel.this.sourcePathPermutation);
                    }
                    SourcesCurrentModel.this.saveAdditionalSourceRoots();
                    SourcesCurrentModel.this.fireTreeChanged();
                }
                catch (IOException ioex) {
                    ErrorManager.getDefault().notify((Throwable)ioex);
                }
            }
        }
    };
    private final Action DELETE_ACTION = Models.createAction((String)NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_Action_Delete"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                for (int i = 0; i < k; ++i) {
                    ArrayList<String> sortedSR;
                    String node = (String)nodes[i];
                    SourcesCurrentModel.this.additionalSourceRoots.remove(node);
                    SourcesCurrentModel.this.disabledSourceRoots.remove(node);
                    ArrayList<String> unorderedSR = new ArrayList<String>(Arrays.asList(SourcesCurrentModel.this.unorderedOriginalSourceRoots));
                    int index = unorderedSR.indexOf(node);
                    if (index >= 0) {
                        int j;
                        unorderedSR.remove(index);
                        SourcesCurrentModel.this.unorderedOriginalSourceRoots = unorderedSR.toArray(new String[0]);
                        int pi = SourcesCurrentModel.this.sourcePathPermutation[index];
                        for (j = 0; j < SourcesCurrentModel.this.sourcePathPermutation.length; ++j) {
                            if (SourcesCurrentModel.this.sourcePathPermutation[j] <= pi) continue;
                            int n = j;
                            SourcesCurrentModel.this.sourcePathPermutation[n] = SourcesCurrentModel.this.sourcePathPermutation[n] - 1;
                        }
                        for (j = index; j < SourcesCurrentModel.this.sourcePathPermutation.length - 1; ++j) {
                            SourcesCurrentModel.this.sourcePathPermutation[j] = SourcesCurrentModel.this.sourcePathPermutation[j + 1];
                        }
                    }
                    if ((index = (sortedSR = new ArrayList<String>(Arrays.asList(SourcesCurrentModel.this.sortedOriginalSourceRoots))).indexOf(node)) < 0) continue;
                    sortedSR.remove(index);
                    SourcesCurrentModel.this.sortedOriginalSourceRoots = sortedSR.toArray(new String[0]);
                }
                SourcesCurrentModel.this.sourcePathPermutation = SourcesCurrentModel.resize(SourcesCurrentModel.this.sourcePathPermutation, -k);
                SourcesCurrentModel.this.saveAdditionalSourceRoots();
                SourcesCurrentModel.this.saveDisabledSourceRoots();
                SourcePathProviderImpl.storeSourceRootsOrder((String)SourcesCurrentModel.this.projectRoot, (String[])SourcesCurrentModel.this.unorderedOriginalSourceRoots, (int[])SourcesCurrentModel.this.sourcePathPermutation);
            }
            SourcesCurrentModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_UP_ACTION = Models.createAction((String)NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_MoveUpSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(Object node) {
            if ("Root".equals(node)) {
                return false;
            }
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                return SourcesCurrentModel.this.sortedOriginalSourceRoots.length > 0 && !SourcesCurrentModel.this.sortedOriginalSourceRoots[0].equals(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                String[] roots = SourcesCurrentModel.this.sortedOriginalSourceRoots;
                int n = roots.length;
                int[] permutation = new int[n];
                for (int i = 0; i < n; ++i) {
                    int j;
                    for (j = 0; j < k && !roots[i].equals(nodes[j]); ++j) {
                    }
                    if (j < k) {
                        if (i <= 0) continue;
                        permutation[i] = permutation[i - 1];
                        permutation[i - 1] = i;
                        continue;
                    }
                    permutation[i] = i;
                }
                if (SourcesCurrentModel.this.currentSourcePathProvider != null) {
                    SourcesCurrentModel.this.currentSourcePathProvider.reorderOriginalSourceRoots(permutation);
                } else {
                    SourcesCurrentModel.this.reorderOriginalSourceRoots(permutation);
                }
            }
            SourcesCurrentModel.this.fireTreeChanged();
            SourcesCurrentModel.this.fireSelectedNodes(nodes);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action MOVE_DOWN_ACTION = Models.createAction((String)NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_MoveDownSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEnabled(Object node) {
            if ("Root".equals(node)) {
                return false;
            }
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                return SourcesCurrentModel.this.sortedOriginalSourceRoots.length > 0 && !SourcesCurrentModel.this.sortedOriginalSourceRoots[SourcesCurrentModel.this.sortedOriginalSourceRoots.length - 1].equals(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void perform(Object[] nodes) {
            int k = nodes.length;
            SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
            synchronized (sourcesCurrentModel) {
                String[] roots = SourcesCurrentModel.this.sortedOriginalSourceRoots;
                int n = roots.length;
                int[] permutation = new int[n];
                for (int i = n - 1; i >= 0; --i) {
                    int j;
                    for (j = 0; j < k && !roots[i].equals(nodes[j]); ++j) {
                    }
                    if (j < k) {
                        if (i >= n - 1) continue;
                        permutation[i] = permutation[i + 1];
                        permutation[i + 1] = i;
                        continue;
                    }
                    permutation[i] = i;
                }
                if (SourcesCurrentModel.this.currentSourcePathProvider != null) {
                    SourcesCurrentModel.this.currentSourcePathProvider.reorderOriginalSourceRoots(permutation);
                } else {
                    SourcesCurrentModel.this.reorderOriginalSourceRoots(permutation);
                }
            }
            SourcesCurrentModel.this.fireTreeChanged();
            SourcesCurrentModel.this.fireSelectedNodes(nodes);
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private final Action RESET_ORDER_ACTION = Models.createAction((String)NbBundle.getMessage(SourcesCurrentModel.class, (String)"CTL_SourcesModel_ResetOrderSrc"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            if (SourcesCurrentModel.this.currentSourcePathProvider != null) {
                SourcesCurrentModel.this.currentSourcePathProvider.reorderOriginalSourceRoots(null);
            } else {
                SourcesCurrentModel.this.reorderOriginalSourceRoots(null);
            }
            SourcesCurrentModel.this.fireTreeChanged();
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);

    public SourcesCurrentModel() {
        this.bindWithSourcePathProvider();
        this.DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        this.MOVE_UP_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.MOVE_DOWN_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
        this.RESET_ORDER_ACTION.putValue("DisabledWhenInSortedTable", Boolean.TRUE);
    }

    private void bindWithSourcePathProvider() {
        this.debuggerListener = new DebuggerManagerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("currentSession".equals(propertyName)) {
                    Session s = DebuggerManager.getDebuggerManager().getCurrentSession();
                    SourcePathProviderImpl spImpl = null;
                    if (s != null) {
                        List sourcePathProviders = s.lookup(null, SourcePathProvider.class);
                        for (SourcePathProvider sp : sourcePathProviders) {
                            if (!(sp instanceof SourcePathProviderImpl)) continue;
                            spImpl = (SourcePathProviderImpl)sp;
                            SourcesCurrentModel.this.setSources(spImpl);
                            break;
                        }
                    }
                    SourcesCurrentModel sourcesCurrentModel = SourcesCurrentModel.this;
                    synchronized (sourcesCurrentModel) {
                        SourcesCurrentModel.this.currentSourcePathProvider = spImpl;
                    }
                    SourcesCurrentModel.this.fireTreeChanged();
                }
            }
        };
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)this.debuggerListener, (Object)DebuggerManager.getDebuggerManager()));
    }

    private synchronized void setSources(SourcePathProviderImpl sp) {
        this.currentSourcePathProvider = sp;
    }

    public Object getRoot() {
        return "Root";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
        if (parent == "Root") {
            String[] sourceRoots;
            SourcesCurrentModel sourcesCurrentModel = this;
            synchronized (sourcesCurrentModel) {
                if (this.currentSourcePathProvider != null) {
                    this.sortedOriginalSourceRoots = this.currentSourcePathProvider.getSourceRoots();
                    return this.sortedOriginalSourceRoots;
                }
            }
            if (this.mainProjectListener == null) {
                this.mainProjectListener = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        SourcesCurrentModel.this.fireTreeChanged();
                    }
                };
                MainProjectManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.mainProjectListener, (Object)MainProjectManager.getDefault()));
            }
            Project p = MainProjectManager.getDefault().getMainProject();
            String root = null;
            if (p != null) {
                List<FileObject> projectSources = SourcesCurrentModel.getProjectSources(p);
                sourceRoots = new String[projectSources.size()];
                for (int i = 0; i < sourceRoots.length; ++i) {
                    sourceRoots[i] = SourcePathProviderImpl.getRoot((FileObject)projectSources.get(i));
                }
                root = p.getProjectDirectory().toURL().toExternalForm();
            } else {
                sourceRoots = new String[]{};
            }
            List<String> addSrcRoots = null;
            SourcesCurrentModel i = this;
            synchronized (i) {
                if (root != null) {
                    addSrcRoots = this.loadAdditionalSourceRoots(root);
                }
                addSrcRoots = addSrcRoots == null ? new ArrayList<String>() : new ArrayList<String>(addSrcRoots);
                this.additionalSourceRoots = addSrcRoots;
                this.disabledSourceRoots = this.loadDisabledSourceRoots(root);
                this.disabledSourceRoots = this.disabledSourceRoots == null ? new HashSet<String>() : new HashSet<String>(this.disabledSourceRoots);
                this.projectRoot = root;
            }
            String[] os = new String[sourceRoots.length + addSrcRoots.size()];
            System.arraycopy(sourceRoots, 0, os, 0, sourceRoots.length);
            System.arraycopy(addSrcRoots.toArray(), 0, os, sourceRoots.length, addSrcRoots.size());
            Map orderIndexes = SourcePathProviderImpl.getSourceRootsOrder((String)root);
            Object[] sortedOriginalRoots = new String[os.length];
            int[] sourcePathPermutation = SourcePathProviderImpl.createPermutation((String[])os, (Map)orderIndexes, (String[])sortedOriginalRoots);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("getChildren(): orderIndexes = " + orderIndexes + ", sourcePathPermutation = " + Arrays.toString(sourcePathPermutation));
                logger.fine("    sorted roots = " + Arrays.toString(sortedOriginalRoots));
                logger.fine("  sourcePathPermutation = " + Arrays.toString(sourcePathPermutation));
            }
            to = Math.min(sortedOriginalRoots.length, to);
            from = Math.min(sortedOriginalRoots.length, from);
            Object[] fos = new Object[to - from];
            System.arraycopy(sortedOriginalRoots, from, fos, 0, to - from);
            SourcesCurrentModel sourcesCurrentModel2 = this;
            synchronized (sourcesCurrentModel2) {
                this.unorderedOriginalSourceRoots = os;
                this.sortedOriginalSourceRoots = sortedOriginalRoots;
                this.sourcePathPermutation = sourcePathPermutation;
            }
            return fos;
        }
        throw new UnknownTypeException(parent);
    }

    private List<String> loadAdditionalSourceRoots(String projectRoot) {
        if (projectRoot == null) {
            return null;
        }
        return (List)this.sourcesProperties.getProperties("additional_source_roots").getMap("project", Collections.emptyMap()).get(projectRoot);
    }

    private Set<String> loadDisabledSourceRoots(String projectRoot) {
        if (projectRoot == null) {
            return null;
        }
        return (Set)this.sourcesProperties.getProperties("source_roots").getMap("project_disabled", Collections.emptyMap()).get(projectRoot);
    }

    private static List<FileObject> getProjectSources(Project p) {
        ClassPath ecp;
        SourceGroup[] sgs;
        ArrayList<FileObject> allSourceRoots = new ArrayList<FileObject>();
        HashSet<FileObject> addedBinaryRoots = new HashSet<FileObject>();
        HashSet<FileObject> preferredRoots = new HashSet<FileObject>();
        Sources s = ProjectUtils.getSources((Project)p);
        for (SourceGroup sg : sgs = s.getSourceGroups("java")) {
            ecp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/boot");
            if (ecp == null) continue;
            SourcesCurrentModel.addSourceRoots(ecp, allSourceRoots, addedBinaryRoots, preferredRoots);
        }
        for (SourceGroup sg : sgs) {
            ecp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/execute");
            if (ecp == null) continue;
            SourcesCurrentModel.addSourceRoots(ecp, allSourceRoots, addedBinaryRoots, preferredRoots);
        }
        for (SourceGroup sg : sgs) {
            ecp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/source");
            if (ecp == null) continue;
            SourcesCurrentModel.addSourceRoots(ecp, allSourceRoots, preferredRoots);
        }
        return allSourceRoots;
    }

    private static void addSourceRoots(ClassPath ecp, List<FileObject> allSourceRoots, Set<FileObject> addedBinaryRoots, Set<FileObject> preferredRoots) {
        FileObject[] binaryRoots;
        for (FileObject fo : binaryRoots = ecp.getRoots()) {
            FileObject[] roots;
            if (addedBinaryRoots.contains(fo)) continue;
            addedBinaryRoots.add(fo);
            for (FileObject fr : roots = SourceForBinaryQuery.findSourceRoots((URL)fo.toURL()).getRoots()) {
                if (preferredRoots.contains(fr)) continue;
                allSourceRoots.add(fr);
                preferredRoots.add(fr);
            }
        }
    }

    private static void addSourceRoots(ClassPath ecp, List<FileObject> allSourceRoots, Set<FileObject> preferredRoots) {
        FileObject[] sourceRoots;
        for (FileObject fr : sourceRoots = ecp.getRoots()) {
            if (preferredRoots.contains(fr) || fr.isVirtual()) continue;
            allSourceRoots.add(fr);
            preferredRoots.add(fr);
        }
    }

    public int getChildrenCount(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return Integer.MAX_VALUE;
        }
        throw new UnknownTypeException(node);
    }

    public boolean isLeaf(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return false;
        }
        if (node instanceof String) {
            return true;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public void fireTreeChanged() {
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged(null);
        }
    }

    private void fireSelectedNodes(Object[] nodes) {
        ModelEvent.SelectionChanged event = new ModelEvent.SelectionChanged((Object)this, nodes);
        Vector v = (Vector)this.listeners.clone();
        int k = v.size();
        for (int i = 0; i < k; ++i) {
            ((ModelListener)v.get(i)).modelChanged((ModelEvent)event);
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node instanceof String) {
            if (this.additionalSourceRoots.contains((String)node)) {
                return new Action[]{this.NEW_SOURCE_ROOT_ACTION, this.DELETE_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
            }
            return new Action[]{this.NEW_SOURCE_ROOT_ACTION, null, this.MOVE_UP_ACTION, this.MOVE_DOWN_ACTION, null, this.RESET_ORDER_ACTION};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (!(node instanceof String)) {
            throw new UnknownTypeException(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEnabled(String root) {
        SourcesCurrentModel sourcesCurrentModel = this;
        synchronized (sourcesCurrentModel) {
            return !this.disabledSourceRoots.contains(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabled(String root, boolean enabled) {
        SourcesCurrentModel sourcesCurrentModel = this;
        synchronized (sourcesCurrentModel) {
            if (enabled) {
                this.disabledSourceRoots.remove(root);
            } else {
                this.disabledSourceRoots.add(root);
            }
            this.saveDisabledSourceRoots();
        }
    }

    private synchronized void saveDisabledSourceRoots() {
        Map map = this.sourcesProperties.getProperties("source_roots").getMap("project_disabled", new HashMap());
        map.put(this.projectRoot, this.disabledSourceRoots);
        this.sourcesProperties.getProperties("source_roots").setMap("project_disabled", map);
    }

    private synchronized void saveAdditionalSourceRoots() {
        Map map = this.sourcesProperties.getProperties("additional_source_roots").getMap("project", new HashMap());
        map.put(this.projectRoot, this.additionalSourceRoots);
        this.sourcesProperties.getProperties("additional_source_roots").setMap("project", map);
    }

    public boolean isCheckable(NodeModel original, Object node) throws UnknownTypeException {
        return true;
    }

    public boolean isCheckEnabled(NodeModel original, Object node) throws UnknownTypeException {
        return true;
    }

    public Boolean isSelected(NodeModel original, Object node) throws UnknownTypeException {
        if (node instanceof String) {
            return this.isEnabled((String)node);
        }
        throw new UnknownTypeException(node);
    }

    public void setSelected(NodeModel original, Object node, Boolean selected) throws UnknownTypeException {
        if (node instanceof String) {
            this.setEnabled((String)node, selected);
            return;
        }
        throw new UnknownTypeException(node);
    }

    public String getDisplayName(NodeModel original, Object node) throws UnknownTypeException {
        return original.getDisplayName(node);
    }

    public String getIconBase(NodeModel original, Object node) throws UnknownTypeException {
        return original.getIconBase(node);
    }

    public String getShortDescription(NodeModel original, Object node) throws UnknownTypeException {
        return original.getShortDescription(node);
    }

    public synchronized void reorderOriginalSourceRoots(int[] permutation) {
        String[] srcRoots = this.sortedOriginalSourceRoots;
        if (permutation == null) {
            for (int i = 0; i < this.sourcePathPermutation.length; ++i) {
                this.sourcePathPermutation[i] = i;
            }
            this.sortedOriginalSourceRoots = this.unorderedOriginalSourceRoots;
            srcRoots = this.unorderedOriginalSourceRoots;
        } else {
            int i;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("reorderOriginalSourceRoots(" + Arrays.toString(permutation));
            }
            if (srcRoots.length != permutation.length) {
                throw new IllegalArgumentException("Bad length of permutation: " + permutation.length + ", have " + srcRoots.length + " source roots.");
            }
            int n = permutation.length;
            String[] unorderedOriginalRoots = this.unorderedOriginalSourceRoots;
            Object[] sortedOriginalRoots = new String[n];
            for (i = 0; i < n; ++i) {
                permutation[i] = this.sourcePathPermutation[permutation[i]];
                sortedOriginalRoots[i] = unorderedOriginalRoots[permutation[i]];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  sourcePathPermutation = " + Arrays.toString(this.sourcePathPermutation));
            }
            for (i = 0; i < n; ++i) {
                this.sourcePathPermutation[i] = permutation[i];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  => sourcePathPermutation = " + Arrays.toString(this.sourcePathPermutation));
                logger.fine("  => sorted roots = " + Arrays.toString(sortedOriginalRoots));
            }
            this.sortedOriginalSourceRoots = sortedOriginalRoots;
            srcRoots = unorderedOriginalRoots;
        }
        SourcePathProviderImpl.storeSourceRootsOrder((String)this.projectRoot, (String[])srcRoots, (int[])this.sourcePathPermutation);
    }

    private static String[] resize(String[] array, int by) {
        int n = array.length + by;
        String[] newArray = new String[n];
        n = Math.min(n, array.length);
        System.arraycopy(array, 0, newArray, 0, n);
        return newArray;
    }

    private static int[] resize(int[] array, int by) {
        int n = array.length + by;
        int[] newArray = new int[n];
        n = Math.min(n, array.length);
        System.arraycopy(array, 0, newArray, 0, n);
        return newArray;
    }

    static File getCurrentSourceRoot() {
        FileObject fo = EditorContextDispatcher.getDefault().getMostRecentFile();
        if (fo == null) {
            return null;
        }
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
        if (cp == null) {
            return null;
        }
        if ((fo = cp.findOwnerRoot(fo)) == null) {
            return null;
        }
        return FileUtil.toFile((FileObject)fo);
    }
}

