/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.invoke.CallSite;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.IndexElement;
import org.netbeans.modules.dbschema.KeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DBElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.DBElementsCollection;
import org.netbeans.modules.dbschema.jdbcimpl.DDLBridge;
import org.netbeans.modules.dbschema.jdbcimpl.IndexElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.MetaDataUtil;
import org.netbeans.modules.dbschema.jdbcimpl.TableElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.UniqueKeyElementImpl;
import org.netbeans.modules.dbschema.jdbcimpl.ViewDependency;
import org.netbeans.modules.dbschema.util.IDEUtil;

public class SchemaElementImpl
extends DBElementImpl
implements SchemaElement.Impl {
    private static Logger LOGGER = Logger.getLogger(SchemaElementImpl.class.getName());
    private DBElementsCollection tables;
    private DBIdentifier _schema;
    private DBIdentifier _catalog;
    private String _url;
    private String _username;
    private String _driver;
    private String _databaseProductName;
    private String _databaseProductVersion;
    private String _driverName;
    private String _driverVersion;
    private transient DatabaseMetaData dmd;
    private transient String catalog;
    private volatile transient boolean stop;
    public transient PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private transient int progress;

    public SchemaElementImpl() {
        this((ConnectionProvider)null);
    }

    public SchemaElementImpl(ConnectionProvider cp) {
        this.tables = new DBElementsCollection(this, new TableElement[0]);
        String hc = String.valueOf(this.tables.hashCode());
        while (DBElementsCollection.instances.contains(hc)) {
            this.tables = new DBElementsCollection(this, new TableElement[0]);
            hc = String.valueOf(this.tables.hashCode());
        }
        DBElementsCollection.instances.add(hc);
        if (cp != null) {
            try {
                this.dmd = cp.getDatabaseMetaData();
                this._url = this.dmd.getURL();
                this._username = this.dmd.getUserName();
                String schema = cp.getSchema();
                this._schema = schema == null ? DBIdentifier.create("") : DBIdentifier.create(schema);
                this.catalog = cp.getConnection().getCatalog();
                this._catalog = this.catalog == null ? DBIdentifier.create("") : DBIdentifier.create(this.catalog);
                this._driver = cp.getDriver();
                this._databaseProductName = this.dmd.getDatabaseProductName().trim();
                this._databaseProductVersion = this.dmd.getDatabaseProductVersion();
                this._driverName = this.dmd.getDriverName();
                this._driverVersion = this.dmd.getDriverVersion();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        this.stop = false;
    }

    @Override
    public void setName(DBIdentifier name) throws DBException {
        int pos;
        String fullName = name.getFullName();
        if (fullName == null) {
            fullName = name.getName();
            name.setFullName(fullName);
        }
        if ((pos = fullName.lastIndexOf("/")) != -1) {
            name.setName(fullName.substring(pos + 1));
        } else if (fullName.indexOf(".") != -1) {
            name.setName(fullName);
        }
        this._name = name;
    }

    @Override
    public DBIdentifier getName() {
        return this._name;
    }

    @Override
    public int getStatus() {
        return 3;
    }

    @Override
    public void setSchema(DBIdentifier schema) throws DBException {
        this._schema = schema;
    }

    @Override
    public DBIdentifier getSchema() {
        return this._schema;
    }

    @Override
    public void setCatalog(DBIdentifier catalog) throws DBException {
        this._catalog = catalog;
    }

    @Override
    public DBIdentifier getCatalog() {
        return this._catalog;
    }

    @Override
    public void changeTables(TableElement[] elems, int action) throws DBException {
        this.tables.changeElements(elems, action);
    }

    @Override
    public TableElement[] getTables() {
        DBElement[] dbe = this.tables.getElements();
        return Arrays.asList(dbe).toArray(new TableElement[dbe.length]);
    }

    @Override
    public TableElement getTable(DBIdentifier name) {
        TableElement tableElement = (TableElement)this.tables.find(name);
        if (tableElement != null) {
            return tableElement;
        }
        if (this.getDriver().contains("mysql")) {
            for (DBElement dbElement : this.tables.getElements()) {
                TableElement te = (TableElement)dbElement;
                if (!te.getName().getName().equalsIgnoreCase(name.getName())) continue;
                return te;
            }
        }
        return null;
    }

    public void initTables(ConnectionProvider cp) {
        this.initTables(cp, null, null, false);
    }

    public void initTables(ConnectionProvider cp, LinkedList t, LinkedList v) {
        this.initTables(cp, t, v, false);
    }

    public void initTables(ConnectionProvider cp, LinkedList t, LinkedList v, boolean allTables) {
        block19: {
            if (cp != null) {
                try {
                    ResultSet rs;
                    this.progress = 0;
                    List tables = new LinkedList();
                    LinkedList views = new LinkedList();
                    LinkedList<String> tablesTmp = new LinkedList<String>();
                    LinkedList<String> viewsTmp = new LinkedList<String>();
                    String user = cp.getSchema();
                    DDLBridge bridge = null;
                    if (IDEUtil.isIDERunning()) {
                        bridge = new DDLBridge(cp.getConnection(), cp.getSchema(), this.dmd);
                    }
                    List recycleBinTables = "Oracle".equals(this.dmd.getDatabaseProductName()) ? this.getOracleRecycleBinTables() : Collections.EMPTY_LIST;
                    if (bridge != null) {
                        bridge.getDriverSpecification().getTables("%", new String[]{"TABLE"});
                        rs = bridge.getDriverSpecification().getResultSet();
                    } else {
                        rs = this.dmd.getTables(this.catalog, user, "%", new String[]{"TABLE"});
                    }
                    if (rs != null) {
                        while (rs.next()) {
                            if (this.isStop()) {
                                rs.close();
                                return;
                            }
                            String tableTmp = bridge != null ? (String)bridge.getDriverSpecification().getRow().get(3) : rs.getString("TABLE_NAME").trim();
                            if (recycleBinTables.contains(tableTmp)) continue;
                            tablesTmp.add(tableTmp);
                        }
                        rs.close();
                    }
                    rs = null;
                    if (bridge != null) {
                        if (bridge.getDriverSpecification().areViewsSupported()) {
                            bridge.getDriverSpecification().getTables("%", new String[]{"VIEW"});
                            rs = bridge.getDriverSpecification().getResultSet();
                        } else if (MetaDataUtil.areViewsSupported(this.dmd.getDatabaseProductName())) {
                            rs = this.dmd.getTables(this.catalog, user, "%", new String[]{"VIEW"});
                        }
                    }
                    if (rs != null) {
                        while (rs.next()) {
                            if (this.isStop()) {
                                rs.close();
                                return;
                            }
                            if (bridge != null) {
                                viewsTmp.add((String)bridge.getDriverSpecification().getRow().get(3));
                                continue;
                            }
                            viewsTmp.add(rs.getString("TABLE_NAME").trim());
                        }
                        rs.close();
                    }
                    if (t == null && v == null) {
                        tables = tablesTmp;
                        views = viewsTmp;
                    } else {
                        t = this.checkNames(t, tablesTmp);
                        v = this.checkNames(v, viewsTmp);
                        tables = allTables ? t : this.checkReferences(t, bridge, user);
                        views = v;
                    }
                    this.propertySupport.firePropertyChange("totalCount", null, (Object)(2 * tables.size() + views.size()));
                    this.initTables(cp, tables, allTables);
                    this.initViews(cp, views, bridge);
                }
                catch (Exception exc) {
                    if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block19;
                    exc.printStackTrace();
                }
            }
        }
    }

    private LinkedList checkNames(List toCheck, List names) {
        LinkedList result = new LinkedList();
        for (int i = 0; i < toCheck.size(); ++i) {
            Object table = toCheck.get(i);
            if (names.contains(table)) {
                result.add(table);
                continue;
            }
            if (!Boolean.getBoolean("netbeans.debug.exceptions")) continue;
            System.out.println("Cannot find " + table + " table in the database.");
        }
        return result;
    }

    private List checkReferences(List<String> tables, DDLBridge bridge, String schema) throws SQLException {
        for (int i = 0; i < tables.size(); ++i) {
            ResultSet rs;
            if (bridge != null) {
                bridge.getDriverSpecification().getImportedKeys(tables.get(i).toString());
                rs = bridge.getDriverSpecification().getResultSet();
            } else {
                rs = this.dmd.getImportedKeys(this.catalog, schema, tables.get(i).toString());
            }
            if (rs == null) continue;
            Map rset = new HashMap();
            while (rs.next()) {
                String refTable;
                String fkSchema;
                String pkSchema;
                String s2;
                String c2;
                String s1;
                String c1;
                if (bridge != null) {
                    rset = bridge.getDriverSpecification().getRow();
                    c1 = (String)rset.get(1);
                    s1 = (String)rset.get(2);
                    c2 = (String)rset.get(5);
                    s2 = (String)rset.get(6);
                    if (!this.comp(c1, c2) || !this.comp(s1, s2)) continue;
                    pkSchema = (String)rset.get(2);
                    if (Objects.equals(pkSchema, fkSchema = (String)rset.get(6)) && !tables.contains(refTable = (String)rset.get(3))) {
                        tables.add(refTable);
                    }
                    rset.clear();
                    continue;
                }
                c1 = rs.getString("PKTABLE_CAT");
                s1 = rs.getString("PKTABLE_SCHEM");
                c2 = rs.getString("FKTABLE_CAT");
                s2 = rs.getString("FKTABLE_SCHEM");
                if (!this.comp(c1, c2) || !this.comp(s1, s2)) continue;
                pkSchema = rs.getString("PKTABLE_SCHEM");
                if (pkSchema != null) {
                    pkSchema = pkSchema.trim();
                }
                if ((fkSchema = rs.getString("FKTABLE_SCHEM")) != null) {
                    fkSchema = fkSchema.trim();
                }
                if (!Objects.equals(pkSchema, fkSchema) || tables.contains(refTable = rs.getString("PKTABLE_NAME").trim())) continue;
                tables.add(refTable);
            }
            rs.close();
        }
        return tables;
    }

    private void initTables(ConnectionProvider cp, List tables, boolean allTables) throws DBException {
        for (int i = 0; i < tables.size(); ++i) {
            if (this.isStop()) {
                return;
            }
            String name = tables.get(i).toString();
            this.propertySupport.firePropertyChange("tableName", null, name);
            TableElementImpl tei = new TableElementImpl(name);
            tei.setTableOrView(true);
            TableElement[] te = new TableElement[]{new TableElement(tei, (SchemaElement)this.element)};
            tei.initColumns(cp);
            tei.initIndexes(cp);
            this.changeTables(te, 1);
            ++this.progress;
            this.propertySupport.firePropertyChange("progress", null, (Object)this.progress);
        }
        for (int i = 0; i < tables.size(); ++i) {
            if (this.isStop()) {
                return;
            }
            String tableName = tables.get(i).toString();
            TableElement te = this.getTable(DBIdentifier.create(tableName));
            if (te != null) {
                this.propertySupport.firePropertyChange("FKt", null, tableName);
                int fkOption = allTables ? 3 : 0;
                ((TableElementImpl)te.getElementImpl()).initKeys(cp, fkOption, tableName);
            }
            ++this.progress;
            this.propertySupport.firePropertyChange("progress", null, (Object)this.progress);
        }
    }

    private void initViews(ConnectionProvider cp, List views, DDLBridge bridge) throws DBException, SQLException {
        for (int i = 0; i < views.size(); ++i) {
            if (this.isStop()) {
                return;
            }
            String name = views.get(i).toString();
            this.propertySupport.firePropertyChange("viewName", null, name);
            TableElementImpl tei = new TableElementImpl(name);
            tei.setTableOrView(false);
            TableElement te = new TableElement(tei, (SchemaElement)this.element);
            tei.initColumns(cp);
            String database = this.dmd.getDatabaseProductName();
            database = database != null ? database.trim() : "";
            if (database.equalsIgnoreCase("Oracle") || database.equalsIgnoreCase("Microsoft SQL Server")) {
                this.propertySupport.firePropertyChange("FKv", null, name);
                ViewDependency vd = new ViewDependency(cp, cp.getSchema(), name);
                LinkedList tables = new LinkedList();
                LinkedList columns = new LinkedList();
                tables.clear();
                columns.clear();
                vd.constructPK();
                tables = vd.getTables();
                columns = vd.getColumns();
                if (!columns.isEmpty()) {
                    int j;
                    Object uke;
                    ResultSet rs;
                    int j2;
                    boolean all = false;
                    for (int k = 0; k < columns.size(); ++k) {
                        if (!((String)columns.get(k)).trim().endsWith("*")) continue;
                        all = true;
                        break;
                    }
                    boolean capture = true;
                    LinkedList<String> pkTables = new LinkedList<String>();
                    for (j2 = 0; j2 < tables.size(); ++j2) {
                        if (this.isStop()) {
                            return;
                        }
                        if (bridge != null) {
                            bridge.getDriverSpecification().getPrimaryKeys(((String)tables.get(j2)).toString());
                            rs = bridge.getDriverSpecification().getResultSet();
                        } else {
                            rs = cp.getDatabaseMetaData().getPrimaryKeys(cp.getConnection().getCatalog(), cp.getSchema(), ((String)tables.get(j2)).toString());
                        }
                        if (rs == null) continue;
                        if (!all) {
                            Map rset = new HashMap();
                            while (rs.next()) {
                                String colName;
                                if (bridge != null) {
                                    rset = bridge.getDriverSpecification().getRow();
                                    colName = (String)rset.get(4);
                                    rset.clear();
                                } else {
                                    colName = rs.getString("COLUMN_NAME").trim();
                                }
                                if (columns.contains(colName.toLowerCase()) || columns.contains(((String)tables.get(j2)).toString().toLowerCase() + "." + colName.toLowerCase())) continue;
                                capture = false;
                                break;
                            }
                        }
                        if (capture) {
                            pkTables.add(((String)tables.get(j2)).toString());
                        }
                        rs.close();
                    }
                    if (capture) {
                        for (j2 = 0; j2 < pkTables.size(); ++j2) {
                            int k;
                            tei.initIndexes(cp, ((String)pkTables.get(j2)).toString());
                            tei.initKeys(cp, 1, ((String)pkTables.get(j2)).toString());
                            LinkedList<UniqueKeyElement> tempList = new LinkedList<UniqueKeyElement>();
                            KeyElement[] keys = te.getUniqueKeys();
                            for (k = 0; k < keys.length; ++k) {
                                if (!keys[k].isPrimaryKey()) continue;
                                tempList.add(keys[k]);
                            }
                            keys = new UniqueKeyElement[tempList.size()];
                            for (k = 0; k < tempList.size(); ++k) {
                                keys[k] = (UniqueKeyElement)tempList.get(k);
                            }
                            te.setKeys(keys);
                            IndexElement[] indexes = new IndexElement[keys.length];
                            for (int k2 = 0; k2 < keys.length; ++k2) {
                                indexes[k2] = ((UniqueKeyElement)keys[k2]).getAssociatedIndex();
                            }
                            te.setIndexes(indexes);
                        }
                    }
                    if (te.getUniqueKeys().length > 1) {
                        IndexElementImpl iei = new IndexElementImpl(tei, "GENERATED_PK_" + tei.getName().getName(), true);
                        IndexElement[] ie = new IndexElement[]{new IndexElement(iei, te)};
                        IndexElement[] ies = te.getIndexes();
                        for (int j3 = 0; j3 < ies.length; ++j3) {
                            iei.changeColumns(ies[j3].getColumns(), 1);
                        }
                        te.setIndexes(ie);
                        IndexElement ii = te.getIndexes()[0];
                        UniqueKeyElementImpl ukei = new UniqueKeyElementImpl(ii.getName().getName(), true);
                        uke = new UniqueKeyElement(ukei, te, ii);
                        ((KeyElement)uke).setColumns(ii.getColumns());
                        tei.changeKeys(new UniqueKeyElement[]{uke}, 0);
                    }
                    LinkedList<String> toCapture = new LinkedList<String>();
                    LinkedList validFKs = new LinkedList();
                    LinkedList<String> fkTables = new LinkedList<String>();
                    for (j = 0; j < tables.size(); ++j) {
                        String fkName;
                        if (this.isStop()) {
                            return;
                        }
                        if (bridge != null) {
                            bridge.getDriverSpecification().getImportedKeys(((String)tables.get(j)).toString());
                            rs = bridge.getDriverSpecification().getResultSet();
                        } else {
                            rs = cp.getDatabaseMetaData().getImportedKeys(cp.getConnection().getCatalog(), cp.getSchema(), ((String)tables.get(j)).toString());
                        }
                        if (rs == null) continue;
                        Map rset = new HashMap();
                        LinkedList<CallSite> local = new LinkedList<CallSite>();
                        LinkedList<CallSite> ref = new LinkedList<CallSite>();
                        LinkedList<String> fk = new LinkedList<String>();
                        while (rs.next()) {
                            String s2;
                            String c2;
                            String s1;
                            String c1;
                            if (bridge != null) {
                                rset = bridge.getDriverSpecification().getRow();
                                c1 = (String)rset.get(1);
                                s1 = (String)rset.get(2);
                                c2 = (String)rset.get(5);
                                s2 = (String)rset.get(6);
                                if (!this.comp(c1, c2) || !this.comp(s1, s2) || (fkName = (String)rset.get(12)) == null) continue;
                                fkName = fkName.trim();
                                local.add((CallSite)((Object)(fkName + "." + (String)rset.get(7) + "." + (String)rset.get(8))));
                                ref.add((CallSite)((Object)(fkName + "." + (String)rset.get(3) + "." + (String)rset.get(4))));
                                if (!fk.contains(fkName)) {
                                    fk.add(fkName);
                                }
                                rset.clear();
                                continue;
                            }
                            c1 = rs.getString("PKTABLE_CAT");
                            s1 = rs.getString("PKTABLE_SCHEM");
                            c2 = rs.getString("FKTABLE_CAT");
                            s2 = rs.getString("FKTABLE_SCHEM");
                            if (!this.comp(c1, c2) || !this.comp(s1, s2) || (fkName = rs.getString("FK_NAME")) == null) continue;
                            fkName = fkName.trim();
                            local.add((CallSite)((Object)(fkName + "." + rs.getString("FKTABLE_NAME").trim() + "." + rs.getString("FKCOLUMN_NAME").trim())));
                            ref.add((CallSite)((Object)(fkName + "." + rs.getString("PKTABLE_NAME").trim() + "." + rs.getString("PKCOLUMN_NAME").trim())));
                            if (fk.contains(fkName)) continue;
                            fk.add(fkName);
                        }
                        rs.close();
                        block11: for (int k = 0; k < fk.size(); ++k) {
                            String colName;
                            int l;
                            fkName = ((String)fk.get(k)).toString();
                            for (l = 0; l < local.size(); ++l) {
                                colName = ((String)local.get(l)).toString();
                                if (!colName.startsWith(fkName)) continue;
                                colName = colName.substring(colName.lastIndexOf(".") + 1).toLowerCase();
                                if (all || columns.contains(colName) || columns.contains(((String)tables.get(j)).toString().toLowerCase() + "." + colName)) continue;
                                fk.set(k, null);
                                break;
                            }
                            if (fk.get(k) == null) continue;
                            for (l = 0; l < ref.size(); ++l) {
                                colName = ((String)ref.get(l)).toString();
                                if (!colName.startsWith(fkName)) continue;
                                if (this.getTable(DBIdentifier.create(colName = colName.substring(colName.indexOf(".") + 1, colName.lastIndexOf(".")))) != null) continue block11;
                                toCapture.add(colName);
                                continue block11;
                            }
                        }
                        String tblName = ((String)tables.get(j)).toString();
                        for (int k = 0; k < fk.size(); ++k) {
                            Object o = fk.get(k);
                            if (o == null) continue;
                            validFKs.add(o);
                            if (fkTables.contains(tblName)) continue;
                            fkTables.add(tblName);
                        }
                    }
                    this.initTables(cp, this.checkReferences(toCapture, bridge, cp.getSchema()), false);
                    for (j = 0; j < fkTables.size(); ++j) {
                        tei.initKeys(cp, 2, ((String)fkTables.get(j)).toString());
                    }
                    LinkedList<ForeignKeyElement> tempList = new LinkedList<ForeignKeyElement>();
                    ForeignKeyElement[] fke = te.getForeignKeys();
                    uke = te.getUniqueKeys();
                    for (int j4 = 0; j4 < fke.length; ++j4) {
                        if (!validFKs.contains(fke[j4].getName().getName())) continue;
                        tempList.add(fke[j4]);
                    }
                    KeyElement[] ke = new KeyElement[((UniqueKeyElement[])uke).length + tempList.size()];
                    for (int j5 = 0; j5 < ((Object)uke).length; ++j5) {
                        ke[j5] = uke[j5];
                    }
                    int idx = ((Object)uke).length;
                    for (int j6 = 0; j6 < tempList.size(); ++j6) {
                        ke[j6 + idx] = (KeyElement)tempList.get(j6);
                    }
                    te.setKeys(ke);
                }
            }
            this.changeTables(new TableElement[]{te}, 1);
            ++this.progress;
            this.propertySupport.firePropertyChange("progress", null, (Object)this.progress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getOracleRecycleBinTables() {
        List<Object> result = new ArrayList();
        try {
            if (this.dmd.getDatabaseMajorVersion() < 10) {
                return Collections.EMPTY_LIST;
            }
            try (Statement stmt = this.dmd.getConnection().createStatement();
                 ResultSet rs = stmt.executeQuery("SELECT OBJECT_NAME FROM RECYCLEBIN WHERE TYPE = 'TABLE'");){
                while (rs.next()) {
                    result.add(rs.getString("OBJECT_NAME"));
                }
            }
        }
        catch (SQLException exc) {
            LOGGER.log(Level.WARNING, "Some older versions of the Oracle  driver do not support getDatabaseMajorVersion().   Setting recycle bin tables to an empty list.", exc);
            result = Collections.emptyList();
        }
        catch (AbstractMethodError ame) {
            LOGGER.log(Level.WARNING, "Some older versions of the Oracle  driver do not support getDatabaseMajorVersion().   Setting recycle bin tables to an empty list.", ame);
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public String getUrl() {
        return this._url;
    }

    @Override
    public void setUrl(String url) throws DBException {
        this._url = url;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    @Override
    public void setUsername(String username) throws DBException {
        this._username = username;
    }

    @Override
    public String getDriver() {
        return this._driver;
    }

    @Override
    public void setDriver(String driver) {
        this._driver = driver;
    }

    @Override
    public String getDatabaseProductName() {
        return this._databaseProductName;
    }

    @Override
    public void setDatabaseProductName(String databaseProductName) throws DBException {
        this._databaseProductName = databaseProductName;
    }

    @Override
    public String getDatabaseProductVersion() {
        return this._databaseProductVersion;
    }

    @Override
    public void setDatabaseProductVersion(String databaseProductVersion) throws DBException {
        this._databaseProductVersion = databaseProductVersion;
    }

    @Override
    public String getDriverName() {
        return this._driverName;
    }

    @Override
    public void setDriverName(String driverName) throws DBException {
        this._driverName = driverName;
    }

    @Override
    public String getDriverVersion() {
        return this._driverVersion;
    }

    @Override
    public void setDriverVersion(String driverVersion) throws DBException {
        this._driverVersion = driverVersion;
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public DBElementsCollection getTableCollection() {
        return this.tables;
    }

    public void setTableCollection(DBElementsCollection collection) {
        this.tables = collection;
    }
}

