/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.css.visual.Bundle;
import org.netbeans.modules.css.visual.RuleEditorViews;
import org.netbeans.modules.css.visual.api.ViewMode;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;

public abstract class ViewActionSupport
extends AbstractAction
implements Presenter.Popup {
    private JRadioButtonMenuItem menuItem;
    protected RuleEditorViews views;

    public ViewActionSupport(RuleEditorViews views) {
        this.views = views;
    }

    public final JMenuItem getPopupPresenter() {
        JRadioButtonMenuItem result = this.obtainMenuItem();
        this.updateMenuItem();
        return result;
    }

    protected final JRadioButtonMenuItem obtainMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }
        return this.menuItem;
    }

    protected abstract void updateMenuItem();

    public static final class AllViewAction
    extends ViewActionSupport {
        public AllViewAction(RuleEditorViews filters) {
            super(filters);
            this.putValue("Name", Bundle.action_name_all());
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/css/visual/resources/viewAll.png", (boolean)false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.views.setViewMode(ViewMode.ALL);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(this.views.getViewMode() == ViewMode.ALL);
        }
    }

    public static final class CategorizedViewAction
    extends ViewActionSupport {
        public CategorizedViewAction(RuleEditorViews filters) {
            super(filters);
            this.putValue("Name", Bundle.action_name_categorized());
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/css/visual/resources/viewByCategory.png", (boolean)false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.views.setViewMode(ViewMode.CATEGORIZED);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(this.views.getViewMode() == ViewMode.CATEGORIZED);
        }
    }

    public static final class UpdatedOnlyViewAction
    extends ViewActionSupport {
        public UpdatedOnlyViewAction(RuleEditorViews filters) {
            super(filters);
            this.putValue("Name", Bundle.action_name_updated());
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/css/visual/resources/viewByUpdated.png", (boolean)false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.views.setViewMode(ViewMode.UPDATED_ONLY);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(this.views.getViewMode() == ViewMode.UPDATED_ONLY);
        }
    }
}

