/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.lib.api.properties.FixedTextGrammarElement;
import org.netbeans.modules.css.lib.api.properties.GrammarElementVisitor;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;
import org.netbeans.modules.css.lib.api.properties.Properties;
import org.netbeans.modules.css.lib.api.properties.PropertyCategory;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.ResolvedProperty;
import org.netbeans.modules.css.lib.api.properties.Token;
import org.netbeans.modules.css.lib.api.properties.UnitGrammarElement;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.ElementFactory;
import org.netbeans.modules.css.model.api.Expression;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelUtils;
import org.netbeans.modules.css.model.api.Property;
import org.netbeans.modules.css.model.api.PropertyDeclaration;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.AutocompleteJComboBox;
import org.netbeans.modules.css.visual.Bundle;
import org.netbeans.modules.css.visual.PropertyUtils;
import org.netbeans.modules.css.visual.PropertyValuesEditor;
import org.netbeans.modules.css.visual.RuleEditorPanel;
import org.netbeans.modules.css.visual.api.DeclarationInfo;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;

public class RuleEditorNode
extends AbstractNode {
    private static String COLOR_CODE_GRAY = "777777";
    private static String COLOR_CODE_RED = "ff7777";
    public static String NONE_PROPERTY_NAME = "<none>";
    private String filterText;
    private PropertySetsInfo propertySetsInfo;
    private RuleEditorPanel panel;
    private Map<PropertyDefinition, PropertyDeclaration> addedDeclarations = new HashMap<PropertyDefinition, PropertyDeclaration>();
    private Rule lastRule;
    private boolean readOnlyMode;
    private static String EMPTY_STRING = "";
    private Node.Property ADD_PROPERTY_FD = new AddPropertyFD();

    public RuleEditorNode(RuleEditorPanel panel) {
        super((Children)new RuleChildren());
        this.panel = panel;
    }

    public Model getModel() {
        return this.panel.getModel();
    }

    public boolean isReadOnlyMode() {
        return this.readOnlyMode;
    }

    public FileObject getFileObject() {
        return (FileObject)this.getModel().getLookup().lookup(FileObject.class);
    }

    public Rule getRule() {
        return this.panel.getRule();
    }

    public boolean isShowAllProperties() {
        return this.panel.getViewMode().isShowAllProperties();
    }

    public boolean isShowCategories() {
        return this.panel.getViewMode().isShowCategories();
    }

    public boolean isAddPropertyMode() {
        return this.panel.isAddPropertyMode();
    }

    void setFilterText(String prefix) {
        this.filterText = prefix;
        this.fireContextChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireContextChanged(boolean forceRefresh) {
        boolean oldReadOnlyModel = this.readOnlyMode;
        boolean bl = this.readOnlyMode = this.getModel() == null || !this.getModel().canApplyChanges();
        if (oldReadOnlyModel != this.readOnlyMode) {
            forceRefresh = true;
        }
        try {
            Node.PropertySet[] newSets;
            Node.PropertySet[] oldSets;
            PropertySetsInfo newInfo;
            block12: {
                PropertySetsInfo oldInfo = this.getCachedPropertySetsInfo();
                newInfo = this.createPropertySetsInfo();
                oldSets = oldInfo.getSets();
                newSets = newInfo.getSets();
                if (!forceRefresh && oldInfo.isCreatedDeclaration() == newInfo.isCreatedDeclaration() && oldSets.length == newSets.length) {
                    for (int i = 0; i < oldSets.length; ++i) {
                        Set newNames;
                        Object d2;
                        Node.PropertySet o = oldSets[i];
                        Node.PropertySet n = newSets[i];
                        Map om = ((PropertyCategoryPropertySet)o).declaration2PropertyMap;
                        Map nm = ((PropertyCategoryPropertySet)n).declaration2PropertyMap;
                        if (om.size() != nm.size()) break block12;
                        HashMap<String, Object> oName2DeclarationMap = new HashMap<String, Object>();
                        for (Object d2 : om.keySet()) {
                            if (this.lastRule.getModel() == d2.getModel()) {
                                oName2DeclarationMap.put(PropertyUtils.getDeclarationId(this.lastRule, (PropertyDeclaration)d2), d2);
                                continue;
                            }
                            break block12;
                        }
                        HashMap<String, PropertyDeclaration> nName2DeclarationMap = new HashMap<String, PropertyDeclaration>();
                        d2 = nm.keySet().iterator();
                        while (d2.hasNext()) {
                            PropertyDeclaration d3 = (PropertyDeclaration)d2.next();
                            nName2DeclarationMap.put(PropertyUtils.getDeclarationId(this.getRule(), d3), d3);
                        }
                        Set oldNames = oName2DeclarationMap.keySet();
                        HashSet comp = new HashSet(oldNames);
                        if (!comp.retainAll(newNames = nName2DeclarationMap.keySet())) {
                            for (Map.Entry entry : oName2DeclarationMap.entrySet()) {
                                String declarationName = (String)entry.getKey();
                                PropertyDeclaration oldD = (PropertyDeclaration)entry.getValue();
                                PropertyDeclaration newD = (PropertyDeclaration)nName2DeclarationMap.get(declarationName);
                                DeclarationProperty declarationProperty = (DeclarationProperty)((Object)om.get(oldD));
                                declarationProperty.updateDeclaration(newD);
                                om.remove(oldD);
                                om.put(newD, declarationProperty);
                            }
                            continue;
                        }
                        break block12;
                    }
                    return;
                }
            }
            this.propertySetsInfo = newInfo;
            this.firePropertySetsChange(oldSets, newSets);
        }
        finally {
            this.lastRule = this.getRule();
        }
    }

    void fireDeclarationInfoChanged(PropertyDeclaration declaration, DeclarationInfo declarationInfo) {
        DeclarationProperty dp = this.getDeclarationProperty(declaration);
        if (dp != null) {
            dp.setDeclarationInfo(declarationInfo);
        }
    }

    DeclarationProperty getDeclarationProperty(PropertyDeclaration declaration) {
        for (PropertyCategoryPropertySet set : this.getCachedPropertySetsInfo().getSets()) {
            DeclarationProperty declarationProperty = set.getDeclarationProperty(declaration);
            if (declarationProperty == null) continue;
            return declarationProperty;
        }
        return null;
    }

    public synchronized Node.PropertySet[] getPropertySets() {
        this.lastRule = this.getRule();
        return this.getCachedPropertySetsInfo().getSets();
    }

    private synchronized PropertySetsInfo getCachedPropertySetsInfo() {
        if (this.propertySetsInfo == null) {
            this.propertySetsInfo = this.createPropertySetsInfo();
        }
        return this.propertySetsInfo;
    }

    private boolean matchesFilterText(String text) {
        if (this.filterText == null) {
            return true;
        }
        return text.contains(this.filterText);
    }

    private Collection<PropertyDefinition> filterByPrefix(Collection<PropertyDefinition> defs) {
        ArrayList<PropertyDefinition> filtered = new ArrayList<PropertyDefinition>();
        for (PropertyDefinition pd : defs) {
            if (!this.matchesFilterText(pd.getName())) continue;
            filtered.add(pd);
        }
        return filtered;
    }

    private PropertySetsInfo createPropertySetsInfo() {
        if (this.getModel() == null || this.getRule() == null) {
            return new PropertySetsInfo(new PropertyCategoryPropertySet[]{}, this.panel.getCreatedDeclaration() != null);
        }
        ArrayList<PropertyCategoryPropertySet> sets = new ArrayList<PropertyCategoryPropertySet>();
        List<PropertyDeclaration> declarations = PropertyUtils.getPropertyDeclarations(this.getRule());
        FileObject file = this.getFileObject();
        if (this.isShowCategories()) {
            HashMap<PropertyDefinition, PropertyDeclaration> created = new HashMap<PropertyDefinition, PropertyDeclaration>();
            EnumMap<PropertyCategory, LinkedList<PropertyDeclaration>> categoryToDeclarationsMap = new EnumMap<PropertyCategory, LinkedList<PropertyDeclaration>>(PropertyCategory.class);
            for (PropertyDeclaration propertyDeclaration : declarations) {
                PropertyCategory category;
                LinkedList<PropertyDeclaration> values;
                if (this.addedDeclarations.containsValue(propertyDeclaration)) continue;
                Property property = propertyDeclaration.getProperty();
                PropertyValue propertyValue = propertyDeclaration.getPropertyValue();
                if (property == null || propertyValue == null || !this.matchesFilterText(property.getContent().toString())) continue;
                PropertyDefinition def = Properties.getPropertyDefinition((String)property.getContent().toString());
                String declarationId = PropertyUtils.getDeclarationId(this.getRule(), propertyDeclaration);
                if (this.panel.getCreatedDeclarationsIdsList().contains(declarationId)) {
                    created.put(def, propertyDeclaration);
                }
                if ((values = (LinkedList<PropertyDeclaration>)categoryToDeclarationsMap.get(category = def != null ? def.getPropertyCategory() : PropertyCategory.UNKNOWN)) == null) {
                    values = new LinkedList<PropertyDeclaration>();
                    categoryToDeclarationsMap.put(category, values);
                }
                values.add(propertyDeclaration);
            }
            EnumMap<PropertyCategory, PropertyCategoryPropertySet> propertySetsMap = new EnumMap<PropertyCategory, PropertyCategoryPropertySet>(PropertyCategory.class);
            for (Map.Entry entry : categoryToDeclarationsMap.entrySet()) {
                List categoryDeclarations = (List)entry.getValue();
                if (this.isShowAllProperties()) {
                    categoryDeclarations.removeAll(created.values());
                }
                categoryDeclarations.sort(PropertyUtils.getDeclarationsComparator());
                PropertyCategoryPropertySet propertyCategoryPropertySet = new PropertyCategoryPropertySet((PropertyCategory)entry.getKey());
                propertyCategoryPropertySet.addAll(categoryDeclarations);
                propertySetsMap.put((PropertyCategory)entry.getKey(), propertyCategoryPropertySet);
                sets.add(propertyCategoryPropertySet);
            }
            if (this.isShowAllProperties()) {
                for (PropertyCategory cat : PropertyCategory.values()) {
                    LinkedList<PropertyDefinition> allInCat = new LinkedList<PropertyDefinition>(this.filterByPrefix(this.getCategoryProperties(cat)));
                    if (allInCat.isEmpty()) continue;
                    allInCat.sort(PropertyUtils.getPropertyDefinitionsComparator());
                    PropertyCategoryPropertySet propertySet = (PropertyCategoryPropertySet)((Object)propertySetsMap.get(cat));
                    if (propertySet == null) {
                        propertySet = new PropertyCategoryPropertySet(cat);
                        sets.add(propertySet);
                    }
                    for (PropertyDeclaration d : propertySet.getDeclarations()) {
                        PropertyDefinition def = Properties.getPropertyDefinition((String)d.getProperty().getContent().toString());
                        allInCat.remove(def);
                    }
                    for (PropertyDefinition pd : allInCat) {
                        PropertyDeclaration alreadyAdded = this.addedDeclarations.get(pd);
                        if (alreadyAdded == null) {
                            alreadyAdded = (PropertyDeclaration)created.get(pd);
                        }
                        if (alreadyAdded != null) {
                            propertySet.add(alreadyAdded, true);
                            continue;
                        }
                        propertySet.add(file, pd);
                    }
                }
            }
        } else {
            PropertyCategoryPropertySet set = new PropertyCategoryPropertySet(PropertyCategory.DEFAULT);
            if (!this.isShowAllProperties()) {
                ArrayList<PropertyDeclaration> filtered = new ArrayList<PropertyDeclaration>();
                for (PropertyDeclaration propertyDeclaration : declarations) {
                    if (this.addedDeclarations.containsValue(propertyDeclaration)) continue;
                    String string = PropertyUtils.getDeclarationId(this.getRule(), propertyDeclaration);
                    if (this.panel.getCreatedDeclarationsIdsList().contains(string)) {
                        filtered.add(propertyDeclaration);
                        continue;
                    }
                    Property property = propertyDeclaration.getProperty();
                    PropertyValue propertyValue = propertyDeclaration.getPropertyValue();
                    if (property == null || propertyValue == null || !this.matchesFilterText(property.getContent().toString())) continue;
                    filtered.add(propertyDeclaration);
                }
                Comparator<PropertyDeclaration> comparator = PropertyUtils.createDeclarationsComparator(this.getRule(), this.panel.getCreatedDeclarationsIdsList());
                filtered.sort(comparator);
                set.addAll(filtered);
                if (!this.readOnlyMode && this.panel.getCreatedDeclaration() == null) {
                    set.add_Add_Property_FeatureDescriptor();
                }
            } else {
                ArrayList<PropertyDeclaration> filteredExisting = new ArrayList<PropertyDeclaration>();
                HashMap<PropertyDefinition, PropertyDeclaration> filteredCreated = new HashMap<PropertyDefinition, PropertyDeclaration>();
                for (PropertyDeclaration propertyDeclaration : declarations) {
                    if (this.addedDeclarations.containsValue(propertyDeclaration)) continue;
                    String declarationId = PropertyUtils.getDeclarationId(this.getRule(), propertyDeclaration);
                    if (this.panel.getCreatedDeclarationsIdsList().contains(declarationId)) {
                        filteredCreated.put(propertyDeclaration.getResolvedProperty().getPropertyDefinition(), propertyDeclaration);
                        continue;
                    }
                    Property property = propertyDeclaration.getProperty();
                    PropertyValue propertyValue = propertyDeclaration.getPropertyValue();
                    if (property == null || propertyValue == null || !this.matchesFilterText(property.getContent().toString())) continue;
                    filteredExisting.add(propertyDeclaration);
                }
                set.addAll(filteredExisting);
                ArrayList<PropertyDefinition> arrayList = new ArrayList<PropertyDefinition>(this.filterByPrefix(Properties.getPropertyDefinitions((FileObject)file, (boolean)true)));
                arrayList.sort(PropertyUtils.getPropertyDefinitionsComparator());
                for (PropertyDeclaration d : set.getDeclarations()) {
                    PropertyDefinition def = Properties.getPropertyDefinition((String)d.getProperty().getContent().toString());
                    arrayList.remove(def);
                }
                for (PropertyDefinition pd : arrayList) {
                    PropertyDeclaration alreadyAdded = this.addedDeclarations.get(pd);
                    if (alreadyAdded == null) {
                        alreadyAdded = (PropertyDeclaration)filteredCreated.get(pd);
                    }
                    if (alreadyAdded != null) {
                        set.add(alreadyAdded, true);
                        continue;
                    }
                    set.add(file, pd);
                }
            }
            set.setDisplayName(Bundle.rule_global_set_displayname());
            set.setShortDescription(Bundle.rule_global_set_tooltip());
            sets.add(set);
        }
        return new PropertySetsInfo(sets.toArray(new PropertyCategoryPropertySet[0]), this.panel.getCreatedDeclaration() != null);
    }

    public List<PropertyDefinition> getCategoryProperties(PropertyCategory cat) {
        Collection defs = Properties.getPropertyDefinitions((FileObject)((FileObject)this.getModel().getLookup().lookup(FileObject.class)), (boolean)true);
        ArrayList<PropertyDefinition> defsInCat = new ArrayList<PropertyDefinition>();
        for (PropertyDefinition d : defs) {
            if (d.getPropertyCategory() != cat) continue;
            defsInCat.add(d);
        }
        return defsInCat;
    }

    private String getPropertyDisplayName(PropertyDeclaration declaration) {
        return declaration.getProperty().getContent().toString();
    }

    public void applyModelChanges() {
        final Model model = this.getModel();
        model.runReadTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                try {
                    model.applyChanges();
                }
                catch (IOException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
    }

    private Node.Property createPropertyDefinitionProperty(FileObject context, PropertyDefinition definition) {
        PropertyDefinition pmodel = Properties.getPropertyDefinition((String)definition.getName());
        return new PropertyDefinitionProperty(definition, this.createPropertyValueEditor(context, pmodel, null, false));
    }

    private PropertyValuesEditor createPropertyValueEditor(FileObject context, PropertyDefinition pmodel, PropertyDeclaration declaration, boolean addNoneProperty) {
        final ArrayList<UnitGrammarElement> unitElements = new ArrayList<UnitGrammarElement>();
        final ArrayList<FixedTextGrammarElement> fixedElements = new ArrayList<FixedTextGrammarElement>();
        if (pmodel != null) {
            GroupGrammarElement rootElement = pmodel.getGrammarElement(context);
            rootElement.accept(new GrammarElementVisitor(){
                private Set<GroupGrammarElement> seen = Collections.newSetFromMap(new IdentityHashMap());

                public boolean visit(UnitGrammarElement element) {
                    unitElements.add(element);
                    return true;
                }

                public boolean visit(FixedTextGrammarElement element) {
                    fixedElements.add(element);
                    return true;
                }

                public boolean visit(GroupGrammarElement element) {
                    if (this.seen.contains(element)) {
                        return false;
                    }
                    this.seen.add(element);
                    return true;
                }
            });
        }
        return new PropertyValuesEditor(this.panel, pmodel, this.getModel(), fixedElements, unitElements, declaration, addNoneProperty);
    }

    private DeclarationProperty createDeclarationProperty(PropertyDeclaration declaration, boolean markAsModified) {
        ResolvedProperty resolvedProperty = declaration.getResolvedProperty();
        PropertyDefinition propertyDefinition = resolvedProperty != null ? resolvedProperty.getPropertyDefinition() : null;
        return new DeclarationProperty(declaration, PropertyUtils.getDeclarationId(this.getRule(), declaration), this.getPropertyDisplayName(declaration), markAsModified, this.createPropertyValueEditor(this.getFileObject(), propertyDefinition, declaration, true));
    }

    private Node.Property create_Add_Property_Feature_Descriptor() {
        return new AddPropertyFD();
    }

    public class DeclarationProperty
    extends PropertySupport {
        private final String propertyName;
        private final PropertyEditor editor;
        private final boolean markAsModified;
        private PropertyDeclaration propertyDeclaration;
        private DeclarationInfo info;
        private String shortDescription;
        private String valueSet;
        private String locationPrefix;
        private RequestProcessor.Task SAVE_CHANGE_TASK;

        public DeclarationProperty(PropertyDeclaration declaration, String propertyName, String propertyDisplayName, boolean markAsModified, PropertyEditor editor) {
            super(propertyName, String.class, propertyDisplayName, null, true, !RuleEditorNode.this.readOnlyMode && RuleEditorNode.this.getRule().isValid());
            this.SAVE_CHANGE_TASK = RuleEditorPanel.RP.create(new Runnable(){

                @Override
                public void run() {
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            if (DeclarationProperty.this.valueSet == null) {
                                return;
                            }
                            Model model = RuleEditorNode.this.getModel();
                            model.runWriteTask(new Model.ModelTask(){

                                public void run(StyleSheet styleSheet) {
                                    if (NONE_PROPERTY_NAME.equals(DeclarationProperty.this.valueSet)) {
                                        Declaration declaration = (Declaration)DeclarationProperty.this.propertyDeclaration.getParent();
                                        Declarations declarations = (Declarations)declaration.getParent();
                                        declaration.removeElement((Element)DeclarationProperty.this.propertyDeclaration);
                                        declarations.removeDeclaration(declaration);
                                    } else {
                                        RuleEditorPanel.LOG.log(Level.FINE, "updating property to {0}", DeclarationProperty.this.valueSet);
                                        DeclarationProperty.this.propertyDeclaration.getPropertyValue().getExpression().setContent((CharSequence)DeclarationProperty.this.valueSet);
                                    }
                                }
                            });
                            if (!RuleEditorNode.this.isAddPropertyMode()) {
                                RuleEditorNode.this.applyModelChanges();
                            }
                            DeclarationProperty.this.valueSet = null;
                        }
                    });
                }
            });
            this.propertyName = propertyName;
            this.propertyDeclaration = declaration;
            this.markAsModified = markAsModified;
            this.editor = editor;
            this.checkForErrors();
        }

        public PropertyDeclaration getDeclaration() {
            return this.propertyDeclaration;
        }

        private void checkForErrors() {
            if (this.getDeclaration().equals(RuleEditorNode.this.panel.getCreatedDeclaration())) {
                return;
            }
            String property = this.propertyDeclaration.getProperty().getContent().toString().trim();
            PropertyDefinition model = Properties.getPropertyDefinition((String)property);
            if (model == null) {
                this.info = DeclarationInfo.ERRONEOUS;
                this.shortDescription = Bundle.property_unknown(this.getLocationPrefix());
                return;
            }
            if (Properties.isVendorSpecificProperty((PropertyDefinition)model)) {
                this.shortDescription = Bundle.property_description(this.getLocationPrefix());
                return;
            }
            PropertyValue value = this.propertyDeclaration.getPropertyValue();
            if (value != null) {
                Expression expression = value.getExpression();
                CharSequence content = expression != null ? expression.getContent() : "";
                ResolvedProperty rp = new ResolvedProperty(RuleEditorNode.this.getFileObject(), model, content);
                if (!rp.isResolved()) {
                    List unresolvedTokens = rp.getUnresolvedTokens();
                    if (unresolvedTokens.isEmpty()) {
                        this.info = DeclarationInfo.ERRONEOUS;
                        this.shortDescription = Bundle.property_value_not_resolved(this.getLocationPrefix());
                        return;
                    }
                    Token unexpectedToken = (Token)unresolvedTokens.iterator().next();
                    String unexpectedText = unexpectedToken.image().toString();
                    if (!org.netbeans.modules.css.editor.module.spi.Utilities.isVendorSpecificPropertyValueToken((FileObject)RuleEditorNode.this.getFileObject(), (CharSequence)unexpectedText)) {
                        this.shortDescription = Bundle.property_value_unexpected_token(this.getLocationPrefix(), unexpectedText);
                        return;
                    }
                }
            }
            this.shortDescription = Bundle.property_description(this.getLocationPrefix());
        }

        private CharSequence getLocationPrefix() {
            if (this.locationPrefix == null) {
                int doc_from;
                PropertyDeclaration decl;
                int ast_from;
                final StringBuilder sb = new StringBuilder();
                sb.append(Bundle.property_set_at_prefix());
                Model model = RuleEditorNode.this.getModel();
                Lookup lookup = model.getLookup();
                FileObject file = (FileObject)lookup.lookup(FileObject.class);
                if (file == null) {
                    sb.append(Bundle.property_no_file());
                } else {
                    sb.append(file.getNameExt());
                }
                Snapshot snap = (Snapshot)lookup.lookup(Snapshot.class);
                final Document doc = (Document)lookup.lookup(Document.class);
                if (snap != null && doc != null && (ast_from = (decl = this.getDeclaration()).getStartOffset()) != -1 && (doc_from = snap.getOriginalOffset(ast_from)) != -1) {
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int lineOffset = 1 + Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)doc_from);
                                sb.append(':');
                                sb.append(lineOffset);
                            }
                            catch (BadLocationException badLocationException) {
                                // empty catch block
                            }
                        }
                    });
                }
                this.locationPrefix = sb.toString();
            }
            return this.locationPrefix;
        }

        private void updateDeclaration(PropertyDeclaration declaration) {
            assert (PropertyUtils.getDeclarationId(RuleEditorNode.this.getRule(), declaration).equals(this.propertyName));
            String oldValue = this.getValue();
            this.propertyDeclaration = declaration;
            String newValue = this.getValue();
            this.locationPrefix = null;
            DeclarationInfo oldInfo = this.info;
            this.info = null;
            String oldShortDescription = this.shortDescription;
            this.checkForErrors();
            if (!this.shortDescription.equals(oldShortDescription)) {
                RuleEditorNode.this.fireShortDescriptionChange(oldShortDescription, this.shortDescription);
            }
            if (this.info != oldInfo) {
                this.setDeclarationInfo(this.info);
            } else {
                this.setDisplayName(this.getHtmlDisplayName());
                RuleEditorNode.this.firePropertyChange(this.propertyName, oldValue, newValue);
            }
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public PropertyEditor getPropertyEditor() {
            return this.editor;
        }

        public void setDeclarationInfo(DeclarationInfo info) {
            if (this.info == info) {
                return;
            }
            this.info = info;
            this.setDisplayName(this.getHtmlDisplayName());
            String oldShortDescription = this.shortDescription;
            switch (info) {
                case ERRONEOUS: {
                    this.shortDescription = Bundle.property_erroneous(this.getLocationPrefix());
                    break;
                }
                case INACTIVE: {
                    this.shortDescription = Bundle.property_inactive(this.getLocationPrefix());
                    break;
                }
                case OVERRIDDEN: {
                    this.shortDescription = Bundle.property_overridden(this.getLocationPrefix());
                }
            }
            RuleEditorNode.this.fireShortDescriptionChange(oldShortDescription, this.shortDescription);
            RuleEditorNode.this.firePropertyChange(this.propertyName, null, this.getValue());
        }

        private boolean isOverridden() {
            return this.info != null && this.info == DeclarationInfo.OVERRIDDEN;
        }

        private boolean isInactive() {
            return this.info != null && this.info == DeclarationInfo.INACTIVE;
        }

        private boolean isErroneous() {
            return this.info != null && this.info == DeclarationInfo.ERRONEOUS;
        }

        public String getHtmlDisplayName() {
            StringBuilder b = new StringBuilder();
            String color = null;
            boolean bold = false;
            boolean strike = false;
            if (RuleEditorNode.this.isShowAllProperties()) {
                if (RuleEditorNode.this.isAddPropertyMode() && !this.markAsModified) {
                    color = COLOR_CODE_GRAY;
                } else {
                    bold = true;
                }
            }
            if (this.isOverridden()) {
                strike = true;
            }
            if (this.isInactive()) {
                color = COLOR_CODE_GRAY;
                strike = true;
            }
            if (this.isErroneous()) {
                strike = true;
                color = COLOR_CODE_RED;
            }
            if (bold) {
                b.append("<b>");
            }
            if (strike) {
                b.append("<s>");
            }
            if (color != null) {
                b.append("<font color=");
                b.append(color);
                b.append(">");
            }
            b.append(RuleEditorNode.this.getPropertyDisplayName(this.propertyDeclaration));
            if (color != null) {
                b.append("</font>");
            }
            if (strike) {
                b.append("</s>");
            }
            if (bold) {
                b.append("</b>");
            }
            return b.toString();
        }

        public String getValue() {
            if (this.valueSet != null) {
                return this.valueSet;
            }
            PropertyValue val = this.propertyDeclaration.getPropertyValue();
            return val == null ? null : val.getExpression().getContent().toString().trim();
        }

        public void setValue(Object o) {
            assert (SwingUtilities.isEventDispatchThread());
            String asString = (String)o;
            if (asString == null || asString.isEmpty()) {
                return;
            }
            String currentValue = this.getValue();
            if (asString.equals(currentValue)) {
                return;
            }
            this.valueSet = asString;
            this.SAVE_CHANGE_TASK.schedule(200);
        }
    }

    private static class RuleChildren
    extends Children.Keys {
        private RuleChildren() {
        }

        protected Node[] createNodes(Object key) {
            return new Node[0];
        }
    }

    private class AddPropertyFD
    extends Node.Property<String> {
        private String valueSet;

        public AddPropertyFD() {
            super(String.class);
            this.setName(AddPropertyFD.class.getSimpleName());
            this.setDisplayName(Bundle.AddProperty_displayName());
            this.setShortDescription(Bundle.AddProperty_shortDescription());
        }

        public PropertyEditor getPropertyEditor() {
            return new AddPropertyPropertyEditor(this);
        }

        public boolean canRead() {
            return true;
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return "";
        }

        public boolean canWrite() {
            return false;
        }

        public void setValue(final String propertyName) {
            if (propertyName == null) {
                return;
            }
            if (propertyName.trim().isEmpty()) {
                return;
            }
            if (this.valueSet != null) {
                RuleEditorPanel.LOG.log(Level.WARNING, "Trying to set property value more than once!, relaxing...");
                return;
            }
            this.valueSet = propertyName;
            final Model model = RuleEditorNode.this.getModel();
            final Rule rule = RuleEditorNode.this.getRule();
            model.runWriteTask(new Model.ModelTask(){

                public void run(StyleSheet styleSheet) {
                    ModelUtils utils = new ModelUtils(model);
                    Declarations decls = rule.getDeclarations();
                    if (decls == null) {
                        decls = model.getElementFactory().createDeclarations();
                        rule.setDeclarations(decls);
                    }
                    PropertyDeclaration pdeclarationElement = utils.createPropertyDeclaration(propertyName + ":");
                    Declaration declarationElement = model.getElementFactory().createDeclaration();
                    declarationElement.setPropertyDeclaration(pdeclarationElement);
                    decls.addDeclaration(declarationElement);
                    RuleEditorNode.this.panel.setCreatedDeclaration(rule, pdeclarationElement);
                }
            });
        }
    }

    private static class PropertySetsInfo {
        private final PropertyCategoryPropertySet[] sets;
        private final boolean createdDeclaration;

        public PropertySetsInfo(PropertyCategoryPropertySet[] sets, boolean createdDeclaration) {
            this.sets = sets;
            this.createdDeclaration = createdDeclaration;
        }

        public PropertyCategoryPropertySet[] getSets() {
            return this.sets;
        }

        public boolean isCreatedDeclaration() {
            return this.createdDeclaration;
        }
    }

    class PropertyCategoryPropertySet
    extends Node.PropertySet {
        private List<Node.Property> properties;
        private Map<PropertyDeclaration, DeclarationProperty> declaration2PropertyMap;

        public PropertyCategoryPropertySet(PropertyCategory propertyCategory) {
            super(propertyCategory.name(), propertyCategory.getDisplayName(), propertyCategory.getShortDescription());
            this.properties = new ArrayList<Node.Property>();
            this.declaration2PropertyMap = new HashMap<PropertyDeclaration, DeclarationProperty>();
        }

        public void add_Add_Property_FeatureDescriptor() {
            this.properties.add(RuleEditorNode.this.create_Add_Property_Feature_Descriptor());
        }

        public void add(PropertyDeclaration declaration, boolean markAsModified) {
            DeclarationProperty property = RuleEditorNode.this.createDeclarationProperty(declaration, markAsModified);
            this.declaration2PropertyMap.put(declaration, property);
            this.properties.add((Node.Property)property);
        }

        public void addAll(Collection<PropertyDeclaration> declarations) {
            for (PropertyDeclaration d : declarations) {
                this.add(d, false);
            }
        }

        public Collection<PropertyDeclaration> getDeclarations() {
            return this.declaration2PropertyMap.keySet();
        }

        public DeclarationProperty getDeclarationProperty(PropertyDeclaration declaration) {
            return this.declaration2PropertyMap.get(declaration);
        }

        public void add(FileObject context, PropertyDefinition propertyDefinition) {
            this.properties.add(RuleEditorNode.this.createPropertyDefinitionProperty(context, propertyDefinition));
        }

        public Node.Property<String>[] getProperties() {
            return this.properties.toArray(new Node.Property[0]);
        }
    }

    private class PropertyDefinitionProperty
    extends PlainPDP {
        public PropertyDefinitionProperty(PropertyDefinition def, PropertyEditor editor) {
            super(def, editor, Bundle.rule_properties_add_declaration_tooltip());
        }
    }

    private class AddPropertyCellEditorComponent
    extends DefaultCellEditor {
        private AutocompleteJComboBox editor;
        private AddPropertyFD property;
        private boolean cancelled;

        public AddPropertyCellEditorComponent(AutocompleteJComboBox jcb, AddPropertyFD addFDProperty) {
            super(jcb);
            this.property = addFDProperty;
            this.editor = jcb;
            this.editor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (!AddPropertyCellEditorComponent.this.cancelled) {
                        AddPropertyCellEditorComponent.this.property.setValue((String)AddPropertyCellEditorComponent.this.editor.getSelectedItem());
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jtable, Object o, boolean bln, int i, int i1) {
            this.editor.setSelectedIndex(-1);
            return this.editor;
        }

        @Override
        protected void fireEditingCanceled() {
            this.cancelled = true;
            super.fireEditingCanceled();
        }
    }

    private class AddPropertyCellRendererComponent
    implements TableCellRenderer {
        private AddPropertyCellRendererComponent() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jtable, Object o, boolean bln, boolean bln1, int i, int i1) {
            return new JLabel(Bundle.AddProperty_displayName_html());
        }
    }

    private class AddPropertyPropertyEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private AddPropertyFD property;

        public AddPropertyPropertyEditor(AddPropertyFD property) {
            this.property = property;
        }

        public void attachEnv(PropertyEnv env) {
            env.getFeatureDescriptor().setValue("custom.cell.renderer", new AddPropertyCellRendererComponent());
            env.getFeatureDescriptor().setValue("custom.cell.editor", new AddPropertyCellEditorComponent(new AutocompleteJComboBox(RuleEditorNode.this.getFileObject()), this.property));
        }
    }

    private class PlainPDP
    extends AbstractPDP<String> {
        public PlainPDP(PropertyDefinition def, PropertyEditor editor, String shortDescription) {
            super(def, editor, String.class, shortDescription);
        }

        @Override
        protected String convertToString(String val) {
            return val;
        }

        @Override
        protected String getEmptyValue() {
            return EMPTY_STRING;
        }
    }

    private abstract class AbstractPDP<T>
    extends PropertySupport<T> {
        private PropertyDefinition def;
        private PropertyEditor editor;

        public AbstractPDP(PropertyDefinition def, PropertyEditor editor, String name, Class<T> type, String displayName, String shortDescription, boolean canR, boolean canW) {
            super(name, type, displayName, shortDescription, canR, canW);
            this.def = def;
            this.editor = editor;
        }

        public AbstractPDP(PropertyDefinition def, PropertyEditor editor, Class<T> clazz, String shortDescription) {
            super(def.getName(), clazz, def.getName(), shortDescription, true, RuleEditorNode.this.getRule().isValid() && !RuleEditorNode.this.readOnlyMode);
            this.def = def;
            this.editor = editor;
        }

        public PropertyEditor getPropertyEditor() {
            return this.editor;
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getEmptyValue();
        }

        public void setValue(T val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.getEmptyValue().equals(val)) {
                return;
            }
            ElementFactory factory = RuleEditorNode.this.getModel().getElementFactory();
            Rule rule = RuleEditorNode.this.getRule();
            Declarations declarations = rule.getDeclarations();
            if (declarations == null) {
                declarations = factory.createDeclarations();
                rule.setDeclarations(declarations);
            }
            Property property = factory.createProperty((CharSequence)this.def.getName());
            Expression expr = factory.createExpression((CharSequence)this.convertToString(val));
            PropertyValue value = factory.createPropertyValue(expr);
            PropertyDeclaration newPropertyDeclaration = factory.createPropertyDeclaration(property, value, false);
            Declaration newDeclaration = factory.createDeclaration();
            newDeclaration.setPropertyDeclaration(newPropertyDeclaration);
            declarations.addDeclaration(newDeclaration);
            if (!RuleEditorNode.this.isAddPropertyMode()) {
                RuleEditorNode.this.panel.setCreatedDeclaration(rule, newPropertyDeclaration);
                RuleEditorNode.this.applyModelChanges();
            } else {
                RuleEditorNode.this.addedDeclarations.put(this.def, newPropertyDeclaration);
                RuleEditorNode.this.fireContextChanged(true);
            }
        }

        protected abstract String convertToString(T var1);

        protected abstract T getEmptyValue();
    }
}

