/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.breakpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cpplite.debugger.CPPLiteDebugger;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class CPPLiteBreakpoint
extends Breakpoint {
    public static final String PROP_CONDITION = "condition";
    private volatile boolean enabled = true;
    private final Map<CPPLiteDebugger, String> ids = new HashMap<CPPLiteDebugger, String>();
    private final Line line;
    private volatile String condition;

    public CPPLiteBreakpoint(Line line) {
        this.line = line;
    }

    public Line getLine() {
        return this.line;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String condition) {
        String oldCondition;
        CPPLiteBreakpoint cPPLiteBreakpoint = this;
        synchronized (cPPLiteBreakpoint) {
            oldCondition = this.condition;
            if (Objects.equals(oldCondition, condition)) {
                return;
            }
            this.condition = condition;
        }
        this.firePropertyChange(PROP_CONDITION, oldCondition, condition);
    }

    public void setCPPValidity(Breakpoint.VALIDITY validity, String reason) {
        this.setValidity(validity, reason);
    }

    public Breakpoint.GroupProperties getGroupProperties() {
        return new CPPGroupProperties();
    }

    private final class CPPGroupProperties
    extends Breakpoint.GroupProperties {
        private CPPEngineListener engineListener;

        private CPPGroupProperties() {
        }

        public String getLanguage() {
            return "C/C++";
        }

        public String getType() {
            return NbBundle.getMessage(CPPLiteBreakpoint.class, (String)"LineBrkp_Type");
        }

        private FileObject getFile() {
            return (FileObject)CPPLiteBreakpoint.this.line.getLookup().lookup(FileObject.class);
        }

        public FileObject[] getFiles() {
            FileObject fo = this.getFile();
            if (fo != null) {
                return new FileObject[]{fo};
            }
            return null;
        }

        public Project[] getProjects() {
            FileObject f = this.getFile();
            while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
            }
            if (f != null) {
                try {
                    return new Project[]{ProjectManager.getDefault().findProject(f)};
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        public DebuggerEngine[] getEngines() {
            DebuggerEngine[] engines;
            if (this.engineListener == null) {
                this.engineListener = new CPPEngineListener();
                DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this.engineListener), (Object)DebuggerManager.getDebuggerManager()));
            }
            if ((engines = DebuggerManager.getDebuggerManager().getDebuggerEngines()).length == 0) {
                return null;
            }
            if (engines.length == 1) {
                if (this.isCPPEngine(engines[0])) {
                    return engines;
                }
                return null;
            }
            ArrayList<DebuggerEngine> antEngines = null;
            for (DebuggerEngine e : engines) {
                if (!this.isCPPEngine(e)) continue;
                if (antEngines == null) {
                    antEngines = new ArrayList<DebuggerEngine>();
                }
                antEngines.add(e);
            }
            if (antEngines == null) {
                return null;
            }
            return antEngines.toArray(new DebuggerEngine[antEngines.size()]);
        }

        private boolean isCPPEngine(DebuggerEngine e) {
            return e.lookupFirst(null, CPPLiteDebugger.class) != null;
        }

        public boolean isHidden() {
            return false;
        }

        private final class CPPEngineListener
        extends DebuggerManagerAdapter {
            private CPPEngineListener() {
            }

            public void engineAdded(DebuggerEngine engine) {
                if (CPPGroupProperties.this.isCPPEngine(engine)) {
                    CPPLiteBreakpoint.this.firePropertyChange("groupProperties", null, (Object)CPPGroupProperties.this);
                }
            }

            public void engineRemoved(DebuggerEngine engine) {
                if (CPPGroupProperties.this.isCPPEngine(engine)) {
                    CPPLiteBreakpoint.this.firePropertyChange("groupProperties", null, (Object)CPPGroupProperties.this);
                }
            }
        }
    }
}

