/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.vcs;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.vcs.HookImpl;
import org.netbeans.modules.bugtracking.vcs.VCSHooksConfig;
import org.netbeans.modules.versioning.hooks.GitHook;
import org.netbeans.modules.versioning.hooks.GitHookContext;
import org.openide.util.NbBundle;

public class GitHookImpl
extends GitHook {
    private static final String[] SUPPORTED_ISSUE_INFO_VARIABLES = new String[]{"id", "summary"};
    private static final String[] SUPPORTED_REVISION_VARIABLES = new String[]{"changeset", "author", "date", "message"};
    private final String name = NbBundle.getMessage(GitHookImpl.class, (String)"LBL_VCSHook");
    private HookImpl delegate;

    public GitHookImpl() {
        VCSHooksConfig config = VCSHooksConfig.getInstance(VCSHooksConfig.HookType.GIT);
        this.delegate = new HookImpl(config, SUPPORTED_ISSUE_INFO_VARIABLES, SUPPORTED_REVISION_VARIABLES);
    }

    public GitHookContext beforeCommit(GitHookContext context) throws IOException {
        String msg = this.delegate.beforeCommit(context.getFiles(), context.getMessage());
        return msg != null ? new GitHookContext(context.getFiles(), msg, context.getLogEntries()) : null;
    }

    public void afterCommit(GitHookContext context) {
        String author = context.getLogEntries()[0].getAuthor();
        String changeset = context.getLogEntries()[0].getChangeset();
        Date date = context.getLogEntries()[0].getDate();
        String message = context.getMessage();
        this.delegate.afterCommit(context.getFiles(), author, changeset, date, message, "GIT", true);
    }

    public GitHookContext beforePush(GitHookContext context) throws IOException {
        return super.beforePush(context);
    }

    public void afterPush(GitHookContext context) {
        GitHookContext.LogEntry[] logEntries = context.getLogEntries();
        String[] changesets = new String[logEntries.length];
        for (int i = 0; i < logEntries.length; ++i) {
            GitHookContext.LogEntry logEntry = logEntries[i];
            changesets[i] = logEntry.getChangeset();
        }
        this.delegate.afterPush(context.getFiles(), changesets, "GIT");
    }

    public JPanel createComponent(GitHookContext context) {
        return this.delegate.createComponent(context.getFiles());
    }

    public String getDisplayName() {
        return this.name;
    }

    public void afterCommitReplace(GitHookContext originalContext, GitHookContext newContext, Map<String, String> mapping) {
        this.delegate.afterChangesetReplace(newContext.getFiles(), mapping, "GIT");
    }
}

