/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.webkit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

final class UnJarResources {
    UnJarResources() {
    }

    static URL extract(URL url) throws IOException {
        if (!"jar".equals(url.getProtocol())) {
            return url;
        }
        JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
        JarFile jar = jarConnection.getJarFile();
        if (jar == null) {
            return url;
        }
        File dir = File.createTempFile(jar.getName(), ".dir");
        dir.delete();
        dir.mkdirs();
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            String entryName = entry.getName();
            if (entryName.endsWith(".class") || entryName.endsWith("/")) continue;
            File file = new File(dir, entryName.replace('/', File.separatorChar));
            file.getParentFile().mkdirs();
            InputStream is = jar.getInputStream(entry);
            Throwable throwable = null;
            try {
                Files.copy(is, file.toPath(), new CopyOption[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        File file = new File(dir, jarConnection.getEntryName().replace('/', File.separatorChar));
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return url;
    }
}

