/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import net.java.html.BrwsrCtx;
import net.java.html.json.Models;
import net.java.html.json.tests.JSONik;
import net.java.html.json.tests.NameAndValue;
import net.java.html.json.tests.People;
import net.java.html.json.tests.Person;
import net.java.html.json.tests.PhaseExecutor;
import net.java.html.json.tests.Sex;
import net.java.html.json.tests.Utils;
import org.netbeans.html.json.tck.KOTest;

public final class JSONTest {
    private final PhaseExecutor[] phases = new PhaseExecutor[]{null};
    private static BrwsrCtx onCallback;

    static void assignFetched(JSONik m, Person p) {
        m.setFetched(p);
    }

    @KOTest
    public void toJSONInABrowser() throws Throwable {
        Object json;
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)JSONTest.newContext());
        p.setSex(Sex.MALE);
        p.setFirstName("J\u00e1ra");
        p.setLastName("Tulach\u016f");
        try {
            json = JSONTest.parseJSON(p.toString());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't parse " + p).initCause(ex);
        }
        Person p2 = (Person)Models.fromRaw((BrwsrCtx)JSONTest.newContext(), Person.class, (Object)json);
        Utils.assertEquals(p2.getFirstName(), p.getFirstName(), "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName());
    }

    @KOTest
    public void fromJsonWithUTF8() throws Throwable {
        BrwsrCtx c = JSONTest.newContext();
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)c);
        p.setSex(Sex.MALE);
        p.setFirstName("J\u00e1ra");
        p.setLastName("Tulach\u016f");
        byte[] arr = p.toString().getBytes("UTF-8");
        Person p2 = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)new ByteArrayInputStream(arr));
        Utils.assertEquals(p2.getFirstName(), p.getFirstName(), "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName());
    }

    @KOTest
    public void fromJsonEmptyValues() throws Throwable {
        BrwsrCtx c = JSONTest.newContext();
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)c);
        p.setSex(Sex.MALE);
        p.setFirstName("");
        p.setLastName("");
        byte[] arr = p.toString().getBytes("UTF-8");
        Person p2 = (Person)Models.parse((BrwsrCtx)c, Person.class, (InputStream)new ByteArrayInputStream(arr));
        Utils.assertEquals(p2.getFirstName(), p.getFirstName(), "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName());
    }

    @KOTest
    public void toJSONWithEscapeCharactersInABrowser() throws Throwable {
        Object json;
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)JSONTest.newContext());
        p.setSex(Sex.MALE);
        p.setFirstName("/*\n * Copyright (c) 2013");
        String txt = p.toString();
        try {
            json = JSONTest.parseJSON(txt);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't parse " + txt).initCause(ex);
        }
        Person p2 = (Person)Models.fromRaw((BrwsrCtx)JSONTest.newContext(), Person.class, (Object)json);
        Utils.assertEquals(p2.getFirstName(), p.getFirstName(), "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName());
    }

    @KOTest
    public void toJSONWithDoubleSlashInABrowser() throws Throwable {
        Object json;
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)JSONTest.newContext());
        p.setSex(Sex.MALE);
        p.setFirstName("/*\\n * Copyright (c) 2013");
        String txt = p.toString();
        try {
            json = JSONTest.parseJSON(txt);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't parse " + txt).initCause(ex);
        }
        Person p2 = (Person)Models.fromRaw((BrwsrCtx)JSONTest.newContext(), Person.class, (Object)json);
        Utils.assertEquals(p2.getFirstName(), p.getFirstName(), "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName());
    }

    @KOTest
    public void toJSONWithApostrophInABrowser() throws Throwable {
        Object json;
        Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)JSONTest.newContext());
        p.setSex(Sex.MALE);
        p.setFirstName("Jimmy 'Jim' Rambo");
        String txt = p.toString();
        try {
            json = JSONTest.parseJSON(txt);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Can't parse " + txt).initCause(ex);
        }
        Person p2 = (Person)Models.fromRaw((BrwsrCtx)JSONTest.newContext(), Person.class, (Object)json);
        Utils.assertEquals(p2.getFirstName(), p.getFirstName(), "Should be the same: " + p.getFirstName() + " != " + p2.getFirstName());
    }

    static void fetch(JSONik model, Person p) {
        model.setFetched(p);
        onCallback = BrwsrCtx.findDefault(model.getClass());
    }

    static void fetchPlain(JSONik model, String p) {
        onCallback = BrwsrCtx.findDefault(model.getClass());
        model.setFetchedResponse(p);
    }

    static void fetchArray(JSONik model, Person[] p) {
        model.setFetchedCount(p.length);
        model.setFetched(p[0]);
        onCallback = BrwsrCtx.findDefault(model.getClass());
    }

    static void setMessage(JSONik m, Exception t) {
        Utils.assertNotNull(t, "Exception provided");
        m.setFetchedResponse("Exception");
    }

    static void fetchPeople(JSONik model, People p) {
        int size = p.getInfo().size();
        if (size > 0) {
            model.setFetched(p.getInfo().get(0));
        }
        model.setFetchedCount(size);
    }

    static void fetchPeopleAge(JSONik model, People p) {
        int sum = 0;
        for (int a : p.getAge()) {
            sum += a;
        }
        model.setFetchedCount(sum);
    }

    @KOTest
    public void loadAndParseJSON() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "{'firstName': 'Sitar', 'sex': 'MALE'}", "application/json", new String[0]);
            BrwsrCtx ctx = JSONTest.newContext();
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)ctx);
            js.applyBindings();
            js.setFetched(null);
            js.fetch(url);
            return new Data(js, 0, url, ctx);
        }).then(d -> {
            Person p = d.js.getFetched();
            Utils.assertEquals("Sitar", p.getFirstName(), "Expecting Sitar: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Expecting MALE: " + (Object)((Object)p.getSex()));
            Utils.assertEquals(d.ctx, onCallback, "Context is the same");
        }).start();
    }

    @KOTest
    public void loadAndParsePlainText() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "{'firstName': 'Sitar', 'sex': 'MALE'}", "text/plain", new String[0]);
            BrwsrCtx ctx = JSONTest.newContext();
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)ctx);
            js.applyBindings();
            js.setFetched(null);
            js.fetchPlain(url);
            return new Data(js, 0, url, ctx);
        }).then(data -> {
            String s = data.js.getFetchedResponse();
            Utils.assertTrue(s.contains("Sitar"), "The text contains Sitar value: " + s);
            Utils.assertTrue(s.contains("MALE"), "The text contains MALE value: " + s);
            Person p = (Person)Models.parse((BrwsrCtx)data.ctx, Person.class, (InputStream)new ByteArrayInputStream(s.getBytes()));
            Utils.assertEquals("Sitar", p.getFirstName(), "Expecting Sitar: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Expecting MALE: " + (Object)((Object)p.getSex()));
            Utils.assertEquals(data.ctx, onCallback, "Same context");
        }).start();
    }

    @KOTest
    public void loadAndParsePlainTextOnArray() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "[ {'firstName': 'Sitar', 'sex': 'MALE'} ]", "text/plain", new String[0]);
            BrwsrCtx ctx = JSONTest.newContext();
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)ctx);
            js.applyBindings();
            js.setFetched(null);
            js.fetchPlain(url);
            return new Data(js, 0, url, ctx);
        }).then(data -> {
            String s = data.js.getFetchedResponse();
            if (s == null) {
                throw new InterruptedException();
            }
            Utils.assertTrue(s.contains("Sitar"), "The text contains Sitar value: " + s);
            Utils.assertTrue(s.contains("MALE"), "The text contains MALE value: " + s);
            Person p = (Person)Models.parse((BrwsrCtx)data.ctx, Person.class, (InputStream)new ByteArrayInputStream(s.getBytes()));
            Utils.assertEquals("Sitar", p.getFirstName(), "Expecting Sitar: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Expecting MALE: " + (Object)((Object)p.getSex()));
            Utils.assertEquals(data.ctx, onCallback, "Same context");
        }).start();
    }

    static void fetchViaJSONP(JSONik model, Person p) {
        model.setFetched(p);
    }

    @KOTest
    public void loadAndParseJSONP() throws InterruptedException, Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "$0({'firstName': 'Mitar', 'sex': 'MALE'})", "application/javascript", "callme");
            int orig = JSONTest.scriptElements();
            Utils.assertTrue(orig > 0, "There should be some scripts on the page");
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.setFetched(null);
            js.fetchViaJSONP(url);
            return new Data(js, orig, url, null);
        }).then(data -> {
            Person p = data.js.getFetched();
            if (p == null) {
                throw new InterruptedException();
            }
            Utils.assertEquals("Mitar", p.getFirstName(), "Unexpected: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Expecting MALE: " + (Object)((Object)p.getSex()));
            int now = JSONTest.scriptElements();
            Utils.assertEquals(data.orig, now, "The set of elements is unchanged. Delta: " + (now - data.orig));
        }).start();
    }

    static void putPerson(JSONik model, String reply) {
        model.setFetchedCount(1);
        model.setFetchedResponse(reply);
    }

    @KOTest
    public void putPeopleUsesRightMethod() throws InterruptedException, Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "$0\n$1", "text/plain", "http.method", "http.requestBody");
            int orig = JSONTest.scriptElements();
            Utils.assertTrue(orig > 0, "There should be some scripts on the page");
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            Person p = (Person)Models.bind((Object)new Person(), (BrwsrCtx)BrwsrCtx.EMPTY);
            p.setFirstName("Jarda");
            js.putPerson(url, p);
            return new Data(js, orig, url, null);
        }).then(data -> {
            String msg;
            JSONik js = data.js;
            int cnt = js.getFetchedCount();
            if (cnt == 0) {
                throw new InterruptedException();
            }
            String res = js.getFetchedResponse();
            int line = res.indexOf(10);
            if (line >= 0) {
                msg = res.substring(line + 1);
                res = res.substring(0, line);
            } else {
                msg = res;
            }
            Utils.assertEquals("PUT", res, "Server was queried with PUT method: " + js.getFetchedResponse());
            Utils.assertTrue(msg.contains("Jarda"), "Data transferred to the server: " + msg);
        }).start();
    }

    private static int scriptElements() throws Exception {
        return ((Number)Utils.executeScript(JSONTest.class, "return window.document.getElementsByTagName('script').length;", new Object[0])).intValue();
    }

    private static Object parseJSON(String s) throws Exception {
        return Utils.executeScript(JSONTest.class, "return window.JSON.parse(arguments[0]);", s);
    }

    @KOTest
    public void loadAndParseJSONSentToArray() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "{'firstName': 'Sitar', 'sex': 'MALE'}", "application/json", new String[0]);
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.setFetched(null);
            js.fetchArray(url);
            return new Data(js, 0, url, null);
        }).then(data -> {
            Person p = data.js.getFetched();
            if (p == null) {
                throw new InterruptedException();
            }
            Utils.assertEquals("Sitar", p.getFirstName(), "Expecting Sitar: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.MALE, (Object)p.getSex(), "Expecting MALE: " + (Object)((Object)p.getSex()));
        }).start();
    }

    @KOTest
    public void loadAndParseJSONArraySingle() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "[{'firstName': 'Gitar', 'sex': 'FEMALE'}]", "application/json", new String[0]);
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.setFetched(null);
            js.fetch(url);
            return new Data(js, 0, url, null);
        }).then(data -> {
            Person p = data.js.getFetched();
            if (p == null) {
                throw new InterruptedException();
            }
            Utils.assertEquals("Gitar", p.getFirstName(), "Expecting Gitar: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.FEMALE, (Object)p.getSex(), "Expecting FEMALE: " + (Object)((Object)p.getSex()));
        }).start();
    }

    @KOTest
    public void loadAndParseArrayInPeople() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "{'info':[{'firstName': 'Gitar', 'sex': 'FEMALE'}]}", "application/json", new String[0]);
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.fetchPeople(url);
            return new Data(js, 0, url, null);
        }).then(data -> {
            JSONik js = data.js;
            if (0 == js.getFetchedCount()) {
                throw new InterruptedException();
            }
            Utils.assertEquals(js.getFetchedCount(), 1, "One person loaded: " + js.getFetchedCount());
            Person p = js.getFetched();
            Utils.assertNotNull(p, "We should get our person back: " + p);
            Utils.assertEquals("Gitar", p.getFirstName(), "Expecting Gitar: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.FEMALE, (Object)p.getSex(), "Expecting FEMALE: " + (Object)((Object)p.getSex()));
        }).start();
    }

    @KOTest
    public void loadAndParseArrayInPeopleWithHeaders() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "{'info':[{'firstName': '$0$1$2$3$4', 'sex': 'FEMALE'}]}", "application/json", "http.header.Easy", "http.header.H-a!r*d^e.r", "http.header.Repeat-ed", "http.header.Repeat*ed", "http.header.Same-URL");
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.fetchPeopleWithHeaders(url, "easy", "harder", "rep");
            return new Data(js, 0, url, null);
        }).then(data -> {
            JSONik js = data.js;
            String url = data.url;
            if (0 == js.getFetchedCount()) {
                throw new InterruptedException();
            }
            Utils.assertEquals(js.getFetchedCount(), 1, "One person loaded: " + js.getFetchedCount());
            Person p = js.getFetched();
            Utils.assertNotNull(p, "We should get our person back: " + p);
            Utils.assertEquals("easyharderreprep" + url, p.getFirstName(), "Expecting header mess: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.FEMALE, (Object)p.getSex(), "Expecting FEMALE: " + (Object)((Object)p.getSex()));
        }).start();
    }

    static void fetchPeopleWithHeaders(JSONik model, People p) {
        int size = p.getInfo().size();
        if (size > 0) {
            model.setFetched(p.getInfo().get(0));
        }
        model.setFetchedCount(size);
    }

    @KOTest
    public void loadAndParseArrayOfIntegers() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "{'age':[1, 2, 3]}", "application/json", new String[0]);
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.fetchPeopleAge(url);
            return new Data(js, 0, url, null);
        }).then(data -> {
            JSONik js = data.js;
            if (0 == js.getFetchedCount()) {
                throw new InterruptedException();
            }
            Utils.assertEquals(js.getFetchedCount(), 6, "1 + 2 + 3 is " + js.getFetchedCount());
        }).start();
    }

    static void fetchPeopleSex(JSONik model, People p) {
        model.setFetchedCount(1);
        model.getFetchedSex().addAll(p.getSex());
    }

    @KOTest
    public void loadAndParseArrayOfEnums() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "{'sex':['FEMALE', 'MALE', 'MALE']}", "application/json", new String[0]);
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.fetchPeopleSex(url);
            return new Data(js, 0, url, null);
        }).then(data -> {
            JSONik js = data.js;
            if (0 == js.getFetchedCount()) {
                throw new InterruptedException();
            }
            Utils.assertEquals(js.getFetchedCount(), 1, "Loaded");
            Utils.assertEquals(js.getFetchedSex().size(), 3, "Three values " + js.getFetchedSex());
            Utils.assertEquals((Object)js.getFetchedSex().get(0), (Object)Sex.FEMALE, "Female first " + js.getFetchedSex());
            Utils.assertEquals((Object)js.getFetchedSex().get(1), (Object)Sex.MALE, "male 2nd " + js.getFetchedSex());
            Utils.assertEquals((Object)js.getFetchedSex().get(2), (Object)Sex.MALE, "male 3rd " + js.getFetchedSex());
        }).start();
    }

    @KOTest
    public void loadAndParseJSONArray() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            String url = Utils.prepareURL(JSONTest.class, "[{'firstName': 'Gitar', 'sex': 'FEMALE'},{'firstName': 'Peter', 'sex': 'MALE'}]", "application/json", new String[0]);
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.setFetched(null);
            js.fetchArray(url);
            return new Data(js, 0, url, null);
        }).then(data -> {
            JSONik js = data.js;
            Person p = js.getFetched();
            if (p == null) {
                throw new InterruptedException();
            }
            Utils.assertEquals(js.getFetchedCount(), 2, "We got two values: " + js.getFetchedCount());
            Utils.assertEquals("Gitar", p.getFirstName(), "Expecting Gitar: " + p.getFirstName());
            Utils.assertEquals((Object)Sex.FEMALE, (Object)p.getSex(), "Expecting FEMALE: " + (Object)((Object)p.getSex()));
        }).start();
    }

    @KOTest
    public void loadError() throws Exception {
        PhaseExecutor.schedule(this.phases, () -> {
            JSONik js = (JSONik)Models.bind((Object)new JSONik(), (BrwsrCtx)JSONTest.newContext());
            js.applyBindings();
            js.setFetched(null);
            js.fetchArray("http://127.0.0.1:54253/does/not/exist.txt");
            return new Data(js, 0, null, null);
        }).then(data -> {
            JSONik js = data.js;
            if (js.getFetchedResponse() == null) {
                throw new InterruptedException();
            }
            Utils.assertEquals("Exception", js.getFetchedResponse(), "Response " + js.getFetchedResponse());
        }).start();
    }

    @KOTest
    public void parseNullNumber() throws Exception {
        String txt = "{ \"name\":\"M\" }";
        ByteArrayInputStream is = new ByteArrayInputStream(txt.getBytes("UTF-8"));
        NameAndValue v = (NameAndValue)Models.parse((BrwsrCtx)JSONTest.newContext(), NameAndValue.class, (InputStream)is);
        Utils.assertEquals("M", v.getName(), "Name is 'M': " + v.getName());
        Utils.assertEquals(0L, v.getValue(), "Value is empty: " + v.getValue());
        Utils.assertEquals((byte)0, v.getSmall(), "Small value is empty: " + v.getSmall());
    }

    @KOTest
    public void deserializeWrongEnum() throws Exception {
        PrintStream prev;
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            prev = System.err;
            System.setErr(new PrintStream(err));
        }
        catch (Throwable e) {
            err = null;
            prev = null;
        }
        String str = "{ \"sex\" : \"unknown\" }";
        ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes("UTF-8"));
        Person p = (Person)Models.parse((BrwsrCtx)JSONTest.newContext(), Person.class, (InputStream)is);
        Utils.assertNull((Object)p.getSex(), "Wrong sex means null, but was: " + (Object)((Object)p.getSex()));
        if (err != null) {
            Utils.assertTrue(err.toString().contains("unknown") && err.toString().contains("Sex"), "Expecting error: " + err.toString());
        }
        if (prev != null) {
            try {
                System.setErr(prev);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
    }

    private static BrwsrCtx newContext() {
        return Utils.newContext(JSONTest.class);
    }

    private static class Data {
        final JSONik js;
        final Integer orig;
        final String url;
        final BrwsrCtx ctx;

        Data(JSONik js, Integer orig, String url, BrwsrCtx ctx) {
            this.js = js;
            this.orig = orig;
            this.url = url;
            this.ctx = ctx;
        }
    }

    static class NandV {
        NandV() {
        }
    }
}

