/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.ko.osgi.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import net.java.html.BrwsrCtx;
import net.java.html.boot.BrowserBuilder;
import net.java.html.js.JavaScriptBody;
import org.apidesign.html.boot.spi.Fn;
import org.apidesign.html.context.spi.Contexts;
import org.apidesign.html.json.spi.Technology;
import org.apidesign.html.json.spi.Transfer;
import org.apidesign.html.json.tck.KnockoutTCK;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class KnockoutEquinoxTCKImpl
extends KnockoutTCK
implements Callable<Class[]> {
    private static Fn.Presenter browserContext;

    public static Class loadOSGiClass(String name, BundleContext ctx) throws Exception {
        for (Bundle b : ctx.getBundles()) {
            try {
                Class osgiClass = b.loadClass(name);
                if (osgiClass == null || osgiClass.getClassLoader() == ClassLoader.getSystemClassLoader()) continue;
                return osgiClass;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Cannot load " + name + " from the OSGi container!");
    }

    @Override
    public Class[] call() throws Exception {
        return KnockoutEquinoxTCKImpl.testClasses();
    }

    public static void start(URI server) throws Exception {
        final BrowserBuilder bb = BrowserBuilder.newBrowser((Object[])new Object[0]).loadClass(KnockoutEquinoxTCKImpl.class).loadPage(server.toString()).invoke("initialized", new String[0]);
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ClassLoader osgiClassLoader = BrowserBuilder.class.getClassLoader();
                    Thread.currentThread().setContextClassLoader(osgiClassLoader);
                    bb.showAndWait();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
    }

    public static void initialized() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(KnockoutEquinoxTCKImpl.class);
        if (bundle == null) {
            throw new IllegalStateException("Should be loaded from a bundle. But was: " + KnockoutEquinoxTCKImpl.class.getClassLoader());
        }
        Class<?> classpathClass = ClassLoader.getSystemClassLoader().loadClass("org.netbeans.html.ko.osgi.test.KnockoutEquinoxIT");
        Method m = classpathClass.getMethod("initialized", Class.class, Object.class);
        browserContext = Fn.activePresenter();
        m.invoke(null, KnockoutEquinoxTCKImpl.class, browserContext);
    }

    public BrwsrCtx createContext() {
        try {
            Class fxCls = KnockoutEquinoxTCKImpl.loadOSGiClass("org.netbeans.html.ko4j.FXContext", FrameworkUtil.getBundle(KnockoutEquinoxTCKImpl.class).getBundleContext());
            Constructor cnstr = fxCls.getConstructor(Fn.Presenter.class);
            cnstr.setAccessible(true);
            Object fx = cnstr.newInstance(browserContext);
            Contexts.Builder cb = Contexts.newBuilder().register(Technology.class, (Object)((Technology)fx), 10).register(Transfer.class, (Object)((Transfer)fx), 10);
            return cb.build();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Object createJSON(Map<String, Object> values) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            try {
                json.put(entry.getKey(), entry.getValue());
            }
            catch (JSONException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return json;
    }

    @JavaScriptBody(args={"s", "args"}, body="var f = new Function(s); return f.apply(null, args);")
    public native Object executeScript(String var1, Object[] var2);

    @JavaScriptBody(args={}, body="var h;if (!!window && !!window.location && !!window.location.href)\n  h = window.location.href;\nelse   h = null;return h;\n")
    private static native String findBaseURL();

    public URI prepareURL(String content, String mimeType, String[] parameters) {
        try {
            URL baseURL = new URL(KnockoutEquinoxTCKImpl.findBaseURL());
            StringBuilder sb = new StringBuilder();
            sb.append("/dynamic?mimeType=").append(mimeType);
            for (int i = 0; i < parameters.length; ++i) {
                sb.append("&param" + i).append("=").append(parameters[i]);
            }
            String mangle = content.replace("\n", "%0a").replace("\"", "\\\"").replace(" ", "%20");
            sb.append("&content=").append(mangle);
            URL query = new URL(baseURL, sb.toString());
            URLConnection c = query.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(c.getInputStream()));
            URI connectTo = new URI(br.readLine());
            return connectTo;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public boolean canFailWebSocketTest() {
        try {
            Class.forName("java.util.function.Function");
            return false;
        }
        catch (ClassNotFoundException ex) {
            return true;
        }
    }
}

