/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.browser;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.presenters.browser.GrizzlyServer;
import org.netbeans.html.presenters.browser.HttpServer;
import org.netbeans.html.presenters.render.Show;
import org.netbeans.html.presenters.spi.ProtoPresenter;
import org.netbeans.html.presenters.spi.ProtoPresenterBuilder;

public final class Browser
implements Fn.Presenter,
Fn.KeepAlive,
Flushable,
Executor,
Closeable {
    static final Logger LOG = Logger.getLogger(Browser.class.getName());
    private final Map<String, Command> SESSIONS = new HashMap<String, Command>();
    private final String app;
    private HttpServer server;
    private Runnable onPageLoad;
    private Command current;
    private final Config config;
    private final Supplier<HttpServer<?, ?, ?, ?>> serverProvider;

    public Browser() {
        this(new Config());
    }

    public Browser(Config config) {
        this(Browser.findCalleeClassName(), config, null);
    }

    Browser(String app, Config config, Supplier<HttpServer<?, ?, ?, ?>> serverProvider) {
        this.serverProvider = serverProvider != null ? serverProvider : GrizzlyServer::new;
        this.app = app;
        this.config = new Config(config);
    }

    @Override
    public final void execute(Runnable r) {
        this.current.execute(r);
    }

    @Override
    public void close() throws IOException {
        if (this.server != null) {
            this.server.shutdownNow();
        }
    }

    HttpServer server() {
        return this.server;
    }

    static HttpServer findServer(Object obj) {
        Command c;
        if (obj instanceof Command) {
            c = (Command)obj;
        } else if (obj instanceof ProtoPresenter) {
            c = (Command)((ProtoPresenter)obj).lookup(Command.class);
        } else {
            throw new IllegalArgumentException("Cannot find server for " + obj);
        }
        return c.browser.server();
    }

    void show(URI page) throws IOException {
        this.config.getBrowser().accept(page);
    }

    public Fn defineFn(String string, String ... strings) {
        throw new UnsupportedOperationException();
    }

    public void loadScript(Reader reader) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Fn defineFn(String string, String[] strings, boolean[] blns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }

    private static URI pageURL(String protocol, HttpServer server, String page) {
        int port = server.getPort();
        try {
            return new URI(protocol + "://localhost:" + port + page);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public final void displayPage(URL page, Runnable onPageLoad) {
        try {
            this.onPageLoad = onPageLoad;
            this.server = this.serverProvider.get();
            int from = 8080;
            int to = 65535;
            int port = this.config.getPort();
            if (port != -1) {
                from = to = port;
            }
            this.server.init(from, to);
            this.server.addHttpHandler(new RootPage(page), "/");
            this.server.start();
            this.show(Browser.pageURL("http", this.server, "/"));
        }
        catch (IOException ex) {
            Logger.getLogger(Browser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static <T extends Exception> T raise(Class<T> aClass, Exception ex) throws T {
        throw ex;
    }

    static <Response> void cors(HttpServer<?, Response, ?, ?> s, Response r) {
        s.setCharacterEncoding(r, "UTF-8");
        s.addHeader(r, "Access-Control-Allow-Origin", "*");
        s.addHeader(r, "Access-Control-Allow-Credentials", "true");
        s.addHeader(r, "Access-Control-Allow-Headers", "Content-Type");
        s.addHeader(r, "Access-Control-Allow-Methods", "GET, POST, DELETE, PUT");
    }

    String createCallbackFn(String prefix, String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("this.toBrwsrSrvr = function(name, a1, a2, a3, a4) {\nvar url = '").append(prefix).append("command.js?id=").append(id).append("&name=' + name;\nvar body = 'p0=' + encodeURIComponent(a1);\nbody += '&p1=' + encodeURIComponent(a2);\nbody += '&p2=' + encodeURIComponent(a3);\nbody += '&p3=' + encodeURIComponent(a4);\nvar request = new XMLHttpRequest();\n");
        if (this.config.debug) {
            sb.append("console.log('PUT ... ' + body.substring(0, 80));\nvar now = new Date().getTime();\n");
        }
        sb.append("var async = name === 'p';\nrequest.open('PUT', url, async);\nrequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=utf-8');\nrequest.send(body);\nif (async) return '';\nvar txt = request.responseText;\n");
        if (this.config.debug) {
            sb.append("var then = new Date().getTime();\nif (txt && txt !== 'null') {\n  var cmd = document.getElementById('cmd');\n  if (cmd) cmd.innerHTML = txt.substring(0,80);\n}\nconsole.log('... PUT [' + (then - now) + 'ms]: ' + txt.substring(0, 80));\n");
        }
        sb.append("return txt;\n};\n");
        return sb.toString();
    }

    private static String findCalleeClassName() {
        StackTraceElement[] frames;
        for (StackTraceElement e : frames = new Exception().getStackTrace()) {
            String cn = e.getClassName();
            if (cn.startsWith("com.dukescript.presenters.") || cn.startsWith("org.netbeans.html.") || cn.startsWith("net.java.html.") || cn.startsWith("java.") || cn.startsWith("javafx.") || cn.startsWith("com.sun.")) continue;
            return cn;
        }
        return "org.netbeans.html";
    }

    public static final class Config {
        private Consumer<URI> browser;
        Integer port;
        boolean debug;

        public Config() {
            this.command(null);
        }

        private Config(Config copy) {
            this.browser = copy.browser;
            this.port = copy.port;
            this.debug = copy.debug;
        }

        public Config command(String executable) {
            this.browser = page -> {
                String impl = executable;
                if (impl == null) {
                    impl = System.getProperty("com.dukescript.presenters.browser");
                }
                if ("none".equalsIgnoreCase(impl)) {
                    return;
                }
                try {
                    Show.show((String)impl, (URI)page);
                }
                catch (IOException ex) {
                    throw Browser.raise(RuntimeException.class, ex);
                }
            };
            return this;
        }

        public Config browser(Consumer<URI> urlOpener) {
            this.browser = urlOpener;
            return this;
        }

        public Config port(int port) {
            this.port = port;
            return this;
        }

        Config debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        final Consumer<URI> getBrowser() {
            return this.browser;
        }

        final int getPort() {
            if (this.port != null) {
                return this.port;
            }
            String browserPort = System.getProperty("com.dukescript.presenters.browserPort");
            try {
                return Integer.parseInt(browserPort);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
    }

    private static final class Command<Request, Response, Runner>
    implements Executor {
        private final HttpServer<Request, Response, ?, Runner> server;
        private final Queue<Object> exec;
        private final Browser browser;
        private final String id;
        private final String prefix;
        private Runner RUNNER;
        private Response suspended;
        private boolean initialized;
        private final ProtoPresenter presenter;

        Command(HttpServer<Request, Response, ?, Runner> s, Browser browser, String prefix) {
            this.server = s;
            this.id = UUID.randomUUID().toString();
            this.RUNNER = s.initializeRunner(this.id);
            this.exec = new LinkedList<Object>();
            this.prefix = prefix;
            this.browser = browser;
            this.presenter = ProtoPresenterBuilder.newBuilder().preparator(this::callbackFn, true).loadJavaScript(this::loadJS, false).app(browser.app).dispatcher((Executor)this, true).displayer(this::displayPage).logger(this::log).type("Browser").register((Object)this).build();
        }

        @Override
        public final void execute(Runnable r) {
            this.server.runSafe(this.RUNNER, r, (Fn.Presenter)this.presenter);
        }

        final synchronized void add(Object obj) {
            if (this.suspended != null) {
                Response rqst = this.suspended;
                this.server.resume(rqst, () -> {
                    try (Writer w = this.server.getWriter(rqst);){
                        w.write(obj.toString());
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, null, ex);
                    }
                });
                this.suspended = null;
                return;
            }
            this.exec.add(obj);
        }

        private synchronized Object take(Response rspns) {
            Object o = this.exec.poll();
            if (o != null) {
                return o;
            }
            this.suspended = rspns;
            this.server.suspend(rspns);
            return null;
        }

        private synchronized boolean initialize(Response rspns) {
            if (!this.initialized) {
                this.initialized = true;
                this.suspended = rspns;
                this.server.suspend(rspns);
                this.execute(this.browser.onPageLoad);
                return true;
            }
            return false;
        }

        void service(Request rqst, Response rspns) throws IOException {
            String methodName = this.server.getParameter(rqst, "name");
            this.server.setContentType(rspns, "text/javascript");
            Writer w = this.server.getWriter(rspns);
            if (methodName == null) {
                if (this.initialize(rspns)) {
                    return;
                }
                Object obj = this.take(rspns);
                if (obj == null) {
                    LOG.log(Level.FINE, "Suspending response {0}", rspns);
                    return;
                }
                String s = obj.toString();
                w.write(s);
                LOG.log(Level.FINE, "Exec global: {0}", s);
            } else {
                String res;
                ArrayList<String> args = new ArrayList<String>();
                String body = this.server.getBody(rqst);
                for (String p : body.split("&")) {
                    if (p.length() < 3) continue;
                    args.add(URLDecoder.decode(p.substring(3), "UTF-8"));
                }
                try {
                    LOG.log(Level.FINE, "Call {0}", methodName + " with " + args);
                    res = this.presenter.js2java(methodName, (String)args.get(0), (String)args.get(1), (String)args.get(2), (String)args.get(3));
                    LOG.log(Level.FINE, "Result: {0}", res);
                }
                catch (Exception ex) {
                    res = "error:" + ex.getMessage();
                }
                if (res != null) {
                    w.write(res);
                } else {
                    w.write("null");
                }
            }
            w.close();
        }

        void callbackFn(ProtoPresenterBuilder.OnPrepared onReady) {
            String sb = this.browser.createCallbackFn(this.prefix, this.id);
            this.add(sb);
            onReady.callbackIsPrepared("toBrwsrSrvr");
        }

        private static Level findLevel(int priority) {
            if (priority >= Level.SEVERE.intValue()) {
                return Level.SEVERE;
            }
            if (priority >= Level.WARNING.intValue()) {
                return Level.WARNING;
            }
            if (priority >= Level.INFO.intValue()) {
                return Level.INFO;
            }
            return Level.FINE;
        }

        void log(int priority, String msg, Object ... args) {
            Level level = Command.findLevel(priority);
            if (args.length == 1 && args[0] instanceof Throwable) {
                LOG.log(level, msg, (Throwable)args[0]);
            } else {
                LOG.log(level, msg, args);
            }
        }

        final void loadJS(String js) {
            this.add(js);
        }

        void dispatch(Runnable r) {
            this.server.runSafe(this.RUNNER, r, null);
        }

        public void displayPage(URL url, Runnable r) {
            throw new UnsupportedOperationException(url.toString());
        }
    }

    private final class RootPage
    extends HttpServer.Handler {
        private final URL page;

        public RootPage(URL page) {
            this.page = page;
        }

        @Override
        public <Request, Response> void service(HttpServer<Request, Response, ?, ?> server, Request rqst, Response rspns) throws IOException {
            String path = server.getRequestURI(rqst);
            Browser.cors(server, rspns);
            if ("OPTIONS".equals(server.getMethod(rqst))) {
                server.setStatus(rspns, 204);
                server.addHeader(rspns, "Allow", "OPTIONS, GET, HEAD, POST, PUT");
                return;
            }
            if ("/".equals(path) || "index.html".equals(path)) {
                int ch;
                InputStreamReader is;
                String prefix = "http://" + server.getServerName(rqst) + ":" + server.getServerPort(rqst) + "/";
                Writer w = server.getWriter(rspns);
                server.setContentType(rspns, "text/html");
                Command cmd = new Command(server, Browser.this, prefix);
                try {
                    is = new InputStreamReader(this.page.openStream());
                }
                catch (IOException ex) {
                    w.write("<html><body>");
                    w.write("<h1>Browser</h1>");
                    w.write("<pre id='cmd'></pre>");
                    this.emitScript(w, prefix, cmd.id);
                    w.write("</body></html>");
                    w.close();
                    return;
                }
                Browser.this.SESSIONS.put(cmd.id, cmd);
                int state = 0;
                while ((ch = ((Reader)is).read()) != -1) {
                    char lower = Character.toLowerCase((char)ch);
                    switch (state) {
                        case 1000: {
                            break;
                        }
                        case 0: {
                            if (lower != '<') break;
                            state = 1;
                            break;
                        }
                        case 1: {
                            if (lower == 'b') {
                                state = 2;
                                break;
                            }
                            if (lower == ' ' || lower == '\n') break;
                            state = 0;
                            break;
                        }
                        case 2: {
                            if (lower == 'o') {
                                state = 3;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        case 3: {
                            if (lower == 'd') {
                                state = 4;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        case 4: {
                            if (lower == 'y') {
                                state = 5;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        case 5: {
                            if (lower == '>') {
                                state = 500;
                                break;
                            }
                            if (lower == ' ' || lower == '\n') break;
                            state = 0;
                        }
                    }
                    w.write((char)ch);
                    if (state != 500) continue;
                    this.emitScript(w, prefix, cmd.id);
                    state = 1000;
                }
                if (state != 1000) {
                    this.emitScript(w, prefix, cmd.id);
                }
                ((Reader)is).close();
                w.close();
            } else if (path.equals("/command.js")) {
                String id = server.getParameter(rqst, "id");
                Command c = (Command)Browser.this.SESSIONS.get(id);
                if (c == null) {
                    server.getWriter(rspns).write("No command for " + id);
                    server.setStatus(rspns, 404);
                    return;
                }
                c.service(rqst, rspns);
            } else {
                int b;
                InputStream is;
                URLConnection conn;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                URL relative = new URL(this.page, path);
                try {
                    conn = relative.openConnection();
                    is = conn.getInputStream();
                }
                catch (FileNotFoundException ex) {
                    server.setStatus(rspns, 404);
                    return;
                }
                String found = null;
                if (relative.getProtocol().equals("file")) {
                    try {
                        File file = new File(relative.toURI());
                        found = Files.probeContentType(file.toPath());
                    }
                    catch (IOException | URISyntaxException file) {}
                } else {
                    found = conn.getContentType();
                }
                if (found == null || "content/unknown".equals(found)) {
                    if (path.endsWith(".html")) {
                        found = "text/html";
                    }
                    if (path.endsWith(".js")) {
                        found = "text/javascript";
                    }
                    if (path.endsWith(".css")) {
                        found = "text/css";
                    }
                }
                if (found != null) {
                    server.setContentType(rspns, found);
                }
                OutputStream out = server.getOutputStream(rspns);
                while ((b = is.read()) != -1) {
                    out.write(b);
                }
                out.close();
                is.close();
            }
        }

        private void emitScript(Writer w, String prefix, String id) throws IOException {
            w.write("  <script id='exec' type='text/javascript'>");
            w.write("\nfunction waitForCommand(counter) {\n  try {\n    if (waitForCommand.seenError) {\n      console.warn('Disconnected from " + prefix + "');\n      return;\n    };\n    var request = new XMLHttpRequest();\n");
            if (((Browser)Browser.this).config.debug) {
                w.write("    console.log('GET[' + counter + ']....');\n");
            }
            w.write("    request.open('GET', '" + prefix + "command.js?id=" + id + "', true);\n    request.setRequestHeader('Content-Type', 'text/plain; charset=utf-8');\n    request.onerror = function(ev) {\n      console.warn(ev);\n      waitForCommand.seenError = true;\n    };\n    request.onreadystatechange = function() {\n      if (this.readyState!==4) return;\n      try {\n");
            if (((Browser)Browser.this).config.debug) {
                w.write("        console.log('...GET[' + counter + '] got something ' + this.responseText.substring(0,80));\n        var cmd = document.getElementById('cmd');\n        if (cmd) cmd.innerHTML = this.responseText.substring(0,80);\n");
            }
            w.write("        (0 || eval)(this.responseText);\n      } catch (e) {\n        console.warn(e); \n      } finally {\n        waitForCommand(counter + 1);\n      }\n    };\n    request.send();\n  } catch (e) {\n    console.warn(e);\n    waitForCommand(counter + 1);\n  }\n}\nwaitForCommand(1);\n");
            w.write("  </script>\n");
        }
    }
}

