/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.presenters.browser;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.PortRange;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.netbeans.html.boot.spi.Fn;
import org.netbeans.html.presenters.render.Show;
import org.netbeans.html.presenters.spi.ProtoPresenter;
import org.netbeans.html.presenters.spi.ProtoPresenterBuilder;

public final class Browser
implements Fn.Presenter,
Fn.KeepAlive,
Flushable,
Executor,
Closeable {
    static final Logger LOG = Logger.getLogger(Browser.class.getName());
    private final Map<String, Command> SESSIONS = new HashMap<String, Command>();
    private final String app;
    private HttpServer s;
    private Runnable onPageLoad;
    private Command current;
    private final Config config;

    public Browser() throws Exception {
        this(new Config());
    }

    public Browser(Config config) {
        this(Browser.findCalleeClassName(), config);
    }

    Browser(String app, Config config) {
        this.app = app;
        this.config = new Config(config);
    }

    @Override
    public final void execute(Runnable r) {
        this.current.runSafe(r, true);
    }

    @Override
    public void close() throws IOException {
        this.s.shutdownNow();
    }

    HttpServer server() {
        return this.s;
    }

    static HttpServer findServer(Object obj) {
        Command c = null;
        if (obj instanceof Command) {
            c = (Command)obj;
        } else if (obj instanceof ProtoPresenter) {
            c = (Command)((ProtoPresenter)obj).lookup(Command.class);
        }
        return c.browser.server();
    }

    void show(URI page) throws IOException {
        String impl = this.config.getBrowser();
        if ("none".equalsIgnoreCase(impl)) {
            return;
        }
        if (impl != null) {
            Show.show((String)impl, (URI)page);
        } else {
            try {
                String ui = System.getProperty("os.name").contains("Mac") ? "Cocoa" : "GTK";
                Show.show((String)ui, (URI)page);
                return;
            }
            catch (IOException ex) {
                IOException one = ex;
                try {
                    Show.show((String)"AWT", (URI)page);
                    return;
                }
                catch (IOException ex2) {
                    IOException two = ex2;
                    try {
                        Show.show((String)impl, (URI)page);
                    }
                    catch (IOException ex3) {
                        two.initCause(one);
                        ex3.initCause(two);
                        throw ex3;
                    }
                }
            }
        }
    }

    public Fn defineFn(String string, String ... strings) {
        throw new UnsupportedOperationException();
    }

    public void loadScript(Reader reader) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Fn defineFn(String string, String[] strings, boolean[] blns) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }

    private static HttpServer server(RootPage r, Config config) {
        int from = 8080;
        int to = 65535;
        int port = config.getPort();
        if (port != -1) {
            from = to = port;
        }
        HttpServer s = HttpServer.createSimpleServer(null, (PortRange)new PortRange(from, to));
        ServerConfiguration conf = s.getServerConfiguration();
        conf.addHttpHandler((HttpHandler)r, new String[]{"/"});
        return s;
    }

    private static URI pageURL(String protocol, HttpServer server, String page) {
        NetworkListener listener = (NetworkListener)server.getListeners().iterator().next();
        int port = listener.getPort();
        try {
            return new URI(protocol + "://localhost:" + port + page);
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public final void displayPage(URL page, Runnable onPageLoad) {
        try {
            this.onPageLoad = onPageLoad;
            this.s = Browser.server(new RootPage(page), this.config);
            this.s.start();
            this.show(Browser.pageURL("http", this.s, "/"));
        }
        catch (IOException ex) {
            Logger.getLogger(Browser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static void cors(Response r) {
        r.setCharacterEncoding("UTF-8");
        r.addHeader("Access-Control-Allow-Origin", "*");
        r.addHeader("Access-Control-Allow-Credentials", "true");
        r.addHeader("Access-Control-Allow-Headers", "Content-Type");
        r.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT");
    }

    private static String findCalleeClassName() {
        StackTraceElement[] frames;
        for (StackTraceElement e : frames = new Exception().getStackTrace()) {
            String cn = e.getClassName();
            if (cn.startsWith("com.dukescript.presenters.") || cn.startsWith("org.netbeans.html.") || cn.startsWith("net.java.html.") || cn.startsWith("java.") || cn.startsWith("javafx.") || cn.startsWith("com.sun.")) continue;
            return cn;
        }
        return "org.netbeans.html";
    }

    private static final class Command
    implements Executor,
    ThreadFactory {
        private final Queue<Object> exec;
        private final Browser browser;
        private final String id;
        private final String prefix;
        private final Executor RUN = Executors.newSingleThreadExecutor(this);
        private Thread RUNNER;
        private Response suspended;
        private boolean initialized;
        private final ProtoPresenter presenter;

        Command(Browser browser, String prefix) {
            this.id = UUID.randomUUID().toString();
            this.exec = new LinkedList<Object>();
            this.prefix = prefix;
            this.browser = browser;
            this.presenter = ProtoPresenterBuilder.newBuilder().preparator(this::callbackFn, true).loadJavaScript(this::loadJS, false).app(browser.app).dispatcher((Executor)this, true).displayer(this::displayPage).logger(this::log).type("Browser").register((Object)this).build();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t;
            this.RUNNER = t = new Thread(r, "Processor for " + this.id);
            return t;
        }

        @Override
        public final void execute(Runnable r) {
            this.runSafe(r, true);
        }

        final void runSafe(final Runnable r, final boolean context) {
            class Wrap
            implements Runnable {
                Wrap() {
                }

                @Override
                public void run() {
                    if (context) {
                        Closeable c = Fn.activate((Fn.Presenter)Command.this.presenter);
                        try {
                            r.run();
                        }
                        finally {
                            try {
                                c.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    r.run();
                }
            }
            if (this.RUNNER == Thread.currentThread()) {
                if (context) {
                    Wrap w = new Wrap();
                    w.run();
                } else {
                    r.run();
                }
            } else {
                Wrap w = new Wrap();
                this.RUN.execute(w);
            }
        }

        final synchronized void add(Object obj) {
            if (this.suspended != null) {
                try {
                    this.suspended.getWriter().write(obj.toString());
                }
                catch (IOException ex) {
                    LOG.log(Level.SEVERE, null, ex);
                }
                this.suspended.resume();
                this.suspended = null;
                return;
            }
            this.exec.add(obj);
        }

        private synchronized Object take(Response rspns) {
            Object o = this.exec.poll();
            if (o != null) {
                return o;
            }
            this.suspended = rspns;
            rspns.suspend();
            return null;
        }

        void service(Request rqst, Response rspns) throws Exception {
            String methodName = rqst.getParameter("name");
            Writer w = rspns.getWriter();
            if (methodName == null) {
                Object obj;
                if (!this.initialized) {
                    this.initialized = true;
                    this.execute(this.browser.onPageLoad);
                }
                if ((obj = this.take(rspns)) == null) {
                    LOG.log(Level.FINE, "Suspending response {0}", rspns);
                    return;
                }
                String s = obj.toString();
                w.write(s);
                LOG.log(Level.FINE, "Exec global: {0}", s);
            } else {
                String res;
                String p;
                ArrayList<String> args = new ArrayList<String>();
                while ((p = rqst.getParameter("p" + args.size())) != null) {
                    args.add(p);
                }
                try {
                    LOG.log(Level.FINE, "Call {0}", methodName + " with " + args);
                    res = this.presenter.js2java(methodName, (String)args.get(0), (String)args.get(1), (String)args.get(2), (String)args.get(3));
                    LOG.log(Level.FINE, "Result: {0}", res);
                }
                catch (Exception ex) {
                    res = "error:" + ex.getMessage();
                }
                if (res != null) {
                    w.write(res);
                } else {
                    w.write("null");
                }
            }
            w.close();
        }

        void callbackFn(ProtoPresenterBuilder.OnPrepared onReady) {
            StringBuilder sb = new StringBuilder();
            sb.append("this.toBrwsrSrvr = function(name, a1, a2, a3, a4) {\nvar url = '").append(this.prefix).append("command.js?id=").append(this.id).append("&name=' + name;\nurl += '&p0=' + encodeURIComponent(a1);\nurl += '&p1=' + encodeURIComponent(a2);\nurl += '&p2=' + encodeURIComponent(a3);\nurl += '&p3=' + encodeURIComponent(a4);\nvar request = new XMLHttpRequest();\nrequest.open('GET', url, false);\nrequest.setRequestHeader('Content-Type', 'text/plain; charset=utf-8');\nrequest.send();\nreturn request.responseText;\n};\n");
            this.add(sb);
            onReady.callbackIsPrepared("toBrwsrSrvr");
        }

        private static Level findLevel(int priority) {
            if (priority >= Level.SEVERE.intValue()) {
                return Level.SEVERE;
            }
            if (priority >= Level.WARNING.intValue()) {
                return Level.WARNING;
            }
            if (priority >= Level.INFO.intValue()) {
                return Level.INFO;
            }
            return Level.FINE;
        }

        void log(int priority, String msg, Object ... args) {
            Level level = Command.findLevel(priority);
            if (args.length == 1 && args[0] instanceof Throwable) {
                LOG.log(level, msg, (Throwable)args[0]);
            } else {
                LOG.log(level, msg, args);
            }
        }

        final void loadJS(String js) {
            this.add(js);
        }

        void dispatch(Runnable r) {
            this.runSafe(r, false);
        }

        public void displayPage(URL url, Runnable r) {
            throw new UnsupportedOperationException(url.toString());
        }
    }

    private final class RootPage
    extends HttpHandler {
        private final URL page;

        public RootPage(URL page) {
            this.page = page;
        }

        public void service(Request rqst, Response rspns) throws Exception {
            String path = rqst.getRequestURI();
            Browser.cors(rspns);
            if ("/".equals(path) || "index.html".equals(path)) {
                int ch;
                InputStreamReader is;
                String prefix = "http://" + rqst.getServerName() + ":" + rqst.getServerPort() + "/";
                Writer w = rspns.getWriter();
                rspns.setContentType("text/html");
                Command cmd = new Command(Browser.this, prefix);
                try {
                    is = new InputStreamReader(this.page.openStream());
                }
                catch (IOException ex) {
                    w.write("<html><body>");
                    w.write("<h1>Browser</h1>");
                    w.write("<pre id='cmd'></pre>");
                    this.emitScript(w, prefix, cmd.id);
                    w.write("</body></html>");
                    w.close();
                    return;
                }
                Browser.this.SESSIONS.put(cmd.id, cmd);
                int state = 0;
                while ((ch = ((Reader)is).read()) != -1) {
                    char lower = Character.toLowerCase((char)ch);
                    switch (state) {
                        case 1000: {
                            break;
                        }
                        case 0: {
                            if (lower != '<') break;
                            state = 1;
                            break;
                        }
                        case 1: {
                            if (lower == 'b') {
                                state = 2;
                                break;
                            }
                            if (lower == ' ' || lower == '\n') break;
                            state = 0;
                            break;
                        }
                        case 2: {
                            if (lower == 'o') {
                                state = 3;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        case 3: {
                            if (lower == 'd') {
                                state = 4;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        case 4: {
                            if (lower == 'y') {
                                state = 5;
                                break;
                            }
                            state = 0;
                            break;
                        }
                        case 5: {
                            if (lower == '>') {
                                state = 500;
                                break;
                            }
                            if (lower == ' ' || lower == '\n') break;
                            state = 0;
                        }
                    }
                    w.write((char)ch);
                    if (state != 500) continue;
                    this.emitScript(w, prefix, cmd.id);
                    state = 1000;
                }
                if (state != 1000) {
                    this.emitScript(w, prefix, cmd.id);
                }
                ((Reader)is).close();
                w.close();
            } else if (path.equals("/command.js")) {
                String id = rqst.getParameter("id");
                Command c = (Command)Browser.this.SESSIONS.get(id);
                if (c == null) {
                    rspns.getOutputBuffer().write("No command for " + id);
                    rspns.setStatus(HttpStatus.NOT_FOUND_404);
                    return;
                }
                c.service(rqst, rspns);
            } else {
                int b;
                InputStream is;
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                URL relative = new URL(this.page, path);
                try {
                    is = relative.openStream();
                }
                catch (FileNotFoundException ex) {
                    rspns.setStatus(HttpStatus.NOT_FOUND_404);
                    return;
                }
                OutputStream out = rspns.getOutputStream();
                while ((b = is.read()) != -1) {
                    out.write(b);
                }
                out.close();
                is.close();
            }
        }

        private void emitScript(Writer w, String prefix, String id) throws IOException {
            w.write("  <script id='exec' type='text/javascript'>");
            w.write("\nfunction waitForCommand() {\n  try {\n    if (waitForCommand.seenError) {\n      console.warn('Disconnected from " + prefix + "');\n      return;\n    };\n    var request = new XMLHttpRequest();\n    request.open('GET', '" + prefix + "command.js?id=" + id + "', true);\n    request.setRequestHeader('Content-Type', 'text/plain; charset=utf-8');\n    request.onerror = function(ev) {\n      console.warn(ev);\n      waitForCommand.seenError = true;\n    };\n    request.onreadystatechange = function() {\n      if (this.readyState!==4) return;\n      try {\n        var cmd = document.getElementById('cmd');\n        if (cmd) cmd.innerHTML = this.responseText.substring(0,80);\n        (0 || eval)(this.responseText);\n      } catch (e) {\n        console.warn(e); \n      } finally {\n        waitForCommand();\n      }\n    };\n    request.send();\n  } catch (e) {\n    console.warn(e);\n    waitForCommand();\n  }\n}\nwaitForCommand();\n");
            w.write("  </script>\n");
        }
    }

    public static final class Config {
        String browser;
        Integer port;

        public Config() {
        }

        private Config(Config copy) {
            this.browser = copy.browser;
            this.port = copy.port;
        }

        public Config command(String executable) {
            this.browser = executable;
            return this;
        }

        public Config port(int port) {
            this.port = port;
            return this;
        }

        final String getBrowser() {
            if (this.browser != null) {
                return this.browser;
            }
            return System.getProperty("com.dukescript.presenters.browser");
        }

        final int getPort() {
            if (this.port != null) {
                return this.port;
            }
            String port = System.getProperty("com.dukescript.presenters.browserPort");
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }
    }
}

