/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private static final int[] DECODING_TABLE = new int[256];
    private final InputStream delegate;
    private int bytesLeftInBuffer = 0;
    private int buffer = 0;

    public Base64InputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeftInBuffer == 0) {
            this.bytesLeftInBuffer = 3;
            for (int i = 0; i < 4; ++i) {
                int c = this.delegate.read();
                this.buffer <<= 6;
                if (c < 0) {
                    if (i == 0) {
                        this.bytesLeftInBuffer = 0;
                        return -1;
                    }
                    throw new EOFException();
                }
                if (this.bytesLeftInBuffer == 2) {
                    if (c == 61) {
                        this.bytesLeftInBuffer = 1;
                        continue;
                    }
                    throw new IOException("Non-padding in Base64 stream after padding had started.");
                }
                int b = DECODING_TABLE[c];
                if (b == -2) {
                    if (i <= 1) {
                        throw new IOException("Base 64 padding in a bad position.");
                    }
                    this.bytesLeftInBuffer = 2;
                    continue;
                }
                if (b == -1) {
                    throw new IOException("Non-Base64 input: \u201c0x" + Integer.toHexString(c) + "\u201d.");
                }
                this.buffer |= b;
            }
        }
        int rv = (this.buffer & 0xFF0000) >> 16;
        this.buffer <<= 8;
        --this.bytesLeftInBuffer;
        return rv;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    static {
        for (int i = 0; i < DECODING_TABLE.length; ++i) {
            Base64InputStream.DECODING_TABLE[i] = i >= 65 && i <= 90 ? i - 65 : (i >= 97 && i <= 122 ? i - 97 + 26 : (i >= 48 && i <= 57 ? i - 48 + 52 : (i == 43 ? 62 : (i == 47 ? 63 : (i == 61 ? -2 : -1)))));
        }
    }
}

