/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import com.ibm.icu.text.Normalizer;
import com.thaiopensource.relaxng.exceptions.AbstractValidationException;
import com.thaiopensource.relaxng.exceptions.BadAttributeValueException;
import com.thaiopensource.relaxng.exceptions.ImpossibleAttributeIgnoredException;
import com.thaiopensource.relaxng.exceptions.OnlyTextNotAllowedException;
import com.thaiopensource.relaxng.exceptions.OutOfContextElementException;
import com.thaiopensource.relaxng.exceptions.RequiredAttributesMissingException;
import com.thaiopensource.relaxng.exceptions.RequiredAttributesMissingOneOfException;
import com.thaiopensource.relaxng.exceptions.RequiredElementsMissingException;
import com.thaiopensource.relaxng.exceptions.RequiredElementsMissingOneOfException;
import com.thaiopensource.relaxng.exceptions.StringNotAllowedException;
import com.thaiopensource.relaxng.exceptions.TextNotAllowedException;
import com.thaiopensource.relaxng.exceptions.UnfinishedElementException;
import com.thaiopensource.relaxng.exceptions.UnfinishedElementOneOfException;
import com.thaiopensource.relaxng.exceptions.UnknownElementException;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import nu.validator.checker.DatatypeMismatchException;
import nu.validator.checker.NormalizationChecker;
import nu.validator.checker.VnuBadAttrValueException;
import nu.validator.checker.VnuBadElementNameException;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.io.DataUri;
import nu.validator.io.SystemIdIOException;
import nu.validator.messages.GnuMessageEmitter;
import nu.validator.messages.ImageReviewHandler;
import nu.validator.messages.MessageEmitter;
import nu.validator.messages.MessageTextHandler;
import nu.validator.messages.Result;
import nu.validator.messages.ResultHandler;
import nu.validator.messages.TooManyErrorsException;
import nu.validator.messages.types.MessageType;
import nu.validator.saxtree.DocumentFragment;
import nu.validator.saxtree.Node;
import nu.validator.saxtree.TreeParser;
import nu.validator.servlet.imagereview.Image;
import nu.validator.servlet.imagereview.ImageCollector;
import nu.validator.source.Location;
import nu.validator.source.SourceCode;
import nu.validator.source.SourceHandler;
import nu.validator.spec.EmptySpec;
import nu.validator.spec.Spec;
import nu.validator.spec.html5.Html5AttributeDatatypeBuilder;
import nu.validator.spec.html5.ImageReportAdviceBuilder;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.CharacterUtil;
import nu.validator.xml.XhtmlSaxEmitter;
import org.apache.log4j.Logger;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MessageEmitterAdapter
implements ErrorHandler {
    private static final Logger log4j = Logger.getLogger(MessageEmitterAdapter.class);
    private static final Map<String, char[]> WELL_KNOWN_NAMESPACES = new HashMap<String, char[]>();
    private static final Map<Class, DocumentFragment> HTML5_DATATYPE_ADVICE;
    private static final DocumentFragment IMAGE_REPORT_GENERAL;
    private static final DocumentFragment IMAGE_REPORT_EMPTY;
    private static final DocumentFragment NO_ALT_NO_LINK_ADVICE;
    private static final DocumentFragment NO_ALT_LINK_ADVICE;
    private static final DocumentFragment EMPTY_ALT_ADVICE;
    private static final DocumentFragment HAS_ALT_ADVICE;
    private static final DocumentFragment IMAGE_REPORT_FATAL;
    private static final String SPEC_LINK_URI;
    private static final long MAX_MESSAGES;
    private static final Map<String, String[]> validInputTypesByAttributeName;
    private static final Map<String, String> fragmentIdByInputType;
    private static final char[] INDETERMINATE_MESSAGE;
    private static final char[] ELEMENT_SPECIFIC_ATTRIBUTES_BEFORE;
    private static final char[] ELEMENT_SPECIFIC_ATTRIBUTES_AFTER;
    private static final char[] CONTENT_MODEL_BEFORE;
    private static final char[] CONTENT_MODEL_AFTER;
    private static final char[] CONTEXT_BEFORE;
    private static final char[] CONTEXT_AFTER;
    private static final char[] BAD_VALUE;
    private static final char[] POTENTIALLY_BAD_VALUE;
    private static final char[] BAD_ELEMENT_NAME;
    private static final char[] POTENTIALLY_BAD_ELEMENT_NAME;
    private static final char[] FOR;
    private static final char[] ATTRIBUTE;
    private static final char[] FROM_NAMESPACE;
    private static final char[] SPACE;
    private static final char[] ON;
    private static final char[] ELEMENT;
    private static final char[] PERIOD;
    private static final char[] COMMA;
    private static final char[] COLON;
    private static final char[] NOT_ALLOWED_ON;
    private static final char[] AT_THIS_POINT;
    private static final char[] ONLY_TEXT;
    private static final char[] NOT_ALLOWED;
    private static final char[] AS_CHILD_OF;
    private static final char[] IN_THIS_CONTEXT_SUPPRESSING;
    private static final char[] REQUIRED_ATTRIBUTES_MISSING;
    private static final char[] REQUIRED_ATTRIBUTES_MISSING_ONE_OF;
    private static final char[] REQUIRED_ELEMENTS_MISSING;
    private static final char[] IS_MISSING_A_REQUIRED_CHILD;
    private static final char[] REQUIRED_CHILDREN_MISSING_FROM;
    private static final char[] REQUIRED_CHILDREN_MISSING_ONE_OF_FROM;
    private static final char[] BAD_CHARACTER_CONTENT;
    private static final char[] IN_THIS_CONTEXT;
    private static final char[] TEXT_NOT_ALLOWED_IN;
    private static final char[] UNKNOWN;
    private static final char[] NO_ALT_NO_LINK_HEADING;
    private static final char[] NO_ALT_LINK_HEADING;
    private static final char[] EMPTY_ALT;
    private static final char[] HAS_ALT;
    private static final String[] DEFAULT_FILTER_STRINGS;
    protected static final Pattern DEFAULT_FILTER_PATTERN;
    protected static final Pattern FILE_NOT_CHECKED;
    private final AttributesImpl attributesImpl = new AttributesImpl();
    private final char[] oneChar = new char[]{'\u0000'};
    private int warnings = 0;
    private int errors = 0;
    private int fatalErrors = 0;
    private final boolean batchMode;
    private int nonDocumentErrors = 0;
    private final Pattern filterPattern;
    private final SourceCode sourceCode;
    private final MessageEmitter emitter;
    private final ExactErrorHandler exactErrorHandler;
    private final boolean showSource;
    private final ImageCollector imageCollector;
    private int lineOffset;
    private Spec spec = EmptySpec.THE_INSTANCE;
    private boolean html = false;
    private boolean loggingOk = false;
    private boolean errorsOnly = false;

    protected static String scrub(String s) throws SAXException {
        if (s == null) {
            return null;
        }
        if (NormalizationChecker.startsWithComposingChar(s = CharacterUtil.prudentlyScrubCharacterData(s))) {
            s = " " + s;
        }
        return Normalizer.normalize((String)s, (Normalizer.Mode)Normalizer.NFC, (int)0);
    }

    private StringBuilder zapLf(StringBuilder builder) {
        int len = builder.length();
        for (int i = 0; i < len; ++i) {
            char c = builder.charAt(i);
            if (c != '\n' && c != '\r') continue;
            builder.setCharAt(i, ' ');
        }
        return builder;
    }

    private void throwIfTooManyMessages() throws SAXException {
        if (!this.batchMode && (long)(this.warnings + this.errors) > MAX_MESSAGES) {
            throw new TooManyErrorsException("Too many messages.");
        }
    }

    public MessageEmitterAdapter(Pattern filterPattern, SourceCode sourceCode, boolean showSource, ImageCollector imageCollector, int lineOffset, boolean batchMode, MessageEmitter messageEmitter) {
        this.filterPattern = filterPattern;
        this.sourceCode = sourceCode;
        this.emitter = messageEmitter;
        this.exactErrorHandler = new ExactErrorHandler(this);
        this.showSource = showSource;
        this.lineOffset = lineOffset;
        this.batchMode = batchMode;
        this.imageCollector = imageCollector;
    }

    public MessageEmitterAdapter() {
        this.filterPattern = null;
        this.sourceCode = null;
        this.emitter = null;
        this.exactErrorHandler = null;
        this.showSource = false;
        this.lineOffset = 0;
        this.batchMode = false;
        this.imageCollector = null;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getFatalErrors() {
        return this.fatalErrors;
    }

    public int getWarnings() {
        return this.warnings;
    }

    private boolean isErrors() {
        return this.errors != 0 || this.fatalErrors != 0;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.warning(e, false);
    }

    private void warning(SAXParseException e, boolean exact) throws SAXException {
        if (!this.batchMode && this.fatalErrors > 0 || this.nonDocumentErrors > 0) {
            return;
        }
        if (!FILE_NOT_CHECKED.matcher(e.getMessage()).matches()) {
            ++this.warnings;
        }
        this.throwIfTooManyMessages();
        this.messageFromSAXParseException(MessageType.WARNING, e, exact, null);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.error(e, false);
    }

    private void error(SAXParseException e, boolean exact) throws SAXException {
        if (!this.batchMode && this.fatalErrors > 0 || this.nonDocumentErrors > 0) {
            return;
        }
        Map<String, DatatypeException> datatypeErrors = null;
        if (e instanceof BadAttributeValueException) {
            datatypeErrors = ((BadAttributeValueException)e).getExceptions();
        }
        if (e instanceof VnuBadAttrValueException) {
            datatypeErrors = ((VnuBadAttrValueException)e).getExceptions();
        }
        if (e instanceof VnuBadElementNameException) {
            datatypeErrors = ((VnuBadElementNameException)e).getExceptions();
        }
        if (e instanceof DatatypeMismatchException) {
            datatypeErrors = ((DatatypeMismatchException)e).getExceptions();
        }
        if (datatypeErrors != null) {
            for (Map.Entry<String, DatatypeException> entry : datatypeErrors.entrySet()) {
                Html5DatatypeException ex5;
                DatatypeException dex = entry.getValue();
                if (!(dex instanceof Html5DatatypeException) || !(ex5 = (Html5DatatypeException)dex).isWarning()) continue;
                ++this.warnings;
                this.throwIfTooManyMessages();
                this.messageFromSAXParseException(MessageType.WARNING, e, exact, null);
                return;
            }
        }
        ++this.errors;
        this.throwIfTooManyMessages();
        this.messageFromSAXParseException(MessageType.ERROR, e, exact, null);
    }

    public void errorWithStart(SAXParseException e, int[] start) throws SAXException {
        if (!this.batchMode && this.fatalErrors > 0 || this.nonDocumentErrors > 0) {
            return;
        }
        ++this.errors;
        this.throwIfTooManyMessages();
        int startLine = start[0];
        int startColumn = start[1];
        int lastLine = e.getLineNumber();
        int lastColumn = e.getColumnNumber();
        boolean exact = startLine == lastLine && startColumn == lastColumn;
        this.messageFromSAXParseException(MessageType.ERROR, e, exact, start);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.fatalError(e, false);
    }

    private void fatalError(SAXParseException e, boolean exact) throws SAXException {
        if (!this.batchMode && this.fatalErrors > 0 || this.nonDocumentErrors > 0) {
            return;
        }
        ++this.fatalErrors;
        Exception wrapped = e.getException();
        String systemId = null;
        if (wrapped instanceof SystemIdIOException) {
            SystemIdIOException siie = (SystemIdIOException)wrapped;
            systemId = siie.getSystemId();
        }
        if (wrapped instanceof IOException) {
            this.message(MessageType.IO, wrapped, systemId, -1, -1, false, null);
        } else {
            this.messageFromSAXParseException(MessageType.FATAL, e, exact, null);
        }
    }

    public void info(String str) throws SAXException {
        if (this.emitter instanceof GnuMessageEmitter) {
            return;
        }
        this.message(MessageType.INFO, new Exception(str), null, -1, -1, false, null);
    }

    public void ioError(IOException e) throws SAXException {
        ++this.nonDocumentErrors;
        String systemId = null;
        if (e instanceof SystemIdIOException) {
            SystemIdIOException siie = (SystemIdIOException)e;
            systemId = siie.getSystemId();
        }
        this.message(MessageType.IO, e, systemId, -1, -1, false, null);
    }

    public void internalError(Throwable e, String message) throws SAXException {
        ++this.nonDocumentErrors;
        this.message(MessageType.INTERNAL, new Exception(message), null, -1, -1, false, null);
    }

    public void schemaError(Exception e) throws SAXException {
        ++this.nonDocumentErrors;
        this.message(MessageType.SCHEMA, e, null, -1, -1, false, null);
    }

    public void start(String documentUri) throws SAXException {
        this.emitter.startMessages(MessageEmitterAdapter.scrub(this.shortenDataUri(documentUri)), this.showSource);
    }

    private String shortenDataUri(String uri) {
        if (DataUri.startsWithData(uri)) {
            return "data:\u2026";
        }
        return uri;
    }

    public void end(String successMessage, String failureMessage, String language) throws SAXException {
        ResultHandler resultHandler = this.emitter.startResult();
        if (resultHandler != null) {
            if (this.isIndeterminate()) {
                resultHandler.startResult(Result.INDETERMINATE);
                resultHandler.characters(INDETERMINATE_MESSAGE, 0, INDETERMINATE_MESSAGE.length);
                resultHandler.endResult();
            } else if (this.isErrors()) {
                resultHandler.startResult(Result.FAILURE);
                resultHandler.characters(failureMessage.toCharArray(), 0, failureMessage.length());
                resultHandler.endResult();
            } else {
                resultHandler.startResult(Result.SUCCESS);
                resultHandler.characters(successMessage.toCharArray(), 0, successMessage.length());
                resultHandler.endResult();
            }
        }
        this.emitter.endResult();
        if (this.imageCollector != null) {
            DocumentFragment instruction = IMAGE_REPORT_GENERAL;
            boolean fatal = false;
            if (this.getFatalErrors() > 0) {
                fatal = true;
                instruction = IMAGE_REPORT_FATAL;
            } else if (this.imageCollector.isEmpty()) {
                instruction = IMAGE_REPORT_EMPTY;
            }
            ImageReviewHandler imageReviewHandler = this.emitter.startImageReview(instruction, fatal);
            if (imageReviewHandler != null && !fatal) {
                this.emitImageReview(imageReviewHandler);
            }
            this.emitter.endImageReview();
        }
        if (this.showSource) {
            SourceHandler sourceHandler = this.emitter.startFullSource(this.lineOffset);
            if (sourceHandler != null) {
                this.sourceCode.emitSource(sourceHandler);
            }
            this.emitter.endFullSource();
        }
        this.emitter.endMessages(language);
    }

    private void emitImageReview(ImageReviewHandler imageReviewHandler) throws SAXException {
        LinkedList<Image> noAltNoLink = new LinkedList<Image>();
        LinkedList<Image> noAltLink = new LinkedList<Image>();
        LinkedList<Image> emptyAlt = new LinkedList<Image>();
        LinkedList<Image> hasAlt = new LinkedList<Image>();
        for (Image image : this.imageCollector) {
            String alt = image.getAlt();
            if (alt == null) {
                if (image.isLinked()) {
                    noAltLink.add(image);
                    continue;
                }
                noAltNoLink.add(image);
                continue;
            }
            if ("".equals(alt)) {
                emptyAlt.add(image);
                continue;
            }
            hasAlt.add(image);
        }
        this.emitImageList(imageReviewHandler, noAltLink, NO_ALT_LINK_HEADING, NO_ALT_LINK_ADVICE, false);
        this.emitImageList(imageReviewHandler, noAltNoLink, NO_ALT_NO_LINK_HEADING, NO_ALT_NO_LINK_ADVICE, false);
        this.emitImageList(imageReviewHandler, emptyAlt, EMPTY_ALT, EMPTY_ALT_ADVICE, false);
        this.emitImageList(imageReviewHandler, hasAlt, HAS_ALT, HAS_ALT_ADVICE, true);
    }

    private void emitImageList(ImageReviewHandler imageReviewHandler, List<Image> list, char[] heading, DocumentFragment instruction, boolean hasAlt) throws SAXException {
        if (!list.isEmpty()) {
            imageReviewHandler.startImageGroup(heading, instruction, hasAlt);
            for (Image image : list) {
                int oneBasedColumn;
                String systemId = image.getSystemId();
                int oneBasedLine = image.getLineNumber();
                Location rangeLast = this.sourceCode.newLocatorLocation(oneBasedLine, oneBasedColumn = image.getColumnNumber());
                if (this.sourceCode.isWithinKnownSource(rangeLast)) {
                    Location rangeStart = this.sourceCode.rangeStartForRangeLast(rangeLast);
                    imageReviewHandler.image(image, hasAlt, systemId, rangeStart.getLine() + 1, rangeStart.getColumn() + 1, oneBasedLine, oneBasedColumn);
                    continue;
                }
                imageReviewHandler.image(image, hasAlt, systemId, -1, -1, -1, -1);
            }
            imageReviewHandler.endImageGroup();
        }
    }

    private boolean isIndeterminate() {
        return this.nonDocumentErrors > 0;
    }

    private void messageFromSAXParseException(MessageType type, SAXParseException spe, boolean exact, int[] start) throws SAXException {
        int lineNumber = spe.getLineNumber() == 0 ? -1 : spe.getLineNumber();
        this.message(type, spe, spe.getSystemId(), lineNumber, spe.getColumnNumber(), exact, start);
    }

    private void message(MessageType type, Exception message, String systemId, int oneBasedLine, int oneBasedColumn, boolean exact, int[] start) throws SAXException {
        String msg = message.getMessage();
        if (msg != null && (this.filterPattern != null && this.filterPattern.matcher(msg).matches() || DEFAULT_FILTER_PATTERN.matcher(msg).matches())) {
            if (type.getSuperType() == "error" && this.errors > 0) {
                --this.errors;
            } else if (type.getSubType() == "warning" && this.warnings > 0) {
                --this.warnings;
            }
            return;
        }
        if (this.loggingOk && type.getSuperType() == "error" && this.spec != EmptySpec.THE_INSTANCE && systemId != null && msg != null && (systemId.startsWith("http:") || systemId.startsWith("https:"))) {
            log4j.info((Object)this.zapLf(new StringBuilder().append(systemId).append('\t').append(msg)));
        }
        if (this.errorsOnly && type.getSuperType() == "info") {
            return;
        }
        String uri = this.sourceCode.getUri();
        if (oneBasedLine > -1 && (uri == systemId || uri != null && uri.equals(systemId))) {
            if (oneBasedColumn > -1) {
                if (exact) {
                    this.messageWithExact(type, message, systemId, oneBasedLine, oneBasedColumn, start);
                } else {
                    this.messageWithRange(type, message, systemId, oneBasedLine, oneBasedColumn, start);
                }
            } else {
                this.messageWithLine(type, message, systemId, oneBasedLine);
            }
        } else {
            this.messageWithoutExtract(type, message, systemId, oneBasedLine, oneBasedColumn);
        }
    }

    private void messageWithRange(MessageType type, Exception message, String systemId, int oneBasedLine, int oneBasedColumn, int[] start) throws SAXException {
        if (start != null && !this.sourceCode.getIsCss()) {
            oneBasedColumn += start[2];
        }
        systemId = this.batchMode ? systemId : null;
        Location rangeLast = this.sourceCode.newLocatorLocation(oneBasedLine, oneBasedColumn);
        if (!this.sourceCode.isWithinKnownSource(rangeLast)) {
            this.messageWithoutExtract(type, message, null, oneBasedLine, oneBasedColumn);
            return;
        }
        Location rangeStart = this.sourceCode.rangeStartForRangeLast(rangeLast);
        if (start != null) {
            rangeStart = this.sourceCode.getIsCss() ? this.sourceCode.newLocatorLocation(start[0], start[1]) : this.sourceCode.newLocatorLocation(start[0], start[1] + start[2]);
        }
        this.startMessage(type, MessageEmitterAdapter.scrub(this.shortenDataUri(systemId)), rangeStart.getLine() + 1, rangeStart.getColumn() + 1, oneBasedLine, oneBasedColumn, false);
        this.messageText(message);
        SourceHandler sourceHandler = this.emitter.startSource();
        if (sourceHandler != null) {
            if (start != null) {
                this.sourceCode.addLocatorLocation(rangeStart.getLine() + 1, rangeStart.getColumn());
            }
            this.sourceCode.rangeEndError(rangeStart, rangeLast, sourceHandler);
        }
        this.emitter.endSource();
        this.elaboration(message);
        this.endMessage();
    }

    private void messageWithExact(MessageType type, Exception message, String systemId, int oneBasedLine, int oneBasedColumn, int[] start) throws SAXException {
        if (start != null && !this.sourceCode.getIsCss()) {
            oneBasedColumn += start[2];
        }
        systemId = this.batchMode ? systemId : null;
        this.startMessage(type, MessageEmitterAdapter.scrub(this.shortenDataUri(systemId)), oneBasedLine, oneBasedColumn, oneBasedLine, oneBasedColumn, true);
        this.messageText(message);
        Location location = this.sourceCode.newLocatorLocation(oneBasedLine, oneBasedColumn);
        if (this.sourceCode.isWithinKnownSource(location)) {
            SourceHandler sourceHandler = this.emitter.startSource();
            if (sourceHandler != null) {
                this.sourceCode.exactError(location, sourceHandler);
            }
            this.emitter.endSource();
        } else {
            this.sourceCode.rememberExactError(location);
        }
        this.elaboration(message);
        this.endMessage();
    }

    private void messageWithLine(MessageType type, Exception message, String systemId, int oneBasedLine) throws SAXException {
        String string = systemId = this.batchMode ? systemId : null;
        if (!this.sourceCode.isWithinKnownSource(oneBasedLine)) {
            throw new RuntimeException("Bug. Line out of range!");
        }
        this.startMessage(type, MessageEmitterAdapter.scrub(this.shortenDataUri(systemId)), oneBasedLine, -1, oneBasedLine, -1, false);
        this.messageText(message);
        SourceHandler sourceHandler = this.emitter.startSource();
        if (sourceHandler != null) {
            this.sourceCode.lineError(oneBasedLine, sourceHandler);
        }
        this.emitter.endSource();
        this.elaboration(message);
        this.endMessage();
    }

    private void messageWithoutExtract(MessageType type, Exception message, String systemId, int oneBasedLine, int oneBasedColumn) throws SAXException {
        if (systemId == null) {
            systemId = this.sourceCode.getUri();
        }
        this.startMessage(type, MessageEmitterAdapter.scrub(this.shortenDataUri(systemId)), oneBasedLine, oneBasedColumn, oneBasedLine, oneBasedColumn, false);
        this.messageText(message);
        this.elaboration(message);
        this.endMessage();
    }

    private void messageText(Exception message) throws SAXException {
        if (message instanceof AbstractValidationException) {
            AbstractValidationException ave = (AbstractValidationException)message;
            this.rngMessageText(ave);
        } else if (message instanceof VnuBadAttrValueException) {
            VnuBadAttrValueException e = (VnuBadAttrValueException)message;
            this.vnuBadAttrValueMessageText(e);
        } else if (message instanceof VnuBadElementNameException) {
            VnuBadElementNameException e = (VnuBadElementNameException)message;
            this.vnuElementNameMessageText(e);
        } else {
            String msg = message.getMessage();
            if (msg == null && message.getCause() != null) {
                msg = message.getCause().getMessage();
            }
            if (msg != null) {
                MessageTextHandler messageTextHandler = this.emitter.startText();
                if (messageTextHandler != null) {
                    this.emitStringWithQurlyQuotes(messageTextHandler, msg);
                }
                this.emitter.endText();
            }
        }
    }

    private void vnuBadAttrValueMessageText(VnuBadAttrValueException e) throws SAXException {
        MessageTextHandler messageTextHandler = this.emitter.startText();
        if (messageTextHandler != null) {
            boolean isWarning = false;
            Map<String, DatatypeException> datatypeErrors = e.getExceptions();
            for (Map.Entry<String, DatatypeException> entry : datatypeErrors.entrySet()) {
                Html5DatatypeException ex5;
                DatatypeException dex = entry.getValue();
                if (!(dex instanceof Html5DatatypeException) || !(ex5 = (Html5DatatypeException)dex).isWarning()) continue;
                isWarning = true;
            }
            if (isWarning) {
                this.messageTextString(messageTextHandler, POTENTIALLY_BAD_VALUE, false);
            } else {
                this.messageTextString(messageTextHandler, BAD_VALUE, false);
            }
            if (e.getAttributeValue().length() < 200) {
                this.codeString(messageTextHandler, e.getAttributeValue());
            }
            this.messageTextString(messageTextHandler, FOR, false);
            this.attribute(messageTextHandler, e.getAttributeName(), e.getCurrentElement(), false);
            this.messageTextString(messageTextHandler, ON, false);
            this.element(messageTextHandler, e.getCurrentElement(), false);
            this.emitDatatypeErrors(messageTextHandler, e.getExceptions());
        }
        this.emitter.endText();
    }

    private void vnuElementNameMessageText(VnuBadElementNameException e) throws SAXException {
        MessageTextHandler messageTextHandler = this.emitter.startText();
        if (messageTextHandler != null) {
            boolean isWarning = false;
            Map<String, DatatypeException> datatypeErrors = e.getExceptions();
            for (Map.Entry<String, DatatypeException> entry : datatypeErrors.entrySet()) {
                Html5DatatypeException ex5;
                DatatypeException dex = entry.getValue();
                if (!(dex instanceof Html5DatatypeException) || !(ex5 = (Html5DatatypeException)dex).isWarning()) continue;
                isWarning = true;
            }
            if (isWarning) {
                this.messageTextString(messageTextHandler, POTENTIALLY_BAD_ELEMENT_NAME, false);
            } else {
                this.messageTextString(messageTextHandler, BAD_ELEMENT_NAME, false);
            }
            this.messageTextString(messageTextHandler, SPACE, false);
            this.codeString(messageTextHandler, e.getElementName());
            this.emitDatatypeErrors(messageTextHandler, e.getExceptions());
        }
        this.emitter.endText();
    }

    private void rngMessageText(AbstractValidationException e) throws SAXException {
        MessageTextHandler messageTextHandler = this.emitter.startText();
        if (messageTextHandler != null) {
            if (e instanceof BadAttributeValueException) {
                BadAttributeValueException ex = (BadAttributeValueException)e;
                boolean isWarning = false;
                Map datatypeErrors = ex.getExceptions();
                for (Map.Entry entry : datatypeErrors.entrySet()) {
                    Html5DatatypeException ex5;
                    DatatypeException dex = (DatatypeException)((Object)entry.getValue());
                    if (!(dex instanceof Html5DatatypeException) || !(ex5 = (Html5DatatypeException)dex).isWarning()) continue;
                    isWarning = true;
                }
                if (isWarning) {
                    this.messageTextString(messageTextHandler, POTENTIALLY_BAD_VALUE, false);
                } else {
                    this.messageTextString(messageTextHandler, BAD_VALUE, false);
                }
                if (ex.getAttributeValue().length() < 200) {
                    this.codeString(messageTextHandler, ex.getAttributeValue());
                }
                this.messageTextString(messageTextHandler, FOR, false);
                this.attribute(messageTextHandler, ex.getAttributeName(), ex.getCurrentElement(), false);
                this.messageTextString(messageTextHandler, ON, false);
                this.element(messageTextHandler, ex.getCurrentElement(), false);
                this.emitDatatypeErrors(messageTextHandler, ex.getExceptions());
            } else if (e instanceof ImpossibleAttributeIgnoredException) {
                ImpossibleAttributeIgnoredException ex = (ImpossibleAttributeIgnoredException)e;
                this.attribute(messageTextHandler, ex.getAttributeName(), ex.getCurrentElement(), true);
                this.messageTextString(messageTextHandler, NOT_ALLOWED_ON, false);
                this.element(messageTextHandler, ex.getCurrentElement(), false);
                this.messageTextString(messageTextHandler, AT_THIS_POINT, false);
            } else if (e instanceof OnlyTextNotAllowedException) {
                OnlyTextNotAllowedException ex = (OnlyTextNotAllowedException)e;
                this.element(messageTextHandler, ex.getCurrentElement(), true);
                this.messageTextString(messageTextHandler, ONLY_TEXT, false);
            } else if (e instanceof OutOfContextElementException) {
                OutOfContextElementException ex = (OutOfContextElementException)e;
                this.element(messageTextHandler, ex.getCurrentElement(), true);
                this.messageTextString(messageTextHandler, NOT_ALLOWED, false);
                if (ex.getParent() != null) {
                    this.messageTextString(messageTextHandler, AS_CHILD_OF, false);
                    this.element(messageTextHandler, ex.getParent(), false);
                }
                this.messageTextString(messageTextHandler, IN_THIS_CONTEXT_SUPPRESSING, false);
            } else if (e instanceof RequiredAttributesMissingOneOfException) {
                RequiredAttributesMissingOneOfException ex = (RequiredAttributesMissingOneOfException)e;
                this.element(messageTextHandler, ex.getCurrentElement(), true);
                this.messageTextString(messageTextHandler, REQUIRED_ATTRIBUTES_MISSING_ONE_OF, false);
                Iterator iter = ex.getAttributeLocalNames().iterator();
                while (iter.hasNext()) {
                    this.codeString(messageTextHandler, (String)iter.next());
                    if (!iter.hasNext()) continue;
                    this.messageTextString(messageTextHandler, COMMA, false);
                }
                this.messageTextString(messageTextHandler, PERIOD, false);
            } else if (e instanceof RequiredAttributesMissingException) {
                RequiredAttributesMissingException ex = (RequiredAttributesMissingException)e;
                this.element(messageTextHandler, ex.getCurrentElement(), true);
                this.messageTextString(messageTextHandler, REQUIRED_ATTRIBUTES_MISSING, false);
                this.codeString(messageTextHandler, ex.getAttributeLocalName());
                this.messageTextString(messageTextHandler, PERIOD, false);
            } else if (e instanceof RequiredElementsMissingException) {
                RequiredElementsMissingException ex = (RequiredElementsMissingException)e;
                if (ex.getParent() == null) {
                    this.messageTextString(messageTextHandler, REQUIRED_ELEMENTS_MISSING, false);
                } else {
                    this.element(messageTextHandler, ex.getParent(), true);
                    if (ex.getMissingElementName() == null) {
                        this.messageTextString(messageTextHandler, IS_MISSING_A_REQUIRED_CHILD, false);
                    } else {
                        this.messageTextString(messageTextHandler, REQUIRED_CHILDREN_MISSING_FROM, false);
                        this.codeString(messageTextHandler, ex.getMissingElementName());
                    }
                    this.messageTextString(messageTextHandler, PERIOD, false);
                }
            } else if (e instanceof StringNotAllowedException) {
                StringNotAllowedException ex = (StringNotAllowedException)e;
                this.messageTextString(messageTextHandler, BAD_CHARACTER_CONTENT, false);
                this.codeString(messageTextHandler, ex.getValue());
                this.messageTextString(messageTextHandler, FOR, false);
                this.element(messageTextHandler, ex.getCurrentElement(), false);
                this.emitDatatypeErrors(messageTextHandler, ex.getExceptions());
            } else if (e instanceof TextNotAllowedException) {
                TextNotAllowedException ex = (TextNotAllowedException)e;
                this.messageTextString(messageTextHandler, TEXT_NOT_ALLOWED_IN, false);
                this.element(messageTextHandler, ex.getCurrentElement(), false);
                this.messageTextString(messageTextHandler, IN_THIS_CONTEXT, false);
            } else if (e instanceof UnfinishedElementException) {
                UnfinishedElementException ex = (UnfinishedElementException)e;
                this.element(messageTextHandler, ex.getCurrentElement(), true);
                if (ex.getMissingElementName() == null) {
                    this.messageTextString(messageTextHandler, IS_MISSING_A_REQUIRED_CHILD, false);
                } else {
                    this.messageTextString(messageTextHandler, REQUIRED_CHILDREN_MISSING_FROM, false);
                    this.codeString(messageTextHandler, ex.getMissingElementName());
                }
                this.messageTextString(messageTextHandler, PERIOD, false);
            } else if (e instanceof UnfinishedElementOneOfException) {
                UnfinishedElementOneOfException ex = (UnfinishedElementOneOfException)e;
                this.element(messageTextHandler, ex.getCurrentElement(), true);
                this.messageTextString(messageTextHandler, REQUIRED_CHILDREN_MISSING_ONE_OF_FROM, false);
                Iterator iter = ex.getMissingElementNames().iterator();
                while (iter.hasNext()) {
                    String missingElementName = (String)iter.next();
                    if ("http://www.w3.org/1999/xhtml".equals(ex.getCurrentElement().getNamespaceUri()) && "frameset".equals(missingElementName)) continue;
                    this.codeString(messageTextHandler, missingElementName);
                    if (!iter.hasNext()) continue;
                    this.messageTextString(messageTextHandler, COMMA, false);
                }
                this.messageTextString(messageTextHandler, PERIOD, false);
            } else if (e instanceof RequiredElementsMissingOneOfException) {
                RequiredElementsMissingOneOfException ex = (RequiredElementsMissingOneOfException)e;
                this.element(messageTextHandler, ex.getParent(), true);
                this.messageTextString(messageTextHandler, REQUIRED_CHILDREN_MISSING_ONE_OF_FROM, false);
                Iterator iter = ex.getMissingElementNames().iterator();
                while (iter.hasNext()) {
                    String missingElementName = (String)iter.next();
                    if ("http://www.w3.org/1999/xhtml".equals(ex.getCurrentElement().getNamespaceUri()) && "frameset".equals(missingElementName)) continue;
                    this.codeString(messageTextHandler, missingElementName);
                    if (!iter.hasNext()) continue;
                    this.messageTextString(messageTextHandler, COMMA, false);
                }
                this.messageTextString(messageTextHandler, PERIOD, false);
            } else if (e instanceof UnknownElementException) {
                UnknownElementException ex = (UnknownElementException)e;
                this.messageTextString(messageTextHandler, UNKNOWN, false);
                this.element(messageTextHandler, ex.getCurrentElement(), false);
                this.messageTextString(messageTextHandler, NOT_ALLOWED, false);
                if (ex.getParent() != null) {
                    this.messageTextString(messageTextHandler, AS_CHILD_OF, false);
                    this.element(messageTextHandler, ex.getParent(), false);
                }
                this.messageTextString(messageTextHandler, PERIOD, false);
            }
        }
        this.emitter.endText();
    }

    private void emitDatatypeErrors(MessageTextHandler messageTextHandler, Map<String, DatatypeException> datatypeErrors) throws SAXException {
        if (datatypeErrors.isEmpty()) {
            this.messageTextString(messageTextHandler, PERIOD, false);
        } else {
            this.messageTextString(messageTextHandler, COLON, false);
            for (Map.Entry<String, DatatypeException> entry : datatypeErrors.entrySet()) {
                this.messageTextString(messageTextHandler, SPACE, false);
                DatatypeException ex = entry.getValue();
                if (ex instanceof Html5DatatypeException) {
                    Html5DatatypeException ex5 = (Html5DatatypeException)ex;
                    String[] segments = ex5.getSegments();
                    for (int i = 0; i < segments.length; ++i) {
                        String segment = segments[i];
                        if (i % 2 == 0) {
                            this.emitStringWithQurlyQuotes(messageTextHandler, segment);
                            continue;
                        }
                        String scrubbed = MessageEmitterAdapter.scrub(segment);
                        messageTextHandler.startCode();
                        messageTextHandler.characters(scrubbed.toCharArray(), 0, scrubbed.length());
                        messageTextHandler.endCode();
                    }
                    continue;
                }
                this.emitStringWithQurlyQuotes(messageTextHandler, ex.getMessage());
            }
        }
    }

    private void element(MessageTextHandler messageTextHandler, Name element, boolean atSentenceStart) throws SAXException {
        if (this.html) {
            this.messageTextString(messageTextHandler, ELEMENT, atSentenceStart);
            this.linkedCodeString(messageTextHandler, element.getLocalName(), this.spec.elementLink(element));
        } else {
            String ns = element.getNamespaceUri();
            char[] humanReadable = WELL_KNOWN_NAMESPACES.get(ns);
            if (humanReadable == null) {
                if (this.loggingOk) {
                    log4j.info((Object)new StringBuilder().append("UNKNOWN_NS:\t").append(ns));
                }
                this.messageTextString(messageTextHandler, ELEMENT, atSentenceStart);
                this.linkedCodeString(messageTextHandler, element.getLocalName(), this.spec.elementLink(element));
                this.messageTextString(messageTextHandler, FROM_NAMESPACE, false);
                this.codeString(messageTextHandler, ns);
            } else {
                this.messageTextString(messageTextHandler, humanReadable, atSentenceStart);
                this.messageTextString(messageTextHandler, SPACE, false);
                this.messageTextString(messageTextHandler, ELEMENT, false);
                this.linkedCodeString(messageTextHandler, element.getLocalName(), this.spec.elementLink(element));
            }
        }
    }

    private void linkedCodeString(MessageTextHandler messageTextHandler, String str, String url) throws SAXException {
        if (url != null) {
            messageTextHandler.startLink(url, null);
        }
        this.codeString(messageTextHandler, str);
        if (url != null) {
            messageTextHandler.endLink();
        }
    }

    private void attribute(MessageTextHandler messageTextHandler, Name attributeName, Name elementName, boolean atSentenceStart) throws SAXException {
        String ns = attributeName.getNamespaceUri();
        if (this.html || "".equals(ns)) {
            this.messageTextString(messageTextHandler, ATTRIBUTE, atSentenceStart);
            this.codeString(messageTextHandler, attributeName.getLocalName());
        } else if ("http://www.w3.org/XML/1998/namespace".equals(ns)) {
            this.messageTextString(messageTextHandler, ATTRIBUTE, atSentenceStart);
            this.codeString(messageTextHandler, "xml:" + attributeName.getLocalName());
        } else {
            char[] humanReadable = WELL_KNOWN_NAMESPACES.get(ns);
            if (humanReadable == null) {
                if (this.loggingOk) {
                    log4j.info((Object)new StringBuilder().append("UNKNOWN_NS:\t").append(ns));
                }
                this.messageTextString(messageTextHandler, ATTRIBUTE, atSentenceStart);
                this.codeString(messageTextHandler, attributeName.getLocalName());
                this.messageTextString(messageTextHandler, FROM_NAMESPACE, false);
                this.codeString(messageTextHandler, ns);
            } else {
                this.messageTextString(messageTextHandler, humanReadable, atSentenceStart);
                this.messageTextString(messageTextHandler, SPACE, false);
                this.messageTextString(messageTextHandler, ATTRIBUTE, false);
                this.codeString(messageTextHandler, attributeName.getLocalName());
            }
        }
    }

    private void codeString(MessageTextHandler messageTextHandler, String str) throws SAXException {
        messageTextHandler.startCode();
        messageTextHandler.characters(str.toCharArray(), 0, str.length());
        messageTextHandler.endCode();
    }

    private void messageTextString(MessageTextHandler messageTextHandler, char[] ch, boolean capitalize) throws SAXException {
        if (capitalize && ch[0] >= 'a' && ch[0] <= 'z') {
            this.oneChar[0] = (char)(ch[0] - 32);
            messageTextHandler.characters(this.oneChar, 0, 1);
            if (ch.length > 1) {
                messageTextHandler.characters(ch, 1, ch.length - 1);
            }
        } else {
            messageTextHandler.characters(ch, 0, ch.length);
        }
    }

    private void emitStringWithQurlyQuotes(MessageTextHandler messageTextHandler, String message) throws SAXException {
        if (message == null) {
            message = "";
        }
        message = MessageEmitterAdapter.scrub(message);
        int len = message.length();
        int start = 0;
        int startQuotes = 0;
        for (int i = 0; i < len; ++i) {
            char[] scrubbed;
            char c = message.charAt(i);
            if (c == '\u201c') {
                if (++startQuotes != 1) continue;
                scrubbed = MessageEmitterAdapter.scrub(message.substring(start, i)).toCharArray();
                messageTextHandler.characters(scrubbed, 0, scrubbed.length);
                start = i + 1;
                messageTextHandler.startCode();
                continue;
            }
            if (c != '\u201d' || startQuotes <= 0 || --startQuotes != 0) continue;
            scrubbed = MessageEmitterAdapter.scrub(message.substring(start, i)).toCharArray();
            messageTextHandler.characters(scrubbed, 0, scrubbed.length);
            start = i + 1;
            messageTextHandler.endCode();
        }
        if (start < len) {
            char[] scrubbed = MessageEmitterAdapter.scrub(message.substring(start, len)).toCharArray();
            messageTextHandler.characters(scrubbed, 0, scrubbed.length);
        }
        if (startQuotes > 0) {
            messageTextHandler.endCode();
        }
    }

    private void elaboration(Exception e) throws SAXException {
        if (!(e instanceof AbstractValidationException || e instanceof VnuBadAttrValueException || e instanceof VnuBadElementNameException || e instanceof DatatypeMismatchException)) {
            return;
        }
        if (e instanceof ImpossibleAttributeIgnoredException) {
            ImpossibleAttributeIgnoredException ex = (ImpossibleAttributeIgnoredException)e;
            Name elt = ex.getCurrentElement();
            this.elaborateElementSpecificAttributes(elt, ex.getAttributeName());
        } else if (e instanceof OnlyTextNotAllowedException) {
            OnlyTextNotAllowedException ex = (OnlyTextNotAllowedException)e;
            Name elt = ex.getCurrentElement();
            this.elaborateContentModel(elt);
        } else if (e instanceof OutOfContextElementException) {
            OutOfContextElementException ex = (OutOfContextElementException)e;
            Name parent = ex.getParent();
            Name child = ex.getCurrentElement();
            this.elaborateContentModelandContext(parent, child);
        } else if (e instanceof RequiredAttributesMissingException) {
            RequiredAttributesMissingException ex = (RequiredAttributesMissingException)e;
            Name elt = ex.getCurrentElement();
            this.elaborateElementSpecificAttributes(elt);
        } else if (e instanceof RequiredAttributesMissingOneOfException) {
            RequiredAttributesMissingOneOfException ex = (RequiredAttributesMissingOneOfException)e;
            Name elt = ex.getCurrentElement();
            this.elaborateElementSpecificAttributes(elt);
        } else if (e instanceof RequiredElementsMissingException) {
            RequiredElementsMissingException ex = (RequiredElementsMissingException)e;
            Name elt = ex.getParent();
            this.elaborateContentModel(elt);
        } else if (e instanceof RequiredElementsMissingOneOfException) {
            RequiredElementsMissingOneOfException ex = (RequiredElementsMissingOneOfException)e;
            Name elt = ex.getParent();
            this.elaborateContentModel(elt);
        } else if (e instanceof StringNotAllowedException) {
            StringNotAllowedException ex = (StringNotAllowedException)e;
            Name elt = ex.getCurrentElement();
            this.elaborateContentModel(elt);
        } else if (e instanceof TextNotAllowedException) {
            TextNotAllowedException ex = (TextNotAllowedException)e;
            Name elt = ex.getCurrentElement();
            this.elaborateContentModel(elt);
        } else if (e instanceof UnfinishedElementException) {
            UnfinishedElementException ex = (UnfinishedElementException)e;
            Name elt = ex.getCurrentElement();
            this.elaborateContentModel(elt);
        } else if (e instanceof UnfinishedElementOneOfException) {
            UnfinishedElementOneOfException ex = (UnfinishedElementOneOfException)e;
            Name elt = ex.getCurrentElement();
            this.elaborateContentModel(elt);
        } else if (e instanceof UnknownElementException) {
            UnknownElementException ex = (UnknownElementException)e;
            Name elt = ex.getParent();
            this.elaborateContentModel(elt);
        } else if (e instanceof BadAttributeValueException) {
            BadAttributeValueException ex = (BadAttributeValueException)e;
            Map map = ex.getExceptions();
            this.elaborateDatatypes(map);
        } else if (e instanceof VnuBadAttrValueException) {
            VnuBadAttrValueException ex = (VnuBadAttrValueException)e;
            Map<String, DatatypeException> map = ex.getExceptions();
            this.elaborateDatatypes(map);
        } else if (e instanceof VnuBadElementNameException) {
            VnuBadElementNameException ex = (VnuBadElementNameException)e;
            Map<String, DatatypeException> map = ex.getExceptions();
            this.elaborateDatatypes(map);
        } else if (e instanceof DatatypeMismatchException) {
            DatatypeMismatchException ex = (DatatypeMismatchException)e;
            Map<String, DatatypeException> map = ex.getExceptions();
            this.elaborateDatatypes(map);
        } else if (e instanceof StringNotAllowedException) {
            StringNotAllowedException ex = (StringNotAllowedException)e;
            Map map = ex.getExceptions();
            this.elaborateDatatypes(map);
        }
    }

    private void elaborateDatatypes(Map<String, DatatypeException> map) throws SAXException {
        HashSet<DocumentFragment> fragments = new HashSet<DocumentFragment>();
        for (Map.Entry<String, DatatypeException> entry : map.entrySet()) {
            Html5DatatypeException ex5;
            DocumentFragment fragment;
            DatatypeException ex = entry.getValue();
            if (!(ex instanceof Html5DatatypeException) || (fragment = HTML5_DATATYPE_ADVICE.get((ex5 = (Html5DatatypeException)ex).getDatatypeClass())) == null) continue;
            fragments.add(fragment);
        }
        if (!fragments.isEmpty()) {
            ContentHandler ch = this.emitter.startElaboration();
            if (ch != null) {
                TreeParser treeParser = new TreeParser(ch, null);
                XhtmlSaxEmitter xhtmlSaxEmitter = new XhtmlSaxEmitter(ch);
                xhtmlSaxEmitter.startElement("dl");
                for (DocumentFragment fragment : fragments) {
                    treeParser.parse((Node)fragment);
                }
                xhtmlSaxEmitter.endElement("dl");
            }
            this.emitter.endElaboration();
        }
    }

    private void elaborateContentModel(Name elt) throws SAXException {
        DocumentFragment dds = this.spec.contentModelDescription(elt);
        if (dds != null) {
            ContentHandler ch = this.emitter.startElaboration();
            if (ch != null) {
                TreeParser treeParser = new TreeParser(ch, null);
                XhtmlSaxEmitter xhtmlSaxEmitter = new XhtmlSaxEmitter(ch);
                xhtmlSaxEmitter.startElement("dl");
                this.emitContentModelDt(xhtmlSaxEmitter, elt);
                treeParser.parse((Node)dds);
                xhtmlSaxEmitter.endElement("dl");
            }
            this.emitter.endElaboration();
        }
    }

    private void elaborateContentModelandContext(Name parent, Name child) throws SAXException {
        DocumentFragment contentModelDds = this.spec.contentModelDescription(parent);
        DocumentFragment contextDds = this.spec.contextDescription(child);
        if (contentModelDds != null || contextDds != null) {
            ContentHandler ch = this.emitter.startElaboration();
            if (ch != null) {
                TreeParser treeParser = new TreeParser(ch, null);
                XhtmlSaxEmitter xhtmlSaxEmitter = new XhtmlSaxEmitter(ch);
                xhtmlSaxEmitter.startElement("dl");
                if (contextDds != null) {
                    this.emitContextDt(xhtmlSaxEmitter, child);
                    treeParser.parse((Node)contextDds);
                }
                if (contentModelDds != null) {
                    this.emitContentModelDt(xhtmlSaxEmitter, parent);
                    treeParser.parse((Node)contentModelDds);
                }
                xhtmlSaxEmitter.endElement("dl");
            }
            this.emitter.endElaboration();
        }
    }

    private void elaborateElementSpecificAttributes(Name elt) throws SAXException {
        this.elaborateElementSpecificAttributes(elt, null);
    }

    private void elaborateElementSpecificAttributes(Name elt, Name attribute) throws SAXException {
        if ("input".equals(elt.getLocalName())) {
            ContentHandler ch = this.emitter.startElaboration();
            if (ch != null) {
                XhtmlSaxEmitter xhtmlSaxEmitter = new XhtmlSaxEmitter(ch);
                this.elaborateInputAttributes(xhtmlSaxEmitter, elt, attribute);
            }
            this.emitter.endElaboration();
        } else {
            DocumentFragment dds = this.spec.elementSpecificAttributesDescription(elt);
            if (dds != null) {
                ContentHandler ch = this.emitter.startElaboration();
                if (ch != null) {
                    TreeParser treeParser = new TreeParser(ch, null);
                    XhtmlSaxEmitter xhtmlSaxEmitter = new XhtmlSaxEmitter(ch);
                    xhtmlSaxEmitter.startElement("dl");
                    this.emitElementSpecificAttributesDt(xhtmlSaxEmitter, elt);
                    treeParser.parse((Node)dds);
                    xhtmlSaxEmitter.endElement("dl");
                }
                this.emitter.endElaboration();
            }
        }
    }

    private void emitElementSpecificAttributesDt(XhtmlSaxEmitter xhtmlSaxEmitter, Name elt) throws SAXException {
        xhtmlSaxEmitter.startElement("dt");
        xhtmlSaxEmitter.characters(ELEMENT_SPECIFIC_ATTRIBUTES_BEFORE);
        this.emitLinkifiedLocalName(xhtmlSaxEmitter, elt);
        xhtmlSaxEmitter.characters(ELEMENT_SPECIFIC_ATTRIBUTES_AFTER);
        xhtmlSaxEmitter.endElement("dt");
    }

    private void emitContextDt(XhtmlSaxEmitter xhtmlSaxEmitter, Name elt) throws SAXException {
        xhtmlSaxEmitter.startElement("dt");
        xhtmlSaxEmitter.characters(CONTEXT_BEFORE);
        this.emitLinkifiedLocalName(xhtmlSaxEmitter, elt);
        xhtmlSaxEmitter.characters(CONTEXT_AFTER);
        xhtmlSaxEmitter.endElement("dt");
    }

    private void emitContentModelDt(XhtmlSaxEmitter xhtmlSaxEmitter, Name elt) throws SAXException {
        xhtmlSaxEmitter.startElement("dt");
        xhtmlSaxEmitter.characters(CONTENT_MODEL_BEFORE);
        this.emitLinkifiedLocalName(xhtmlSaxEmitter, elt);
        xhtmlSaxEmitter.characters(CONTENT_MODEL_AFTER);
        xhtmlSaxEmitter.endElement("dt");
    }

    private void emitLinkifiedLocalName(XhtmlSaxEmitter xhtmlSaxEmitter, Name elt) throws SAXException {
        String url = this.spec.elementLink(elt);
        if (url != null) {
            this.attributesImpl.clear();
            this.attributesImpl.addAttribute("href", url);
            xhtmlSaxEmitter.startElement("a", this.attributesImpl);
        }
        xhtmlSaxEmitter.startElement("code");
        xhtmlSaxEmitter.characters(elt.getLocalName());
        xhtmlSaxEmitter.endElement("code");
        if (url != null) {
            xhtmlSaxEmitter.endElement("a");
        }
    }

    private void elaborateInputAttributes(XhtmlSaxEmitter xhtmlSaxEmitter, Name elt, Name badAttribute) throws SAXException {
        this.attributesImpl.clear();
        this.attributesImpl.addAttribute("class", "inputattrs");
        xhtmlSaxEmitter.startElement("dl", this.attributesImpl);
        this.emitElementSpecificAttributesDt(xhtmlSaxEmitter, elt);
        xhtmlSaxEmitter.startElement("dd");
        this.attributesImpl.clear();
        this.addHyperlink(xhtmlSaxEmitter, "Global attributes", SPEC_LINK_URI + "#global-attributes");
        this.attributesImpl.addAttribute("class", "inputattrtypes");
        xhtmlSaxEmitter.startElement("span", this.attributesImpl);
        xhtmlSaxEmitter.endElement("span");
        xhtmlSaxEmitter.endElement("dd");
        for (Map.Entry<String, String[]> entry : validInputTypesByAttributeName.entrySet()) {
            String attributeName = entry.getKey();
            xhtmlSaxEmitter.startElement("dd");
            this.attributesImpl.clear();
            this.attributesImpl.addAttribute("class", "inputattrname");
            xhtmlSaxEmitter.startElement("code", this.attributesImpl);
            this.attributesImpl.clear();
            this.attributesImpl.addAttribute("href", SPEC_LINK_URI + entry.getValue()[0]);
            xhtmlSaxEmitter.startElement("a", this.attributesImpl);
            this.addText(xhtmlSaxEmitter, attributeName);
            xhtmlSaxEmitter.endElement("a");
            xhtmlSaxEmitter.endElement("code");
            this.attributesImpl.addAttribute("class", "inputattrtypes");
            if (badAttribute != null && attributeName.equals(badAttribute.getLocalName())) {
                this.listInputTypesForAttribute(xhtmlSaxEmitter, attributeName, true);
            } else {
                this.listInputTypesForAttribute(xhtmlSaxEmitter, attributeName, false);
            }
            xhtmlSaxEmitter.endElement("dd");
        }
        xhtmlSaxEmitter.endElement("dl");
    }

    private void listInputTypesForAttribute(XhtmlSaxEmitter xhtmlSaxEmitter, String attributeName, boolean bad) throws SAXException {
        String highlight;
        String[] typeNames = validInputTypesByAttributeName.get(attributeName);
        int typeCount = typeNames.length;
        String wrapper = bad ? "b" : "span";
        String string = highlight = bad ? " highlight" : "";
        if (typeCount > 1 || "value".equals(attributeName)) {
            this.addText(xhtmlSaxEmitter, " ");
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("class", "inputattrtypes" + highlight);
            xhtmlSaxEmitter.startElement(wrapper, attributesImpl);
            this.addText(xhtmlSaxEmitter, "when ");
            xhtmlSaxEmitter.startElement("code");
            this.addText(xhtmlSaxEmitter, "type");
            xhtmlSaxEmitter.endElement("code", "code");
            this.addText(xhtmlSaxEmitter, " is ");
            if ("value".equals(attributeName)) {
                this.addText(xhtmlSaxEmitter, "not ");
                this.addHyperlink(xhtmlSaxEmitter, "file", SPEC_LINK_URI + fragmentIdByInputType.get("file"));
                this.addText(xhtmlSaxEmitter, " or ");
                this.addHyperlink(xhtmlSaxEmitter, "image", SPEC_LINK_URI + fragmentIdByInputType.get("image"));
            } else {
                for (int i = 1; i < typeCount; ++i) {
                    String typeName = typeNames[i];
                    if (i > 1) {
                        this.addText(xhtmlSaxEmitter, " ");
                    }
                    if (typeCount > 2 && i == typeCount - 1) {
                        this.addText(xhtmlSaxEmitter, "or ");
                    }
                    this.addHyperlink(xhtmlSaxEmitter, typeName, SPEC_LINK_URI + fragmentIdByInputType.get(typeName));
                    if (i >= typeCount - 1 || typeCount <= 3) continue;
                    this.addText(xhtmlSaxEmitter, ",");
                }
            }
            xhtmlSaxEmitter.endElement(wrapper);
        } else {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("class", "inputattrtypes");
            xhtmlSaxEmitter.startElement("span", attributesImpl);
            xhtmlSaxEmitter.endElement("span");
        }
    }

    private void addText(XhtmlSaxEmitter xhtmlSaxEmitter, String text) throws SAXException {
        char[] ch = text.toCharArray();
        xhtmlSaxEmitter.characters(ch, 0, ch.length);
    }

    private void addHyperlink(XhtmlSaxEmitter xhtmlSaxEmitter, String text, String href) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("href", href);
        xhtmlSaxEmitter.startElement("a", attributesImpl);
        this.addText(xhtmlSaxEmitter, text);
        xhtmlSaxEmitter.endElement("a");
    }

    public ErrorHandler getExactErrorHandler() {
        return this.exactErrorHandler;
    }

    public void setLineOffset(int lineOffset) {
        this.lineOffset = lineOffset;
    }

    public void setSpec(Spec spec) {
        this.spec = spec;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public void setLoggingOk(boolean ok) {
        this.loggingOk = ok;
    }

    public void setErrorsOnly(boolean errorsOnly) {
        this.errorsOnly = errorsOnly;
    }

    public void endMessage() throws SAXException {
        this.emitter.endMessage();
    }

    public void startMessage(MessageType type, String systemId, int oneBasedFirstLine, int oneBasedFirstColumn, int oneBasedLastLine, int oneBasedLastColumn, boolean exact) throws SAXException {
        this.emitter.startMessage(type, systemId, oneBasedFirstLine == -1 ? -1 : oneBasedFirstLine + this.lineOffset, oneBasedFirstColumn, oneBasedLastLine == -1 ? -1 : oneBasedLastLine + this.lineOffset, oneBasedLastColumn, exact);
    }

    static {
        WELL_KNOWN_NAMESPACES.put("", "unnamespaced".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/1999/xhtml", "XHTML".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/2000/svg", "SVG".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/1998/Math/MathML", "MathML".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/2005/Atom", "Atom".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/1999/xlink", "XLink".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://docbook.org/ns/docbook", "DocBook".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://relaxng.org/ns/structure/1.0", "RELAX NG".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/XML/1998/namespace", "XML".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/1999/XSL/Transform", "XSLT".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/ns/xbl", "XBL2".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.mozilla.org/keymaster/gatekeeper/there.is.only.xul", "XUL".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "RDF".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://purl.org/dc/elements/1.1/", "Dublin Core".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/2001/XMLSchema-instance", "XML Schema Instance".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.w3.org/2002/06/xhtml2/", "XHTML2".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.ascc.net/xml/schematron", "Schematron".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://purl.oclc.org/dsdl/schematron", "ISO Schematron".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.inkscape.org/namespaces/inkscape", "Inkscape".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd", "Sodipodi".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://www.openmath.org/OpenMath", "OpenMath".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://ns.adobe.com/AdobeSVGViewerExtensions/3.0/", "Adobe SVG Viewer 3.0 extension".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://ns.adobe.com/AdobeIllustrator/10.0/", "Adobe Illustrator 10.0".toCharArray());
        WELL_KNOWN_NAMESPACES.put("adobe:ns:meta/", "XMP Container".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://ns.adobe.com/xap/1.0/", "XMP".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://ns.adobe.com/pdf/1.3/", "Adobe PDF 1.3".toCharArray());
        WELL_KNOWN_NAMESPACES.put("http://ns.adobe.com/tiff/1.0/", "Adobe TIFF".toCharArray());
        HTML5_DATATYPE_ADVICE = new HashMap<Class, DocumentFragment>();
        SPEC_LINK_URI = System.getProperty("nu.validator.spec.html5-link", "https://html.spec.whatwg.org/multipage/");
        MAX_MESSAGES = Integer.parseInt(System.getProperty("nu.validator.messages.limit", "1000"));
        validInputTypesByAttributeName = new TreeMap<String, String[]>();
        validInputTypesByAttributeName.put("accept", new String[]{"#attr-input-accept", "file"});
        validInputTypesByAttributeName.put("alt", new String[]{"#attr-input-alt", "image"});
        validInputTypesByAttributeName.put("autocomplete", new String[]{"#attr-input-autocomplete", "text", "search", "url", "tel", "email", "password", "date", "month", "week", "time", "datetime-local", "number", "range", "color"});
        validInputTypesByAttributeName.put("autofocus", new String[]{"#attr-fe-autofocus"});
        validInputTypesByAttributeName.put("checked", new String[]{"#attr-input-checked", "checkbox", "radio"});
        validInputTypesByAttributeName.put("dirname", new String[]{"#attr-input-dirname", "text", "search"});
        validInputTypesByAttributeName.put("disabled", new String[]{"#attr-fe-disabled"});
        validInputTypesByAttributeName.put("form", new String[]{"#attr-fae-form"});
        validInputTypesByAttributeName.put("formaction", new String[]{"#attr-fs-formaction", "submit", "image"});
        validInputTypesByAttributeName.put("formenctype", new String[]{"#attr-fs-formenctype", "submit", "image"});
        validInputTypesByAttributeName.put("formmethod", new String[]{"#attr-fs-formmethod", "submit", "image"});
        validInputTypesByAttributeName.put("formnovalidate", new String[]{"#attr-fs-formnovalidate", "submit", "image"});
        validInputTypesByAttributeName.put("formtarget", new String[]{"#attr-fs-formtarget", "submit", "image"});
        validInputTypesByAttributeName.put("height", new String[]{"#attr-dim-height", "image"});
        validInputTypesByAttributeName.put("list", new String[]{"#attr-input-list", "text", "search", "url", "tel", "email", "date", "month", "week", "time", "datetime-local", "number", "range", "color"});
        validInputTypesByAttributeName.put("max", new String[]{"#attr-input-max", "date", "month", "week", "time", "datetime-local", "number", "range"});
        validInputTypesByAttributeName.put("maxlength", new String[]{"#attr-input-maxlength", "text", "search", "url", "tel", "email", "password"});
        validInputTypesByAttributeName.put("min", new String[]{"#attr-input-min", "date", "month", "week", "time", "datetime-local", "number", "range"});
        validInputTypesByAttributeName.put("multiple", new String[]{"#attr-input-multiple", "email", "file"});
        validInputTypesByAttributeName.put("name", new String[]{"#attr-fe-name"});
        validInputTypesByAttributeName.put("pattern", new String[]{"#attr-input-pattern", "text", "search", "url", "tel", "email", "password"});
        validInputTypesByAttributeName.put("placeholder", new String[]{"#attr-input-placeholder", "text", "search", "url", "tel", "email", "password", "number"});
        validInputTypesByAttributeName.put("readonly", new String[]{"#attr-input-readonly", "text", "search", "url", "tel", "email", "password", "date", "month", "week", "time", "datetime-local", "number"});
        validInputTypesByAttributeName.put("required", new String[]{"#attr-input-required", "text", "search", "url", "tel", "email", "password", "date", "month", "week", "time", "datetime-local", "number", "checkbox", "radio", "file"});
        validInputTypesByAttributeName.put("size", new String[]{"#attr-input-size", "text", "search", "url", "tel", "email", "password"});
        validInputTypesByAttributeName.put("src", new String[]{"#attr-input-src", "image"});
        validInputTypesByAttributeName.put("step", new String[]{"#attr-input-step", "date", "month", "week", "time", "datetime-local", "number", "range"});
        validInputTypesByAttributeName.put("type", new String[]{"#attr-input-type"});
        validInputTypesByAttributeName.put("value", new String[]{"#attr-input-value"});
        validInputTypesByAttributeName.put("width", new String[]{"#attr-dim-width", "image"});
        fragmentIdByInputType = new TreeMap<String, String>();
        fragmentIdByInputType.put("hidden", "#hidden-state-(type=hidden)");
        fragmentIdByInputType.put("text", "#text-(type=text)-state-and-search-state-(type=search)");
        fragmentIdByInputType.put("search", "#text-(type=text)-state-and-search-state-(type=search)");
        fragmentIdByInputType.put("tel", "#telephone-state-(type=tel)");
        fragmentIdByInputType.put("url", "#url-state-(type=url)");
        fragmentIdByInputType.put("email", "#e-mail-state-(type=email)");
        fragmentIdByInputType.put("password", "#password-state-(type=password)");
        fragmentIdByInputType.put("date", "#date-state-(type=date)");
        fragmentIdByInputType.put("month", "#month-state-(type=month)");
        fragmentIdByInputType.put("week", "#week-state-(type=week)");
        fragmentIdByInputType.put("time", "#time-state-(type=time)");
        fragmentIdByInputType.put("datetime-local", "#local-date-and-time-state-(type=datetime-local)");
        fragmentIdByInputType.put("number", "#number-state-(type=number)");
        fragmentIdByInputType.put("range", "#range-state-(type=range)");
        fragmentIdByInputType.put("color", "#color-state-(type=color)");
        fragmentIdByInputType.put("checkbox", "#checkbox-state-(type=checkbox)");
        fragmentIdByInputType.put("radio", "#radio-button-state-(type=radio)");
        fragmentIdByInputType.put("file", "#file-upload-state-(type=file)");
        fragmentIdByInputType.put("submit", "#submit-button-state-(type=submit)");
        fragmentIdByInputType.put("image", "#image-button-state-(type=image)");
        fragmentIdByInputType.put("reset", "#reset-button-state-(type=reset)");
        fragmentIdByInputType.put("button", "#button-state-(type=button)");
        try {
            HTML5_DATATYPE_ADVICE.putAll(Html5AttributeDatatypeBuilder.parseSyntaxDescriptions());
            List<DocumentFragment> list = ImageReportAdviceBuilder.parseAltAdvice();
            IMAGE_REPORT_GENERAL = list.get(0);
            NO_ALT_NO_LINK_ADVICE = list.get(1);
            NO_ALT_LINK_ADVICE = list.get(2);
            EMPTY_ALT_ADVICE = list.get(3);
            HAS_ALT_ADVICE = list.get(4);
            IMAGE_REPORT_EMPTY = list.get(5);
            IMAGE_REPORT_FATAL = list.get(6);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        INDETERMINATE_MESSAGE = "The result cannot be determined due to a non-document-error.".toCharArray();
        ELEMENT_SPECIFIC_ATTRIBUTES_BEFORE = "Attributes for element ".toCharArray();
        ELEMENT_SPECIFIC_ATTRIBUTES_AFTER = ":".toCharArray();
        CONTENT_MODEL_BEFORE = "Content model for element ".toCharArray();
        CONTENT_MODEL_AFTER = ":".toCharArray();
        CONTEXT_BEFORE = "Contexts in which element ".toCharArray();
        CONTEXT_AFTER = " may be used:".toCharArray();
        BAD_VALUE = "Bad value ".toCharArray();
        POTENTIALLY_BAD_VALUE = "Potentially bad value ".toCharArray();
        BAD_ELEMENT_NAME = "Bad element name".toCharArray();
        POTENTIALLY_BAD_ELEMENT_NAME = "Potentially bad element name".toCharArray();
        FOR = " for ".toCharArray();
        ATTRIBUTE = "attribute ".toCharArray();
        FROM_NAMESPACE = " from namespace ".toCharArray();
        SPACE = " ".toCharArray();
        ON = " on ".toCharArray();
        ELEMENT = "element ".toCharArray();
        PERIOD = ".".toCharArray();
        COMMA = ", ".toCharArray();
        COLON = ":".toCharArray();
        NOT_ALLOWED_ON = " not allowed on ".toCharArray();
        AT_THIS_POINT = " at this point.".toCharArray();
        ONLY_TEXT = " is not allowed to have content that consists solely of text.".toCharArray();
        NOT_ALLOWED = " not allowed".toCharArray();
        AS_CHILD_OF = " as child of ".toCharArray();
        IN_THIS_CONTEXT_SUPPRESSING = " in this context. (Suppressing further errors from this subtree.)".toCharArray();
        REQUIRED_ATTRIBUTES_MISSING = " is missing required attribute ".toCharArray();
        REQUIRED_ATTRIBUTES_MISSING_ONE_OF = " is missing one or more of the following attributes: ".toCharArray();
        REQUIRED_ELEMENTS_MISSING = "Required elements missing.".toCharArray();
        IS_MISSING_A_REQUIRED_CHILD = " is missing a required child element".toCharArray();
        REQUIRED_CHILDREN_MISSING_FROM = " is missing a required instance of child element ".toCharArray();
        REQUIRED_CHILDREN_MISSING_ONE_OF_FROM = " is missing a required instance of one or more of the following child elements: ".toCharArray();
        BAD_CHARACTER_CONTENT = "Bad character content ".toCharArray();
        IN_THIS_CONTEXT = " in this context.".toCharArray();
        TEXT_NOT_ALLOWED_IN = "Text not allowed in ".toCharArray();
        UNKNOWN = "Unknown ".toCharArray();
        NO_ALT_NO_LINK_HEADING = "No textual alternative available, not linked".toCharArray();
        NO_ALT_LINK_HEADING = "No textual alternative available, image linked".toCharArray();
        EMPTY_ALT = "Empty textual alternative\u2014Omitted from non-graphical presentation".toCharArray();
        HAS_ALT = "Images with textual alternative".toCharArray();
        DEFAULT_FILTER_STRINGS = new String[]{".*Authors who wish to regulate nested browsing contexts.*", ".*\\s+\u201creport-uri\u201d\\s+in\\s+favour\\s+of\\s+a\\s+new\\s+\u201creport-to\u201d.*", ".*is only used for backwards compatibility with older CSP.*", ".*Unknown pseudo-element or pseudo-class \u201c:focus-within\u201d.*", ".*leader(.+)is not a \u201ccontent\u201d value.*"};
        DEFAULT_FILTER_PATTERN = Pattern.compile(String.join((CharSequence)"|", DEFAULT_FILTER_STRINGS));
        FILE_NOT_CHECKED = Pattern.compile(".*File was not checked.*");
    }

    private final class ExactErrorHandler
    implements ErrorHandler {
        private final MessageEmitterAdapter owner;

        ExactErrorHandler(MessageEmitterAdapter owner) {
            this.owner = owner;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.owner.error(exception, true);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.owner.fatalError(exception, true);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            this.owner.warning(exception, true);
        }
    }
}

