/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import nu.validator.io.SystemIdIOException;
import nu.validator.xml.TypedInputSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ContentTypeParser {
    private static final char[] CHARSET = new char[]{'c', 'h', 'a', 'r', 's', 'e', 't'};
    private final ErrorHandler errorHandler;
    private boolean laxContentType;
    private boolean allowRnc = false;
    private boolean allowHtml = false;
    private boolean allowXhtml = false;
    private boolean acceptAllKnownXmlTypes = false;
    private boolean allowGenericXml = true;

    private final boolean hasCharset(String param, int offset) {
        if (param.length() - offset < 7) {
            return false;
        }
        for (int i = 0; i < 7; ++i) {
            char c = param.charAt(offset + i);
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            if (c == CHARSET[i]) continue;
            return false;
        }
        return true;
    }

    private final void malformedContentTypeError(String contentType, String reason) throws SAXException {
        if (this.errorHandler != null) {
            this.errorHandler.error(new SAXParseException("Document served with malformed Content-Type header:   \u201c" + contentType + "\u201d. " + reason, null, null, -1, -1));
        }
    }

    public ContentTypeParser(ErrorHandler errorHandler, boolean laxContentType, boolean allowRnc, boolean allowHtml, boolean allowXhtml, boolean acceptAllKnownXmlTypes, boolean allowGenericXml) {
        this.errorHandler = errorHandler;
        this.laxContentType = laxContentType;
        this.allowRnc = allowRnc;
        this.allowHtml = allowHtml;
        this.allowXhtml = allowXhtml;
        this.acceptAllKnownXmlTypes = acceptAllKnownXmlTypes;
        this.allowGenericXml = allowGenericXml;
    }

    public ContentTypeParser(ErrorHandler errorHandler, boolean laxContentType) {
        this.errorHandler = errorHandler;
        this.laxContentType = laxContentType;
    }

    protected boolean xmlContentType(String type, InputSource is) throws SAXException {
        boolean typeOk;
        if ("application/xhtml-voice+xml".equals(type) && this.errorHandler != null) {
            this.errorHandler.warning(new SAXParseException("application/xhtml-voice+xml is an obsolete type.", is.getPublicId(), is.getSystemId(), -1, -1));
        }
        boolean bl = typeOk = "application/xml".equals(type) || "text/xml".equals(type) || type.endsWith("+xml") || "application/xml-external-parsed-entity".equals(type) || "text/xml-external-parsed-entity".equals(type) || "application/xml-dtd".equals(type) || "application/octet-stream".equals(type);
        if (!typeOk && this.laxContentType) {
            boolean laxOk;
            boolean bl2 = laxOk = "text/plain".equals(type) || "text/html".equals(type) || "text/xsl".equals(type);
            if (laxOk && this.errorHandler != null) {
                this.errorHandler.warning(new SAXParseException("Being lax about non-XML Content-Type: " + type, is.getPublicId(), is.getSystemId(), -1, -1));
            }
            return laxOk;
        }
        return typeOk;
    }

    protected boolean rncContentType(String type, InputSource is) throws SAXException {
        boolean typeOk = "application/relax-ng-compact-syntax".equals(type);
        if (!typeOk && (typeOk = "application/vnd.relax-ng.rnc".equals(type)) && this.errorHandler != null) {
            this.errorHandler.warning(new SAXParseException("application/vnd.relax-ng.rnc is an unregistered type. application/relax-ng-compact-syntax is the registered type.", is.getPublicId(), is.getSystemId(), -1, -1));
        }
        if (!typeOk) {
            boolean bl = typeOk = "application/octet-stream".equals(type) && is.getSystemId().endsWith(".rnc");
        }
        if (!typeOk && this.laxContentType) {
            boolean laxOk;
            boolean bl = laxOk = "text/plain".equals(type) && is.getSystemId().endsWith(".rnc");
            if (laxOk && this.errorHandler != null) {
                this.errorHandler.warning(new SAXParseException("Being lax about non-RNC Content-Type: " + type, is.getPublicId(), is.getSystemId(), -1, -1));
            }
            return laxOk;
        }
        if (!typeOk && !this.laxContentType && this.errorHandler != null) {
            String msg = "Non-RNC Content-Type: \u201c" + type + "\u201d." + " (application/relax-ng-compact-syntax" + " is the registered type.)";
            SAXParseException spe = new SAXParseException(msg, is.getPublicId(), is.getSystemId(), -1, -1, new SystemIdIOException(is.getSystemId(), msg));
            if (this.errorHandler != null) {
                this.errorHandler.fatalError(spe);
            }
            throw spe;
        }
        return typeOk;
    }

    /*
     * Unable to fully structure code
     */
    public TypedInputSource buildTypedInputSource(String baseUri, String publicId, String contentType) throws SAXException, SAXParseException {
        block51: {
            is = new TypedInputSource();
            is.setPublicId(publicId);
            is.setSystemId(baseUri);
            if (contentType == null) break block51;
            params = contentType.split(";");
            type = params[0].trim().toLowerCase();
            wasRnc = false;
            wasHtml = false;
            if (this.isAllowRnc() && this.rncContentType(type, is)) {
                wasRnc = true;
                is.setType("application/relax-ng-compact-syntax");
            }
            if (!wasRnc) {
                if (this.isAllowHtml()) {
                    if ("text/html".equals(type) || "text/html-sandboxed".equals(type)) {
                        is.setType(type);
                        wasHtml = true;
                    } else if (this.isOnlyHtmlAllowed()) {
                        if (this.laxContentType && "text/plain".equals(type)) {
                            is.setType(type);
                            wasHtml = true;
                            if (this.errorHandler != null) {
                                this.errorHandler.warning(new SAXParseException("Being lax about non-HTML Content-Type: " + type, is.getPublicId(), is.getSystemId(), -1, -1));
                            }
                        } else if ("application/octet-stream".equals(type)) {
                            is.setType(type);
                            wasHtml = true;
                        } else {
                            msg = "Non-HTML Content-Type: \u201c" + type + "\u201d.";
                            spe = new SAXParseException(msg, publicId, baseUri, -1, -1, new SystemIdIOException(baseUri, msg));
                            if (this.errorHandler != null) {
                                this.errorHandler.fatalError(spe);
                            }
                            throw spe;
                        }
                    }
                }
                if (!wasHtml && (this.isAllowGenericXml() || this.isAllowXhtml() || this.isAcceptAllKnownXmlTypes())) {
                    if (!this.xmlContentType(type, is)) {
                        msg = "Non-XML Content-Type: \u201c" + type + "\u201d.";
                        spe = new SAXParseException(msg, publicId, baseUri, -1, -1, new SystemIdIOException(baseUri, msg));
                        if (this.errorHandler != null) {
                            this.errorHandler.fatalError(spe);
                        }
                        throw spe;
                    }
                    is.setType(type);
                }
            }
            charset = null;
            quoted = false;
            sb = new StringBuilder();
            for (i = 1; i < params.length; ++i) {
                block52: {
                    param = params[i];
                    block20: for (offset = 0; offset < param.length(); ++offset) {
                        c = param.charAt(offset);
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': {
                                ** GOTO lbl54
                            }
                            case 'C': 
                            case 'c': {
                                break block20;
                            }
lbl54:
                            // 2 sources

                            default: {
                                continue block20;
                            }
                        }
                    }
                    if (!this.hasCharset(param, offset)) break block52;
                    c = param.charAt(offset += 7);
                    switch (c) {
                        case '=': {
                            break;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            this.malformedContentTypeError(contentType, "Whitespace is not allowed before the \u201c=\u201d sign in the \u201ccharset\u201d parameter.");
                            break block52;
                        }
                        default: {
                            this.malformedContentTypeError(contentType, "Expected an \u201c=\u201d sign but saw \u201c" + c + "\u201d instead.");
                            break block52;
                        }
                    }
                    c = param.charAt(++offset);
                    block8 : switch (c) {
                        case '\"': {
                            quoted = true;
                            ** GOTO lbl75
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            this.malformedContentTypeError(contentType, "Whitespace is not allowed after the \u201c=\u201d sign in the parameter value.");
                            break;
                        }
lbl75:
                        // 2 sources

                        default: {
                            block21: for (j = ++offset; j < param.length(); ++j) {
                                c = param.charAt(j);
                                switch (c) {
                                    case '\"': {
                                        if (quoted) break block21;
                                        this.malformedContentTypeError(contentType, "Unmatched \u201c\"\u201d character in \u201ccharset\u201d parameter.");
                                        break block8;
                                    }
                                    case '\t': 
                                    case '\n': 
                                    case '\f': 
                                    case '\r': 
                                    case ' ': {
                                        break block21;
                                    }
                                    default: {
                                        if (!(c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '-' || c == '!' || c == '#' || c == '$' || c == '%' || c == '&' || c == '\'' || c == '+' || c == '_' || c == '`' || c == '{' || c == '}' || c == '~' || c == '^')) {
                                            this.malformedContentTypeError(contentType, "The character \u201c" + c + "\u201d is not a valid character in an encoding name.");
                                            break block8;
                                        }
                                        ++offset;
                                        sb.append(c);
                                        continue block21;
                                    }
                                }
                            }
                            if (quoted) {
                                if ('\"' == param.charAt(offset)) {
                                    ++offset;
                                } else {
                                    this.malformedContentTypeError(contentType, "Unmatched \u201c\"\u201d character in \u201ccharset\u201d parameter.");
                                    break;
                                }
                            }
                            if (param.length() > offset) {
                                block22: for (k = offset + 1; k < param.length(); ++k) {
                                    c = param.charAt(k);
                                    switch (c) {
                                        case '\t': 
                                        case '\n': 
                                        case '\f': 
                                        case '\r': 
                                        case ' ': {
                                            ++offset;
                                            continue block22;
                                        }
                                        default: {
                                            this.malformedContentTypeError(contentType, "Only whitespace is allowed after the encoding name in the \u201ccharset\u201d parameter. Found \u201c" + c + "\u201d instead.");
                                            break block8;
                                        }
                                    }
                                }
                            }
                            if (sb.length() != 0) break;
                            this.malformedContentTypeError(contentType, "The empty string is not a valid encoding name.");
                        }
                    }
                }
                if (sb.length() <= 0) continue;
                if ('\'' == sb.charAt(0) && '\'' == sb.charAt(sb.length() - 1)) {
                    this.malformedContentTypeError(contentType, "Single-quoted encoding names are not allowed in the \u201ccharset\u201d parameter.");
                    continue;
                }
                charset = sb.toString();
            }
            if (charset != null) {
                is.setEncoding(charset);
            } else if (type.startsWith("text/") && !wasHtml) {
                if (this.laxContentType) {
                    if (this.errorHandler != null) {
                        this.errorHandler.warning(new SAXParseException("text/* type without a charset parameter seen. Would have defaulted to US-ASCII had the lax option not been chosen.", is.getPublicId(), is.getSystemId(), -1, -1));
                    }
                } else {
                    is.setEncoding("US-ASCII");
                    if (this.errorHandler != null) {
                        this.errorHandler.warning(new SAXParseException("text/* type without a charset parameter seen. Defaulting to US-ASCII per section 3.1 of RFC 3023.", is.getPublicId(), is.getSystemId(), -1, -1));
                    }
                }
            }
        }
        return is;
    }

    public boolean isAcceptAllKnownXmlTypes() {
        return this.acceptAllKnownXmlTypes;
    }

    public void setAcceptAllKnownXmlTypes(boolean acceptAllKnownXmlTypes) {
        this.acceptAllKnownXmlTypes = acceptAllKnownXmlTypes;
    }

    public boolean isAllowGenericXml() {
        return this.allowGenericXml;
    }

    public void setAllowGenericXml(boolean allowGenericXml) {
        this.allowGenericXml = allowGenericXml;
    }

    public boolean isAllowHtml() {
        return this.allowHtml;
    }

    public void setAllowHtml(boolean allowHtml) {
        this.allowHtml = allowHtml;
    }

    public boolean isAllowRnc() {
        return this.allowRnc;
    }

    public void setAllowRnc(boolean allowRnc) {
        this.allowRnc = allowRnc;
    }

    public boolean isAllowXhtml() {
        return this.allowXhtml;
    }

    public void setAllowXhtml(boolean allowXhtml) {
        this.allowXhtml = allowXhtml;
    }

    public boolean isLaxContentType() {
        return this.laxContentType;
    }

    public void setLaxContentType(boolean laxContentType) {
        this.laxContentType = laxContentType;
    }

    public boolean isOnlyHtmlAllowed() {
        return !this.isAllowGenericXml() && !this.isAllowRnc() && !this.isAllowXhtml();
    }
}

