/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.tooling;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.plugin.use.PluginId;
import org.gradle.util.VersionNumber;
import org.netbeans.modules.gradle.tooling.NbProjectInfoBuilder;
import org.netbeans.modules.gradle.tooling.NbProjectInfoModel;

public class GradleInternalAdapter {
    private static final Logger LOG = Logging.getLogger(NbProjectInfoBuilder.class);
    private final Project project;
    private final VersionNumber gradleVersion;
    private Set<String> reportedIncompatibilities = new HashSet<String>();
    protected NbProjectInfoModel model;
    protected boolean pluginsInitialized;
    protected PluginManagerInternal pluginManager;
    protected PluginRegistry registry;

    public GradleInternalAdapter(Project project) {
        this.project = project;
        this.gradleVersion = VersionNumber.parse((String)project.getGradle().getGradleVersion());
    }

    boolean initPlugins() {
        if (!this.pluginsInitialized) {
            if (this.project.getPluginManager() instanceof PluginManagerInternal) {
                this.pluginManager = (PluginManagerInternal)this.project.getPluginManager();
            }
            this.registry = this.project instanceof ProjectInternal ? (PluginRegistry)this.safeCall(() -> (PluginRegistry)((ProjectInternal)this.project).getServices().get(PluginRegistry.class), "plugin registry").orElse(null) : null;
        }
        return this.pluginManager != null;
    }

    public void setModel(NbProjectInfoModel model) {
        this.model = model;
    }

    protected boolean isFixedValue(String description, ValueSupplier.ExecutionTimeValue etv) {
        return etv.isFixedValue();
    }

    public boolean isMutableType(Object potentialValue) {
        if (potentialValue instanceof PropertyInternal) {
            return true;
        }
        if (potentialValue instanceof NamedDomainObjectContainer && potentialValue instanceof HasPublicType) {
            return true;
        }
        return potentialValue instanceof Iterable || potentialValue instanceof Map;
    }

    public boolean hasPluginManager() {
        return this.initPlugins();
    }

    public NbProjectInfoBuilder.ValueAndType findPropertyValueInternal(String propName, Object val) {
        return this.sinceGradleOrDefault("6.4", () -> this.safeCall(() -> {
            if (val instanceof ProviderInternal) {
                ValueSupplier.ExecutionTimeValue etv;
                ProviderInternal provided = (ProviderInternal)val;
                try {
                    etv = provided.calculateExecutionTimeValue();
                }
                catch (RuntimeException ex) {
                    return new NbProjectInfoBuilder.ValueAndType(provided.getType());
                }
                if (this.isFixedValue("property " + propName, etv)) {
                    return new NbProjectInfoBuilder.ValueAndType(provided.getType(), etv.getFixedValue());
                }
                return new NbProjectInfoBuilder.ValueAndType(provided.getType());
            }
            return new NbProjectInfoBuilder.ValueAndType(val != null ? val.getClass() : null, val);
        }, "property " + propName).orElse(null), null);
    }

    private static <T extends Throwable> void sneakyThrow(Throwable exception) throws T {
        throw exception;
    }

    private <T, E extends Throwable> T sinceGradleOrDefault(String version, NbProjectInfoBuilder.ExceptionCallable<T, E> c, Supplier<T> def) {
        if (this.gradleVersion.compareTo(VersionNumber.parse((String)version)) >= 0) {
            try {
                return c.call();
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                GradleInternalAdapter.sneakyThrow(t);
                return null;
            }
        }
        return def.get();
    }

    public Optional<PluginId> findPluginId(Class fc) {
        if (!this.initPlugins()) {
            return Optional.empty();
        }
        Optional id = this.sinceGradleOrDefault("7.1", () -> this.safeCall(() -> this.pluginManager.findPluginIdForClass(fc).orElse(null), "plugins"), Optional::empty);
        if (id.isPresent() || this.registry == null) {
            return id;
        }
        return this.safeCall(() -> this.registry.findPluginForClass(fc).orElse(null), "plugin class " + fc.getName());
    }

    private void noteAndLogError(Throwable ex, String description) {
        String msg = "Error inspecting " + (description == null ? "project" : description);
        this.model.noteProblem(msg + ": " + ex.toString());
        LOG.log(LogLevel.LIFECYCLE, msg, ex);
    }

    protected <T, E extends Throwable> Optional<T> safeCall(NbProjectInfoBuilder.ExceptionCallable<T, E> sup, String description) {
        try {
            return Optional.ofNullable(sup.call());
        }
        catch (RuntimeException ex) {
            this.noteAndLogError(ex, description);
            return Optional.empty();
        }
        catch (Error ex) {
            if (this.reportedIncompatibilities.add(ex.toString())) {
                this.noteAndLogError(ex, description);
            }
            return Optional.empty();
        }
        catch (Throwable t) {
            GradleInternalAdapter.sneakyThrow(t);
            return null;
        }
    }

    public static class Gradle76
    extends GradleInternalAdapter {
        private static Optional<Method> refHasValue;

        public Gradle76(Project project) {
            super(project);
        }

        @Override
        protected boolean isFixedValue(String description, ValueSupplier.ExecutionTimeValue etv) {
            if (refHasValue == null) {
                refHasValue = this.safeCall(() -> ValueSupplier.ExecutionTimeValue.class.getMethod("hasFixedValue", new Class[0]), "Gradle 7.6+ ExecutionTimeValue");
            }
            if (refHasValue.isPresent()) {
                return this.safeCall(() -> (Boolean)refHasValue.get().invoke((Object)etv, new Object[0]), description).orElse(false);
            }
            return false;
        }
    }
}

