/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.conversion;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.conversion.SelectedIndicesToButtonModelArrayConverter;
import org.netbeans.validation.api.conversion.SelectedIndicesToListSelectionModelConverter;
import org.netbeans.validation.api.conversion.StringToComboBoxModelConverter;
import org.netbeans.validation.api.conversion.StringToDocumentConverter;
import org.openide.util.Lookup;

public abstract class Converter<From, To> {
    private static Set<Converter<?, ?>> registry = new HashSet();
    private final Class<From> from;
    private final Class<To> to;

    protected Converter(Class<From> from, Class<To> to) {
        this.from = from;
        this.to = to;
    }

    public final Class<From> from() {
        return this.from;
    }

    public final Class<To> to() {
        return this.to;
    }

    public abstract Validator<To> convert(Validator<From> var1);

    public final Validator<To> convert(Validator<From> ... froms) {
        return this.convert(ValidatorUtils.merge(froms));
    }

    public static void register(Converter<?, ?> converter) {
        registry.add(converter);
    }

    public static <From, To> Converter<From, To> find(Class<From> from, Class<To> to) {
        Collection converters = Lookup.getDefault().lookupAll(Converter.class);
        for (Converter converter : converters) {
            if (!converter.match(from, to)) continue;
            return converter.as(from, to);
        }
        for (Converter converter : registry) {
            if (!converter.match(from, to)) continue;
            return converter.as(from, to);
        }
        throw new IllegalArgumentException("No registered converter from " + from.getName() + " to " + to.getName());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Converter other = (Converter)obj;
        if (!(this.from == other.from || this.from != null && this.from.equals(other.from))) {
            return false;
        }
        return this.to == other.to || this.to != null && this.to.equals(other.to);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.from != null ? this.from.hashCode() : 0);
        hash = 11 * hash + (this.to != null ? this.to.hashCode() : 0);
        return hash;
    }

    private boolean match(Class<?> from, Class<?> to) {
        return this.from().equals(from) && this.to().equals(to);
    }

    <T, R> Converter<T, R> as(Class<T> t, Class<R> r) {
        return new Wrap(t, r, this);
    }

    static {
        Converter.register(new StringToDocumentConverter());
        Converter.register(new StringToComboBoxModelConverter());
        Converter.register(new SelectedIndicesToListSelectionModelConverter());
        Converter.register(new SelectedIndicesToButtonModelArrayConverter());
    }

    static final class Wrap<A, B, T, R>
    extends Converter<A, B> {
        final Converter<T, R> other;
        private final Exception ex;

        Wrap(Class<A> a, Class<B> b, Converter<T, R> other) {
            super(a, b);
            this.other = other;
            this.ex = new Exception();
        }

        @Override
        public Validator<B> convert(Validator<A> from) {
            Validator tv = ValidatorUtils.cast(((Converter)this.other).from, from);
            Validator<R> cvt = this.other.convert((Validator<T>)tv);
            return ValidatorUtils.cast(this.to(), cvt);
        }
    }
}

