/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openidex.search.CompoundSearchIterator;
import org.openidex.search.SearchInfo;
import org.openidex.search.Utils;

class CompoundSearchInfo
implements SearchInfo.Files {
    private final SearchInfo[] elements;

    CompoundSearchInfo(SearchInfo ... elements) {
        if (elements == null) {
            throw new IllegalArgumentException();
        }
        this.elements = elements.length != 0 ? elements : null;
    }

    @Override
    public boolean canSearch() {
        if (this.elements != null) {
            for (SearchInfo element : this.elements) {
                if (!element.canSearch()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<DataObject> objectsToSearch() {
        return Utils.toDataObjectIterator(this.filesToSearch());
    }

    @Override
    public Iterator<FileObject> filesToSearch() {
        if (this.elements == null) {
            return Collections.emptyList().iterator();
        }
        ArrayList<SearchInfo> searchableElements = new ArrayList<SearchInfo>(this.elements.length);
        for (SearchInfo element : this.elements) {
            if (!element.canSearch()) continue;
            searchableElements.add(element);
        }
        return new CompoundSearchIterator(searchableElements.toArray(new SearchInfo[0]));
    }
}

