/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openide.util.Parameters;

abstract class CachedHiDPIIcon
implements Icon {
    private static final double MAX_CACHE_SIZE = 10.0;
    private final int width;
    private final int height;
    private final Map<CachedImageKey, Image> cache = new LinkedHashMap<CachedImageKey, Image>(16, 0.75f, true);
    private double cacheSize = 0.0;

    protected CachedHiDPIIcon(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException();
        }
        if (height < 0) {
            throw new IllegalArgumentException();
        }
        this.width = width;
        this.height = height;
    }

    private synchronized Image getScaledImageCached(Component c, CachedImageKey key) {
        Image ret = this.cache.get(key);
        if (ret != null) {
            return ret;
        }
        double scale = key.getScale();
        int deviceWidth = (int)Math.ceil((double)this.getIconWidth() * scale);
        int deviceHeight = (int)Math.ceil((double)this.getIconHeight() * scale);
        Image img = this.createImage(c, key.getGraphicsConfiguration(), deviceWidth, deviceHeight, scale);
        double imgSize = key.getSize();
        if (imgSize <= 10.0) {
            Iterator<CachedImageKey> iter = this.cache.keySet().iterator();
            while (this.cacheSize + imgSize > 10.0 && iter.hasNext()) {
                CachedImageKey removeKey = iter.next();
                iter.remove();
                this.cacheSize -= removeKey.getSize();
            }
            this.cache.put(key, img);
            this.cacheSize += imgSize;
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paintIcon(Component c, Graphics g0, int x, int y) {
        Graphics2D g = (Graphics2D)g0;
        CachedImageKey key = CachedImageKey.create(g);
        AffineTransform oldTransform = g.getTransform();
        try {
            g.translate(x, y);
            Image scaledImage = this.getScaledImageCached(c, key);
            AffineTransform tx2 = g.getTransform();
            g.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, (int)tx2.getTranslateX(), (int)tx2.getTranslateY()));
            g.drawImage(scaledImage, 0, 0, null);
        }
        finally {
            g.setTransform(oldTransform);
        }
    }

    @Override
    public final int getIconWidth() {
        return this.width;
    }

    @Override
    public final int getIconHeight() {
        return this.height;
    }

    protected abstract Image createImage(Component var1, GraphicsConfiguration var2, int var3, int var4, double var5);

    private static final class CachedImageKey {
        private final GraphicsConfiguration gconf;
        private final double scale;

        public CachedImageKey(GraphicsConfiguration gconf, double scale) {
            Parameters.notNull((CharSequence)"gconf", (Object)gconf);
            if (scale <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.gconf = gconf;
            this.scale = scale;
        }

        public static CachedImageKey create(Graphics2D g) {
            AffineTransform tx = g.getTransform();
            int txType = tx.getType();
            double scale = txType == 2 || txType == 3 ? tx.getScaleX() : 1.0;
            return new CachedImageKey(g.getDeviceConfiguration(), scale);
        }

        public double getScale() {
            return this.scale;
        }

        public double getSize() {
            return Math.pow(this.getScale(), 2.0);
        }

        public GraphicsConfiguration getGraphicsConfiguration() {
            return this.gconf;
        }

        public int hashCode() {
            return Objects.hash(this.gconf, this.scale);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CachedImageKey)) {
                return false;
            }
            CachedImageKey other = (CachedImageKey)obj;
            return this.gconf.equals(other.gconf) && this.scale == other.scale;
        }
    }
}

