/*
 * Decompiled with CFR 0.152.
 */
package org.openide.modules;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public abstract class InstalledFileLocator {
    private static final InstalledFileLocator DEFAULT = new InstalledFileLocator(){

        @Override
        public File locate(String rp, String cnb, boolean l) {
            InstalledFileLocator[] ifls = InstalledFileLocator.getInstances();
            for (int i = 0; i < ifls.length; ++i) {
                File f = ifls[i].locate(rp, cnb, l);
                if (f == null) continue;
                return f;
            }
            return null;
        }

        @Override
        public Set<File> locateAll(String relativePath, String codeNameBase, boolean localized) {
            Set<File> result = null;
            for (InstalledFileLocator ifl : InstalledFileLocator.getInstances()) {
                Set<File> added = ifl.locateAll(relativePath, codeNameBase, localized);
                if (added.isEmpty()) continue;
                if (result == null) {
                    result = added;
                    continue;
                }
                result = new LinkedHashSet<File>(result);
                result.addAll(added);
            }
            return result != null ? result : Collections.emptySet();
        }
    };
    private static InstalledFileLocator[] instances = null;
    private static Lookup.Result<InstalledFileLocator> result = null;
    private static final Object LOCK = new String(InstalledFileLocator.class.getName());

    protected InstalledFileLocator() {
    }

    public abstract File locate(String var1, String var2, boolean var3);

    public Set<File> locateAll(String relativePath, String codeNameBase, boolean localized) {
        File f = this.locate(relativePath, codeNameBase, localized);
        return f != null ? Collections.singleton(f) : Collections.emptySet();
    }

    public static InstalledFileLocator getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstalledFileLocator[] getInstances() {
        Lookup.Result _result;
        Object object = LOCK;
        synchronized (object) {
            if (instances != null) {
                return instances;
            }
        }
        Object object2 = LOCK;
        synchronized (object2) {
            _result = result;
        }
        if (_result == null) {
            _result = Lookup.getDefault().lookupResult(InstalledFileLocator.class);
            _result.addLookupListener(new LookupListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultChanged(LookupEvent e) {
                    Object object = LOCK;
                    synchronized (object) {
                        instances = null;
                    }
                }
            });
            object2 = LOCK;
            synchronized (object2) {
                result = _result;
            }
        }
        Collection c = _result.allInstances();
        Object object3 = LOCK;
        synchronized (object3) {
            instances = c.toArray(new InstalledFileLocator[0]);
            return instances;
        }
    }
}

