/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.viewmodel.Column;
import org.netbeans.modules.viewmodel.DefaultColumn;
import org.netbeans.modules.viewmodel.DelegatingCellEditor;
import org.netbeans.modules.viewmodel.DelegatingCellRenderer;
import org.netbeans.modules.viewmodel.HyperCompoundModel;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.DnDNodeModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;

public class OutlineTable
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(OutlineTable.class.getName());
    private ExplorerManager explorerManager;
    final MyTreeTable treeTable;
    Node.Property[] columns;
    private TableColumn[] tableColumns;
    private int[] columnVisibleMap;
    private boolean ignoreCreateDefaultColumnsFromModel;
    private boolean isDefaultColumnAdded;
    private int defaultColumnIndex;
    private boolean ignoreMove;
    private boolean isSettingModelUp;
    TreeModelRoot currentTreeModelRoot;

    public OutlineTable() {
        this.setLayout(new BorderLayout());
        this.treeTable = new MyTreeTable();
        this.treeTable.getOutline().setRootVisible(false);
        this.treeTable.setVerticalScrollBarPolicy(22);
        this.treeTable.setHorizontalScrollBarPolicy(30);
        this.treeTable.setTreeHorizontalScrollBarPolicy(30);
        this.add((Component)((Object)this.treeTable), "Center");
        this.treeTable.getTable().addPropertyChangeListener("createdDefaultColumnsFromModel", new CreatedDefaultColumnsFromModel());
        this.treeTable.getTable().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void columnAdded(TableColumnModelEvent e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("columnAdded(" + e + ") to = " + e.getToIndex());
                    TableColumnModel tcme = (TableColumnModel)e.getSource();
                    logger.fine(" column header = '" + tcme.getColumn(e.getToIndex()).getHeaderValue() + "'");
                    OutlineTable.this.dumpColumnVisibleMap();
                }
                if (OutlineTable.this.tableColumns != null && e.getToIndex() >= 0) {
                    int visibleIndex = e.getToIndex();
                    int columnIndex = -1;
                    TableColumnModel tcm = OutlineTable.this.treeTable.getTable().getColumnModel();
                    ETableColumnModel ecm = (ETableColumnModel)tcm;
                    for (int i = 0; i < OutlineTable.this.tableColumns.length; ++i) {
                        if (OutlineTable.this.tableColumns[i] == null) continue;
                        boolean wasHidden = OutlineTable.this.columns[i].isHidden();
                        boolean isHidden = ecm.isColumnHidden(OutlineTable.this.tableColumns[i]);
                        if (!wasHidden || isHidden) continue;
                        columnIndex = i;
                        break;
                    }
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("  to index = " + visibleIndex + ", column index = " + columnIndex);
                    }
                    if (columnIndex != -1) {
                        int i;
                        int prefferedVisibleIndex;
                        int columnVisibleIndex = prefferedVisibleIndex = OutlineTable.this.columnVisibleMap[columnIndex];
                        int corder = OutlineTable.this.getColumnOrder(OutlineTable.this.columns[columnIndex]);
                        for (i = 0; i < OutlineTable.this.columnVisibleMap.length; ++i) {
                            if (OutlineTable.this.columnVisibleMap[i] != prefferedVisibleIndex || corder <= OutlineTable.this.getColumnOrder(OutlineTable.this.columns[i]) || OutlineTable.this.columns[i].isHidden()) continue;
                            ++prefferedVisibleIndex;
                            break;
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("  to index = " + visibleIndex + ", column = " + OutlineTable.this.columns[columnIndex].getDisplayName() + ", columnVisibleIndex = " + columnVisibleIndex + ", prefferedVisibleIndex = " + prefferedVisibleIndex);
                        }
                        OutlineTable.this.columns[columnIndex].setHidden(false);
                        ((OutlineTable)OutlineTable.this).columnVisibleMap[columnIndex] = prefferedVisibleIndex;
                        for (i = 0; i < OutlineTable.this.columnVisibleMap.length; ++i) {
                            if (OutlineTable.this.columnVisibleMap[i] < columnVisibleIndex || i == columnIndex || OutlineTable.this.getColumnOrder(OutlineTable.this.columns[i]) < corder) continue;
                            int[] nArray = OutlineTable.this.columnVisibleMap;
                            int n = i;
                            nArray[n] = nArray[n] + 1;
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            OutlineTable.this.dumpColumnVisibleMap();
                        }
                        if (prefferedVisibleIndex >= 0 && prefferedVisibleIndex != visibleIndex) {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.fine("moveColumn(" + visibleIndex + ", " + prefferedVisibleIndex + ")");
                            }
                            OutlineTable.this.ignoreMove = true;
                            try {
                                OutlineTable.this.treeTable.getTable().getColumnModel().moveColumn(visibleIndex, prefferedVisibleIndex);
                            }
                            finally {
                                OutlineTable.this.ignoreMove = false;
                            }
                        }
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    OutlineTable.this.dumpColumnVisibleMap();
                    logger.fine("columnAdded() done.");
                }
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("columnRemoved(" + e + ") from = " + e.getFromIndex());
                    OutlineTable.this.dumpColumnVisibleMap();
                }
                if (OutlineTable.this.tableColumns != null && e.getFromIndex() >= 0) {
                    int visibleIndex = e.getFromIndex();
                    logger.log(Level.FINE, "  from index = {0}", visibleIndex);
                    int columnIndex = OutlineTable.this.getColumnIndex(visibleIndex);
                    if (columnIndex != -1) {
                        OutlineTable.this.columns[columnIndex].setHidden(true);
                        for (int i = 0; i < OutlineTable.this.columnVisibleMap.length; ++i) {
                            if (OutlineTable.this.columnVisibleMap[i] < visibleIndex || OutlineTable.this.columnVisibleMap[i] <= 0) continue;
                            int[] nArray = OutlineTable.this.columnVisibleMap;
                            int n = i;
                            nArray[n] = nArray[n] - 1;
                        }
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    OutlineTable.this.dumpColumnVisibleMap();
                    logger.fine("columnRemoved() done.");
                }
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
                int to;
                if (OutlineTable.this.tableColumns == null || OutlineTable.this.ignoreMove) {
                    return;
                }
                int from = e.getFromIndex();
                if (from == (to = e.getToIndex())) {
                    return;
                }
                int fc = OutlineTable.this.getColumnIndex(from);
                int tc = OutlineTable.this.getColumnIndex(to);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("columnMoved(" + e + ") from = " + from + ", to = " + to);
                    logger.fine("  from = " + from + ", to = " + to);
                    logger.fine("  fc = " + fc + ", tc = " + tc);
                    TableColumnModel tcme = (TableColumnModel)e.getSource();
                    logger.fine(" column headers = '" + tcme.getColumn(e.getFromIndex()).getHeaderValue() + "' => '" + tcme.getColumn(e.getToIndex()).getHeaderValue() + "'");
                    OutlineTable.this.dumpColumnVisibleMap();
                }
                int toColumnOrder = OutlineTable.this.getColumnOrder(OutlineTable.this.columns[tc]);
                int fromColumnOrder = OutlineTable.this.getColumnOrder(OutlineTable.this.columns[fc]);
                OutlineTable.this.setColumnOrder(OutlineTable.this.columns[fc], toColumnOrder);
                OutlineTable.this.setColumnOrder(OutlineTable.this.columns[tc], fromColumnOrder);
                fromColumnOrder = OutlineTable.this.columnVisibleMap[fc];
                ((OutlineTable)OutlineTable.this).columnVisibleMap[fc] = OutlineTable.this.columnVisibleMap[tc];
                ((OutlineTable)OutlineTable.this).columnVisibleMap[tc] = fromColumnOrder;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("After move:");
                    OutlineTable.this.dumpColumnVisibleMap();
                }
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        ActionMap map = this.getActionMap();
        ExplorerManager manager = this.getExplorerManager();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)manager, (boolean)false));
        this.setFocusable(false);
    }

    private void dumpColumnVisibleMap() {
        logger.fine("");
        logger.fine("Column Visible Map (" + this.columnVisibleMap.length + "):");
        for (int i = 0; i < this.columnVisibleMap.length; ++i) {
            logger.fine(" {" + this.columns[i].getDisplayName() + "} \tvisible map[" + i + "] = " + this.columnVisibleMap[i] + "; columnOrder[" + i + "] = " + this.getColumnOrder(this.columns[i]) + "\t" + (this.columns[i].isHidden() ? "hidden" : ""));
        }
        logger.fine("");
    }

    private int getColumnOrder(Node.Property column) {
        Integer order = (Integer)column.getValue("OrderNumberOutline");
        if (order == null) {
            return -1;
        }
        return order;
    }

    private void setColumnOrder(Node.Property column, int order) {
        column.setValue("OrderNumberOutline", (Object)order);
        if (order != this.getColumnOrder(column)) {
            Exceptions.printStackTrace((Throwable)new IllegalStateException("The order " + order + " could not be set to column " + column));
        }
    }

    private int getColumnIndex(int visibleIndex) {
        for (int i = 0; i < this.columnVisibleMap.length; ++i) {
            if (visibleIndex != this.columnVisibleMap[i] || this.columns[i].isHidden()) continue;
            return i;
        }
        return -1;
    }

    public void setModel(Models.CompoundModel model) {
        this.setModel(model, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(Models.CompoundModel model, MessageFormat treeNodeDisplayFormat) {
        this.isSettingModelUp = true;
        try {
            if (this.currentTreeModelRoot == null || this.currentTreeModelRoot.getTreeNodeDisplayFormat() == null) {
                this.saveWidths();
                this.saveSortedState();
            }
            if (this.currentTreeModelRoot != null) {
                this.currentTreeModelRoot.destroy();
                this.currentTreeModelRoot = null;
            }
            if (model == null) {
                this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
                return;
            }
            Object[] nodesColumnName = new String[]{null, null};
            ColumnModel[] cs = model.getColumns();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("setModel(): creating columns: (" + cs.length + ")");
                for (int i = 0; i < cs.length; ++i) {
                    logger.fine("  ColumnModel[" + i + "] = " + cs[i].getDisplayName() + ", ID = " + cs[i].getID() + ", visible = " + cs[i].isVisible());
                }
            }
            Object[] columnsToSet = this.createColumns(cs, (String[])nodesColumnName);
            this.ignoreCreateDefaultColumnsFromModel = true;
            this.treeTable.setNodesColumnName(nodesColumnName[0], nodesColumnName[1]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("setModel(): setNodesColumnName(" + Arrays.toString(nodesColumnName) + ") done");
            }
            this.currentTreeModelRoot = new TreeModelRoot(model, (OutlineView)this.treeTable);
            this.currentTreeModelRoot.setTreeNodeDisplayFormat(treeNodeDisplayFormat);
            TreeModelNode rootNode = this.currentTreeModelRoot.getRootNode();
            this.getExplorerManager().setRootContext((Node)rootNode);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("setModel(): setProperties(" + Arrays.toString(columnsToSet) + ")");
            }
            if (treeNodeDisplayFormat == null) {
                this.treeTable.setProperties((Node.Property[])columnsToSet);
                this.updateTableColumns((Node.Property[])columnsToSet, null);
            } else {
                this.treeTable.setProperties(new Node.Property[0]);
            }
            this.ignoreCreateDefaultColumnsFromModel = false;
            this.treeTable.setAllowedDragActions(model.getAllowedDragActions());
            this.treeTable.setAllowedDropActions(model.getAllowedDropActions(null));
            this.treeTable.setDynamicDropActions(model);
            if (treeNodeDisplayFormat == null) {
                this.updateColumnWidthsAndSorting();
            }
        }
        finally {
            this.isSettingModelUp = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(HyperCompoundModel model, MessageFormat treeNodeDisplayFormat) {
        this.isSettingModelUp = true;
        try {
            if (this.currentTreeModelRoot == null || this.currentTreeModelRoot.getTreeNodeDisplayFormat() == null) {
                this.saveWidths();
                this.saveSortedState();
            }
            if (this.currentTreeModelRoot != null) {
                this.currentTreeModelRoot.destroy();
                this.currentTreeModelRoot = null;
            }
            if (model == null) {
                this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
                return;
            }
            String[] nodesColumnName = new String[]{null, null};
            ColumnModel[] cs = model.getColumns();
            Node.Property[] columnsToSet = this.createColumns(cs, nodesColumnName);
            this.ignoreCreateDefaultColumnsFromModel = true;
            this.treeTable.setNodesColumnName(nodesColumnName[0], nodesColumnName[1]);
            this.currentTreeModelRoot = new TreeModelRoot(model, (OutlineView)this.treeTable);
            this.currentTreeModelRoot.setTreeNodeDisplayFormat(treeNodeDisplayFormat);
            TreeModelNode rootNode = this.currentTreeModelRoot.getRootNode();
            this.getExplorerManager().setRootContext((Node)rootNode);
            if (treeNodeDisplayFormat == null) {
                this.treeTable.setProperties(columnsToSet);
                this.updateTableColumns(columnsToSet, null);
            } else {
                this.treeTable.setProperties(new Node.Property[0]);
            }
            this.ignoreCreateDefaultColumnsFromModel = false;
            this.treeTable.setAllowedDragActions(model.getAllowedDragActions());
            this.treeTable.setAllowedDropActions(model.getAllowedDropActions(null));
            if (treeNodeDisplayFormat == null) {
                this.updateColumnWidthsAndSorting();
            }
        }
        finally {
            this.isSettingModelUp = false;
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.explorerManager == null) {
            this.explorerManager = new ExplorerManager();
        }
        return this.explorerManager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
        if (tc == null) {
            return;
        }
        if (propertyName.equals("currentNodes")) {
            ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)this.equalNodes());
        } else if (propertyName.equals("selectedNodes")) {
            tc.setActivatedNodes((Node[])evt.getNewValue());
        }
    }

    private boolean equalNodes() {
        Node[] ns2;
        Node[] ns1 = TopComponent.getRegistry().getCurrentNodes();
        if (ns1 == (ns2 = this.getExplorerManager().getSelectedNodes())) {
            return true;
        }
        if (ns1 == null || ns2 == null) {
            return false;
        }
        if (ns1.length != ns2.length) {
            return false;
        }
        int k = ns1.length;
        for (int i = 0; i < k; ++i) {
            if (ns1[i].equals((Object)ns2[i])) continue;
            return false;
        }
        return true;
    }

    private Node.Property[] createColumns(ColumnModel[] cs, String[] nodesColumnNameAndDescription) {
        int j;
        int i;
        int k = cs.length;
        HashMap<String, ColumnModel> IDs = new HashMap<String, ColumnModel>(k);
        for (i = 0; i < k; ++i) {
            String id = cs[i].getID();
            if (IDs.containsKey(id)) {
                ColumnModel csi = (ColumnModel)IDs.get(id);
                logger.severe("\nHave two columns with identical IDs \"" + id + "\": " + csi + " [" + csi.getDisplayName() + "] and " + cs[i] + " [" + cs[i].getDisplayName() + "]\n");
                continue;
            }
            IDs.put(id, cs[i]);
        }
        this.columns = new Column[k];
        this.columnVisibleMap = new int[k];
        this.isDefaultColumnAdded = false;
        ColumnModel treeColumn = null;
        boolean addDefaultColumn = true;
        ArrayList<Column> columnList = new ArrayList<Column>(k);
        int d = 0;
        boolean[] originalOrder = new boolean[k];
        for (i = 0; i < k; ++i) {
            Column c = new Column(cs[i]);
            this.columns[i] = c;
            int order = cs[i].getCurrentOrderNumber();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("createColumns(): column {" + c.getDisplayName() + "}: order = " + order + ", i = " + i + ", d = " + d);
            }
            if (order == -1) {
                order = i;
            } else {
                originalOrder[i] = true;
            }
            this.columnVisibleMap[i] = order += d;
            if (cs[i].getType() != null) {
                columnList.add(c);
                continue;
            }
            treeColumn = cs[i];
            nodesColumnNameAndDescription[0] = Actions.cutAmpersand((String)cs[i].getDisplayName());
            nodesColumnNameAndDescription[1] = cs[i].getShortDescription();
            addDefaultColumn = false;
            this.defaultColumnIndex = i;
            if (cs[i].getCurrentOrderNumber() == -1) {
                this.columnVisibleMap[i] = 0;
                j = 0;
                while (j < i) {
                    int n = j++;
                    this.columnVisibleMap[n] = this.columnVisibleMap[n] + 1;
                }
                d = 1;
            }
            c.setHidden(false);
        }
        if (addDefaultColumn) {
            PropertySupport.ReadWrite[] columns2 = new PropertySupport.ReadWrite[this.columns.length + 1];
            System.arraycopy(this.columns, 0, columns2, 1, this.columns.length);
            columns2[0] = new DefaultColumn();
            nodesColumnNameAndDescription[0] = columns2[0].getDisplayName();
            nodesColumnNameAndDescription[1] = columns2[0].getShortDescription();
            this.columns = columns2;
            int[] columnVisibleMap2 = new int[this.columnVisibleMap.length + 1];
            columnVisibleMap2[0] = 0;
            for (i = 0; i < k; ++i) {
                columnVisibleMap2[i + 1] = this.columnVisibleMap[i] + 1;
            }
            this.columnVisibleMap = columnVisibleMap2;
            this.isDefaultColumnAdded = true;
            this.defaultColumnIndex = 0;
        }
        if (treeColumn != null) {
            this.treeTable.setTreeSortable(treeColumn.isSortable());
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createColumns(): columns before checkOrder()");
            this.dumpColumnVisibleMap();
        }
        this.checkOrder(this.columnVisibleMap, originalOrder);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createColumns(): columns after checkOrder()");
            this.dumpColumnVisibleMap();
        }
        int[] columnOrder = new int[this.columnVisibleMap.length];
        System.arraycopy(this.columnVisibleMap, 0, columnOrder, 0, columnOrder.length);
        for (i = 0; i < this.columnVisibleMap.length; ++i) {
            this.setColumnOrder(this.columns[i], columnOrder[i]);
            if (!this.columns[i].isHidden()) continue;
            int order = columnOrder[i];
            for (j = 0; j < this.columnVisibleMap.length; ++j) {
                if (columnOrder[j] < order || this.columnVisibleMap[j] <= 0) continue;
                int n = j;
                this.columnVisibleMap[n] = this.columnVisibleMap[n] - 1;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("createColumns:");
            this.dumpColumnVisibleMap();
        }
        Node.Property[] columnProps = columnList.toArray(new Node.Property[0]);
        this.tableColumns = null;
        return columnProps;
    }

    private void checkOrder(int[] orders, boolean[] originalOrder) {
        int i;
        int i2;
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder("checkOrder(");
            for (i2 = 0; i2 < orders.length; ++i2) {
                msg.append(orders[i2]);
                msg.append(", ");
            }
            msg.append("\b\b)");
            logger.fine(msg.toString());
        }
        int n = orders.length;
        for (i2 = 0; i2 < n; ++i2) {
            int j;
            int min = Integer.MAX_VALUE;
            for (j = 0; j < n && i2 != orders[j]; ++j) {
                if (orders[j] <= i2) continue;
                min = Math.min(min, orders[j]);
            }
            if (j != n || min == Integer.MAX_VALUE) continue;
            int shift = min - i2;
            for (j = 0; j < n; ++j) {
                if (orders[j] <= i2) continue;
                int n2 = j;
                orders[n2] = orders[n2] - shift;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder("  squeezed: ");
            for (i = 0; i < orders.length; ++i) {
                msg.append(orders[i]);
                msg.append(", ");
            }
            msg.append("\b\b)");
            logger.fine(msg.toString());
        }
        int[] duplicates = new int[n];
        for (i = 0; i < n; ++i) {
            int n3 = orders[i];
            duplicates[n3] = duplicates[n3] + 1;
            int d = duplicates[n3];
            if (d <= 1) continue;
            int o = orders[i];
            boolean isOriginalOrder = originalOrder[i];
            boolean shiftedOther = false;
            for (int j = 0; j < n; ++j) {
                if (orders[j] <= o && orders[j] != o) continue;
                if (orders[j] == o) {
                    if (shiftedOther) continue;
                    if (j < i && isOriginalOrder && !originalOrder[j]) {
                        shiftedOther = true;
                    } else if (j < i) continue;
                }
                if (j <= i) {
                    int n4 = orders[j];
                    duplicates[n4] = duplicates[n4] - 1;
                }
                int n5 = j;
                orders[n5] = orders[n5] + 1;
                if (j > i) continue;
                int n6 = orders[j];
                duplicates[n6] = duplicates[n6] + 1;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder("  splitted: ");
            for (int i3 = 0; i3 < orders.length; ++i3) {
                msg.append(orders[i3]);
                msg.append(", ");
            }
            msg.append("\b\b)");
            logger.fine(msg.toString());
        }
    }

    private void updateTableColumns(Node.Property[] columnsToSet, TableColumn[] newTColumns) {
        int i;
        TableColumnModel tcm = this.treeTable.getTable().getColumnModel();
        ETableColumnModel ecm = (ETableColumnModel)tcm;
        List<TableColumn> allColumns = this.getAllColumns(ecm);
        int ci = 0;
        int tci = 0;
        TableColumn[] tableColumns = new TableColumn[this.columns.length];
        if (this.defaultColumnIndex > 0) {
            ++tci;
        }
        for (i = 0; i < this.columns.length; ++i) {
            Column c;
            TableColumn tc;
            if (ci < columnsToSet.length && this.columns[i] == columnsToSet[ci] && i != this.defaultColumnIndex) {
                tableColumns[i] = tc = allColumns.get(tci);
                if (this.columns[i] instanceof Column) {
                    c = (Column)this.columns[i];
                    TableCellEditor cellEditor = tc.getCellEditor();
                    if (cellEditor == null) {
                        cellEditor = this.treeTable.getTable().getDefaultEditor(Node.Property.class);
                    }
                    tc.setCellEditor(new DelegatingCellEditor(c.getName(), cellEditor));
                    TableCellRenderer cellRenderer = tc.getCellRenderer();
                    if (cellRenderer == null) {
                        cellRenderer = this.treeTable.getTable().getDefaultRenderer(Node.Property.class);
                    }
                    tc.setCellRenderer(new DelegatingCellRenderer(c.getName(), cellRenderer));
                    tc.setPreferredWidth(c.getColumnWidth());
                }
                if (this.columns[i].isHidden()) {
                    ecm.setColumnHidden(tc, true);
                } else if (this.columns[i] instanceof Column) {
                    c = (Column)this.columns[i];
                    tc.setPreferredWidth(c.getColumnWidth());
                }
                ++tci;
                ++ci;
                continue;
            }
            tableColumns[i] = tc = allColumns.get(0);
            if (this.columns[i] instanceof Column) {
                c = (Column)this.columns[i];
                tc.setCellEditor(c.getTableCellEditor());
                tc.setPreferredWidth(c.getColumnWidth());
            }
            String name = tc.getHeaderValue().toString();
            tc.setCellEditor(new DelegatingCellEditor(name, this.treeTable.getTable().getCellEditor(0, 0)));
            tc.setCellRenderer(new DelegatingCellRenderer(name, this.treeTable.getTable().getCellRenderer(0, 0)));
            if (this.defaultColumnIndex != 0) continue;
            ++tci;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("updateTableColumns(" + this.columns.length + "):");
            for (i = 0; i < this.columns.length; ++i) {
                logger.fine("Column[" + i + "] (" + this.columns[i].getDisplayName() + ") = " + (tableColumns[i] != null ? tableColumns[i].getHeaderValue() : "null") + "\t" + (this.columns[i].isHidden() ? "hidden" : ""));
            }
        }
        this.setColumnsOrder();
        this.tableColumns = tableColumns;
    }

    private List<TableColumn> getAllColumns(ETableColumnModel etcm) {
        try {
            Method getAllColumnsMethod = ETableColumnModel.class.getDeclaredMethod("getAllColumns", new Class[0]);
            getAllColumnsMethod.setAccessible(true);
            Object allColumns = getAllColumnsMethod.invoke((Object)etcm, new Object[0]);
            return (List)allColumns;
        }
        catch (IllegalAccessException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.EMPTY_LIST;
    }

    private void setColumnsOrder() {
        logger.fine("setColumnsOrder()");
        TableColumnModel tcm = this.treeTable.getTable().getColumnModel();
        int defaultColumnVisibleIndex = 0;
        for (int i = 0; i < this.defaultColumnIndex; ++i) {
            if (this.columns[i].isHidden()) continue;
            ++defaultColumnVisibleIndex;
        }
        if (defaultColumnVisibleIndex != 0 && defaultColumnVisibleIndex < tcm.getColumnCount()) {
            logger.log(Level.FINE, " move default column({0}, {1})", new Object[]{0, defaultColumnVisibleIndex});
            tcm.moveColumn(0, defaultColumnVisibleIndex);
        }
        int n = tcm.getColumnCount();
        int[] order = new int[n];
        int ci = 0;
        int i = 0;
        while (i < n) {
            while (ci < this.columns.length && this.columns[ci].isHidden()) {
                ++ci;
            }
            if (ci >= this.columns.length) break;
            order[i] = this.columnVisibleMap[ci];
            logger.log(Level.FINE, "    order[{0}] = {1}", new Object[]{i, order[i]});
            ++i;
            ++ci;
        }
        for (i = 0; i < n; ++i) {
            int j;
            for (j = 0; j < n && order[j] != i; ++j) {
            }
            if (j == n) continue;
            logger.log(Level.FINE, "  order[{0}] = {1}", new Object[]{j, i});
            if (j == i) continue;
            for (int k = j; k > i; --k) {
                order[k] = order[k - 1];
            }
            order[i] = i;
            logger.log(Level.FINE, " move column({0}, {1})", new Object[]{j, i});
            tcm.moveColumn(j, i);
        }
    }

    private boolean isHiddenColumn(int index) {
        if (this.tableColumns == null) {
            return false;
        }
        if (this.tableColumns[index] == null) {
            return true;
        }
        ETableColumnModel ecm = (ETableColumnModel)this.treeTable.getTable().getColumnModel();
        return ecm.isColumnHidden(this.tableColumns[index]);
    }

    void updateColumnWidthsAndSorting() {
        logger.fine("\nupdateColumnWidthsAndSorting():");
        int k = this.columns.length;
        TableColumnModel tcm = this.treeTable.getTable().getColumnModel();
        ETableColumnModel ecm = (ETableColumnModel)tcm;
        ecm.clearSortedColumns();
        for (int i = 0; i < k; ++i) {
            ETableColumn tc;
            if (this.isHiddenColumn(i)) continue;
            int visibleOrder = this.columnVisibleMap[i];
            logger.log(Level.FINE, "  visibleOrder[{0}] = {1}, ", new Object[]{i, visibleOrder});
            try {
                tc = (ETableColumn)tcm.getColumn(visibleOrder);
            }
            catch (ArrayIndexOutOfBoundsException aioobex) {
                logger.log(Level.SEVERE, "Column(" + i + ") " + this.columns[i].getName() + " visible index = " + visibleOrder + ", columnVisibleMap = " + Arrays.toString(this.columnVisibleMap) + ", num of columns = " + tcm.getColumnCount(), aioobex);
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  GUI column = " + tc.getHeaderValue());
            }
            if (!(this.columns[i] instanceof Column)) continue;
            Column c = (Column)this.columns[i];
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("    Retrieved width " + c.getColumnWidth() + " from " + this.columns[i].getDisplayName() + "[" + i + "] for " + tc.getHeaderValue());
            }
            tc.setPreferredWidth(c.getColumnWidth());
            if (!c.isSorted()) continue;
            ecm.setColumnSorted(tc, !c.isSortedDescending(), 1);
        }
    }

    private void saveWidths() {
        if (this.columns == null) {
            return;
        }
        int k = this.columns.length;
        if (k == 0) {
            return;
        }
        TableColumnModel tcm = this.treeTable.getTable().getColumnModel();
        ETableColumnModel ecm = (ETableColumnModel)tcm;
        Enumeration<TableColumn> etc = tcm.getColumns();
        boolean defaultState = true;
        while (etc.hasMoreElements()) {
            if (etc.nextElement().getWidth() == 75) continue;
            defaultState = false;
            break;
        }
        if (defaultState) {
            return;
        }
        logger.fine("\nsaveWidths():");
        for (int i = 0; i < k; ++i) {
            TableColumn tc;
            if (this.isHiddenColumn(i)) continue;
            int visibleOrder = this.columnVisibleMap[i];
            logger.log(Level.FINE, "  visibleOrder[{0}] = {1}, ", new Object[]{i, visibleOrder});
            if (visibleOrder >= tcm.getColumnCount()) continue;
            try {
                tc = tcm.getColumn(visibleOrder);
            }
            catch (ArrayIndexOutOfBoundsException aioobex) {
                logger.log(Level.SEVERE, "Column(" + i + ") " + this.columns[i].getName() + " visible index = " + visibleOrder + ", columnVisibleMap = " + Arrays.toString(this.columnVisibleMap) + ", num of columns = " + tcm.getColumnCount(), aioobex);
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "  GUI column = {0}", tc.getHeaderValue());
            }
            if (!(this.columns[i] instanceof Column)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("    Setting width " + tc.getWidth() + " from " + tc.getHeaderValue() + " to " + this.columns[i].getDisplayName() + "[" + i + "]");
            }
            ((Column)this.columns[i]).setColumnWidth(tc.getWidth());
        }
    }

    private void saveSortedState() {
        if (this.columns == null) {
            return;
        }
        int k = this.columns.length;
        if (k == 0) {
            return;
        }
        TableColumnModel tcm = this.treeTable.getTable().getColumnModel();
        ETableColumnModel ecm = (ETableColumnModel)tcm;
        Enumeration<TableColumn> etc = tcm.getColumns();
        logger.fine("\nsaveSortedState():");
        for (int i = 0; i < k; ++i) {
            ETableColumn tc;
            if (this.isHiddenColumn(i)) continue;
            int visibleOrder = this.columnVisibleMap[i];
            logger.log(Level.FINE, "  visibleOrder[{0}] = {1}, ", new Object[]{i, visibleOrder});
            if (visibleOrder >= tcm.getColumnCount()) continue;
            try {
                tc = (ETableColumn)tcm.getColumn(visibleOrder);
            }
            catch (ArrayIndexOutOfBoundsException aioobex) {
                logger.log(Level.SEVERE, "Column(" + i + ") " + this.columns[i].getName() + " visible index = " + visibleOrder + ", columnVisibleMap = " + Arrays.toString(this.columnVisibleMap) + ", num of columns = " + tcm.getColumnCount(), aioobex);
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("  GUI column = " + tc.getHeaderValue());
            }
            if (!(this.columns[i] instanceof Column)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("    Setting sorted " + tc.isSorted() + " descending " + !tc.isAscending() + " to " + this.columns[i].getDisplayName() + "[" + i + "]");
            }
            ((Column)this.columns[i]).setSorted(tc.isSorted());
            ((Column)this.columns[i]).setSortedDescending(!tc.isAscending());
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeTable.requestFocusInWindow();
    }

    @Override
    public void addNotify() {
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)true);
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        ExplorerUtils.activateActions((ExplorerManager)this.getExplorerManager(), (boolean)false);
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
        this.setModel(null);
    }

    public boolean isExpanded(Object node) {
        TreeModelNode[] ns = this.currentTreeModelRoot.findNode(node);
        if (ns.length == 0) {
            return false;
        }
        return this.treeTable.isExpanded((Node)ns[0]);
    }

    public void expandNode(Object node) {
        TreeModelNode[] ns;
        for (TreeModelNode n : ns = this.currentTreeModelRoot.findNode(node)) {
            this.treeTable.expandNode((Node)n);
        }
    }

    public void collapseNode(Object node) {
        TreeModelNode[] ns;
        for (TreeModelNode n : ns = this.currentTreeModelRoot.findNode(node)) {
            this.treeTable.collapseNode((Node)n);
        }
    }

    static /* synthetic */ TableColumn[] access$302(OutlineTable x0, TableColumn[] x1) {
        x0.tableColumns = x1;
        return x1;
    }

    private static final class F8FilterInputMap
    extends InputMap {
        private KeyStroke f8 = KeyStroke.getKeyStroke(119, 0);

        public F8FilterInputMap(InputMap imap) {
            this.setParent(imap);
        }

        @Override
        public Object get(KeyStroke keyStroke) {
            if (this.f8.equals(keyStroke)) {
                return null;
            }
            return super.get(keyStroke);
        }
    }

    private static final class F8FilterComponentInputMap
    extends ComponentInputMap {
        private KeyStroke f8 = KeyStroke.getKeyStroke(119, 0);

        public F8FilterComponentInputMap(JComponent component, InputMap imap) {
            super(component);
            this.setParent(imap);
        }

        @Override
        public Object get(KeyStroke keyStroke) {
            if (this.f8.equals(keyStroke)) {
                return null;
            }
            return super.get(keyStroke);
        }
    }

    static class MyTreeTable
    extends OutlineView {
        private Reference dndModelRef = new WeakReference<Object>(null);
        private Node.Property[] properties;

        MyTreeTable() {
            Outline outline = this.getOutline();
            outline.setShowHorizontalLines(true);
            outline.setShowVerticalLines(false);
            this.filterInputMap((JComponent)outline, 0);
            this.filterInputMap((JComponent)outline, 2);
            this.filterInputMap((JComponent)outline, 1);
            outline.putClientProperty((Object)"PropertyToolTipShortDescription", (Object)Boolean.TRUE);
        }

        private void filterInputMap(JComponent component, int condition) {
            InputMap imap = component.getInputMap(condition);
            imap = imap instanceof ComponentInputMap ? new F8FilterComponentInputMap(component, imap) : new F8FilterInputMap(imap);
            component.setInputMap(condition, imap);
        }

        JTable getTable() {
            return this.getOutline();
        }

        public void setProperties(Node.Property[] newProperties) {
            this.properties = newProperties;
            super.setProperties(newProperties);
        }

        Node.Property[] getProperties() {
            return this.properties;
        }

        void setNodesColumnName(String name, String description) {
            OutlineModel m = this.getOutline().getOutlineModel();
            if (m instanceof DefaultOutlineModel) {
                ((DefaultOutlineModel)m).setNodesColumnLabel(name);
            }
            this.setPropertyColumnDescription(name, description);
        }

        public void expandNodes(List exPaths) {
            for (String[] sp : exPaths) {
                TreePath tp = this.stringPath2TreePath(sp);
                if (tp == null) continue;
                this.getOutline().expandPath(tp);
                Rectangle rect = this.getOutline().getPathBounds(tp);
                if (rect == null) continue;
                this.getOutline().scrollRectToVisible(rect);
            }
        }

        private TreePath stringPath2TreePath(String[] sp) {
            ExplorerManager em = ExplorerManager.find((Component)((Object)this));
            try {
                Node n = NodeOp.findPath((Node)em.getRootContext(), (String[])sp);
                Object[] tns = new TreeNode[sp.length + 1];
                for (int i = sp.length; i >= 0; --i) {
                    tns[i] = Visualizer.findVisualizer((Node)n);
                    n = n.getParentNode();
                }
                return new TreePath(tns);
            }
            catch (NodeNotFoundException e) {
                return null;
            }
        }

        void setDynamicDropActions(DnDNodeModel model) {
            this.dndModelRef = new WeakReference<DnDNodeModel>(model);
        }

        void setDynamicDropActions(HyperCompoundModel model) {
            this.dndModelRef = new WeakReference<HyperCompoundModel>(model);
        }

        protected int getAllowedDropActions(Transferable t) {
            Object model = this.dndModelRef.get();
            if (model instanceof DnDNodeModel) {
                return ((DnDNodeModel)model).getAllowedDropActions(t);
            }
            if (model instanceof HyperCompoundModel) {
                return ((HyperCompoundModel)model).getAllowedDropActions(t);
            }
            return super.getAllowedDropActions();
        }
    }

    private class CreatedDefaultColumnsFromModel
    implements PropertyChangeListener {
        private CreatedDefaultColumnsFromModel() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Node.Property[] properties;
            TableColumn[] columns = (TableColumn[])evt.getNewValue();
            if (columns == null) {
                if (OutlineTable.this.currentTreeModelRoot != null && !OutlineTable.this.isSettingModelUp) {
                    OutlineTable.this.saveWidths();
                }
                OutlineTable.access$302(OutlineTable.this, null);
            } else if (!OutlineTable.this.ignoreCreateDefaultColumnsFromModel && (properties = OutlineTable.this.treeTable.getProperties()) != null) {
                OutlineTable.this.updateTableColumns(properties, columns);
            }
        }
    }
}

