/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.hints;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.support.CaretAwareJavaSourceTaskFactory;
import org.netbeans.api.java.source.support.EditorAwareJavaSourceTaskFactory;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.java.hints.providers.spi.PositionRefresherHelper;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.hints.HintsInvoker;
import org.netbeans.modules.java.hints.spiimpl.options.HintsSettings;
import org.netbeans.modules.java.source.PositionRefProvider;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.spi.editor.hints.Context;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.editor.hints.settings.FileHintPreferences;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public class HintsTask
implements CancellableTask<CompilationInfo> {
    public static final String KEY_HINTS = HintsInvoker.class.getName() + "-hints";
    public static final String KEY_SUGGESTIONS = HintsInvoker.class.getName() + "-suggestions";
    private static final Logger TIMER = Logger.getLogger("TIMER");
    private static final Logger TIMER_EDITOR = Logger.getLogger("TIMER.editor");
    private static final Logger TIMER_CARET = Logger.getLogger("TIMER.caret");
    private final AtomicBoolean cancel = new AtomicBoolean();
    private final boolean caretAware;

    public HintsTask(boolean caretAware) {
        this.caretAware = caretAware;
    }

    public void run(CompilationInfo info) {
        this.cancel.set(false);
        if (Utilities.disableErrors(info.getFileObject()).contains(Severity.VERIFIER)) {
            return;
        }
        Document doc = info.getSnapshot().getSource().getDocument(false);
        FileObject f = info.getSnapshot().getSource().getFileObject();
        if (f != null) {
            try {
                PositionRefProvider prp = PositionRefProvider.get((FileObject)f);
                if (prp == null) {
                    return;
                }
                prp.createPosition(0, Position.Bias.Forward);
            }
            catch (IOException | IllegalArgumentException ex) {
                return;
            }
        }
        long startTime = System.currentTimeMillis();
        int caret = CaretAwareJavaSourceTaskFactory.getLastPosition((FileObject)info.getFileObject());
        HintsSettings settings = HintsSettings.getSettingsFor(info.getFileObject());
        HintsInvoker inv = this.caretAware ? new HintsInvoker(settings, caret, this.cancel) : new HintsInvoker(settings, this.cancel);
        List<ErrorDescription> result = inv.computeHints(info);
        if (result == null || this.cancel.get()) {
            return;
        }
        HintsController.setErrors((FileObject)info.getFileObject(), (String)(this.caretAware ? KEY_SUGGESTIONS : KEY_HINTS), result);
        if (this.caretAware) {
            SuggestionsPositionRefresherHelper.setVersion(doc, caret);
        } else {
            HintPositionRefresherHelper.setVersion(doc);
        }
        long endTime = System.currentTimeMillis();
        TIMER.log(Level.FINE, "{1}ms Hints Task: " + (this.caretAware ? " - Caret Aware" : "") + " {0}", new Object[]{info.getFileObject(), endTime - startTime});
        Logger l = this.caretAware ? TIMER_CARET : TIMER_EDITOR;
        for (Map.Entry<String, Long> e : inv.getTimeLog().entrySet()) {
            l.log(Level.FINE, "{1}ms {0}", new Object[]{e.getKey(), e.getValue()});
        }
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public static final class SuggestionsPositionRefresherHelper
    extends PositionRefresherHelper<SuggestionsDocumentVersion> {
        public SuggestionsPositionRefresherHelper() {
            super(KEY_SUGGESTIONS);
        }

        @Override
        protected boolean isUpToDate(Context context, Document doc, SuggestionsDocumentVersion oldVersion) {
            return oldVersion.suggestionsCaret == context.getPosition();
        }

        @Override
        public List<ErrorDescription> getErrorDescriptionsAt(CompilationInfo info, Context context, Document doc) throws BadLocationException {
            return new HintsInvoker(HintsSettings.getSettingsFor(info.getFileObject()), context.getPosition(), context.getCancel()).computeHints(info);
        }

        private static void setVersion(Document doc, int caret) {
            for (PositionRefresherHelper h : MimeLookup.getLookup((String)"text/x-java").lookupAll(PositionRefresherHelper.class)) {
                if (!(h instanceof SuggestionsPositionRefresherHelper)) continue;
                SuggestionsPositionRefresherHelper sp = (SuggestionsPositionRefresherHelper)h;
                sp.setVersion(doc, new SuggestionsDocumentVersion(doc, caret));
            }
        }
    }

    public static final class HintPositionRefresherHelper
    extends PositionRefresherHelper<PositionRefresherHelper.DocumentVersion> {
        public HintPositionRefresherHelper() {
            super(KEY_HINTS);
        }

        @Override
        protected boolean isUpToDate(Context context, Document doc, PositionRefresherHelper.DocumentVersion oldVersion) {
            return true;
        }

        @Override
        public List<ErrorDescription> getErrorDescriptionsAt(CompilationInfo info, Context context, Document doc) throws BadLocationException {
            int rowStart = LineDocumentUtils.getLineStartOffset((LineDocument)((BaseDocument)doc), (int)context.getPosition());
            int rowEnd = LineDocumentUtils.getLineEndOffset((LineDocument)((BaseDocument)doc), (int)context.getPosition());
            return new HintsInvoker(HintsSettings.getSettingsFor(info.getFileObject()), rowStart, rowEnd, context.getCancel()).computeHints(info);
        }

        private static void setVersion(Document doc) {
            for (PositionRefresherHelper h : MimeLookup.getLookup((String)"text/x-java").lookupAll(PositionRefresherHelper.class)) {
                if (!(h instanceof HintPositionRefresherHelper)) continue;
                HintPositionRefresherHelper hp = (HintPositionRefresherHelper)h;
                hp.setVersion(doc, new PositionRefresherHelper.DocumentVersion(doc));
            }
        }
    }

    private static class SuggestionsDocumentVersion
    extends PositionRefresherHelper.DocumentVersion {
        private final int suggestionsCaret;

        public SuggestionsDocumentVersion(Document doc, int suggestionsCaret) {
            super(doc);
            this.suggestionsCaret = suggestionsCaret;
        }
    }

    public static final class CaretFactoryImpl
    extends CaretAwareJavaSourceTaskFactory
    implements ChangeListener {
        public CaretFactoryImpl() {
            super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW);
            FileHintPreferences.addChangeListener((ChangeListener)WeakListeners.change((ChangeListener)this, HintsSettings.class));
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject file) {
            return new HintsTask(true);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (FileObject file : this.getFileObjects()) {
                this.reschedule(file);
            }
        }
    }

    public static final class FactoryImpl
    extends EditorAwareJavaSourceTaskFactory
    implements ChangeListener {
        public FactoryImpl() {
            super(JavaSource.Phase.RESOLVED, JavaSource.Priority.LOW, TaskIndexingMode.ALLOWED_DURING_SCAN, new String[0]);
            FileHintPreferences.addChangeListener((ChangeListener)WeakListeners.change((ChangeListener)this, HintsSettings.class));
        }

        protected CancellableTask<CompilationInfo> createTask(FileObject file) {
            return new HintsTask(false);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (FileObject file : this.getFileObjects()) {
                this.reschedule(file);
            }
        }
    }
}

