/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.nodes;

import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.nodes.NodeImpl;
import org.netbeans.modules.xml.xdm.nodes.Token;
import org.netbeans.modules.xml.xdm.nodes.TokenType;
import org.netbeans.modules.xml.xdm.visitor.XMLNodeVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.TypeInfo;

public class Attribute
extends NodeImpl
implements Node,
Attr {
    private String name = null;
    private String value = null;

    Attribute() {
    }

    Attribute(String name) {
        List<Token> tokens = this.getTokensForWrite();
        tokens.add(Token.create(" ", TokenType.TOKEN_WHITESPACE));
        tokens.add(Token.create(name, TokenType.TOKEN_ATTR_NAME));
        tokens.add(Token.create("=", TokenType.TOKEN_ATTR_EQUAL));
        tokens.add(Token.create("\"\"", TokenType.TOKEN_ATTR_VAL));
    }

    Attribute(String name, String value) {
        List<Token> tokens = this.getTokensForWrite();
        tokens.add(Token.create(" ", TokenType.TOKEN_WHITESPACE));
        tokens.add(Token.create(name, TokenType.TOKEN_ATTR_NAME));
        tokens.add(Token.create("=", TokenType.TOKEN_ATTR_EQUAL));
        tokens.add(Token.create("\"".concat(this.insertEntityReference(value)).concat("\""), TokenType.TOKEN_ATTR_VAL));
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public boolean getSpecified() {
        return false;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public Element getOwnerElement() {
        return (Element)((Object)super.getParentNode());
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    private void validateTokens(List<Token> newTokens) {
        assert (newTokens != null);
        assert (newTokens.size() >= 3 && newTokens.size() <= 6);
        int currentIdx = 0;
        int nameIdx = -1;
        int equalIdx = -1;
        int valIdx = -1;
        for (Token token : newTokens) {
            if (token.getType() == TokenType.TOKEN_ATTR_NAME) {
                if (nameIdx != -1) {
                    throw new IllegalArgumentException();
                }
                nameIdx = currentIdx;
            } else if (token.getType() == TokenType.TOKEN_ATTR_EQUAL) {
                if (equalIdx != -1 || nameIdx == -1) {
                    throw new IllegalArgumentException();
                }
                equalIdx = currentIdx;
            } else if (token.getType() == TokenType.TOKEN_ATTR_VAL) {
                if (valIdx != -1 || equalIdx == -1) {
                    throw new IllegalArgumentException();
                }
                valIdx = currentIdx;
            } else if (token.getType() != TokenType.TOKEN_WHITESPACE) {
                throw new IllegalArgumentException();
            }
            ++currentIdx;
        }
        if (nameIdx == -1 || equalIdx == -1 || valIdx == -1) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    void setTokens(List<Token> newTokens) {
        this.name = null;
        this.value = null;
        super.setTokens(newTokens);
    }

    @Override
    public void accept(XMLNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String getLocalName() {
        int idx;
        String qName = this.getName();
        if (qName != null && (idx = qName.indexOf(58) + 1) > 0) {
            return qName.substring(idx);
        }
        return qName;
    }

    public void setLocalName(String localName) {
        String prefix = this.getPrefix();
        if (prefix == null) {
            this.setName(localName);
        } else if (localName == null || localName.equals("")) {
            this.setName(prefix);
        } else {
            this.setName(prefix.concat(":").concat(localName));
        }
    }

    @Override
    public String getPrefix() {
        int idx;
        String qName = this.getName();
        if (qName != null && (idx = qName.indexOf(58)) > 0) {
            return qName.substring(0, idx);
        }
        return null;
    }

    @Override
    public void setPrefix(String prefix) {
        String localName = this.getLocalName();
        if (prefix == null || prefix.equals("")) {
            this.setName(localName);
        } else {
            this.setName(prefix.concat(":").concat(localName));
        }
    }

    @Override
    public String getName() {
        if (this.name == null) {
            for (Token token : this.getTokens()) {
                if (token.getType() != TokenType.TOKEN_ATTR_NAME) continue;
                this.name = token.getValue();
                break;
            }
        }
        return this.name;
    }

    public void setName(String name) {
        assert (name != null && !"".equals(name));
        this.checkNotInTree();
        this.name = name;
        int tokenIndex = -1;
        for (Token token : this.getTokens()) {
            ++tokenIndex;
            if (token.getType() != TokenType.TOKEN_ATTR_NAME) continue;
            Token newToken = Token.create(name, TokenType.TOKEN_ATTR_NAME);
            this.getTokensForWrite().set(tokenIndex, newToken);
            return;
        }
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            for (Token token : this.getTokens()) {
                if (token.getType() != TokenType.TOKEN_ATTR_VAL) continue;
                String tokenValue = token.getValue();
                int len = tokenValue.length();
                if (len <= 2) {
                    this.value = "";
                    continue;
                }
                this.value = this.removeEntityReference(tokenValue.substring(1, len - 1));
            }
        }
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.checkNotInTree();
        this.value = value;
        int tokenIndex = -1;
        for (Token token : this.getTokens()) {
            ++tokenIndex;
            if (token.getType() != TokenType.TOKEN_ATTR_VAL) continue;
            String oldVal = token.getValue();
            String newVal = oldVal.charAt(0) + this.insertEntityReference(value) + oldVal.charAt(oldVal.length() - 1);
            Token newToken = Token.create(newVal, TokenType.TOKEN_ATTR_VAL);
            this.getTokensForWrite().set(tokenIndex, newToken);
            return;
        }
    }

    public boolean isXmlnsAttribute() {
        return "xmlns".equals(this.getPrefix()) || "xmlns".equals(this.getName());
    }

    @Override
    protected void cloneNamespacePrefixes(Map<Integer, String> allNS, Map<String, String> prefixes) {
        String namespace;
        String prefix;
        if (allNS == null) {
            return;
        }
        String[] parts = this.getValue().split(":");
        String string = prefix = parts.length > 1 ? parts[0] : null;
        if (prefix != null && (namespace = this.lookupNamespaceURI(prefix)) != null) {
            prefixes.put(prefix, namespace);
        }
        super.cloneNamespacePrefixes(allNS, prefixes);
    }

    private String insertEntityReference(String text) {
        return this.removeEntityReference(text).replace("&", "&amp;").replace("<", "&lt;").replace("'", "&apos;").replace("\"", "&quot;");
    }

    private String removeEntityReference(String text) {
        return text.replace("&amp;", "&").replace("&lt;", "<").replace("&apos;", "'").replace("&quot;", "\"");
    }
}

