/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.visitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class HashNamespaceResolver
implements NamespaceContext {
    private Map<String, String> prefixes;
    private Map<String, String> namespaces;

    public HashNamespaceResolver(Map<String, String> nsTable) {
        this.namespaces = nsTable;
        this.prefixes = new HashMap<String, String>();
        for (Map.Entry<String, String> e : this.namespaces.entrySet()) {
            this.prefixes.put(e.getValue(), e.getKey());
        }
    }

    public HashNamespaceResolver(Map<String, String> namespaces, Map<String, String> prefixes) {
        this.namespaces = namespaces;
        this.prefixes = prefixes;
    }

    public Iterator getPrefixes(String namespaceURI) {
        return Collections.singletonList(this.getPrefix(namespaceURI)).iterator();
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.prefixes.get(namespaceURI);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.namespaces.get(prefix);
    }
}

