/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator.visitor.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.visitor.DefaultSchemaVisitor;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

public class SchemaSemanticsVisitor
extends DefaultSchemaVisitor {
    public static final String VAL_MISSING_IMPORTED_DOCUMENT = "VAL_MISSING_IMPORTED_DOCUMENT";
    public static final String FIX_MISSING_IMPORTED_DOCUMENT = "FIX_MISSING_IMPORTED_DOCUMENT";
    public List<Validator.ResultItem> mResultItems = new ArrayList<Validator.ResultItem>();
    private WSDLModel mParentModel;
    private Validator mValidator;
    private Validation mValidation;
    private List<Model> mValidatedModels;

    public SchemaSemanticsVisitor(WSDLModel parentModel, Validator validator, Validation validation, List<Model> validatedModels) {
        this.mParentModel = parentModel;
        this.mValidation = validation;
        this.mValidatedModels = validatedModels;
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.mResultItems;
    }

    public void visit(Schema s) {
        if (s != null) {
            this.visitChildren((SchemaComponent)s);
        }
    }

    public void visit(Import im) {
        WSDLSchema schema;
        Collection schemas = im.getModel().findSchemas(im.getNamespace());
        if ((schemas == null || schemas.isEmpty()) && (schema = this.findInlineSchema(im.getNamespace())) == null) {
            this.logValidation(Validator.ResultType.ERROR, (Component)im, NbBundle.getMessage(SchemaSemanticsVisitor.class, (String)VAL_MISSING_IMPORTED_DOCUMENT, (Object)im.getNamespace(), (Object)im.getSchemaLocation()), NbBundle.getMessage(SchemaSemanticsVisitor.class, (String)FIX_MISSING_IMPORTED_DOCUMENT));
        }
    }

    private void visitChildren(SchemaComponent w) {
        List coll = w.getChildren();
        if (coll != null) {
            for (SchemaComponent component : coll) {
                component.accept((SchemaVisitor)this);
            }
        }
    }

    private void logValidation(Validator.ResultType type, Component component, String desc, String correction) {
        String message = desc;
        if (correction != null) {
            message = desc + " : " + correction;
        }
        Validator.ResultItem item = new Validator.ResultItem(this.mValidator, type, component, message);
        this.mResultItems.add(item);
    }

    private WSDLSchema findInlineSchema(String namespace) {
        List<WSDLSchema> schemas;
        Types types;
        if (namespace == null) {
            return null;
        }
        WSDLSchema matchingSchema = null;
        Definitions def = this.mParentModel.getDefinitions();
        if (def != null && (types = def.getTypes()) != null && (schemas = types.getExtensibilityElements(WSDLSchema.class)) != null) {
            for (WSDLSchema wSchema : schemas) {
                String targetNamespace;
                SchemaModel sModel = wSchema.getSchemaModel();
                if (sModel == null || sModel.getSchema() == null || !namespace.equals(targetNamespace = sModel.getSchema().getTargetNamespace())) continue;
                matchingSchema = wSchema;
                break;
            }
        }
        return matchingSchema;
    }
}

