/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.impl;

import java.util.Locale;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLAttribute;
import org.netbeans.modules.xml.wsdl.model.impl.WSDLQNames;
import org.netbeans.modules.xml.wsdl.model.spi.WSDLComponentBase;
import org.netbeans.modules.xml.wsdl.model.visitor.WSDLVisitor;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class ImportImpl
extends WSDLComponentBase
implements Import {
    public ImportImpl(WSDLModel model, Element e) {
        super(model, e);
    }

    public ImportImpl(WSDLModel model) {
        this(model, ImportImpl.createNewElement(WSDLQNames.IMPORT.getQName(), model));
    }

    @Override
    public void accept(WSDLVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setNamespace(String namespaceURI) {
        this.setAttribute("namespaceURI", WSDLAttribute.NAMESPACE_URI, namespaceURI);
    }

    @Override
    public void setLocation(String locationURI) {
        this.setAttribute("location", WSDLAttribute.LOCATION, locationURI);
    }

    @Override
    public String getNamespace() {
        return this.getAttribute(WSDLAttribute.NAMESPACE_URI);
    }

    @Override
    public String getLocation() {
        return this.getAttribute(WSDLAttribute.LOCATION);
    }

    @Override
    public WSDLModel getImportedWSDLModel() throws CatalogModelException {
        DocumentModel m = this.resolveImportedModel();
        if (m instanceof WSDLModel) {
            return (WSDLModel)m;
        }
        String msg = NbBundle.getMessage(ImportImpl.class, (String)"MSG_CANNOT_LOAD_WSDL", (Object)this.getLocation());
        throw new CatalogModelException(msg);
    }

    public WSDLModel resolveToWSDLModel() throws CatalogModelException {
        DocumentModel m = this.resolveImportedModel();
        if (m instanceof WSDLModel) {
            return (WSDLModel)m;
        }
        return null;
    }

    public SchemaModel resolveToSchemaModel() throws CatalogModelException {
        DocumentModel m = this.resolveImportedModel();
        if (m instanceof SchemaModel) {
            return (SchemaModel)m;
        }
        return null;
    }

    public DocumentModel resolveImportedModel() throws CatalogModelException {
        ModelSource ms = this.resolveModel(this.getLocation());
        String location = this.getLocation().toLowerCase(Locale.US);
        if (location.endsWith(".wsdl")) {
            return this.loadAsWSDL(ms);
        }
        if (location.endsWith(".xsd")) {
            return this.loadAsSchema(ms);
        }
        WSDLModel m = this.loadAsWSDL(ms);
        if (m == null) {
            m = this.loadAsSchema(ms);
        }
        return m;
    }

    private WSDLModel loadAsWSDL(ModelSource ms) {
        WSDLModel m = WSDLModelFactory.getDefault().getModel(ms);
        if (m != null && m.getState() == Model.State.NOT_WELL_FORMED) {
            return null;
        }
        return m;
    }

    private SchemaModel loadAsSchema(ModelSource ms) {
        SchemaModel m = SchemaModelFactory.getDefault().getModel(ms);
        if (m != null && m.getState() == Model.State.NOT_WELL_FORMED) {
            return null;
        }
        return m;
    }
}

