/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator;

import java.util.Collection;
import java.util.Hashtable;
import org.netbeans.modules.xml.wsdl.validator.spi.ValidatorSchemaFactory;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class ValidatorSchemaFactoryRegistry {
    private static ValidatorSchemaFactoryRegistry registry;
    private Hashtable<String, ValidatorSchemaFactory> schemaFactories;

    private ValidatorSchemaFactoryRegistry() {
        this.initialize();
    }

    public static ValidatorSchemaFactoryRegistry getDefault() {
        if (registry == null) {
            registry = new ValidatorSchemaFactoryRegistry();
        }
        return registry;
    }

    private void initialize() {
        this.schemaFactories = new Hashtable();
        Lookup.Result lookupResult = Lookup.getDefault().lookupResult(ValidatorSchemaFactory.class);
        lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                ValidatorSchemaFactoryRegistry.this.refreshServices();
            }
        });
        this.refreshServices();
    }

    public ValidatorSchemaFactory getValidatorSchemaFactory(String namespace) {
        return this.schemaFactories.get(namespace);
    }

    public Collection<ValidatorSchemaFactory> getAllValidatorSchemaFactories() {
        return ((Hashtable)this.schemaFactories.clone()).values();
    }

    private void refreshServices() {
        this.schemaFactories.clear();
        for (ValidatorSchemaFactory factory : Lookup.getDefault().lookupAll(ValidatorSchemaFactory.class)) {
            this.schemaFactories.put(factory.getNamespaceURI(), factory);
        }
    }
}

