/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.syntax.dom;

import java.util.Collection;
import java.util.LinkedHashMap;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.spi.dom.NamedNodeMapImpl;
import org.netbeans.modules.xml.spi.dom.ROException;
import org.netbeans.modules.xml.spi.dom.UOException;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.AttrImpl;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.netbeans.modules.xml.text.syntax.dom.Util;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Tag
extends SyntaxNode
implements Element,
XMLTokenIDs {
    protected NamedNodeMap domAttributes;
    protected String name;

    public Tag(XMLSyntaxSupport support, TokenItem from, int to, String name, Collection attribs) {
        super(support, from, to);
        this.name = name;
    }

    @Override
    public final short getNodeType() {
        return 1;
    }

    @Override
    public final String getNodeName() {
        return this.getTagName();
    }

    @Override
    public final String getTagName() {
        return this.name;
    }

    @Override
    public synchronized NamedNodeMap getAttributes() {
        LinkedHashMap<Object, AttrImpl> map = new LinkedHashMap<Object, AttrImpl>(3);
        block0: for (TokenItem next = this.first().getNext(); next != null; next = next.getNext()) {
            TokenID id = next.getTokenID();
            if (id == ARGUMENT) {
                TokenItem attributeStart = next;
                String name = next.getImage();
                while (next.getTokenID() != VALUE) {
                    if ((next = next.getNext()) != null && next.getTokenID() != ERROR) continue;
                    break block0;
                }
                String image = next.getImage();
                char test = image.charAt(0);
                if (image.length() == 1 && (test == '\"' || test == '\'')) {
                    next = next.getNext();
                }
                if (next == null) break;
                String value = next.getImage();
                Object key = NamedNodeMapImpl.createKey((String)name);
                map.put(key, new AttrImpl(this.support, attributeStart, this));
                next = Util.skipAttributeValue(next, test);
                if (next != null) continue;
                break;
            }
            if (id != WS) break;
        }
        return new NamedNodeMapImpl(map);
    }

    @Override
    public String getAttribute(String name) {
        Attr attribute = this.getAttributeNode(name);
        return attribute != null ? attribute.getValue() : "";
    }

    @Override
    public final void setAttribute(String name, String value) {
        NamedNodeMap attributes = this.getAttributes();
        Node attr = attributes.getNamedItem(name);
        if (attr != null) {
            attr.setNodeValue(value);
        } else {
            String stringToInsert = " " + name + "=" + '\"' + value + '\"';
            BaseDocument doc = this.support.getDocument();
            doc.atomicLock();
            try {
                int insertStart = this.offset + this.length - 1;
                block5: for (TokenItem next = this.first().getNext(); next != null; next = next.getNext()) {
                    TokenID id = next.getTokenID();
                    if (id == ARGUMENT) {
                        while (next.getTokenID() != VALUE) {
                            if ((next = next.getNext()) != null) continue;
                            break block5;
                        }
                        if (next == null) break;
                        String image = next.getImage();
                        char test = image.charAt(0);
                        while (next.getTokenID() == VALUE || next.getTokenID() == CHARACTER) {
                            String actualValue = Util.actualAttributeValue(image);
                            if (!actualValue.equals(image)) {
                                insertStart = next.getOffset() + actualValue.length();
                                break block5;
                            }
                            if ((next = next.getNext()) == null) break block5;
                            image = next.getImage();
                            insertStart = next.getOffset();
                            if (image.length() <= 0 || image.charAt(image.length() - 1) != '>') continue;
                            insertStart += image.length() - 1;
                            if (image.length() <= 1 || image.charAt(image.length() - 2) != '/') continue;
                            --insertStart;
                        }
                        if (next != null) continue;
                        break;
                    }
                    if (id != WS) break;
                }
                doc.insertString(insertStart, stringToInsert, null);
                doc.invalidateSyntaxMarks();
            }
            catch (BadLocationException e) {
                throw new DOMException(11, e.getMessage());
            }
            finally {
                doc.atomicUnlock();
            }
        }
    }

    @Override
    public final void removeAttribute(String name) {
        throw new ROException();
    }

    @Override
    public Attr getAttributeNode(String name) {
        NamedNodeMap map = this.getAttributes();
        Node node = map.getNamedItem(name);
        return (Attr)node;
    }

    @Override
    public final Attr setAttributeNode(Attr attribute) {
        throw new ROException();
    }

    @Override
    public final Attr removeAttributeNode(Attr attribute) {
        throw new ROException();
    }

    @Override
    public NodeList getElementsByTagName(String name) {
        throw new ROException();
    }

    @Override
    public Node getPreviousSibling() {
        SyntaxNode prev = this.getStartTag();
        if (prev == null) {
            return null;
        }
        if ((prev = Tag.findPrevious(prev)) instanceof StartTag) {
            return null;
        }
        return prev;
    }

    @Override
    public Node getNextSibling() {
        SyntaxNode next = this.getEndTag();
        if (next == null) {
            return null;
        }
        if ((next = Tag.findNext(next)) instanceof EndTag) {
            return null;
        }
        return next;
    }

    @Override
    public Node getFirstChild() {
        NodeList list = this.getChildNodes();
        if (list.getLength() == 0) {
            return null;
        }
        return this.getChildNodes().item(0);
    }

    @Override
    public Node getLastChild() {
        NodeList list = this.getChildNodes();
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(list.getLength());
    }

    protected abstract Tag getStartTag();

    protected abstract Tag getEndTag();

    @Override
    public String getAttributeNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        throw new UOException();
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) {
        throw new UOException();
    }

    @Override
    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public boolean hasAttribute(String name) {
        throw new UOException();
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        throw new UOException();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Tag) {
            Tag tag = (Tag)obj;
            Tag t1 = tag.getStartTag();
            Tag t2 = this.getStartTag();
            if (t1 == null || t2 == null) {
                return false;
            }
            return t1.superEquals(t2);
        }
        return false;
    }

    private boolean superEquals(Tag tag) {
        return super.equals(tag);
    }

    @Override
    public final int hashCode() {
        Tag tag = this.getStartTag();
        if (tag == null || tag == this) {
            return super.hashCode();
        }
        return tag.hashCode();
    }
}

