/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl.resolver;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Include;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.impl.resolver.MultivalueMap;

public class ResolveSession {
    private SchemaModelImpl mInitialSModel;
    private String mSoughtNamespace;
    private Map<SchemaModel, Checked> mModelToChecked = new HashMap<SchemaModel, Checked>();
    private Set<SchemaModelImpl> mImported = null;
    private Set<SchemaModelImpl> mMegaImported = null;
    private MultivalueMap.BidirectionalGraph<SchemaModelImpl> mFirstIncludeGraph = null;
    private MultivalueMap.BidirectionalGraph<SchemaModelImpl> mSecondIncludeGraph = null;

    public ResolveSession(SchemaModelImpl initialSModel, String soughtNamespace) {
        this.mInitialSModel = initialSModel;
        this.mSoughtNamespace = soughtNamespace;
        SchemaImpl schema = this.mInitialSModel.getSchema();
        assert (schema != null);
    }

    public Checked getChecked(SchemaModel sModel) {
        Checked checked = this.mModelToChecked.get(sModel);
        if (checked == null) {
            checked = new Checked();
            this.mModelToChecked.put(sModel, checked);
        }
        return checked;
    }

    public Set<SchemaModelImpl> getImported() {
        if (this.mImported == null) {
            this.mImported = new HashSet<SchemaModelImpl>();
        }
        return this.mImported;
    }

    public Set<SchemaModelImpl> getMegaImported() {
        if (this.mMegaImported == null) {
            this.mMegaImported = new HashSet<SchemaModelImpl>();
        }
        return this.mMegaImported;
    }

    public MultivalueMap.BidirectionalGraph<SchemaModelImpl> getInclusionGraph(SchemaModelImpl sModel, String namespace) {
        Set<SchemaModelImpl> sModels = Collections.emptySet();
        MultivalueMap.BidirectionalGraph<SchemaModelImpl> graph = null;
        if (Util.equal(namespace, this.mSoughtNamespace)) {
            if (this.mSecondIncludeGraph == null) {
                this.mSecondIncludeGraph = new MultivalueMap.BidirectionalGraph();
                sModels = this.populateInclusionGraph(this.mSoughtNamespace, this.mSecondIncludeGraph);
            }
            graph = this.mSecondIncludeGraph;
        } else {
            String initialTargetNs = this.mInitialSModel.getSchema().getTargetNamespace();
            if (Util.equal(namespace, initialTargetNs)) {
                if (this.mFirstIncludeGraph == null) {
                    this.mFirstIncludeGraph = new MultivalueMap.BidirectionalGraph();
                    sModels = this.populateInclusionGraph(initialTargetNs, this.mFirstIncludeGraph);
                }
                graph = this.mFirstIncludeGraph;
            } else assert (false) : "Namespace can be either the sought one or equal to target namespace of the initial schema!";
        }
        Set<SchemaModelImpl> inclusionRoots = graph.getRoots(sModel, false);
        HashSet<SchemaModelImpl> avoidCycling = new HashSet<SchemaModelImpl>();
        for (SchemaModelImpl root : inclusionRoots) {
            this.checkAllDependingModelsLoaded(root, graph, sModels, avoidCycling);
        }
        return graph;
    }

    private Set<SchemaModelImpl> populateInclusionGraph(String soughtNs, MultivalueMap.BidirectionalGraph<SchemaModelImpl> graph) {
        List modelsList = SchemaModelFactory.getDefault().getModels();
        HashSet<SchemaModelImpl> filteredModels = new HashSet<SchemaModelImpl>();
        for (SchemaModel sModel : modelsList) {
            String otherTargetNs;
            Schema otherSchema;
            if (sModel == null || sModel.getSchema() == null || (otherSchema = sModel.getSchema()) == null || !Util.equal(soughtNs, otherTargetNs = otherSchema.getTargetNamespace())) continue;
            assert (sModel instanceof SchemaModelImpl);
            SchemaModelImpl otherSModel = (SchemaModelImpl)SchemaModelImpl.class.cast(sModel);
            filteredModels.add(otherSModel);
            Collection<Include> includes = otherSchema.getIncludes();
            for (Include ref : includes) {
                SchemaModelImpl includedSm = otherSModel.resolve(ref);
                if (includedSm == null) continue;
                graph.put(otherSModel, includedSm);
            }
        }
        return filteredModels;
    }

    private void checkAllDependingModelsLoaded(SchemaModelImpl owner, MultivalueMap.BidirectionalGraph<SchemaModelImpl> graph, Set<SchemaModelImpl> initiallyLoadedModels, Set<SchemaModelImpl> avoidCycling) {
        if (avoidCycling.contains(owner)) {
            return;
        }
        avoidCycling.add(owner);
        boolean needRegister = !initiallyLoadedModels.contains(owner);
        for (SchemaModelReference ref : owner.getNotImportRefrences()) {
            SchemaModelImpl referencedSModel = owner.resolve(ref);
            if (referencedSModel == null) continue;
            if (needRegister) {
                graph.put(owner, referencedSModel);
            }
            this.checkAllDependingModelsLoaded(referencedSModel, graph, initiallyLoadedModels, avoidCycling);
        }
    }

    public static class Checked {
        boolean itself = false;
        boolean included = false;
        boolean imports = false;

        public String toString() {
            return "inself=" + this.itself + "; included=" + this.included + "; imports=" + this.imports;
        }
    }
}

