/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl.resolver;

import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.impl.Util;
import org.netbeans.modules.xml.schema.model.impl.resolver.IncludeResolver;
import org.netbeans.modules.xml.schema.model.impl.resolver.ResolveSession;
import org.netbeans.modules.xml.xam.NamedReferenceable;

public class ImportResolver {
    public static <T extends NamedReferenceable> T resole(SchemaModelImpl sModel, String namespace, String localName, Class<T> type) {
        ResolveSession session = new ResolveSession(sModel, namespace);
        T found = null;
        found = ImportResolver.findInImports(sModel, namespace, localName, type, session);
        if (found != null) {
            return found;
        }
        ImportResolver.populateRecursivelyIncludedImports(sModel, namespace, session);
        found = ImportResolver.findInIncludedImportsDown(namespace, localName, type, session, false);
        if (found != null) {
            return found;
        }
        ImportResolver.populateMegaIncludedImports(sModel, namespace, session);
        found = ImportResolver.findInIncludedImportsDown(namespace, localName, type, session, true);
        if (found != null) {
            return found;
        }
        found = ImportResolver.findInIncludedImportsUpwards(namespace, localName, type, session, false);
        if (found != null) {
            return found;
        }
        found = ImportResolver.findInIncludedImportsUpwards(namespace, localName, type, session, true);
        if (found != null) {
            return found;
        }
        return null;
    }

    static <T extends NamedReferenceable> T findInImports(SchemaModelImpl sModel, String namespace, String localName, Class<T> type, ResolveSession session) {
        SchemaImpl mySchema = sModel.getSchema();
        if (mySchema == null) {
            return null;
        }
        Collection<Import> imports = mySchema.getImports();
        for (Import imp : imports) {
            SchemaModelImpl importedSchema;
            String importedNs = imp.getNamespace();
            if (!Util.equal(importedNs, namespace) || (importedSchema = sModel.resolve(imp)) == null) continue;
            session.getImported().add(importedSchema);
            ResolveSession.Checked checked = session.getChecked(importedSchema);
            if (checked.itself) continue;
            T found = importedSchema.findByNameAndType(localName, type);
            checked.itself = true;
            if (found == null) continue;
            return found;
        }
        return null;
    }

    static <T extends NamedReferenceable> T findInIncludedImportsDown(String namespace, String localName, Class<T> type, ResolveSession session, boolean checkMegaImported) {
        Set<SchemaModelImpl> imported = checkMegaImported ? session.getMegaImported() : session.getImported();
        for (SchemaModelImpl imp : imported) {
            assert (imp.getSchema() != null);
            assert (Util.equal(imp.getSchema().getTargetNamespace(), namespace));
            T found = IncludeResolver.resolveRecursiveDown(imp, localName, type, session);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    static <T extends NamedReferenceable> T findInIncludedImportsUpwards(String namespace, String localName, Class<T> type, ResolveSession session, boolean checkMegaImported) {
        Set<SchemaModelImpl> imported = checkMegaImported ? session.getMegaImported() : session.getImported();
        for (SchemaModelImpl imp : imported) {
            assert (imp.getSchema() != null);
            assert (Util.equal(imp.getSchema().getTargetNamespace(), namespace));
            T found = IncludeResolver.resolveUpwards(imp, namespace, localName, type, session);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    static void populateRecursivelyIncludedImports(SchemaModelImpl sModel, String namespace, ResolveSession session) {
        SchemaImpl mySchema = sModel.getSchema();
        if (mySchema == null) {
            return;
        }
        Set<SchemaModelImpl> imported = session.getImported();
        Collection<SchemaModelReference> includes = sModel.getNotImportRefrences();
        for (SchemaModelReference smRef : includes) {
            SchemaModelImpl includedSModel = sModel.resolve(smRef);
            if (includedSModel == null) continue;
            ResolveSession.Checked checked = session.getChecked(includedSModel);
            if (checked.imports) continue;
            checked.imports = true;
            SchemaImpl includedSchema = includedSModel.getSchema();
            if (includedSchema == null) continue;
            Collection<Import> imports = includedSchema.getImports();
            for (Import imp : imports) {
                SchemaModelImpl importedSModel;
                String importedModelNamespace = imp.getNamespace();
                if (!Util.equal(namespace, importedModelNamespace) || (importedSModel = includedSModel.resolve(imp)) == null) continue;
                imported.add(importedSModel);
            }
            ImportResolver.populateRecursivelyIncludedImports(includedSModel, namespace, session);
        }
    }

    static void populateMegaIncludedImports(SchemaModelImpl sModel, String namespace, ResolveSession session) {
        Set<SchemaModelImpl> imported = session.getImported();
        Set<SchemaModelImpl> megaImported = session.getMegaImported();
        SchemaImpl mySchema = sModel.getSchema();
        if (mySchema == null) {
            return;
        }
        Set<SchemaModelImpl> models = IncludeResolver.getMegaIncludedModels(sModel, mySchema.getTargetNamespace(), session);
        for (SchemaModelImpl includedSModel : models) {
            ResolveSession.Checked checked = session.getChecked(includedSModel);
            if (includedSModel == null || checked.imports) continue;
            checked.imports = true;
            SchemaImpl schema = includedSModel.getSchema();
            if (schema == null) continue;
            Collection<Import> imports = schema.getImports();
            for (Import imp : imports) {
                SchemaModelImpl importedSModel;
                String importedModelNamespace = imp.getNamespace();
                if (!Util.equal(namespace, importedModelNamespace) || (importedSModel = includedSModel.resolve(imp)) == null || imported.contains(importedSModel)) continue;
                megaImported.add(importedSModel);
            }
        }
    }
}

